/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.MeasurementSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesignSet;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.EventSet;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ExternalDataSet;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStoreSet;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.InfoStructureSet;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.model.design.process.RecordStructureSet;
import oracle.dbtools.crest.model.design.process.Role;
import oracle.dbtools.crest.model.design.process.RoleSet;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationPackageSet;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.process.ProcessModelPropertiesDialog;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;
import oracle.dbtools.crest.util.GUID;

public class ProcessModel
extends DesignPart
implements ModelObjectSetListener,
DesignListener {
    public static final String OBJECT_TYPE_NAME = "Process Model";
    public static final String REC_STRUCTURE_SET_NAME = "Record Structures";
    public static final String EXT_DATA_SET_NAME = "External Datas";
    public static final String EVENT_SET_NAME = "Events";
    public static final String INFOSTRUCTURE_SET_NAME = "Information Structures";
    public static final String STORE_SET_NAME = "Information Stores";
    public static final String ROLE_SET_NAME = "Roles";
    private EventSet eventSet;
    private InfoStructureSet infoStructureSet;
    private InfoStoreSet infoStoreSet;
    private RoleSet roleSet;
    private DataFlowDesign dataFlowDesign;
    private DataFlowDesignSet dfdSet;
    private TransformationPackageSet trPackageSet;
    private MeasurementSet measurementSet;
    private DesignObjectCollection topDataFlowDesigns = new DesignObjectCollection();
    private TransformationPackage transformationPackage;
    private TransformationTask transformationTask;
    private ExternalDataSet extDataSet;
    private RecordStructureSet recStructureSet;
    private boolean hasOpenedDFDesigns = false;
    private Map entityFlowMap = new TreeMap();
    private Map attributeFlowMap = new TreeMap();

    public ProcessModel(Design design) {
        this.setDesign(design);
        this.createDataFlowDesignSet();
        this.topDataFlowDesigns.setName(Messages.getString("ProcessModel.DataFlowDiagrams"));
        this.topDataFlowDesigns.setElementDescriptor(DataFlowDesignSet.class);
        this.topDataFlowDesigns.setParent(this);
        this.topDataFlowDesigns.setDesign(design.getDesign());
        this.setDirty(true);
    }

    public static final String getDataFlowDesignSetName() {
        return Messages.getString("ProcessModel.DataFlowDiagrams");
    }

    private void createDataFlowDesignSet() {
        this.dfdSet = new DataFlowDesignSet(this);
        this.dfdSet.setDesign(this.getDesign());
        this.dfdSet.setName(Messages.getString("ProcessModel.DataFlowDiagrams"));
        this.dfdSet.setElementDescriptor(DataFlowDesign.class);
        this.dfdSet.setParent(this);
        this.dfdSet.addSetListener(this);
    }

    @Override
    public String getName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String toString() {
        return Messages.getString("ProcessModel.ProcessModel");
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList collection = new ArrayList();
        this.getDataFlowDesigns().addAllElementsTo(collection);
        this.getRecordStructureSet().addAllElementsTo(collection);
        this.getExternalDataSet().addAllElementsTo(collection);
        this.getEventSet().addAllElementsTo(collection);
        this.getInfoStructureSet().addAllElementsTo(collection);
        this.getInfoStoreSet().addAllElementsTo(collection);
        this.getRoleSet().addAllElementsTo(collection);
        this.getTransformationPackageSet().addAllElementsTo(collection);
        return collection;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getNumberOfChildren() {
        return 7;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.topDataFlowDesigns;
            }
            case 1: {
                return this.getInfoStructureSet();
            }
            case 2: {
                return this.getEventSet();
            }
            case 3: {
                return this.getInfoStoreSet();
            }
            case 4: {
                return this.getRoleSet();
            }
            case 5: {
                return this.getRecordStructureSet();
            }
            case 6: {
                return this.getTransformationPackageSet();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.topDataFlowDesigns) {
            return 0;
        }
        if (child == this.getInfoStructureSet()) {
            return 1;
        }
        if (child == this.getEventSet()) {
            return 2;
        }
        if (child == this.getInfoStoreSet()) {
            return 3;
        }
        if (child == this.getRoleSet()) {
            return 4;
        }
        if (child == this.getRecordStructureSet()) {
            return 5;
        }
        if (child == this.getTransformationPackageSet()) {
            return 6;
        }
        return -1;
    }

    public DataFlowDesign addDataFlowDesign(String name) {
        DataFlowDesign design = (DataFlowDesign)this.dfdSet.createElement(null);
        design.setDesign(this.getDesign());
        if (name != null) {
            design.setName(name);
        }
        this.getDesign().setModelListChanged(true);
        return design;
    }

    public DataFlowDesign addDataFlowDesign() {
        return this.addDataFlowDesign(null);
    }

    public DataFlowDesign addDataFlowDesign(String name, boolean topLevel) {
        DataFlowDesign design = (DataFlowDesign)this.dfdSet.createElement(null, topLevel);
        design.setDesign(this.getDesign());
        if (name != null) {
            design.setName(name);
        }
        this.setDirty(true);
        this.getDesign().setDirty(true);
        this.getDesign().setModelListChanged(true);
        return design;
    }

    public void showAllDataFlowDesigns() {
        Iterator it = this.dfdSet.iterator();
        while (it.hasNext()) {
            DataFlowDesign dfDesign = (DataFlowDesign)it.next();
            if (!dfDesign.isLoaded()) continue;
            dfDesign.setMainViewVisible(true);
        }
    }

    public void clearDesign() {
        Object[] dfds = this.dfdSet.toArray();
        int dfdSize = dfds.length;
        for (int i = 0; i < dfdSize; ++i) {
            DataFlowDesign dfDesign = (DataFlowDesign)dfds[i];
            if (dfDesign.isClean()) continue;
            dfDesign.clearDesignPart();
        }
        this.dfdSet.removeAll();
        this.dfdSet.resetCounter();
        this.entityFlowMap.clear();
        this.attributeFlowMap.clear();
        this.setDataFlowDesign(null);
    }

    public DataFlowDesign getDataFlowDesign() {
        if (this.dataFlowDesign == null) {
            this.dataFlowDesign = this.addDataFlowDesign(null);
        }
        return this.dataFlowDesign;
    }

    public void setDataFlowDesign(DataFlowDesign design) {
        this.dataFlowDesign = design;
    }

    public void removeDataFlowDesign(DataFlowDesign design) {
        if (design != null) {
            this.dfdSet.remove(design);
            design.clearDesignPart();
            design.fireDeleted();
            this.setDirty(true);
            this.getDesign().setDirty(true);
            this.getDesign().setModelListChanged(true);
        }
    }

    public DataFlowDesignSet getDataFlowDesigns() {
        return this.dfdSet;
    }

    public EventSet getEventSet() {
        if (this.eventSet == null) {
            this.eventSet = new EventSet(this);
            this.eventSet.setDesign(this.getDesign());
            this.eventSet.setName(Messages.getString("ProcessModel.Events"));
            this.eventSet.setParent(this);
            this.eventSet.addSetListener(this);
        }
        return this.eventSet;
    }

    public InfoStructureSet getInfoStructureSet() {
        if (this.infoStructureSet == null) {
            this.infoStructureSet = new InfoStructureSet(this);
            this.infoStructureSet.setDesign(this.getDesign());
            this.infoStructureSet.setName(Messages.getString("ProcessModel.InformationStructures"));
            this.infoStructureSet.setParent(this);
            this.infoStructureSet.addSetListener(this);
        }
        return this.infoStructureSet;
    }

    public InfoStoreSet getInfoStoreSet() {
        if (this.infoStoreSet == null) {
            this.infoStoreSet = new InfoStoreSet(this);
            this.infoStoreSet.setDesign(this.getDesign());
            this.infoStoreSet.setName(Messages.getString("ProcessModel.AllInformationStores"));
            this.infoStoreSet.setParent(this);
            this.infoStoreSet.addSetListener(this);
        }
        return this.infoStoreSet;
    }

    public ExternalDataSet getExternalDataSet() {
        if (this.extDataSet == null) {
            this.extDataSet = new ExternalDataSet(this);
            this.extDataSet.setDesign(this.getDesign());
            this.extDataSet.setName(Messages.getString("ProcessModel.ExternalDatas"));
            this.extDataSet.setParent(this);
            this.extDataSet.addSetListener(this);
        }
        return this.extDataSet;
    }

    public static final String getTransformationPackageSetName() {
        return Messages.getString("ProcessModel.TransformationPackages");
    }

    public TransformationPackageSet getTransformationPackageSet() {
        if (this.trPackageSet == null) {
            this.trPackageSet = new TransformationPackageSet(this);
            this.trPackageSet.setDesign(this.getDesign());
            this.trPackageSet.setName(Messages.getString("ProcessModel.TransformationPackages"));
            this.trPackageSet.setParent(this);
            this.trPackageSet.addSetListener(this);
        }
        return this.trPackageSet;
    }

    public RoleSet getRoleSet() {
        if (this.roleSet == null) {
            this.roleSet = new RoleSet(this);
            this.roleSet.setDesign(this.getDesign());
            this.roleSet.setName(Messages.getString("ProcessModel.Roles"));
            this.roleSet.setParent(this);
            this.roleSet.addSetListener(this);
        }
        return this.roleSet;
    }

    public RecordStructureSet getRecordStructureSet() {
        if (this.recStructureSet == null) {
            this.recStructureSet = new RecordStructureSet(this);
            this.recStructureSet.setDesign(this.getDesign());
            this.recStructureSet.setName(Messages.getString("ProcessModel.RecordStructures"));
            this.recStructureSet.setParent(this);
            this.recStructureSet.addSetListener(this);
        }
        return this.recStructureSet;
    }

    public MeasurementSet getMeasurementSet() {
        if (this.measurementSet == null) {
            this.measurementSet = new MeasurementSet(this);
            this.measurementSet.setDesign(this.getDesign());
            this.measurementSet.setName(Messages.getString("ProcessModel.Measurement"));
            this.measurementSet.setParent(this);
            this.measurementSet.addSetListener(this);
        }
        return this.measurementSet;
    }

    public Event createEvent(int eventType) {
        return this.getEventSet().createEvent(null, eventType);
    }

    public Event createEvent() {
        return this.createEvent(0);
    }

    public InfoStructure createInfoStructure() {
        return this.getInfoStructureSet().createInfoStructure(null);
    }

    public InfoStore createInfoStore() {
        return this.getInfoStoreSet().createInfoStore(null);
    }

    public ExternalData createExternalData() {
        return this.getExternalDataSet().createExternalData(null);
    }

    public RecordStructure createRecordStructure() {
        return this.getRecordStructureSet().createRecordStructure(null);
    }

    public TransformationPackage createTransformationPackage() {
        return this.createTransformationPackage(null);
    }

    public TransformationPackage createTransformationPackage(String ID) {
        this.transformationPackage = this.getTransformationPackageSet().createTransformationPackage(ID);
        return this.transformationPackage;
    }

    public Role createRole() {
        return this.getRoleSet().createRole(null);
    }

    @Override
    public void clearAll() {
        this.clearDesign();
        Iterator it = this.getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage pack = (TransformationPackage)it.next();
            pack.clearTasks();
        }
        this.getTransformationPackageSet().removeAll();
        this.getInfoStoreSet().removeAll();
        this.getEventSet().removeAll();
        this.getInfoStructureSet().removeAll();
        this.getRoleSet().removeAll();
        this.getExternalDataSet().removeAll();
        this.getRecordStructureSet().removeAll();
        this.setObjectID(new GUID().toString());
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    public void sortCollections() {
        this.getTransformationPackageSet().sort();
        this.getInfoStoreSet().sort();
        this.getEventSet().sort();
        this.getInfoStructureSet().sort();
        this.getRoleSet().sort();
        this.getExternalDataSet().sort();
        this.getRecordStructureSet().sort();
    }

    @Override
    protected DesignPartView createDesignPartSubView(String name) {
        return null;
    }

    @Override
    public DesignPartView getMainView() {
        return null;
    }

    @Override
    public void updateActions() {
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ProcessModel";
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (event == SetEvent.OBJECT_ADDED) {
            this.fireAdded(event.getAffected());
        } else if (event == SetEvent.OBJECT_REMOVED) {
            this.fireRemoved(event.getAffected());
        }
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> list = new ArrayList<DesignObjectSet>();
        list.add(this.getRecordStructureSet());
        list.add(this.getEventSet());
        list.add(this.getInfoStructureSet());
        list.add(this.getInfoStoreSet());
        list.add(this.getRoleSet());
        list.add(this.getTransformationPackageSet());
        return list;
    }

    @Override
    public void doAfterLoad() {
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        if (this.getMainView() != null) {
            this.getMainView().setDirty(false);
        }
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void load() {
        XMLPersistenceManager pm = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader reader = pm.getDesignPartReader(this);
        if (reader != null) {
            reader.recreateDesign(this.getObjectID(), (DesignPart)this, false);
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        if (this.getMainView() != null) {
            this.getMainView().setDirty(false);
        }
        this.setDirty(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            DataFlowDesign dfDesign;
            if (event.getAffected() instanceof DataFlowDesign && (dfDesign = (DataFlowDesign)event.getAffected()).isTopLevel()) {
                dfDesign.setParent(this.topDataFlowDesigns);
                this.topDataFlowDesigns.add(dfDesign);
                dfDesign.addDesignListener(this);
            }
        } else if (event.isType(0) && event.getAffected() instanceof DataFlowDesign) {
            DataFlowDesign dfDesign = (DataFlowDesign)event.getAffected();
            this.topDataFlowDesigns.remove(dfDesign);
            dfDesign.addDesignListener(this);
        }
    }

    public List getAllPrimitiveProcesses() {
        ArrayList list = new ArrayList();
        Iterator it = this.getDataFlowDesigns().iterator();
        while (it.hasNext()) {
            DataFlowDesign dfd = (DataFlowDesign)it.next();
            if (!dfd.isTopLevel()) continue;
            dfd.addAllPrimitiveProcesses(list);
        }
        return list;
    }

    public List getAllPrimitiveProcessesConnectedToStore() {
        ArrayList list = new ArrayList();
        Iterator it = this.getDataFlowDesigns().iterator();
        while (it.hasNext()) {
            DataFlowDesign dfd = (DataFlowDesign)it.next();
            if (!dfd.isTopLevel()) continue;
            dfd.addAllPrimitiveProcessesConnectedToStore(list);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        if (this.getEventSet().size() != 0) {
            return false;
        }
        if (this.getInfoStructureSet().size() != 0) {
            return false;
        }
        if (this.getInfoStoreSet().size() != 0) {
            return false;
        }
        if (this.getRoleSet().size() != 0) {
            return false;
        }
        if (this.getRecordStructureSet().size() != 0) {
            return false;
        }
        if (this.getDataFlowDesigns().size() != 0) {
            return false;
        }
        return this.getTransformationPackageSet().size() == 0;
    }

    public TransformationPackage getTransformationPackage() {
        return this.transformationPackage;
    }

    public void setTransformationPackage(TransformationPackage transformationPackage) {
        this.transformationPackage = transformationPackage;
    }

    public TransformationTask getTransformationTask() {
        return this.transformationTask;
    }

    public TransformationTask getTransformationTaskById(String id) {
        Iterator it = this.getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage pack = (TransformationPackage)it.next();
            Iterator packit = pack.getTransformationTaskSet().iterator();
            while (packit.hasNext()) {
                TransformationTask task = (TransformationTask)packit.next();
                if (!task.getObjectID().equalsIgnoreCase(id)) continue;
                return task;
            }
        }
        return null;
    }

    public List getTransformations() {
        ArrayList tasks = new ArrayList();
        Iterator it = this.getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage pack = (TransformationPackage)it.next();
            Iterator packit = pack.getTransformationTaskSet().iterator();
            while (packit.hasNext()) {
                TransformationTask task = (TransformationTask)packit.next();
                Iterator trIt = task.getTransformationSet().iterator();
                while (trIt.hasNext()) {
                    tasks.add(trIt.next());
                }
            }
        }
        return tasks;
    }

    public void setTransformationTask(TransformationTask transformationTask) {
        this.transformationTask = transformationTask;
    }

    public List getAllTransformationTasks() {
        ArrayList list = new ArrayList();
        Iterator it = this.getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage pack = (TransformationPackage)it.next();
            pack.getTransformationTaskSet().addAllElementsTo(list);
        }
        return list;
    }

    public void updateRoles() {
        Iterator it = this.getRoleSet().iterator();
        while (it.hasNext()) {
            Role role = (Role)it.next();
            role.updateProcesses();
        }
    }

    public void updateRecordStructures() {
        Iterator it = this.getRecordStructureSet().iterator();
        while (it.hasNext()) {
            RecordStructure rs = (RecordStructure)it.next();
            rs.updatedExtDatas();
        }
    }

    public void updateObjects() {
        this.updateRoles();
        this.updateRecordStructures();
    }

    public boolean hasOpenedDFDesigns() {
        return this.hasOpenedDFDesigns;
    }

    public void setHasOpenedDFDesigns(boolean hasDFDesigns) {
        this.hasOpenedDFDesigns = hasDFDesigns;
    }

    @Override
    public Note createNote() {
        return null;
    }

    public void buidEntAttrFlowMaps() {
        this.entityFlowMap.clear();
        this.attributeFlowMap.clear();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ProcessModelPropertiesDialog dialog = new ProcessModelPropertiesDialog(this.getDesign().getAppView(), this, true);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("RecordStructure");
        list.add("ExternalData");
        list.add("Event");
        list.add("InfoStructure");
        list.add("InfoStore");
        list.add("Role");
        list.add("TransformationPackage");
        list.add("MainView");
        list.add("SubView");
        return list;
    }

    @Override
    public String getStoragePath() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "pm").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "pm/" + this.getName() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StorableObject createObject(String objectType, String objectID, String name) {
        DesignObject object = null;
        if ("RecordStructure".equalsIgnoreCase(objectType)) {
            object = this.getRecordStructureSet().createRecordStructure(objectID);
        } else if ("ExternalData".equalsIgnoreCase(objectType)) {
            object = this.getExternalDataSet().createExternalData(objectID);
        } else if ("Event".equalsIgnoreCase(objectType)) {
            object = this.getEventSet().createEvent(objectID, 0);
        } else if ("InfoStructure".equalsIgnoreCase(objectType)) {
            object = this.getInfoStructureSet().createInfoStructure(objectID);
        } else if ("InfoStore".equalsIgnoreCase(objectType)) {
            object = this.getInfoStoreSet().createInfoStore(objectID);
        } else if ("Role".equalsIgnoreCase(objectType)) {
            object = this.getRoleSet().createRole(objectID);
        } else if ("TransformationPackage".equalsIgnoreCase(objectType)) {
            object = this.getTransformationPackageSet().createTransformationPackage(objectID);
        } else if ("Note".equalsIgnoreCase(objectType)) {
            object = this.getNoteSet().createNote(objectID);
        }
        if (object != null && name != null && name.length() > 0) {
            object.setName(name);
        }
        return object;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("recordstructure", "RecordStructure");
            this.f2tMap.put("extdata", "ExternalData");
            this.f2tMap.put("event", "Event");
            this.f2tMap.put("infostructure", "InfoStructure");
            this.f2tMap.put("store", "InfoStore");
            this.f2tMap.put("role", "Role");
            this.f2tMap.put("tp", "TransformationPackage");
        }
        return this.f2tMap;
    }

    public static void initObjectDetails(Design design, File file, String path, StorableObjectStatusHelper sosHelper, String storableObjectID) {
        sosHelper.treePath.add(new TreePathHelper(OBJECT_TYPE_NAME, new File(design.getProcessModel().getStorageName()), ProcessModel.class));
        if ("recordstructure".equalsIgnoreCase(path)) {
            sosHelper.objectClass = RecordStructure.class;
            sosHelper.objectType = "RecordStructure";
            sosHelper.treePath.add(new TreePathHelper(REC_STRUCTURE_SET_NAME, file.getParentFile(), RecordStructureSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((ProcessModel)sosHelper.designPart).getRecordStructureSet();
                sosHelper.storableObject = ((ProcessModel)sosHelper.designPart).getRecordStructureSet().getObjectByID(storableObjectID);
            }
        } else if ("extdata".equalsIgnoreCase(path)) {
            sosHelper.objectClass = ExternalData.class;
            sosHelper.objectType = "ExternalData";
            sosHelper.treePath.add(new TreePathHelper(EXT_DATA_SET_NAME, file.getParentFile(), ExternalDataSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((ProcessModel)sosHelper.designPart).getExternalDataSet();
                sosHelper.storableObject = ((ProcessModel)sosHelper.designPart).getExternalDataSet().getObjectByID(storableObjectID);
            }
        } else if ("event".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Event.class;
            sosHelper.objectType = "Event";
            sosHelper.treePath.add(new TreePathHelper(EVENT_SET_NAME, file.getParentFile(), EventSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((ProcessModel)sosHelper.designPart).getEventSet();
                sosHelper.storableObject = ((ProcessModel)sosHelper.designPart).getEventSet().getObjectByID(storableObjectID);
            }
        } else if ("infostructure".equalsIgnoreCase(path)) {
            sosHelper.objectClass = InfoStructure.class;
            sosHelper.objectType = "InfoStructure";
            sosHelper.treePath.add(new TreePathHelper(INFOSTRUCTURE_SET_NAME, file.getParentFile(), InfoStructureSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((ProcessModel)sosHelper.designPart).getInfoStructureSet();
                sosHelper.storableObject = ((ProcessModel)sosHelper.designPart).getInfoStructureSet().getObjectByID(storableObjectID);
            }
        } else if ("store".equalsIgnoreCase(path)) {
            sosHelper.objectClass = InfoStore.class;
            sosHelper.objectType = "InfoStore";
            sosHelper.treePath.add(new TreePathHelper(STORE_SET_NAME, file.getParentFile(), InfoStoreSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((ProcessModel)sosHelper.designPart).getInfoStoreSet();
                sosHelper.storableObject = ((ProcessModel)sosHelper.designPart).getInfoStoreSet().getObjectByID(storableObjectID);
            }
        } else if ("role".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Role.class;
            sosHelper.objectType = "Role";
            sosHelper.treePath.add(new TreePathHelper(ROLE_SET_NAME, file.getParentFile(), RoleSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((ProcessModel)sosHelper.designPart).getRoleSet();
                sosHelper.storableObject = ((ProcessModel)sosHelper.designPart).getRoleSet().getObjectByID(storableObjectID);
            }
        } else if ("tp".equalsIgnoreCase(path)) {
            sosHelper.objectClass = TransformationPackage.class;
            sosHelper.objectType = "TransformationPackage";
            sosHelper.treePath.add(new TreePathHelper(ProcessModel.getTransformationPackageSetName(), file.getParentFile(), TransformationPackageSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((ProcessModel)sosHelper.designPart).getTransformationPackageSet();
                sosHelper.storableObject = ((ProcessModel)sosHelper.designPart).getTransformationPackageSet().getObjectByID(storableObjectID);
            }
        } else if ("dflows".equalsIgnoreCase(path)) {
            sosHelper.objectClass = DataFlowDesign.class;
            sosHelper.objectType = "Data Flow Diagram";
            sosHelper.treePath.add(new TreePathHelper(ProcessModel.getDataFlowDesignSetName(), file.getParentFile(), DataFlowDesignSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((ProcessModel)sosHelper.designPart).getDataFlowDesigns();
                sosHelper.storableObject = ((ProcessModel)sosHelper.designPart).getDataFlowDesigns().getObjectByID(storableObjectID);
            }
        }
    }

    public StorableObjectStatusHelper initDesignPart(String pathName, String dpID, StorableObjectStatusHelper sosHelper) {
        if ("dflows".equalsIgnoreCase(pathName)) {
            sosHelper.designPartClass = DataFlowDesign.class;
            sosHelper.designPart = null;
            Iterator it = this.getDataFlowDesigns().iterator();
            while (it.hasNext()) {
                DataFlowDesign model = (DataFlowDesign)it.next();
                if (!dpID.equalsIgnoreCase(model.getObjectID())) continue;
                sosHelper.designPart = model;
                break;
            }
            return sosHelper;
        }
        return null;
    }

    public void orderDataFlowDesigns() {
        this.getDataFlowDesigns().orderDataFlowDesigns();
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        this.sortCollections();
        this.updateObjects();
    }

    @Override
    public void designChanged(DesignEvent event) {
        if (event.isType("DFD top level flag changed") && event.getDesignPart() instanceof DataFlowDesign) {
            DataFlowDesign dfDesign = (DataFlowDesign)event.getDesignPart();
            if (dfDesign.isTopLevel() && !this.topDataFlowDesigns.contains(dfDesign)) {
                dfDesign.setParent(this.topDataFlowDesigns);
                this.topDataFlowDesigns.add(dfDesign);
            } else if (!dfDesign.isTopLevel()) {
                this.topDataFlowDesigns.remove(dfDesign);
            }
        }
    }

    @Override
    public List<Object> getObjectsWithMeasurements() {
        ArrayList<Object> objects = new ArrayList<Object>();
        Iterator it = this.getEventSet().iterator();
        while (it.hasNext()) {
            Event event = (Event)it.next();
            if (event.getMeasurements().size() <= 0) continue;
            objects.add(event);
        }
        it = this.getInfoStructureSet().iterator();
        while (it.hasNext()) {
            InfoStructure infoStructure = (InfoStructure)it.next();
            if (infoStructure.getMeasurements().size() <= 0) continue;
            objects.add(infoStructure);
        }
        it = this.getInfoStoreSet().iterator();
        while (it.hasNext()) {
            InfoStore infoStore = (InfoStore)it.next();
            if (infoStore.getMeasurements().size() <= 0) continue;
            objects.add(infoStore);
        }
        it = this.getRoleSet().iterator();
        while (it.hasNext()) {
            Role role = (Role)it.next();
            if (role.getMeasurements().size() <= 0) continue;
            objects.add(role);
        }
        it = this.getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage transformationPackage = (TransformationPackage)it.next();
            if (transformationPackage.getMeasurements().size() <= 0) continue;
            objects.add(transformationPackage);
        }
        it = this.getExternalDataSet().iterator();
        while (it.hasNext()) {
            ExternalData externalData = (ExternalData)it.next();
            if (externalData.getMeasurements().size() <= 0) continue;
            objects.add(externalData);
        }
        it = this.getRecordStructureSet().iterator();
        while (it.hasNext()) {
            RecordStructure recordStructure = (RecordStructure)it.next();
            if (recordStructure.getMeasurements().size() <= 0) continue;
            objects.add(recordStructure);
        }
        return objects;
    }

    @Override
    public ArrayList<SearchDockable> getAllSearchDockables() {
        if (this.allSearchDockables == null) {
            this.allSearchDockables = new ArrayList();
        }
        return this.allSearchDockables;
    }

    @Override
    public void addSearchDockable(SearchDockable sd) {
        this.getAllSearchDockables().add(sd);
    }

    @Override
    public SearchDockable getLastNonPinnedSearchDockable() {
        SearchDockable lastOne = null;
        int currentSeq = 0;
        for (SearchDockable sd : this.getAllSearchDockables()) {
            if (((SearchPanel)sd.getGUI()).isPinned() || sd.getViewSequence() < currentSeq) continue;
            lastOne = sd;
        }
        return lastOne;
    }

    @Override
    public int getSearchDockableIdSequence() {
        int currentSeq = 0;
        for (SearchDockable sd : this.getAllSearchDockables()) {
            if (sd.getViewSequence() <= currentSeq) continue;
            currentSeq = sd.getViewSequence();
        }
        return currentSeq + 1;
    }

    @Override
    public void closeAllSearchDockables() {
        for (SearchDockable sd : this.getAllSearchDockables()) {
            sd.closeView(sd);
        }
        this.getAllSearchDockables().clear();
    }

    @Override
    public List getSearchableSets() {
        ArrayList<SearchSet> sets = new ArrayList<SearchSet>();
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(DataFlowDesign.class), DataFlowDesign.class, this, this.getDataFlowDesigns()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(InfoStructure.class), InfoStructure.class, this, this.getInfoStructureSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Event.class), Event.class, this, this.getEventSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Role.class), Role.class, this, this.getRoleSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(RecordStructure.class), RecordStructure.class, this, this.getRecordStructureSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(TransformationPackage.class), TransformationPackage.class, this, this.getTransformationPackageSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(InfoStore.class), InfoStore.class, this, this.getInfoStoreSet()));
        return sets;
    }
}

