/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;

public class TargetElement
implements ID_ObjectPropertyTranslator {
    private DesignObject target;
    private List sources = new ArrayList();
    private String transformationType = Transformation.TRANSFORMATION_TYPES[0];
    private String Description = "";
    private String objectID;
    private String name;
    private DesignPart designPart;
    private Process process;

    public TargetElement(DesignPart designPart) {
        this.designPart = designPart;
    }

    public TargetElement(DesignObject target) {
        this.target = target;
        this.designPart = target.getDesignPart();
    }

    public TargetElement(DesignObject target, Process process) {
        this.target = target;
        this.designPart = target.getDesignPart();
        this.process = process;
    }

    public TargetElement(TargetElement targetElement) {
        this.target = targetElement.getTarget();
        this.sources.addAll(targetElement.getSources());
        this.transformationType = targetElement.getTransformationType();
        this.Description = targetElement.getDescription();
        this.designPart = this.target.getDesignPart();
    }

    public DesignObject getTarget() {
        return this.target;
    }

    public void setTarget(DesignObject target) {
        this.target = target;
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public List getSources() {
        return this.sources;
    }

    public void addSource(DesignObject source) {
        this.sources.add(source);
    }

    public void removeSource(DesignObject source) {
        this.sources.remove(source);
    }

    public DesignObject getSourceByID(String id) {
        for (DesignObject obj : this.sources) {
            if (!obj.getObjectID().equals(id)) continue;
            return obj;
        }
        return null;
    }

    public String getTransformationType() {
        return this.transformationType;
    }

    public void setTransformationType(String transformationType) {
        this.transformationType = transformationType;
    }

    public String getObjectID() {
        if (this.target != null) {
            return this.target.getObjectID();
        }
        return this.objectID;
    }

    public void setObjectID(String objectID) {
        this.objectID = objectID;
    }

    public String getName() {
        if (this.target != null) {
            return this.target.getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        Object obj = null;
        if (this.process != null && (obj = this.process.translateIdToObject(propertyName, id)) != null) {
            return obj;
        }
        Design design = this.designPart.getDesign();
        if (design != null) {
            obj = design.getDesignObject(id);
            return obj;
        }
        return null;
    }

    @Override
    public String translateObjectToID(String propertyName, Object object) {
        if (object != null && object instanceof ModelIDObject) {
            return ((ModelIDObject)object).getObjectID();
        }
        return null;
    }

    public void setProcess(Process process) {
        this.process = process;
    }
}

