/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.swingui.editor.process.TransformationPropertiesDialogEx;

public class Transformation
extends AbstractProcessObject
implements EditableFonts {
    public static final int PRIMITIVE_TYPE = 0;
    public static final int COMPOSITE_TYPE = 1;
    public static final String[] TRANSFORMATION_TYPES_DISPLAY = new String[]{Messages.getString("Transformation.AsItIs"), Messages.getString("Transformation.Derivation"), Messages.getString("Transformation.Aggregation"), Messages.getString("Transformation.Summarization"), Messages.getString("Transformation.ComplexFormula")};
    public static final String[] TRANSFORMATION_TYPES = new String[]{"As It Is", "Derivation", "Aggregation", "Summarization", "Complex Formula"};
    private int type = 0;
    private List targetElements = new ArrayList();
    private boolean primary = false;
    private String filterCondition = "";
    private String joinCondition = "";
    private List editableFonts = new ArrayList();
    public static final String TYPE_NAME = "Transformation";

    public Transformation(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isLeaf() {
        return this.type == 0;
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return -1;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "TRANSF";
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TransformationPropertiesDialogEx dialog = new TransformationPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public List getInfoStructures() {
        ArrayList<InfoStructure> result = new ArrayList<InfoStructure>();
        for (int i = 0; i < this.getAllFlows().length; ++i) {
            Flow flow = this.getAllFlows()[i].getFlow();
            for (InfoStructure structure : flow.getInfoStructures()) {
                if (result.contains(structure)) continue;
                result.add(structure);
            }
        }
        return result;
    }

    public List getProcessedAttributes(boolean flowsToStoreOnly) {
        ArrayList<ProcessedObject> result = new ArrayList<ProcessedObject>();
        ArrayList<Flow> storeFlows = new ArrayList<Flow>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof InfoStore) && (flowsToStoreOnly || !(flow.getSourceProcessObject() instanceof Transformation)) || storeFlows.contains(flow)) continue;
            storeFlows.add(flow);
        }
        for (Flow flow : this.getOutgoingFlows()) {
            if (!(flow.getTargetProcessObject() instanceof InfoStore) && (flowsToStoreOnly || !(flow.getTargetProcessObject() instanceof Transformation)) || storeFlows.contains(flow)) continue;
            storeFlows.add(flow);
        }
        for (Flow flow : storeFlows) {
            List flowlist = flow.getInfoStructures();
            Iterator is = flowlist.iterator();
            while (is.hasNext()) {
                for (Attribute attribute : ((InfoStructure)is.next()).getAttributes()) {
                    ProcessedObject po = this.getProcessedObjectFor(result, attribute);
                    if (po == null) {
                        po = new ProcessedObject();
                        po.setObject(attribute);
                        result.add(po);
                    }
                    po.setOpCreate(flow.isOpCreate() || po.isOpCreate());
                    po.setOpRead(flow.isOpRead() || po.isOpRead());
                    po.setOpUpdate(flow.isOpUpdate() || po.isOpUpdate());
                    po.setOpDelete(flow.isOpDelete() || po.isOpDelete());
                }
            }
        }
        return result;
    }

    public List getTargetAttributes(boolean flowsToStoreOnly) {
        ArrayList<DesignObject> result = new ArrayList<DesignObject>();
        ArrayList<Flow> storeFlows = new ArrayList<Flow>();
        for (Flow flow : this.getOutgoingFlows()) {
            if (flow.getTargetProcessObject() instanceof InfoStore || !flowsToStoreOnly && flow.getTargetProcessObject() instanceof Transformation) {
                if (storeFlows.contains(flow)) continue;
                storeFlows.add(flow);
                continue;
            }
            if (!(flow.getTargetProcessObject() instanceof InOutParams)) continue;
            InOutParams params = (InOutParams)flow.getTargetProcessObject();
            result.addAll(params.getParams());
        }
        for (Flow flow : storeFlows) {
            if (flow.getExternalData().size() < 1) {
                Iterator is = flow.getInfoStructures().iterator();
                while (is.hasNext()) {
                    for (DesignObject dobj : ((InfoStructure)is.next()).getAttributes()) {
                        if (result.contains(dobj)) continue;
                        result.add(dobj);
                    }
                }
                continue;
            }
            for (DesignObject dobj : flow.getExternalData()) {
                if (result.contains(dobj)) continue;
                result.add(dobj);
            }
        }
        return result;
    }

    private ProcessedObject getProcessedObjectFor(List polist, DesignObject po) {
        for (ProcessedObject obj : polist) {
            if (obj.getObject() != po) continue;
            return obj;
        }
        return null;
    }

    public List getProcessedEntities(boolean flowsToStoreOnly) {
        ArrayList<ProcessedObject> result = new ArrayList<ProcessedObject>();
        for (ProcessedObject po : this.getProcessedAttributes(flowsToStoreOnly)) {
            ContainerObject ent = ((Attribute)po.getObject()).getContainer();
            ProcessedObject pe = this.getProcessedObjectFor(result, ent);
            if (pe == null) {
                pe = new ProcessedObject();
                pe.setObject(ent);
                result.add(pe);
            }
            pe.setObject(((Attribute)po.getObject()).getContainer());
            pe.setOpCreate(po.isOpCreate() || pe.isOpCreate());
            pe.setOpRead(po.isOpRead() || pe.isOpRead());
            pe.setOpUpdate(po.isOpUpdate() || pe.isOpUpdate());
            pe.setOpDelete(po.isOpDelete() || pe.isOpDelete());
        }
        return result;
    }

    public void addProcessedEntitiesToList(List list, boolean flowsToStoreOnly) {
        for (ProcessedObject po : this.getProcessedEntities(flowsToStoreOnly)) {
            DesignObject ent = po.getObject();
            ProcessedObject pe = this.getProcessedObjectFor(list, ent);
            if (pe == null) {
                pe = new ProcessedObject();
                pe.setObject(ent);
                list.add(pe);
            }
            pe.setObject(po.getObject());
            pe.setOpCreate(po.isOpCreate() || pe.isOpCreate());
            pe.setOpRead(po.isOpRead() || pe.isOpRead());
            pe.setOpUpdate(po.isOpUpdate() || pe.isOpUpdate());
            pe.setOpDelete(po.isOpDelete() || pe.isOpDelete());
        }
    }

    public String getProcessNumber() {
        String levelNumber = Integer.toString(this.getDesignObjectSet().getIndexOf(this) + 1);
        return levelNumber;
    }

    public boolean isComposite() {
        return this.type == 1;
    }

    @Override
    public void remove() {
        this.removeFlows();
        super.remove();
    }

    public void updateTargetElements() {
        this.removeInvalidElements();
        for (Flow flow : this.getOutgoingFlows()) {
            if (flow.getTargetProcessObject() instanceof InOutParams) {
                InOutParams params = (InOutParams)flow.getTargetProcessObject();
                for (DesignObject attribute : params.getParams()) {
                    if (this.containsTarget(attribute)) continue;
                    this.targetElements.add(new TargetElement(attribute));
                }
                continue;
            }
            for (InfoStructure structure : flow.getInfoStructures()) {
                for (Attribute attribute : structure.getAttributes()) {
                    if (this.containsTarget(attribute)) continue;
                    this.targetElements.add(new TargetElement(attribute));
                }
            }
        }
    }

    public void removeInvalidElements() {
        List targets = this.getTargetAttributes(false);
        for (int i = this.targetElements.size() - 1; i >= 0; --i) {
            TargetElement target = (TargetElement)this.targetElements.get(i);
            if (targets.contains(target.getTarget())) continue;
            this.targetElements.remove(target);
        }
        List sources = this.getSourceElements();
        for (int i = 0; i < this.targetElements.size(); ++i) {
            TargetElement target = (TargetElement)this.targetElements.get(i);
            for (int j = target.getSources().size() - 1; j >= 0; --j) {
                DesignObject source = (DesignObject)target.getSources().get(j);
                if (sources.contains(source)) continue;
                target.getSources().remove(j);
            }
        }
    }

    private boolean containsTarget(DesignObject attribute) {
        for (TargetElement target : this.targetElements) {
            if (target.getTarget() != attribute) continue;
            return true;
        }
        return false;
    }

    public List getSourceElements_WithParams() {
        return this.getSourceElements();
    }

    public List getSourceElements() {
        ArrayList<DesignObject> result = new ArrayList<DesignObject>();
        for (Flow flow : this.getIncomingFlows()) {
            if (flow.getExternalData().size() < 1) {
                Iterator is = flow.getInfoStructures().iterator();
                while (is.hasNext()) {
                    for (DesignObject dobj : ((InfoStructure)is.next()).getAttributes()) {
                        if (result.contains(dobj)) continue;
                        result.add(dobj);
                    }
                }
            } else {
                for (DesignObject dobj : flow.getExternalData()) {
                    if (result.contains(dobj)) continue;
                    result.add(dobj);
                }
            }
            if (!(flow.getSourceProcessObject() instanceof InOutParams)) continue;
            InOutParams params = (InOutParams)flow.getSourceProcessObject();
            for (ParameterObject param : params.getParams()) {
                if (result.contains(param)) continue;
                result.add(param);
            }
        }
        return result;
    }

    public List getTargetElements() {
        return this.targetElements;
    }

    public boolean isConnectedToStore() {
        Flow.Connection[] conns = this.getAllFlows();
        for (int i = 0; i < conns.length; ++i) {
            Flow flow = conns[i].getFlow();
            if (!flow.isConnectedToInfoStore()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public String getJoinCondition() {
        return this.joinCondition;
    }

    public void setJoinCondition(String joinCondition) {
        this.joinCondition = joinCondition;
    }

    @Override
    public String getFCObjectType() {
        return TYPE_NAME;
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "process/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public class ProcessedObject {
        private DesignObject object;
        private boolean opCreate;
        private boolean opRead;
        private boolean opUpdate;
        private boolean opDelete;

        public DesignObject getObject() {
            return this.object;
        }

        public void setObject(DesignObject object) {
            this.object = object;
        }

        public boolean isOpCreate() {
            return this.opCreate;
        }

        public void setOpCreate(boolean opCreate) {
            this.opCreate = opCreate;
        }

        public boolean isOpDelete() {
            return this.opDelete;
        }

        public void setOpDelete(boolean opDelete) {
            this.opDelete = opDelete;
        }

        public boolean isOpRead() {
            return this.opRead;
        }

        public void setOpRead(boolean opRead) {
            this.opRead = opRead;
        }

        public boolean isOpUpdate() {
            return this.opUpdate;
        }

        public void setOpUpdate(boolean opUpdate) {
            this.opUpdate = opUpdate;
        }
    }
}

