/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ExternalDataSet;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStoreSet;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.ProcessSet;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.model.design.process.TransformationFlowSet;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.process.TranformationTaskPropertiesDialog;
import oracle.dbtools.crest.swingui.process.DPVTransformation;

public class TransformationTask
extends DesignPart {
    public static final String OBJECT_TYPE_NAME = "TransformationTask";
    public static final String FLOW_SET_NAME = "Flows";
    public static final String NOTE_SET_NAME = "Notes";
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    private ProcessModel processModel;
    protected DesignPartView mainView;
    private TransformationSet processSet;
    private TransformationFlowSet flowSet;
    DesignObjectCollection agents;
    DesignObjectCollection extProcesses;
    DesignObjectCollection stores;
    private NoteSet noteSet;
    private boolean topLevel = true;
    private Process process;
    private TransformationPackage transformationPackage;
    private InOutParams inputParams;
    private InOutParams outputParams;
    private IDGenerator localIDGenerator;
    private Map localIDs = new TreeMap();
    private List inputParameters = new ArrayList();
    private List outputParameters = new ArrayList();
    private List sources = new ArrayList();
    private List targets = new ArrayList();
    private boolean pmDirty = false;

    public TransformationTask(ProcessModel processModel, TransformationPackage transformationPackage) {
        this.setDesign(processModel.getDesign());
        this.processModel = processModel;
        this.transformationPackage = transformationPackage;
        this.processModel.setDirty(true);
        transformationPackage.setDirty(true);
        this.setParent(transformationPackage);
        this.inputParams = new InOutParams(this, "Input");
        this.outputParams = new InOutParams(this, "Output");
        this.inputParams.setDesign(processModel.getDesign());
        this.outputParams.setDesign(processModel.getDesign());
        if (this.inputParams.getObjectID() != null) {
            this.assignLocalID(this.inputParams);
        }
        if (this.outputParams.getObjectID() != null) {
            this.assignLocalID(this.outputParams);
        }
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    public void setProcessModel(ProcessModel processModel) {
        this.processModel = processModel;
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList collection = new ArrayList();
        this.getTransformationSet().addAllElementsTo(collection);
        this.getFlowSet().addAllElementsTo(collection);
        this.getNoteSet().addAllElementsTo(collection);
        this.getDiagramViewSet().addAllElementsTo(collection);
        return collection;
    }

    public TransformationFlowSet getFlowSet() {
        if (this.flowSet == null) {
            this.flowSet = new TransformationFlowSet(this);
            this.flowSet.setDesign(this.getDesign());
            this.flowSet.setName(Messages.getString("TransformationTask.Flows"));
            this.flowSet.setParent(this);
            this.flowSet.addSetListener(this);
        }
        return this.flowSet;
    }

    public InfoStoreSet getInfoStoreSet() {
        return this.getDesign().getProcessModel().getInfoStoreSet();
    }

    public TransformationSet getTransformationSet() {
        if (this.processSet == null) {
            this.processSet = new TransformationSet(this);
            this.processSet.setDesign(this.getDesign());
            this.processSet.setName(Messages.getString("TransformationTask.Transformations"));
            this.processSet.setParent(this);
            this.processSet.addSetListener(this);
        }
        return this.processSet;
    }

    @Override
    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(Messages.getString("TransformationTask.Notes"));
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public ExternalDataSet getExternalDataSet() {
        return this.getProcessModel().getExternalDataSet();
    }

    public Transformation createTransformation() {
        Transformation transformation = this.createTransformation(null);
        return transformation;
    }

    public Transformation createTransformation(String objectID) {
        Transformation transformation = this.getTransformationSet().createTransformation(objectID);
        return transformation;
    }

    public TransformationFlow createFlow() {
        return this.getFlowSet().createFlow(null);
    }

    public Flow createFlow(String objectID) {
        return this.getFlowSet().createFlow(objectID);
    }

    public InfoStore createInfoStore() {
        return this.getInfoStoreSet().createInfoStore(null);
    }

    public ExternalData createExternalData() {
        return this.getExternalDataSet().createExternalData(null);
    }

    @Override
    public Note createNote() {
        Note note = this.getNoteSet().createNote(null);
        return note;
    }

    @Override
    public Note recreateNote(String id) {
        return this.getNoteSet().createNote(id);
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        if (dirty) {
            this.processModel.setDirty(dirty);
        }
    }

    @Override
    public void clearAll() {
        this.getTransformationSet().removeAll();
        this.getNoteSet().removeAll();
        this.getStores().removeAll();
        this.getDiagramViewSet().removeAll();
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    public int getNumberOfChildren() {
        return 3;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.getTransformationSet();
            }
            case 1: {
                return this.getStores();
            }
            case 2: {
                return this.getFlowSet();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.getTransformationSet()) {
            return 0;
        }
        if (child == this.getStores()) {
            return 1;
        }
        if (child == this.getFlowSet()) {
            return 2;
        }
        return -1;
    }

    @Override
    protected DesignPartView createDesignPartSubView(String name) {
        return null;
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVTransformation(this.getDesign().getAppView(), this);
            this.mainView.addViewFor(this.inputParams);
            this.mainView.addViewFor(this.outputParams);
            this.mainView.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
            TopView tv = this.outputParams.getTopView();
            if (tv != null) {
                if (tv.getCellView() != null) {
                    tv.getCellView().setNewBounds(new Rectangle(600, 400, 150, 80));
                } else {
                    tv.setLocation(600, 400);
                }
            }
            if ((tv = this.inputParams.getTopView()) != null && tv.getCellView() != null) {
                Rectangle r = tv.getCellView().getBounds().getBounds();
                tv.getCellView().setNewBounds(new Rectangle(r.x, r.y, 150, 80));
            }
        }
        return this.mainView;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "TRTASK";
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (event == SetEvent.OBJECT_ADDED) {
            this.fireAdded(event.getAffected());
        } else if (event == SetEvent.OBJECT_REMOVED) {
            if (this.process != null) {
                this.agents.removePlaceHolderFor(event.getAffected());
                this.stores.removePlaceHolderFor(event.getAffected());
            }
            this.fireRemoved(event.getAffected());
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> list = new ArrayList<DesignObjectSet>();
        list.add(this.getTransformationSet());
        list.add(this.getFlowSet());
        list.add(this.getNoteSet());
        return list;
    }

    @Override
    public void doBeforeLoad() {
        this.pmDirty = this.getProcessModel().isDirty();
    }

    @Override
    public void doAfterLoad() {
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.getProcessModel().setDirty(this.pmDirty);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void load() {
        boolean dirty = this.getProcessModel().isDirty();
        XMLPersistenceManager pm = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader reader = pm.getDesignPartReader(this);
        if (reader != null) {
            if (this.getDesign().getLoadedVersion() < 3.2f) {
                reader.recreateDesign(this.getObjectID(), (DesignPart)this, false);
            } else {
                reader.recreateDesign(this.getPathIDString(), (DesignPart)this, false);
            }
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.getProcessModel().setDirty(dirty);
        this.checkAndSetIDGenerator();
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
        this.setParent(process);
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean topLevel) {
        this.topLevel = topLevel;
    }

    public Collection getFlowsForProcessObject(AbstractProcessObject processObject) {
        ArrayList<Flow> col = new ArrayList<Flow>();
        Iterator it = this.getFlowSet().iterator();
        while (it.hasNext()) {
            Flow flow = (Flow)it.next();
            if (processObject != flow.getSourceProcessObject() && processObject != flow.getTargetProcessObject()) continue;
            col.add(flow);
        }
        return col;
    }

    public void registerLocalObject(TopView topView) {
        DesignObject object = topView.getModel();
        if (object != null) {
            if (object instanceof ExternalAgent && !this.getAgents().containsPlaceHolderFor(object)) {
                this.getAgents().add(new DesignObjectPlaceHolder((DesignPart)this, object));
            } else if (object instanceof InfoStore && !this.getStores().containsPlaceHolderFor(object)) {
                this.getStores().add(new DesignObjectPlaceHolder((DesignPart)this, object));
            }
        }
    }

    public void unRegisterLocalObject(TopView topView) {
        DesignObject object = topView.getModel();
        if (object != null) {
            if (object instanceof ExternalAgent) {
                this.getAgents().removePlaceHolderFor(object);
            } else if (object instanceof InfoStore) {
                this.getStores().removePlaceHolderFor(object);
            }
        }
    }

    public DesignObjectCollection getStores() {
        if (this.stores == null) {
            this.stores = new DesignObjectCollection();
            this.stores.setDesign(this.getDesign());
            this.stores.setName(Messages.getString("TransformationTask.UsedInformationStores"));
            this.stores.setParent(this);
            this.stores.setElementDescriptor(InfoStore.class);
        }
        return this.stores;
    }

    public DesignObjectCollection getAgents() {
        if (this.agents == null) {
            this.agents = new DesignObjectCollection();
            this.agents.setDesign(this.getDesign());
            this.agents.setName(Messages.getString("TransformationTask.ProcessExternalAgents"));
            this.agents.setElementDescriptor(ExternalAgent.class);
            this.agents.setParent(this);
        }
        return this.agents;
    }

    public TransformationTask getParentDataFlowdesign() {
        if (this.process != null) {
            return (TransformationTask)this.process.getDesignPart();
        }
        return null;
    }

    public Flow getFirstFlowBetween(AbstractProcessObject source, AbstractProcessObject target) {
        Iterator it = this.getFlowSet().iterator();
        while (it.hasNext()) {
            Flow flow = (Flow)it.next();
            if (flow.getSourceProcessObject() != source || flow.getTargetProcessObject() != target) continue;
            return flow;
        }
        return null;
    }

    public List getFlowsBetween(AbstractProcessObject source, AbstractProcessObject target) {
        ArrayList<Flow> result = new ArrayList<Flow>();
        Iterator it = this.getFlowSet().iterator();
        while (it.hasNext()) {
            Flow flow = (Flow)it.next();
            if (flow.getSourceProcessObject() != source || flow.getTargetProcessObject() != target) continue;
            result.add(flow);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public TransformationPackage getTransformationPackage() {
        return this.transformationPackage;
    }

    public void addInputParam(ParameterObject parameter) {
        this.assignLocalID(parameter);
        this.inputParameters.add(parameter);
    }

    public void addOutputParam(ParameterObject parameter) {
        this.assignLocalID(parameter);
        this.outputParameters.add(parameter);
    }

    public void addInputParam(String id, String name, String logicalType) {
        ParameterObject param = new ParameterObject(this);
        param.setLogicalDatatype(this.getDesign().getLogicalDatatypeSet().getLogTypeByName(logicalType));
        param.setName(name);
        param.setObjectID(id);
        this.inputParameters.add(param);
    }

    public void addOutputParam(String id, String name, String logicalType) {
        ParameterObject param = new ParameterObject(this);
        param.setLogicalDatatype(this.getDesign().getLogicalDatatypeSet().getLogTypeByName(logicalType));
        param.setName(name);
        param.setObjectID(id);
        this.outputParameters.add(param);
    }

    protected void assignLocalID(ModelIDObject object) {
        String id = object.getObjectID();
        if (id == null) {
            while (this.localIDs.containsKey(id = this.getLocalIDGenerator().createNewID())) {
            }
            this.localIDs.put(id, object);
            object.setObjectID(id);
        } else {
            this.localIDs.put(id, object);
        }
    }

    protected void assignOldLocalID(ModelIDObject object) {
        String id = null;
        if (id == null) {
            while (this.localIDs.containsKey(id = this.getLocalIDGenerator().createNewID(this.getObjectID(), "#", object.getIDPrefix()))) {
            }
            this.localIDs.put(id, object);
            object.setObjectID(id);
        } else {
            this.localIDs.put(id, object);
        }
    }

    public IDGenerator getLocalIDGenerator() {
        if (this.localIDGenerator == null) {
            this.localIDGenerator = new IDGenerator();
            this.localIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.localIDGenerator;
    }

    public List getInputParameters() {
        return this.inputParameters;
    }

    public List getOutputParameters() {
        return this.outputParameters;
    }

    @Override
    public void setObjectID(String id) {
        super.setObjectID(id);
        this.assignLocalID(this.inputParams);
        this.assignLocalID(this.outputParams);
    }

    public InOutParams getInputParamsObject() {
        return this.inputParams;
    }

    public InOutParams getOutputParamsObject() {
        return this.outputParams;
    }

    public InOutParams getInOutParamsObjectById(String id) {
        if (this.getInputParamsObject().getObjectID().equalsIgnoreCase(id)) {
            return this.getInputParamsObject();
        }
        if (this.getOutputParamsObject().getObjectID().equalsIgnoreCase(id)) {
            return this.getOutputParamsObject();
        }
        return null;
    }

    public ParameterObject getParameterObjectById(String id) {
        for (ParameterObject par : this.inputParameters) {
            if (!par.getObjectID().equalsIgnoreCase(id)) continue;
            return par;
        }
        for (ParameterObject par : this.outputParameters) {
            if (!par.getObjectID().equalsIgnoreCase(id)) continue;
            return par;
        }
        return null;
    }

    public List getSources() {
        return this.sources;
    }

    public void addSource(InfoStore source) {
        this.sources.add(source);
    }

    public void removeSource(InfoStore source) {
        this.sources.remove(source);
    }

    public void removeAllSources() {
        this.sources.clear();
    }

    public List getTargets() {
        return this.targets;
    }

    public void addTarget(InfoStore target) {
        this.targets.add(target);
    }

    public void removeTarget(InfoStore target) {
        this.targets.remove(target);
    }

    public void removeAllTargets() {
        this.targets.clear();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TranformationTaskPropertiesDialog dialog = new TranformationTaskPropertiesDialog(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.showDialog();
        }
    }

    @Override
    public void setMainViewVisible(boolean visible) {
        super.setMainViewVisible(visible);
        if (!ApplicationView.loading) {
            this.transformationPackage.setDirty(true);
        }
    }

    @Override
    public void setMainViewVisible(boolean visible, ProgressDialog monitor) {
        super.setMainViewVisible(visible, monitor);
        if (!ApplicationView.loading) {
            this.transformationPackage.setDirty(true);
        }
    }

    public void assignOldLocalIDs() {
        this.assignOldLocalID(this.inputParams);
        this.assignOldLocalID(this.outputParams);
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Transformation");
        list.add(TransformationFlow.TYPE_NAME);
        list.add("Note");
        list.add("MainView");
        list.add("SubView");
        return list;
    }

    @Override
    public int getPathID() {
        if (this.pathID == 0) {
            this.pathID = this.transformationPackage.getTransformationTaskSet().nextIndex();
        }
        return this.pathID;
    }

    @Override
    public String getStoragePath() {
        String designPath = this.getTransformationPackage().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "tt/" + this.getObjectID()).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String designPath = this.getTransformationPackage().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "tt/" + this.getObjectID() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StorableObject createObject(String objectType, String objectID, String name) {
        DesignObject object = null;
        if ("Transformation".equalsIgnoreCase(objectType)) {
            object = this.getTransformationSet().createTransformation(objectID);
        } else if (TransformationFlow.TYPE_NAME.equalsIgnoreCase(objectType)) {
            object = this.getFlowSet().createFlow(objectID);
        } else if ("Note".equalsIgnoreCase(objectType)) {
            object = this.getNoteSet().createNote(objectID);
        }
        if (object != null && name != null && name.length() > 0) {
            object.setName(name);
        }
        return object;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("process", "Transformation");
            this.f2tMap.put("flow", TransformationFlow.TYPE_NAME);
            this.f2tMap.put("note", "Note");
        }
        return this.f2tMap;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        DesignObject object = null;
        object = this.getDesign().getDesignObject(id);
        if (object != null) {
            return object;
        }
        if ("processModel".equalsIgnoreCase(propertyName)) {
            ProcessModel pm = this.getDesign().getProcessModel();
            if (pm.getObjectID().equals(id)) {
                return pm;
            }
        } else if ("sourceProcessObject".equalsIgnoreCase(propertyName) || "targetProcessObject".equalsIgnoreCase(propertyName)) {
            object = this.getInOutParamsObjectById(id);
        }
        if (object != null) {
            return object;
        }
        return super.translateIdToObject(propertyName, id);
    }

    public String getInputParObjectID() {
        return this.getInputParamsObject().getObjectID();
    }

    public void setInputParObjectID(String id) {
        this.getInputParamsObject().setObjectID(id);
    }

    public String getOutputParObjectID() {
        return this.getOutputParamsObject().getObjectID();
    }

    public void setOutputParObjectID(String id) {
        this.getOutputParamsObject().setObjectID(id);
    }

    public static void initObjectDetails(Design design, File file, String type, StorableObjectStatusHelper sosHelper, String storableObjectID, String parentID) {
        sosHelper.designPartClass = TransformationTask.class;
        sosHelper.designPart = TransformationTask.findTransformationTask(design, storableObjectID);
        SVNObjectHelper svnOH = SVNObjectHelper.getSVNObjectHelperFor(design, storableObjectID);
        if (svnOH != null) {
            SVNObjectHelper parentSVNOH = SVNObjectHelper.getSVNObjectHelperFor(design, svnOH.parentID);
            while (parentSVNOH != null) {
                try {
                    Class<ModelIDObject> parentClass = Class.forName(parentSVNOH.className);
                    if (parentClass.isAssignableFrom(TransformationPackage.class)) {
                        sosHelper.treePath.add(0, new TreePathHelper(parentSVNOH.propName, new File(parentSVNOH.fileName), parentClass));
                        sosHelper.treePath.add(0, new TreePathHelper(ProcessModel.getTransformationPackageSetName(), new File(parentSVNOH.fileName).getParentFile(), parentClass));
                    } else if (parentClass.isAssignableFrom(TransformationTask.class)) {
                        sosHelper.treePath.add(0, new TreePathHelper(parentSVNOH.propName, new File(parentSVNOH.fileName), parentClass));
                    } else if (parentClass.isAssignableFrom(ProcessModel.class)) {
                        sosHelper.treePath.add(0, new TreePathHelper("Process Model", new File(design.getProcessModel().getStorageName()), parentClass));
                    }
                    parentSVNOH = SVNObjectHelper.getSVNObjectHelperFor(design, parentSVNOH.parentID);
                }
                catch (ClassNotFoundException e) {}
            }
        }
        if ("tt".equalsIgnoreCase(type)) {
            sosHelper.objectClass = TransformationTask.class;
            sosHelper.objectType = OBJECT_TYPE_NAME;
            sosHelper.objectSet = null;
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((TransformationTask)sosHelper.designPart).getTransformationPackage().getTransformationTaskSet();
                sosHelper.storableObject = ((TransformationTask)sosHelper.designPart).getTransformationPackage().getTransformationTaskSet().getObjectByID(storableObjectID);
            }
        } else if ("process".equalsIgnoreCase(type)) {
            sosHelper.objectClass = Transformation.class;
            sosHelper.objectType = "Transformation";
            sosHelper.treePath.add(new TreePathHelper(Messages.getString("TransformationTask.Transformations"), file.getParentFile(), ProcessSet.class));
            sosHelper.designPart = TransformationTask.findTransformationTask(design, parentID);
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((TransformationTask)sosHelper.designPart).getTransformationSet();
                sosHelper.storableObject = ((TransformationTask)sosHelper.designPart).getTransformationSet().getObjectByID(storableObjectID);
            }
        } else if ("flow".equalsIgnoreCase(type)) {
            sosHelper.objectClass = TransformationFlow.class;
            sosHelper.objectType = TransformationFlow.TYPE_NAME;
            sosHelper.treePath.add(new TreePathHelper(FLOW_SET_NAME, file.getParentFile(), TransformationFlowSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((TransformationTask)sosHelper.designPart).getFlowSet();
                sosHelper.storableObject = ((TransformationTask)sosHelper.designPart).getFlowSet().getObjectByID(storableObjectID);
            }
        } else if ("note".equalsIgnoreCase(type)) {
            sosHelper.objectClass = Note.class;
            sosHelper.objectType = "Note";
            sosHelper.treePath.add(new TreePathHelper(NOTE_SET_NAME, file.getParentFile(), NoteSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((TransformationTask)sosHelper.designPart).getNoteSet();
                sosHelper.storableObject = ((TransformationTask)sosHelper.designPart).getNoteSet().getObjectByID(storableObjectID);
            }
        } else if ("subviews".equalsIgnoreCase(type)) {
            sosHelper.objectClass = DPVTransformation.class;
            sosHelper.treePath.add(new TreePathHelper(DIAGRAM_SET_NAME, file.getParentFile(), DPVTransformation.class));
            if (sosHelper.designPart != null && sosHelper.designPart instanceof TransformationTask) {
                TransformationTask model = (TransformationTask)sosHelper.designPart;
                sosHelper.storableObject = model.getMainView().getDPVId().equals(storableObjectID) ? model.getMainView() : model.getSubViewByID(storableObjectID);
            }
        }
    }

    private static TransformationTask findTransformationTask(Design design, String storableObjectID) {
        for (Object o : design.getProcessModel().getAllTransformationTasks()) {
            TransformationTask model = (TransformationTask)o;
            if (!storableObjectID.equalsIgnoreCase(model.getObjectID())) continue;
            return model;
        }
        return null;
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        if (this.getMainView() != null) {
            this.getMainView().getWorkSpace().updateSettings();
        }
        this.sortCollections();
    }

    @Override
    public List<Object> getObjectsWithMeasurements() {
        ArrayList<Object> objects = new ArrayList<Object>();
        Iterator it = this.getTransformationSet().iterator();
        while (it.hasNext()) {
            Transformation transformation = (Transformation)it.next();
            if (transformation.getMeasurements().size() <= 0) continue;
            objects.add(transformation);
        }
        it = this.getFlowSet().iterator();
        while (it.hasNext()) {
            Flow flow = (Flow)it.next();
            if (flow.getMeasurements().size() <= 0) continue;
            objects.add(flow);
        }
        it = this.getNoteSet().iterator();
        while (it.hasNext()) {
            Note note = (Note)it.next();
            if (note.getMeasurements().size() <= 0) continue;
            objects.add(note);
        }
        return objects;
    }

    @Override
    public List getSearchableSets() {
        return Collections.EMPTY_LIST;
    }
}

