/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.Collection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;

public abstract class AbstractDenormalizer {
    private Table baseTable;
    private Table derivedTable;

    public abstract TableSet getTableSet();

    public void changeColumns(Collection columns, Table destination, boolean move) {
        this.changeColumns(columns.toArray(new Column[0]), destination, move);
    }

    public Column[] changeColumns(Column[] columns, Table destination, boolean move) {
        Column[] result = new Column[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            Column newColumn = null;
            if (column.isFKElement()) {
                Column columnFk = column;
                FKIndexAssociation oldAssociation = columnFk.getFKIndexAssociation();
                FKIndexAssociation newAssociation = null;
                FKIndexAssociation[] fks = destination.getFKAssociations();
                for (int j = 0; j < fks.length; ++j) {
                    FKIndexAssociation fkassociation = fks[j];
                    if (!oldAssociation.getObjectID().equalsIgnoreCase(fkassociation.getGeneratorID())) continue;
                    newAssociation = fkassociation;
                    break;
                }
                if (newAssociation == null) {
                    newAssociation = destination.addFK(oldAssociation.getKeyObject(), oldAssociation);
                    Index localFKIndex = newAssociation.getLocalFKIndex();
                    localFKIndex.setGeneratorID(oldAssociation.getGeneratorID());
                    ContainedObject[] indexCols = localFKIndex.getElements();
                    if (indexCols.length == 1) {
                        newColumn = (Column)indexCols[0];
                    }
                }
                System.out.println("AbstractDenormalizer.changeColumns: should FKAssociation be recreated ?");
            } else {
                newColumn = destination.createColumn();
            }
            if (newColumn != null) {
                column.copy(newColumn);
                newColumn.setGeneratorID(column.getGeneratorID());
            }
            result[i] = newColumn;
            if (!move) continue;
            column.remove();
        }
        return result;
    }

    public void moveColumns(Column[] columns, Table source, Table destination) {
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            source.remove(column);
            destination.add(column);
        }
    }

    public FKIndexAssociation[] changeForeignKeys(Collection foreignKeys, Table destination, boolean move) {
        return this.changeForeignKeys(foreignKeys.toArray(new FKIndexAssociation[0]), destination, move);
    }

    public FKIndexAssociation[] changeForeignKeys(FKIndexAssociation[] foreignKeys, Table destination, boolean move) {
        FKIndexAssociation[] result = new FKIndexAssociation[foreignKeys.length];
        return result;
    }

    public void setBaseTable(Table table) {
        this.baseTable = table;
    }

    public void setDerivedTable(Table table) {
        this.derivedTable = table;
    }

    public Table getBaseTable() {
        return this.baseTable;
    }

    public Table getDerivedTable() {
        return this.derivedTable;
    }

    protected Design getDesign() {
        Table table = this.getBaseTable();
        if (table == null) {
            table = this.getDerivedTable();
        }
        return table.getDesign();
    }
}

