/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.logical.RelationSet;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.ForeignKeyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.GUID;
import oracle.ide.Ide;

public class FKIndexAssociation
extends DesignObject
implements ContainerObjectListener,
ConnectionInterface {
    public static final String DELETE_RULE_CASCADE = "CASCADE";
    public static final String DELETE_RULE_SET_NULL = "SET NULL";
    public static final String DELETE_RULE_RESTRICT = "RESTRICT";
    public static final String DELETE_RULE_NOTHING = "NO ACTION";
    public static final String DELETE_RULE_SET_DEFAULT = "SET DEFAULT";
    public static final String[] DELETE_RULES = new String[]{"NO ACTION", "CASCADE", "SET NULL", "RESTRICT"};
    public static final String[] DELETE_RULES_ORACLE = new String[]{"NO ACTION", "CASCADE", "SET NULL"};
    public static final String[] OPTIONAL_CHILD_DELETE_RULES = new String[]{"RESTRICT", "NO ACTION", "SET NULL"};
    public static final String[] DELETE_RULES_WITHOUT_NULL = new String[]{"NO ACTION", "CASCADE", "RESTRICT"};
    public static final String[] DELETE_RULES_WITHOUT_NULL_ORACLE = new String[]{"NO ACTION", "CASCADE"};
    public static final String[] DELETE_RULES_WITH_DEFAULT = new String[]{"NO ACTION", "CASCADE", "SET NULL", "SET DEFAULT"};
    public static final String[] DELETE_RULES_WITH_DEFAULT_WITHOUT_NULL = new String[]{"NO ACTION", "CASCADE", "SET DEFAULT"};
    public static final String[] DELETE_RULES_RESTRICT_CASCADE = new String[]{"CASCADE", "RESTRICT"};
    public static final String[] DELETE_RULES_NOACTION_CASCADE = new String[]{"CASCADE", "NO ACTION"};
    public static final String PROPERTY_ASSOCIATION_ID = "fkassociation.id";
    public static final String ID_PREFIX = "IDXFK";
    public static boolean RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS = true;
    private Index fkIndex = null;
    Collection dpvCol = new ArrayList();
    DesignPartView dpvPhysical;
    protected KeyObject keyObject = null;
    protected ContainerWithKeyObject container = null;
    protected Map elementMap = new HashMap();
    protected String deleteRule = "NO ACTION";
    private boolean mandatory = true;
    private boolean transferable = true;
    private FKArc arc = null;
    public static float[] dashpattern = new float[]{8.0f, 8.0f};
    private FKIndexAssociation originatingFK;
    private TVTable originatingSourceTVTable;
    private TVTable originatingTargetTVTable;
    private boolean silentRemove = false;
    private String discriminatorValue = "";
    private Column discriminatorColumn;
    private boolean columnDependencyConstraintGenerateInDDL = true;
    private String columnDependencyConstraintGenerateName = "";
    public static final String TYPE_NAME = "FKIndexAssociation";
    TVTable sourceTVT = null;
    TVTable targetTVT = null;
    FKConnection fkConnection = null;

    public FKIndexAssociation(Table table) {
        super(table.getDesignPart());
        this.id = new GUID().toString();
        this.setContainerWithKeyObject(table);
        this.setBackup(table.isBackup());
    }

    public FKIndexAssociation(DesignPart designPart) {
        super(designPart);
    }

    public FKIndexAssociation(DesignPart designPart, FKIndexAssociation originatingFK) {
        super(designPart);
        this.originatingFK = originatingFK;
    }

    public void setContainerWithKeyObject(ContainerWithKeyObject container) {
        if (container != null) {
            container.addContainerListener(this);
        }
        this.container = container;
        if (container != null) {
            this.dpvPhysical = this.getDesign().getRelationalDesign().getMainView();
        }
    }

    public Table getTable() {
        return (Table)this.getContainerWithKeyObject();
    }

    public ContainedObject createElementFor(ContainedObject fkElement) {
        Column column = this.getTable().getFKColumn(this, (Column)fkElement);
        if (column == null) {
            Column columnFK = this.getTable().createColumnFK((Column)fkElement, this);
            this.getLocalFKIndex().add(columnFK);
            return columnFK;
        }
        return column;
    }

    @Override
    public String getIDPrefix() {
        return ID_PREFIX;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public Column[] getColumns() {
        return (Column[])this.getLocalFKIndex().getElements();
    }

    public boolean hasLocalFKIndex() {
        return this.fkIndex != null;
    }

    public void setLocalFKIndex(Index index) {
        this.fkIndex = index;
        if (index != null) {
            this.initializeLocalIndex(this.fkIndex);
        }
    }

    public Index getLocalFKIndex() {
        if (this.fkIndex == null) {
            this.fkIndex = this.createLocalFKIndex();
        } else if (this.fkIndex.getFKAssociation() == this && this.fkIndex.getContainerWithKeyObject() == null) {
            this.fkIndex.setContainerObject(this.getContainerWithKeyObject());
        }
        return this.fkIndex;
    }

    public Index getRemoteIndex() {
        return (Index)this.getKeyObject();
    }

    public Table getRemoteTable() {
        if (this.getRemoteIndex() != null) {
            return (Table)this.getRemoteIndex().getContainerObject();
        }
        return null;
    }

    public Index createLocalFKIndex() {
        this.fkIndex = this.getTable().createIndexFK(this);
        return this.initializeLocalIndex(this.fkIndex);
    }

    protected Index initializeLocalIndex(Index fkIndex) {
        fkIndex.setFKAssociation(this);
        Column[] columns = this.getTable().getAllFKColumns(this);
        for (int i = 0; i < columns.length; ++i) {
            fkIndex.add(columns[i]);
        }
        return fkIndex;
    }

    @Override
    public void remove() {
        this.getTable().removeContainerListener(this);
        this.getLocalFKIndex().remove();
        this.getTable().removeFKAssociationFromList(this);
        this.removeAllFKElements();
        super.remove();
        this.dpvCol.clear();
    }

    public void callRemoveListeners() {
        ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
        event.setAffected(this);
        this.fireChange(event);
        event.setAffected(null);
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getContainerWithKeyObject().isDropEnabled() || this.getContainerWithKeyObject().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public void changed(ContainerObject container, ContainerObjectEvent event) {
        if (!this.isBackupFK() && !this.getDesign().isCleaning()) {
            if (container instanceof KeyObject && this.getDesign().isPropagatePKChahges()) {
                if (event.isType(0)) {
                    this.addFKElement((ContainedObject)event.getAffectedElement());
                } else if (event.isType(1)) {
                    if (event.getAffectedElement() instanceof Column) {
                        ArrayList<Column> cols = new ArrayList<Column>();
                        cols.add((Column)event.getAffectedElement());
                        this.removeFKElement(cols);
                    }
                } else if (event.isType(4)) {
                    System.out.println("FKAssociation.changed: DOES NOT HAPPEN ? or irrelevant ?");
                } else if (event.isType(7)) {
                    this.moveLocalColumn(container, (Column)event.getAffectedElement());
                }
            }
            if (event.isType(4) && this.hasLocalFKIndex() && this.getLocalFKIndex().equals(event.getAffectedElement())) {
                this.setLocalFKIndex(null);
            }
        }
    }

    public void synchronizeFKColumns() {
        if (this.keyObject != null) {
            int i;
            Column[] pkCols = (Column[])this.keyObject.getElements();
            Table tab = (Table)this.getContainerWithKeyObject();
            ArrayList<Column> list = new ArrayList<Column>();
            for (i = 0; i < pkCols.length; ++i) {
                Column fkcol = tab.getFKColumn(this, pkCols[i]);
                if (fkcol == null) {
                    fkcol = tab.getColumnForDelegate(this, pkCols[i]);
                    if (fkcol != null) {
                        fkcol.addFKAssociation(pkCols[i], this);
                        this.getLocalFKIndex().add(fkcol);
                    } else {
                        fkcol = tab.createColumnFK(pkCols[i], this);
                        String name = ApplyNamingStandards.createFKColumnName(pkCols[i], this, this.getDesign().getDesignLevelSettings().getNamingStandardRule());
                        fkcol.setName(name);
                    }
                }
                list.add(fkcol);
                if (this.getLocalFKIndex().contains(fkcol)) continue;
                this.getLocalFKIndex().add(fkcol);
            }
            for (i = 0; i < list.size(); ++i) {
                this.getLocalFKIndex().moveToIndex((ContainedObject)list.get(i), i);
            }
        }
    }

    private Column getColumnForReferencedColumn(Column refcol) {
        for (Column col : this.getLocalFKIndex().getElementsCollection()) {
            if (!col.isReferingTo(this, refcol)) continue;
            return col;
        }
        return null;
    }

    private void moveLocalColumn(ContainerObject refContainer, Column refColumn) {
        int ind = refContainer.getIndexOf(refColumn);
        Column col = this.getColumnForReferencedColumn(refColumn);
        if (col != null) {
            this.getLocalFKIndex().moveToIndex(col, ind);
        }
    }

    @Override
    public void setTopView(TopView view) {
        this.addTopView(view);
    }

    @Override
    public TopView getTopView() {
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            return dpi.tv;
        }
        return null;
    }

    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        dpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv != null && inf.tv != view) {
            throw new RuntimeException(Messages.getString("FKIndexAssociation.AssociationAlreadyExists"));
        }
        inf.tv = view;
    }

    @Override
    public void removeTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        dpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv == null) {
            return;
        }
        this.dpvCol.remove(inf);
        this.removeObjectListener(view);
    }

    @Override
    public void resetViewNumbers() {
    }

    public dpvInfo getDPVInfoFor(DesignPartView dpv) {
        dpvInfo dpi2;
        for (dpvInfo dpi2 : this.dpvCol) {
            if (dpi2.dpv != dpv) continue;
            return dpi2;
        }
        dpi2 = new dpvInfo();
        dpi2.dpv = dpv;
        this.dpvCol.add(dpi2);
        return dpi2;
    }

    public List getAllTVRelations() {
        ArrayList<TopView> list = new ArrayList<TopView>();
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            list.add(dpi.tv);
        }
        return list;
    }

    @Override
    public TopView getViewFor(DesignPartView dpv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.tv;
    }

    @Override
    public String getGeneratorID() {
        if (this.hasLocalFKIndex()) {
            return this.getLocalFKIndex().getGeneratorID();
        }
        return "";
    }

    @Override
    public void setGeneratorID(String value) {
        if (this.hasLocalFKIndex()) {
            this.getLocalFKIndex().setGeneratorID(value);
        }
    }

    public void setSourceTVTable(TVTable source) {
        DesignPartView dpv = source.getDesignPartView();
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV != source) {
            boolean reassignConnection = false;
            if (dpi.sourceTV != null) {
                reassignConnection = true;
                if (dpi.tv != null && !this.isBackupFK()) {
                    ((TVFKRelation)dpi.tv).removeConnection();
                }
                dpi.sourceTV.removeTopViewListener(this);
            }
            dpi.sourceTV = source;
            if (!this.isBackupFK()) {
                dpi.sourceTV.addTopViewListener(this);
                this.addTVFKRelation(dpi);
                if (reassignConnection && dpi.tv != null) {
                    ((TVFKRelation)dpi.tv).addConnection(true);
                    ((TVFKRelation)dpi.tv).resetEdgeParams();
                }
            }
        }
    }

    public void resetSourceTVTable(TVTable source) {
        DesignPartView dpv = source.getDesignPartView();
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        boolean reassignConnection = false;
        if (dpi.sourceTV != null) {
            reassignConnection = true;
            if (dpi.tv != null && !this.isBackupFK()) {
                ((TVFKRelation)dpi.tv).removeConnection();
            }
            dpi.sourceTV.removeTopViewListener(this);
        }
        dpi.sourceTV = source;
        if (!this.isBackupFK()) {
            dpi.sourceTV.addTopViewListener(this);
            this.addTVFKRelation(dpi);
            if (reassignConnection && dpi.tv != null) {
                ((TVFKRelation)dpi.tv).addConnection(true);
                ((TVFKRelation)dpi.tv).resetEdgeParams();
            }
        }
    }

    public void setTargetTVTable(TVTable target) {
        DesignPartView dpv = target.getDesignPartView();
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV != target) {
            boolean reassignConnection = false;
            if (dpi.targetTV != null) {
                reassignConnection = true;
                if (dpi.tv != null && !this.isBackupFK()) {
                    ((TVFKRelation)dpi.tv).removeConnection();
                }
                dpi.targetTV.removeTopViewListener(this);
            }
            dpi.targetTV = target;
            if (!this.isBackupFK()) {
                dpi.targetTV.addTopViewListener(this);
                this.addTVFKRelation(dpi);
                if (reassignConnection && dpi.tv != null) {
                    ((TVFKRelation)dpi.tv).addConnection(true);
                    ((TVFKRelation)dpi.tv).resetEdgeParams();
                }
            }
        }
    }

    public void addTVFKRelation(dpvInfo dpi) {
        if (dpi.tv == null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            TVFKRelation tvr = new TVFKRelation(this.getDesign().getAppView(), dpi.dpv);
            tvr.setModel(this);
            tvr.setSize(new Dimension(100, 100));
            this.addObjectListener(tvr);
            dpi.dpv.registerForTreemodel(tvr);
            if (dpi.tv != null && ((TVFKRelation)dpi.tv).getEdge() == null && dpi.dpv.isVisible() && !ApplicationView.loading) {
                tvr.addConnection();
                tvr.resetEdgeParams();
            }
        }
        if (dpi.tv != null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            dpi.dpv.registerTopView(dpi.tv);
        }
    }

    public void addTVFKRelation(TopView tv, TVTable sourceTV, TVTable targetTV, DesignPartView dpv) {
        if (tv == null && sourceTV != null && targetTV != null && dpv != null) {
            TVFKRelation tvr = new TVFKRelation(this.getDesign().getAppView(), dpv);
            tvr.setModel(this);
            tvr.setSize(new Dimension(100, 100));
            this.addObjectListener(tvr);
            dpv.registerForTreemodel(tvr);
            if (dpv.isVisible() && !ApplicationView.loading) {
                tvr.addConnection();
                tvr.resetEdgeParams();
            }
        }
    }

    public void changeKeyObject(KeyObject newKey, Column[] fkColumns) {
        KeyObject oldKey = this.getKeyObject();
        Column[] old_cols = this.getLocalFKIndex().getColumns();
        if (oldKey != newKey) {
            this.setKeyObject(newKey);
            if (newKey != null) {
                if (this.getContainerWithKeyObject().isBST()) {
                    if (this.getOriginalContainer().isBST()) {
                        Column col = (Column)this.getContainerWithKeyObject().getExactRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                        if (col == null) {
                            col = (Column)this.getContainerWithKeyObject().getRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                        }
                        if (col != null) {
                            this.setRefFKColumn(col);
                        }
                    } else {
                        ContainedObject[] elements = this.keyObject.getElements();
                        for (int i = 0; i < elements.length; ++i) {
                            Column keyColumn = (Column)elements[i];
                            Column[] compatibleColumns = this.getCompatibleColumns(keyColumn);
                            if (compatibleColumns.length != 1) continue;
                            Column compatibleColumn = compatibleColumns[0];
                            compatibleColumn.addFKAssociation(keyColumn, this);
                            this.getLocalFKIndex().add(compatibleColumn);
                        }
                    }
                } else if (this.getOriginalContainer().isBST()) {
                    ContainedObject[] elements = this.keyObject.getElements();
                    if (elements.length > 0 && !elements[0].isOid()) {
                        for (int i = 0; i < elements.length; ++i) {
                            this.addFKElement(elements[i]);
                        }
                    } else {
                        Table table = (Table)this.getContainerWithKeyObject();
                        table.createRefToStructuredType(this.getOriginalContainer().getBasedOnStructuredType(), this);
                    }
                }
            }
            this.callRemoveListeners();
            this.addToAllDPVs();
        }
        this.swapFKColumnsWithAskDelete(old_cols, fkColumns);
    }

    public void addToAllDPVs() {
        DesignPartView dpv;
        Collection targetDPVs = this.getContainerWithKeyObject().getAffectedDPVs();
        Collection sourceDPVs = this.getRemoteTable().getAffectedDPVs();
        Iterator tit = targetDPVs.iterator();
        Iterator sit = sourceDPVs.iterator();
        while (tit.hasNext()) {
            dpv = (DesignPartView)tit.next();
            this.getTargetTV(dpv);
        }
        while (sit.hasNext()) {
            dpv = (DesignPartView)sit.next();
            this.getSourceTV(dpv);
        }
    }

    public TVTable getSourceTVTable() {
        DesignPartView dpv = ApplicationView.loading ? this.getDesignPart().getMainView() : this.getDesign().getAppView().getCurrentDPV();
        if (dpv == null) {
            dpv = this.getDesignPart().getMainView();
        }
        return this.getSourceTV(dpv);
    }

    public TVTable getTargetTVTable() {
        DesignPartView dpv = ApplicationView.loading ? this.getDesignPart().getMainView() : this.getDesign().getAppView().getCurrentDPV();
        if (dpv == null) {
            dpv = this.getDesignPart().getMainView();
        }
        return this.getTargetTV(dpv);
    }

    public TVTable getSourceTV(DesignPartView dpv) {
        Collection c;
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV == null && this.getRemoteTable() != null && !(c = this.getRemoteTable().getAllViews(dpv)).isEmpty()) {
            Iterator it = c.iterator();
            dpi.sourceTV = (TVTable)it.next();
            if (!this.isBackupFK()) {
                dpi.sourceTV.addTopViewListener(this);
                this.addTVFKRelation(dpi);
            }
        }
        return dpi.sourceTV;
    }

    public TVTable getTargetTV(DesignPartView dpv) {
        Collection c;
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV == null && this.getContainerWithKeyObject() != null && !(c = this.getContainerWithKeyObject().getAllViews(dpv)).isEmpty()) {
            Iterator it = c.iterator();
            dpi.targetTV = (TVTable)it.next();
            if (!this.isBackupFK()) {
                dpi.targetTV.addTopViewListener(this);
                this.addTVFKRelation(dpi);
            }
        }
        return dpi.targetTV;
    }

    public FKConnection getFKConnection() {
        if (this.fkConnection == null) {
            this.fkConnection = new FKConnection();
            this.fkConnection.setParentTable(this.getRemoteTable());
            this.fkConnection.setChildTable((Table)this.getContainerWithKeyObject());
        }
        return this.fkConnection;
    }

    @Override
    public void changed(TopView tv, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView dpv = tv.getDesignPartView();
            dpv.removeViewFor(this);
            dpvInfo dpi = this.getDPVInfoFor(dpv);
            dpi.tv = null;
            if (dpi.sourceTV == tv) {
                dpi.sourceTV = null;
            }
            if (dpi.targetTV == tv) {
                dpi.targetTV = null;
            }
        }
    }

    public void repairSelfReference() {
        if (this.getContainerWithKeyObject() == this.getRemoteTable()) {
            Collection targetDPVs = this.getContainerWithKeyObject().getAffectedDPVs();
            for (DesignPartView dpv : targetDPVs) {
                TVTable tv = this.getTargetTV(dpv);
                ((TVFKRelation)this.getViewFor(dpv)).repairSelfReference(tv);
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        if (this.getContainerWithKeyObject() != null && this.getContainerWithKeyObject().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    public void swapAndRemoveFKColumn(Column fkColumn, Column compatibleColumn, Column delegateColumn) {
        if (fkColumn == compatibleColumn) {
            return;
        }
        if (fkColumn.getContainerWithKeyObject() != compatibleColumn.getContainerWithKeyObject() || fkColumn.getContainerWithKeyObject() != this.getContainerWithKeyObject()) {
            return;
        }
        if (FKUtilities.compatibleColumns(fkColumn, compatibleColumn)) {
            int posInIndex = this.getLocalFKIndex().getIndexOf(fkColumn);
            fkColumn.removeFKAssociation(this.getObjectID());
            this.getLocalFKIndex().remove(fkColumn);
            compatibleColumn.addFKAssociation(delegateColumn, this);
            this.getLocalFKIndex().add(compatibleColumn);
            this.getLocalFKIndex().moveToIndex(compatibleColumn, posInIndex);
            if (fkColumn.getAssociationsCount() == 0 && !fkColumn.isPreviousColumn()) {
                fkColumn.remove();
            }
        }
    }

    public void swapFKColumnsWith(Column[] fkColumns) {
        ContainedObject col;
        int i;
        ContainedObject[] oldCols = (Column[])this.getLocalFKIndex().getElements();
        ContainedObject[] pkCols = (Column[])this.getKeyObject().getElements();
        this.changeMapping(oldCols, pkCols, fkColumns);
        for (i = 0; i < oldCols.length; ++i) {
            col = oldCols[i];
            ((Column)col).removeFKAssociation(this.getObjectID());
            this.getLocalFKIndex().remove(col);
        }
        for (i = 0; i < fkColumns.length; ++i) {
            if (fkColumns[i] == null) continue;
            fkColumns[i].addFKAssociation((Column)pkCols[i], this);
            this.getLocalFKIndex().add(fkColumns[i]);
        }
        for (i = 0; i < oldCols.length; ++i) {
            col = oldCols[i];
            if (((Column)col).getAssociationsCount() != 0 || ((Column)col).isPreviousColumn()) continue;
            col.remove();
        }
    }

    public void swapFKColumnsWithAskDelete(Column[] oldCols, Column[] fkColumns) {
        int i;
        int deleteFKcolumns = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
        ContainedObject[] pkCols = this.getKeyObject().getElements();
        this.changeMapping(oldCols, pkCols, fkColumns);
        for (i = 0; i < oldCols.length; ++i) {
            Column col = oldCols[i];
            col.removeFKAssociation(this.getObjectID());
            this.getLocalFKIndex().remove(col);
        }
        for (i = 0; i < fkColumns.length; ++i) {
            if (fkColumns[i] == null) continue;
            fkColumns[i].addFKAssociation((Column)pkCols[i], this);
            this.getLocalFKIndex().add(fkColumns[i]);
        }
        String colNames = "";
        ArrayList<Column> colList = new ArrayList<Column>();
        for (int i2 = 0; i2 < oldCols.length; ++i2) {
            Column col = oldCols[i2];
            if (col.getAssociationsCount() != 0 || col.isPreviousColumn()) continue;
            colNames = colNames.equals("") ? col.getName() : colNames + ", " + col.getName();
            colList.add(col);
        }
        if (colList.size() > 0) {
            if (this.getDesign().isClosing() || this.isSilentRemove()) {
                this.removeColumns(colList);
            } else if (deleteFKcolumns == 0 || this.getDesignPart().getUndoManager().isInUndoRedoMode()) {
                this.removeColumns(colList);
            } else if (deleteFKcolumns == 2) {
                JOptionPane pane = new JOptionPane(MessageFormat.format(Messages.getString("FKIndexAssociation.DoYouWantToDeleteColumns"), colNames), 3, 0);
                JDialog dialog = pane.createDialog((Component)Ide.getMainWindow(), Messages.getString("FKIndexAssociation.DeleteFKColumnsStrategy"));
                dialog.setVisible(true);
                Integer result = (Integer)pane.getValue();
                if (result == 0) {
                    this.removeColumns(colList);
                }
            }
        }
    }

    private void changeMapping(ContainedObject[] oldCols, ContainedObject[] pkCols, Column[] fkColumns) {
        Table tab;
        Entity ent;
        if (oldCols.length > 0 && (ent = (tab = (Table)oldCols[0].getContainer()).getEngEntity()) != null) {
            Column delegate;
            Column col;
            int i;
            HashMap<Column, Column> dmap = new HashMap<Column, Column>();
            for (i = 0; i < oldCols.length; ++i) {
                col = (Column)oldCols[i];
                delegate = col.getDelegate();
                if (delegate == null) continue;
                dmap.put(delegate, col);
            }
            for (i = 0; i < fkColumns.length; ++i) {
                DesignObject obj;
                XtdMapping mapping;
                Column old;
                col = fkColumns[i];
                delegate = (Column)pkCols[i];
                if (delegate == null || (old = (Column)dmap.get(delegate)) == null || old == col || (mapping = old.getMappingFor(ent)) == null || !((obj = mapping.getObjectMappedTo(old)) instanceof Attribute)) continue;
                Attribute attr = (Attribute)obj;
                XtdMapping nmapping = col.getRMExtendedMap().createMapping(attr, col);
                nmapping.setInheritanceType(mapping.getInheritanceType());
                col.getDesign().getExtendedMap().removeMapping(mapping);
                attr.setEngineerTo(col.getDesignPart().getObjectID(), false);
            }
        }
    }

    private void removeColumns(List<Column> colList) {
        for (Column col : colList) {
            col.remove();
            this.elementMap.remove(col);
        }
    }

    public Column[] getCompatibleColumns(Column column) {
        return FKUtilities.getCompatibleColumns(this.getContainerWithKeyObject(), column);
    }

    public Column getColumnForDelegate(Column delegate) {
        Column[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].isReferingTo(this, delegate)) continue;
            return cols[i];
        }
        return null;
    }

    public String getSubstitudeCaption() {
        return "Substitute FK Columns";
    }

    @Override
    public boolean hasAliveGenerator() {
        RelationSet iset;
        DesignObject obj;
        RelationSet set = this.getDesign().getLogicalDesign().getRelationSet();
        return ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID()) || (obj = set.getObjectByID(this.getGeneratorID())) != null || (obj = (iset = this.getDesign().getLogicalDesign().getInheritanceRelationSet()).getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ApplicationView apv = this.getDesign().getAppView();
            DesignPartView dpv = apv.getCurrentDPV();
            if (dpv != null && this.getContainerWithKeyObject().getDesignPart() != dpv.getDesignPart() || dpv == null) {
                dpv = this.getContainerWithKeyObject().getDesignPart().getMainView();
            }
            ForeignKeyPropertiesDialogEx dialog = new ForeignKeyPropertiesDialogEx(apv, this);
            dialog.initProperties(this.getFKMemento(dpv));
            dialog.show();
        }
    }

    public boolean showPropertyDialog(FKMemento mem, Dialog owner) {
        if (!this.isDialogVisible()) {
            ForeignKeyPropertiesDialogEx dialog = new ForeignKeyPropertiesDialogEx(owner, this.getDesign().getAppView(), this, mem);
            dialog.initProperties(mem);
            dialog.setModal(true);
            dialog.show();
            return dialog.changed();
        }
        return false;
    }

    public void addFKElement(ContainedObject fkElement) {
        ContainerObject originalContainer = this.getOriginalContainer();
        if (!this.getContainerWithKeyObject().isBST() && originalContainer != null) {
            Table table = (Table)this.getContainerWithKeyObject();
            Column columnFK = null;
            columnFK = table.getColumnForDelegate(this, (Column)fkElement);
            if (columnFK == null || !columnFK.getFKAssociationsForDelegate(fkElement.getObjectID()).contains(this)) {
                columnFK = (Column)this.doCreateElementFor(fkElement);
            } else {
                this.getLocalFKIndex().add(columnFK);
                columnFK.addFKAssociation((Column)fkElement, this);
            }
            columnFK.setNullsAllowed(!this.isMandatory());
            this.elementMap.put(fkElement, columnFK);
        }
    }

    protected ContainedObject doCreateElementFor(ContainedObject fkElement) {
        ContainedObject element = this.createElementFor(fkElement);
        if (!element.isNameFixed()) {
            String generatedFKColumnName = ApplyNamingStandards.createFKColumnName((Column)fkElement, this, this.getDesign().getDesignLevelSettings().getNamingStandardRule());
            element.setName(generatedFKColumnName != null ? generatedFKColumnName : fkElement.getName());
        }
        this.elementMap.put(fkElement, element);
        return element;
    }

    public void removeAllFKElements() {
        if (this.keyObject != null) {
            ArrayList<Column> col = new ArrayList<Column>();
            ContainedObject[] elements = this.keyObject.getElements();
            for (int i = 0; i < elements.length; ++i) {
                col.add((Column)elements[i]);
            }
            if (this.keyObject.getElementsCollection().size() > 0) {
                this.removeFKElement(col);
            } else {
                this.removeAssociationFromColumns();
            }
        }
        this.elementMap.clear();
    }

    private void removeAssociationFromColumns() {
        for (Column col : this.getLocalFKIndex().getElementsCollection()) {
            col.removeFKAssociation(this.getObjectID());
        }
        this.getLocalFKIndex().getElementsCollection().clear();
    }

    public void removeFKElement(List<Column> fkColumns) {
        int deleteFKcolumns = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
        String tableName = null;
        String colNames = "";
        ArrayList<Column> colList = new ArrayList<Column>();
        Iterator<Column> it = fkColumns.iterator();
        while (it.hasNext()) {
            Column col = ((Table)this.getContainerWithKeyObject()).getFKColumn(this, it.next());
            if (col == null) continue;
            tableName = col.getContainer().getName();
            this.getLocalFKIndex().remove(col);
            col.removeFKAssociation(this.getObjectID());
            if (this.isColumnUsedInConstraints(col) || col.getAssociationsCount() != 0 || col.isPreviousColumn()) continue;
            colNames = colNames.equals("") ? col.getName() : colNames + ", " + col.getName();
            colList.add(col);
        }
        if (colList.size() > 0) {
            if (this.getDesign().isClosing() || this.isSilentRemove()) {
                this.removeColumns(colList);
            } else if (deleteFKcolumns == 0 || this.getDesignPart().getUndoManager().isInUndoRedoMode()) {
                this.removeColumns(colList);
            } else if (deleteFKcolumns == 2) {
                JOptionPane pane = new JOptionPane(MessageFormat.format(Messages.getString("FKIndexAssociation.DoYouWantToDelete"), colNames, tableName), 3, 0);
                JDialog dialog = pane.createDialog((Component)Ide.getMainWindow(), Messages.getString("FKIndexAssociation.DeleteFKColumnsStrategy"));
                dialog.setVisible(true);
                Integer result = (Integer)pane.getValue();
                if (result == 0) {
                    this.removeColumns(colList);
                }
            }
        }
    }

    public void setKeyObject(KeyObject keyObject) {
        if (this.keyObject != keyObject) {
            if (this.keyObject != null) {
                this.keyObject.removeContainerListener(this);
                this.keyObject.removeObjectListener(this.getContainerWithKeyObject());
            }
            this.keyObject = keyObject;
            if (this.keyObject != null) {
                keyObject.addContainerListener(this);
                keyObject.addObjectListener(this.getContainerWithKeyObject());
            }
        }
    }

    public KeyObject getKeyObject() {
        return this.keyObject;
    }

    public String[] getDeleteRuleChoices() {
        return DELETE_RULES;
    }

    public void setDeleteRule(String rule) {
        this.deleteRule = rule != null ? rule : DELETE_RULE_NOTHING;
    }

    public String getDeleteRule() {
        return this.deleteRule;
    }

    public String getValidDeleteRule() {
        StorageDesign sd = ((RelationalDesign)this.getDesignPart()).getStorageDesign();
        if (sd != null) {
            return sd.getValidFKRule(this.deleteRule);
        }
        return this.deleteRule;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public void addAllFKElements() {
        ContainedObject[] elements = this.keyObject.getElements();
        if (!this.getContainerWithKeyObject().isBST() && !this.getOriginalContainer().isBST()) {
            for (int i = 0; i < elements.length; ++i) {
                this.addFKElement(elements[i]);
            }
        } else if (this.getContainerWithKeyObject().isBST()) {
            if (this.getOriginalContainer().isBST()) {
                Column col = (Column)this.getContainerWithKeyObject().getExactRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                if (col == null) {
                    col = (Column)this.getContainerWithKeyObject().getRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                }
                if (col != null) {
                    this.setRefFKColumn(col);
                }
            } else {
                for (int i = 0; i < elements.length; ++i) {
                    Column keyColumn = (Column)elements[i];
                    Column[] compatibleColumns = this.getCompatibleColumns(keyColumn);
                    if (compatibleColumns.length != 1) continue;
                    Column compatibleColumn = compatibleColumns[0];
                    compatibleColumn.addFKAssociation(keyColumn, this);
                    this.getLocalFKIndex().add(compatibleColumn);
                }
            }
        } else if (elements.length > 0 && !elements[0].isOid()) {
            for (int i = 0; i < elements.length; ++i) {
                this.addFKElement(elements[i]);
            }
        } else {
            Table table = (Table)this.getContainerWithKeyObject();
            table.createRefToStructuredType(this.getOriginalContainer().getBasedOnStructuredType(), this);
        }
    }

    private void setRefFKColumn(Column column) {
        Column col = (Column)this.getOriginalContainer().getOidElement();
        if (col != null) {
            column.addFKAssociation(col, this);
        }
        column.setScopeId(this.getOriginalContainer().getObjectID());
        this.getLocalFKIndex().add(column);
    }

    protected String longNameToName(String longName) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(longName, ".", true);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken();
            if (tok.equals(".")) {
                buf.append('_');
                continue;
            }
            buf.append(tok);
        }
        return buf.toString();
    }

    public ContainerObject getOriginalContainer() {
        if (this.getKeyObject() == null) {
            return null;
        }
        return this.getKeyObject().getContainerObject();
    }

    public ContainerWithKeyObject getContainerWithKeyObject() {
        return this.container;
    }

    @Override
    public String getLongName() {
        if (this.container != null) {
            StringBuffer buffer = new StringBuffer(this.container.getName());
            buffer.append(".").append(this.getName());
            return buffer.toString();
        }
        return this.getName();
    }

    @Override
    public String getVeryLongName() {
        if (this.container != null) {
            SchemaObject so = this.container.getSchemaObject();
            if (so != null) {
                StringBuffer buffer = new StringBuffer(so.getName());
                buffer.append(".").append(this.container.getName()).append(".").append(this.getName());
                return buffer.toString();
            }
            StringBuffer buffer = new StringBuffer(this.container.getName());
            buffer.append(".").append(this.getName());
            return buffer.toString();
        }
        return this.getName();
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView dpv) {
        return this.getViewFor(dpv) != null;
    }

    public Relation getEngRelation() {
        XtdMapping mapping;
        DesignObject obj;
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (obj = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null && obj instanceof Relation) {
            return (Relation)obj;
        }
        Relation relation = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectByID(this.getGeneratorID());
        if (relation == null) {
            relation = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectGeneratedBy(this.getObjectID());
        }
        return relation;
    }

    public List<XtdMapping> getMappingsToRelations() {
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            XtdMapping mapping;
            DesignObject obj;
            ArrayList<XtdMapping> res = new ArrayList<XtdMapping>();
            if (list.size() > 0 && (obj = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null && obj instanceof Relation) {
                res.add(mapping);
            }
            return res;
        }
        return Collections.EMPTY_LIST;
    }

    public Relation getEngRelation(Entity entity) {
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        for (int i = 0; i < list.size(); ++i) {
            Relation rel;
            XtdMapping mapping = (XtdMapping)list.get(i);
            DesignObject obj = mapping.getObjectMappedTo(this);
            if (obj == null || !(obj instanceof Relation) || (rel = (Relation)obj).getSourceEntity() != entity && rel.getTargetEntity() != entity) continue;
            return (Relation)obj;
        }
        Relation relation = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectByID(this.getGeneratorID());
        if (relation == null) {
            relation = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectGeneratedBy(this.getObjectID());
        }
        return relation;
    }

    public InheritanceRelation getEngInheritanceRelation() {
        XtdMapping mapping;
        DesignObject obj;
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (obj = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null && obj instanceof InheritanceRelation) {
            return (InheritanceRelation)obj;
        }
        return null;
    }

    @Override
    public void copy(DesignObject desObject) {
        super.copy(desObject);
        FKIndexAssociation newAssociation = (FKIndexAssociation)desObject;
        newAssociation.setDeleteRule(this.getDeleteRule());
        newAssociation.setMandatory(this.isMandatory());
        newAssociation.setTransferable(this.isTransferable());
        newAssociation.setArc(this.getArc());
        Table nt = newAssociation.getRemoteTable();
        Column col = this.getDiscriminatorColumn();
        if (col != null && nt != null) {
            Column dcol = null;
            if (nt.isRemoteObject()) {
                dcol = (Column)nt.getElementByRemoteObjectID(col.getObjectID());
            }
            if (dcol == null) {
                dcol = (Column)nt.getElementByID(col.getObjectID());
            }
            if (dcol == null) {
                dcol = (Column)nt.getElementByName(col.getName());
            }
            if (dcol != null) {
                newAssociation.setDiscriminatorColumn(dcol);
            }
        }
        newAssociation.setDiscriminatorValue(this.getDiscriminatorValue());
        newAssociation.setColumnDependencyConstraintGenerateName(this.getColumnDependencyConstraintGenerateName());
        newAssociation.setColumnDependencyConstraintGenerateInDDL(this.isColumnDependencyConstraintGenerateInDDL());
    }

    public void backupTo(FKIndexAssociation fk, DesignPartView dpv) {
        if (!fk.isBackupFK()) {
            throw new RuntimeException("FKIndexAssociation.backupTo(...) can be used only for backup FK");
        }
        this.copy(fk);
        fk.setNameFixed(this.isNameFixed());
        fk.setObjectID(this.getObjectID());
        Table table = (Table)fk.getContainerWithKeyObject();
        ArrayList<Column> list = new ArrayList<Column>();
        for (Column oldcol : this.getLocalFKIndex().getElementsCollection()) {
            Column newcol = (Column)table.getElementByID(oldcol.getObjectID());
            if (newcol == null) continue;
            list.add(newcol);
        }
        fk.swapFKColumnsWith(list.toArray(new Column[0]));
    }

    public void restoreTo(FKIndexAssociation fk, DesignPartView dpv) {
        if (!this.isBackupFK()) {
            throw new RuntimeException("FKIndexAssociation.restoreTo(...) can be used only tp restore from backup FK");
        }
        this.copy(fk);
        Table table = (Table)fk.getContainerWithKeyObject();
        ArrayList<Column> list = new ArrayList<Column>();
        for (Column oldcol : this.getLocalFKIndex().getElementsCollection()) {
            Column newcol = (Column)table.getElementByID(oldcol.getObjectID());
            if (newcol == null) continue;
            list.add(newcol);
        }
        fk.swapFKColumnsWith(list.toArray(new Column[0]));
    }

    public void restoreToCandidateOrigFK(FKIndexAssociation candidateOriginatingFK, DesignPartView dpv) {
        if (!this.getContainerWithKeyObject().isBackup() || this.originatingFK != null && this.originatingFK != candidateOriginatingFK) {
            throw new RuntimeException("FKIndexAssociation.restoreToCandidateOrigFK(...) can be used only when new FK on backup table is created in TablePropertiesDialogEx");
        }
        this.originatingFK = candidateOriginatingFK;
        this.restoreTo(candidateOriginatingFK, dpv);
    }

    public XtdMapping getDeletedMapping() {
        List list = this.getRMExtendedMap().getDeletedMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            XtdMapping mapping = (XtdMapping)list.get(0);
            return mapping;
        }
        return null;
    }

    @Override
    public void setSourceTopView(TopView source) {
        this.setSourceTVTable((TVTable)source);
    }

    @Override
    public void setTargetTopView(TopView target) {
        this.setTargetTVTable((TVTable)target);
    }

    @Override
    public TopView getSourceTopView(DesignPartView dpv) {
        return this.getSourceTV(dpv);
    }

    @Override
    public TopView getTargetTopView(DesignPartView dpv) {
        return this.getTargetTV(dpv);
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView dpv) {
        return this.getViewFor(dpv);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getRemoteTable();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getContainerWithKeyObject();
    }

    public boolean hasColumnWithAllowNulls() {
        Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getNullsAllowed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setName(String name) {
        Index localFKIndex;
        boolean result = super.setName(name);
        if (ApplicationView.loading) {
            return result;
        }
        if (result && (localFKIndex = this.getLocalFKIndex()) != null) {
            localFKIndex.setName(name);
        }
        return result;
    }

    @Override
    public void setMarkedGenerate(boolean markedGenerate) {
        super.setMarkedGenerate(markedGenerate);
        if (this.getLocalFKIndex() != null) {
            this.getLocalFKIndex().synchronizeMarkedGenerate(markedGenerate);
        }
    }

    public void synchronizeMarkedGenerate(boolean markedGenerate) {
        super.setMarkedGenerate(markedGenerate);
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        if (this.getDesign().isLoading()) {
            this.mandatory = mandatory;
            return;
        }
        if (this.mandatory != mandatory) {
            this.mandatory = mandatory;
            if (this.getLocalFKIndex() != null) {
                KeyObject pk = this.getContainerWithKeyObject().getPK();
                for (Column co : this.getLocalFKIndex().getElementsCollection()) {
                    boolean optional = co.getNullsAllowed();
                    if (pk != null && pk.contains(co)) {
                        co.setNullsAllowed(false);
                    } else if (!mandatory) {
                        if (co.isInMandatoryFK()) {
                            co.setNullsAllowed(false);
                        } else {
                            co.setNullsAllowed(true);
                        }
                    } else {
                        co.setNullsAllowed(!mandatory);
                    }
                    if (co.getNullsAllowed() == optional) continue;
                    co.setDirty(true);
                }
            }
        } else if (this.getLocalFKIndex() != null) {
            KeyObject pk = this.getContainerWithKeyObject().getPK();
            for (Column co : this.getLocalFKIndex().getElementsCollection()) {
                boolean optional = co.getNullsAllowed();
                if (mandatory) {
                    if (co.getNullsAllowed()) {
                        co.setNullsAllowed(false);
                    }
                } else if (pk != null && pk.contains(co) || co.isInMandatoryFK()) {
                    co.setNullsAllowed(false);
                } else if (!co.getNullsAllowed()) {
                    co.setNullsAllowed(true);
                }
                if (co.getNullsAllowed() == optional) continue;
                co.setDirty(true);
            }
        }
        if (mandatory && DELETE_RULE_SET_NULL.equals(this.getDeleteRule())) {
            this.setDeleteRule(DELETE_RULE_NOTHING);
            this.resetEdgeParams();
        }
        this.resetDependentColumns(mandatory);
    }

    private void resetDependentColumns(boolean mandatory) {
        List list = this.getTable().getColumnsDependinOn(this);
        for (Column col : list) {
            if (mandatory) {
                if (col.isMandatory()) continue;
                col.setMandatory(col.isDependOnFK_AsMandatory());
                continue;
            }
            if (!col.isMandatory()) continue;
            col.setDependOnFK_AsMandatory(true);
            col.setMandatory(false);
        }
    }

    public boolean canBeOptional() {
        KeyObject pk = this.getTable().getPK();
        if (pk != null) {
            for (ContainedObject co : this.getLocalFKIndex().getElementsCollection()) {
                if (!pk.contains(co)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public void setTransferable(boolean transferable) {
        this.transferable = transferable;
    }

    public FKArc getArc() {
        return this.arc;
    }

    public void setArc(FKArc arc) {
        this.arc = arc;
    }

    public boolean isInArc() {
        return this.arc != null;
    }

    public void resetEdgeParams() {
        for (TVFKRelation tv : this.getAllTVRelations()) {
            tv.resetEdgeParams();
        }
    }

    public void createDefaultSelfReferencePoints() {
        for (TVFKRelation tv : this.getAllTVRelations()) {
            tv.createDefaultSelfReferencePoints();
        }
    }

    public void resetMandatoryUsingColumns() {
        if (this.getLocalFKIndex() != null) {
            boolean hasNulls = false;
            boolean hasNotNulls = false;
            boolean pkelem = false;
            for (Column co : this.getLocalFKIndex().getElementsCollection()) {
                if (co.isPKElement()) {
                    pkelem = true;
                }
                if (co.getNullsAllowed()) {
                    hasNulls = true;
                    continue;
                }
                hasNotNulls = true;
            }
            boolean mand = false;
            if (hasNulls && hasNotNulls) {
                if (pkelem) {
                    mand = false;
                } else if (this.getRemoteIndex() != null && this.getRemoteIndex().isPK()) {
                    mand = true;
                } else if (this.getRemoteIndex() != null && this.getRemoteIndex().isUnique()) {
                    boolean un_nulls = false;
                    for (Column col : this.getRemoteIndex().getElementsCollection()) {
                        if (!col.getNullsAllowed()) continue;
                        un_nulls = true;
                        break;
                    }
                    if (!un_nulls) {
                        mand = true;
                    }
                }
            } else if (hasNotNulls) {
                mand = true;
            }
            if (RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS) {
                this.setMandatory(mand);
            } else {
                this.mandatory = mand;
            }
            if (this.mandatory && DELETE_RULE_SET_NULL.equals(this.getDeleteRule())) {
                this.setDeleteRule(DELETE_RULE_NOTHING);
            }
            this.resetEdgeParams();
        }
    }

    @Override
    public List getAllViews() {
        return this.getAllTVRelations();
    }

    @Override
    public void restoreTopView(TopView tv, TopView sourceTV, TopView targetTV) {
        tv.getDesignPartView().restoreTopview(tv, this);
        dpvInfo dpi = this.getDPVInfoFor(tv.getDesignPartView());
        if (dpi.tv == tv) {
            this.addObjectListener(tv);
            dpi.targetTV = (TVTable)targetTV;
            dpi.targetTV.addTopViewListener(this);
            dpi.sourceTV = (TVTable)sourceTV;
            dpi.sourceTV.addTopViewListener(this);
        }
    }

    public boolean canRemoveColumnAutomaticaly(Column column) {
        Table table = (Table)column.getContainerWithKeyObject();
        Index index = this.getLocalFKIndex();
        if (table != this.getContainerWithKeyObject()) {
            return false;
        }
        if (column.isPreviousColumn()) {
            return false;
        }
        int deleteFKcolumns = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
        if (deleteFKcolumns == 1) {
            return false;
        }
        KeyObject[] keys = table.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Index key = (Index)keys[i];
            if (key == index || !key.isFK() && !key.isPK() && !key.isUnique() || !key.contains(column)) continue;
            return false;
        }
        return true;
    }

    public List getAutomaticallyRemovedcolumns() {
        ArrayList<Column> list = new ArrayList<Column>();
        for (Column column : this.getLocalFKIndex().getElementsCollection()) {
            if (!this.canRemoveColumnAutomaticaly(column)) continue;
            list.add(column);
        }
        return list;
    }

    private boolean isColumnUsedInConstraints(Column column) {
        Table table = (Table)this.getContainerWithKeyObject();
        Index index = this.getLocalFKIndex();
        KeyObject[] keys = table.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Index key = (Index)keys[i];
            if (key == index || !key.isFK() && !key.isPK() && !key.isUnique() || !key.contains(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    public boolean isBackupFK() {
        return this.originatingFK != null;
    }

    public FKIndexAssociation getOriginatingFK() {
        return this.originatingFK;
    }

    public TVTable getOriginatingSourceTVTable() {
        return this.originatingSourceTVTable;
    }

    public void setOriginatingSourceTVTable(TVTable originatingSourceTVTable) {
        this.originatingSourceTVTable = originatingSourceTVTable;
    }

    public TVTable getOriginatingTargetTVTable() {
        return this.originatingTargetTVTable;
    }

    public void setOriginatingTargetTVTable(TVTable originatingTargetTVTable) {
        this.originatingTargetTVTable = originatingTargetTVTable;
    }

    public FKMemento getFKMemento(DesignPartView dpv) {
        FKMemento mem = new FKMemento(this);
        mem.name = this.getName();
        mem.comments = this.getComment();
        mem.notes = this.getNotes();
        mem.id = this.getObjectID();
        mem.index_id = this.getLocalFKIndex().getObjectID();
        mem.mandatory = this.isMandatory();
        mem.generate_in_DDL = this.isMarkedGenerate();
        mem.cdcDeprecated = this.isDeprecated();
        mem.transferable = this.isTransferable();
        mem.table = (Table)this.getContainerWithKeyObject();
        mem.remoteTable = this.getRemoteTable();
        mem.remoteKey = this.getRemoteIndex();
        if (mem.remoteKey != null) {
            mem.remoteKeyID = this.getRemoteIndex().getObjectID();
        }
        mem.deleteRule = this.getDeleteRule();
        mem.arc = this.getArc();
        mem.dpv = dpv;
        mem.sourceTV = this.getSourceTV(dpv);
        mem.targetTV = this.getTargetTV(dpv);
        mem.discrColumn = this.getDiscriminatorColumn();
        mem.discrValue = this.getDiscriminatorValue();
        mem.name_fixed = this.isNameFixed();
        for (Column col : this.getLocalFKIndex().getElementsCollection()) {
            Column refcol = col.getReferencedColumn(this);
            if (col == null || refcol == null) continue;
            mem.columns.add(col.getObjectID());
        }
        mem.cdcName = this.getColumnDependencyConstraintGenerateName();
        mem.cdcGenerateInDDL = this.isColumnDependencyConstraintGenerateInDDL();
        return mem;
    }

    public void resetFromMemento(FKMemento mem) {
        if (mem.fk != this) {
            throw new RuntimeException("FKMemento object is for another Foreign key");
        }
        this.setNameFixed(mem.name_fixed);
        this.setName(mem.name);
        this.setComment(mem.comments);
        this.setNotes(mem.notes);
        this.setMarkedGenerate(mem.generate_in_DDL);
        this.setDeprecated(mem.cdcDeprecated);
        this.getLocalFKIndex().setMarkedGenerate(mem.generate_in_DDL);
        this.setDeleteRule(mem.deleteRule);
        this.setTransferable(mem.transferable);
        Column[] fkColumns = FKUtilities.getFKColumnsFromTable(mem, (Table)this.getContainerWithKeyObject());
        this.changeKeyObject(mem.remoteKey, fkColumns);
        if (mem.sourceTV != null && mem.targetTV != null) {
            this.setSourceTVTable(mem.sourceTV);
            this.setTargetTVTable(mem.targetTV);
        }
        this.setMandatory(mem.mandatory);
        this.setDiscriminatorColumn(mem.discrColumn);
        this.setDiscriminatorValue(mem.discrValue);
        this.setColumnDependencyConstraintGenerateName(mem.cdcName);
        this.setColumnDependencyConstraintGenerateInDDL(mem.cdcGenerateInDDL);
        this.getTable().setDirty(true);
        for (TVFKRelation tv : this.getAllTVRelations()) {
            tv.displayLabels();
        }
        this.resetEdgeParams();
    }

    public void setNewFK(FKIndexAssociation fk) {
        this.setName(fk.name);
        this.setComment(fk.getComment());
        this.setNotes(fk.getNotes());
        this.setMarkedGenerate(fk.isMarkedGenerate());
        this.setDeleteRule(fk.deleteRule);
        this.setTransferable(fk.transferable);
        this.setMandatory(fk.mandatory);
        this.setColumnDependencyConstraintGenerateName(fk.columnDependencyConstraintGenerateName);
        this.setColumnDependencyConstraintGenerateInDDL(fk.columnDependencyConstraintGenerateInDDL);
        if (fk.sourceTVT != null && fk.targetTVT != null) {
            this.setSourceTVTable(fk.sourceTVT);
            this.setTargetTVTable(fk.targetTVT);
        }
        this.getTable().setDirty(true);
        this.resetEdgeParams();
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "foreignkey/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isSilentRemove() {
        return this.silentRemove;
    }

    public void setSilentRemove(boolean silentRemove) {
        this.silentRemove = silentRemove;
    }

    public boolean isOneToOne() {
        ContainedObject[] cols = this.getLocalFKIndex().getElements();
        Iterator it = this.getTable().getKeySet().iterator();
        while (it.hasNext()) {
            Index key = (Index)it.next();
            if (!key.isPK() && !key.isUnique() && !"Unique Plain Index".equalsIgnoreCase(key.getIndexState()) || key.getElementsCollection().size() != cols.length) continue;
            boolean hasit = true;
            for (int i = 0; i < cols.length; ++i) {
                if (key.contains(cols[i])) continue;
                hasit = false;
                break;
            }
            if (!hasit) continue;
            return true;
        }
        return false;
    }

    public boolean isIdentifyingForPK() {
        ContainedObject[] cols = this.getLocalFKIndex().getElements();
        Iterator it = this.getTable().getKeySet().iterator();
        while (it.hasNext()) {
            Index key = (Index)it.next();
            if (!key.isPK() || key.getElementsCollection().size() < cols.length) continue;
            boolean hasit = true;
            for (int i = 0; i < cols.length; ++i) {
                if (key.contains(cols[i])) continue;
                hasit = false;
                break;
            }
            if (!hasit) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToTable() {
        Table table = this.getTable();
        if (table != null && !table.getFKAssociationsList().contains(this)) {
            boolean pk_prop = this.getDesign().isPropagatePKChahges();
            try {
                String segm_name = this.getDirectorySegmentName();
                this.getDesign().setPropagatePKChahges(false);
                table.addRecreateFKAssociation(this);
                this.setDirectorySegmentName(segm_name, true);
            }
            catch (Exception ex) {
                System.out.println("fk - " + this.getName() + "   - table " + this.getTable().getName());
            }
            finally {
                this.getDesign().setPropagatePKChahges(pk_prop);
            }
        }
    }

    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }

    @Override
    public String toString() {
        return this.getVeryLongName();
    }

    @Override
    public Collection getAffectedDPVs() {
        ArrayList<DesignPartView> list = new ArrayList<DesignPartView>();
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null || dpi.dpv == null) continue;
            list.add(dpi.dpv);
        }
        return list;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public Column getDiscriminatorColumn() {
        Column col;
        if (this.arc != null && (col = this.arc.getDiscriminatorColumn()) != null) {
            return col;
        }
        return this.discriminatorColumn;
    }

    public Column getDiscriminatorColumnToStore() {
        if (this.arc != null && this.arc.getDiscriminatorColumn() != null) {
            return null;
        }
        return this.discriminatorColumn;
    }

    public void setDiscriminatorColumn(Column discriminatorColumn) {
        this.discriminatorColumn = discriminatorColumn;
    }

    @Override
    public DesignObject getTempObject() {
        return new FKIndexAssociation(this.getDesignPart());
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        Design design = this.getDesign();
        if (design != null) {
            DesignObject result = design.getDesignObject(id);
            if (result == null) {
                Map map = design.getCorrespondenceMap();
                if (map != null) {
                    result = map.get(id);
                }
                if (result == null && this.getRemoteObjectID() != null && "containerWithKeyObject".equals(propertyName)) {
                    result = ((RelationalDesign)this.getDesignPart()).getTableSet().getObjectByRemoteObjectID(id);
                }
                if (result == null && this.getRemoteObjectID() != null && "localFKIndex".equals(propertyName)) {
                    result = this.getTable().getKeySet().getObjectByRemoteObjectID(id);
                }
                return result;
            }
            return result;
        }
        return null;
    }

    public boolean isColumnDependencyConstraintGenerateInDDL() {
        return this.columnDependencyConstraintGenerateInDDL;
    }

    public void setColumnDependencyConstraintGenerateInDDL(boolean columnDependencyConstraintGenerateInDDL) {
        this.columnDependencyConstraintGenerateInDDL = columnDependencyConstraintGenerateInDDL;
    }

    public String getColumnDependencyConstraintGenerateName() {
        return this.columnDependencyConstraintGenerateName;
    }

    public void setColumnDependencyConstraintGenerateName(String columnDependencyConstraintGenerateName) {
        this.columnDependencyConstraintGenerateName = columnDependencyConstraintGenerateName;
    }

    public class FKMemento {
        public FKIndexAssociation fk;
        public DesignPartView dpv;
        public String comments = "";
        public String notes = "";
        public String name;
        public String id;
        public String index_id;
        public boolean mandatory;
        public boolean transferable;
        public boolean generate_in_DDL;
        public boolean name_fixed;
        public Table table;
        public Table remoteTable;
        public String remoteKeyID;
        public Index remoteKey;
        public List<String> columns = new ArrayList<String>();
        public String deleteRule = "";
        public FKArc arc;
        public TVTable sourceTV;
        public TVTable targetTV;
        public Column discrColumn;
        public String discrValue = "";
        public String cdcName = "";
        public boolean cdcGenerateInDDL;
        public boolean cdcDeprecated;

        public FKMemento(FKIndexAssociation fk) {
            this.fk = fk;
        }

        public void copyTo(FKMemento mem) {
            mem.comments = this.comments;
            mem.notes = this.notes;
            mem.name = this.name;
            mem.id = this.id;
            mem.index_id = this.index_id;
            mem.mandatory = this.mandatory;
            mem.transferable = this.transferable;
            mem.generate_in_DDL = this.generate_in_DDL;
            mem.table = this.table;
            mem.remoteTable = this.remoteTable;
            mem.remoteKeyID = this.remoteKeyID;
            mem.remoteKey = this.remoteKey;
            mem.columns.addAll(this.columns);
            mem.deleteRule = this.deleteRule;
            mem.sourceTV = this.sourceTV;
            mem.targetTV = this.targetTV;
            mem.arc = this.arc;
            mem.dpv = this.dpv;
            mem.discrColumn = this.discrColumn;
            mem.discrValue = this.discrValue;
            mem.name_fixed = this.name_fixed;
            mem.cdcName = this.cdcName;
            mem.cdcGenerateInDDL = this.cdcGenerateInDDL;
            mem.cdcDeprecated = this.cdcDeprecated;
        }
    }

    public class dpvInfo {
        public TVTable sourceTV;
        public TVTable targetTV;
        public TopView tv;
        public DesignPartView dpv;

        dpvInfo() {
        }
    }

    public class FKConnection {
        Table child;
        Table parent;
        public int countAdded = 0;

        public void setChildTable(Table table) {
            this.child = table;
        }

        public Table getChildTable() {
            return this.child;
        }

        public TVTable getSourceTV(DesignPartView dpv) {
            return FKIndexAssociation.this.getSourceTV(dpv);
        }

        public TVTable getTargetTV(DesignPartView dpv) {
            return FKIndexAssociation.this.getTargetTV(dpv);
        }

        public void setParentTable(Table table) {
            this.parent = table;
        }

        public Table getParentTable() {
            return this.parent;
        }

        public String toString() {
            return FKIndexAssociation.this.getName();
        }

        public TopView getTopView() {
            return FKIndexAssociation.this.getTopView();
        }

        public TopView getViewFor(DesignPartView dpv) {
            return FKIndexAssociation.this.getViewFor(dpv);
        }

        public FKIndexAssociation getFKIndexAssociation() {
            return FKIndexAssociation.this;
        }
    }
}

