/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.reference.ModelIDObjectReference;
import oracle.dbtools.crest.model.reference.ReferenceSet;

public class FKIndexAssociationSet
extends DesignObjectSet {
    public static final Object[] PROTOTYPE_ARRAY = new FKIndexAssociation[0];
    private FKAssociationReferenceSet referenceSet = new FKAssociationReferenceSet();

    public FKIndexAssociationSet(DesignPart designPart) {
        super(designPart);
        this.setCreateNameVariants(true);
        this.requireSort = true;
    }

    public ModelIDObject createElement(String id) {
        throw new RuntimeException("FKIndexAssociations should be created via Table instances");
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTOTYPE_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "FK_ASS";
    }

    @Override
    public String getSeparator() {
        return "_";
    }

    public Collection getAssociationsWith(Table foreignTable) {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation association = (FKIndexAssociation)it.next();
            if (!foreignTable.equals(association.getRemoteTable())) continue;
            list.add(association);
        }
        return list;
    }

    public Collection getAssociationsWith(KeyObject foreignPK) {
        return this.iterateAndFill(foreignPK, false);
    }

    public Collection getAssociatedTablesWith(Table foreignTable) {
        ArrayList<FKIndexAssociation> collection = new ArrayList<FKIndexAssociation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation association = (FKIndexAssociation)it.next();
            if (!foreignTable.equals(association.getRemoteTable())) continue;
            collection.add(association);
        }
        return collection;
    }

    public List getRelatedTablesTo(Table table) {
        ArrayList<Table> list = new ArrayList<Table>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation association = (FKIndexAssociation)it.next();
            if (association.getTable() == association.getRemoteTable()) continue;
            if (table.equals(association.getTable())) {
                list.add(association.getRemoteTable());
                continue;
            }
            if (!table.equals(association.getRemoteTable())) continue;
            list.add(association.getTable());
        }
        return list;
    }

    public List getParentTables(Table table) {
        ArrayList<Table> list = new ArrayList<Table>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation association = (FKIndexAssociation)it.next();
            if (!table.equals(association.getTable())) continue;
            list.add(association.getRemoteTable());
        }
        return list;
    }

    public List getChildTables(Table table) {
        ArrayList<Table> list = new ArrayList<Table>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation association = (FKIndexAssociation)it.next();
            if (!table.equals(association.getRemoteTable())) continue;
            list.add(association.getTable());
        }
        return list;
    }

    public Collection getAssociatedTablesWith(KeyObject foreignPK) {
        return this.iterateAndFill(foreignPK, true);
    }

    private Collection iterateAndFill(KeyObject foreignPK, boolean tables) {
        if (foreignPK == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<DesignObject> collection = new HashSet<DesignObject>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation association = (FKIndexAssociation)it.next();
            if (!foreignPK.equals(association.getRemoteIndex())) continue;
            if (tables) {
                collection.add(association.getTable());
                continue;
            }
            collection.add(association);
        }
        return collection;
    }

    public FKIndexAssociationReference createReference() {
        return (FKIndexAssociationReference)this.referenceSet.createReference(this.getDesign());
    }

    public List getFKeysToListOfKeys(List keys) {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            if (!keys.contains(fk.getRemoteIndex())) continue;
            list.add(fk);
        }
        return list;
    }

    public List getFKeysEndingTo(Table table) {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        if (table != null) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                FKIndexAssociation association = (FKIndexAssociation)it.next();
                if (table != association.getRemoteTable() && table != association.getTable()) continue;
                list.add(association);
            }
        }
        return list;
    }

    @Override
    public boolean changeName(String oldName, String newName, DesignObject object) {
        Object obj2 = this.names.get(newName.toUpperCase());
        if (obj2 == null || obj2 == object || this.checkDifferentSchema((FKIndexAssociation)object, (FKIndexAssociation)obj2)) {
            this.doRenaming(oldName, newName, object);
            return true;
        }
        return false;
    }

    private boolean checkDifferentSchema(FKIndexAssociation currentFK, FKIndexAssociation otherFK) {
        Table currentFKTable = currentFK.getTable();
        Table otherFKTable = otherFK.getTable();
        if (currentFKTable != null && otherFKTable != null) {
            return !currentFKTable.getSchema().equals(otherFKTable.getSchema());
        }
        return true;
    }

    private void doRenaming(String oldName, String newName, DesignObject object) {
        String oname;
        DesignObject dobj;
        if (oldName != null && (dobj = (DesignObject)this.names.get(oname = oldName.toUpperCase())) == object) {
            this.names.remove(oname);
        }
        this.names.put(newName.toUpperCase(), object);
        if (!object.getDesign().isLoading()) {
            SetEvent.NAME_CHANGED.setAffected(object);
            this.fireChange(SetEvent.NAME_CHANGED);
        }
    }

    class FKAssociationReferenceSet
    extends ReferenceSet {
        FKAssociationReferenceSet() {
        }

        @Override
        protected ModelIDObjectReference instantiateReference(Design design) {
            return new FKIndexAssociationReference(this.counter++, design, this);
        }
    }
}

