/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.OptimizerHint;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.ColumnViewSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.ViewColumnPlaceHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.relational.TableViewPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;

public class TableView
extends AbstractView
implements EditableFonts {
    private List editableFonts = new ArrayList();
    private String oidText = "";

    public TableView(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getIDPrefix() {
        return MDPreferences.getDefaultInstance().get("tableview id prefix");
    }

    @Override
    public Class getContainedClass() {
        return ColumnView.class;
    }

    @Override
    public DesignObjectSet getTableSet() {
        return ((RelationalDesign)this.getDesignPart()).getTableSet();
    }

    public ColumnViewSet getColumnViewSet() {
        return ((RelationalDesign)this.getDesignPart()).getColumnViewSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getColumnViewSet();
    }

    @Override
    public ContainedObject createContainedObject(String id) {
        ColumnView column = new ColumnView(this.getDesignPart());
        column.setDesign(this.getDesign());
        column.setContainer(this);
        if (id != null) {
            column.setObjectID(id);
        }
        column.setDesignObjectSet(this.getColumnViewSet());
        this.add(column);
        this.getColumnViewSet().add(column);
        if (id != null) {
            column.setObjectID(id);
        }
        return column;
    }

    @Override
    public void add(ContainedObject object) {
        if (!this.exists(object)) {
            if (object instanceof ColumnView) {
                if (object.getObjectID() == null) {
                    this.assignLocalID(object);
                }
                object.setDesign(this.getDesign());
                this.getColumnViewSet().add(object);
                this.phelements.add(new ViewColumnPlaceHolder(this.getDesignPart(), object));
                super.add(object);
                if (((ColumnView)object).getReferencedColumn() != null) {
                    ((ColumnView)object).getReferencedColumn().addObjectListener(this);
                }
                if (((ColumnView)object).getReferencedColumnView() != null) {
                    ((ColumnView)object).getReferencedColumnView().addObjectListener(this);
                }
                if (((ColumnView)object).getView() != null && ((ColumnView)object).getView() != this) {
                    ContainedObject[] cols = ((ColumnView)object).getView().getElements();
                    for (int i = 0; i < cols.length; ++i) {
                        if (((ColumnView)cols[i]).getReferencedColumn() != ((ColumnView)object).getReferencedColumn()) continue;
                        cols[i].addObjectListener(this);
                    }
                }
            } else {
                ColumnView adapter = new ColumnView(this.getDesignPart());
                adapter.setObjectID(this.getDesign().getAppView().getIDGenerator().createNewID());
                adapter.setName(object.getName());
                adapter.setDesign(this.getDesign());
                adapter.setReferencedColumn((Column)object);
                adapter.setDataType(((Column)object).getDataType().toString());
                adapter.setContainer(this);
                adapter.setTable((Table)object.getContainer());
                this.getColumnViewSet().add(adapter);
                this.phelements.add(new ViewColumnPlaceHolder(this.getDesignPart(), adapter));
                super.add(adapter);
                if (adapter.getView() != this) {
                    adapter.addObjectListener(this);
                }
            }
            object.addObjectListener(this);
        }
    }

    public ColumnView columnViewAdd(ContainedObject object) {
        if (!this.exists(object)) {
            if (object instanceof ColumnView) {
                if (object.getObjectID() == null) {
                    this.assignLocalID(object);
                }
                object.setDesign(this.getDesign());
                this.getColumnViewSet().add(object);
                this.phelements.add(new ViewColumnPlaceHolder(this.getDesignPart(), object));
                super.add(object);
                if (((ColumnView)object).getReferencedColumn() != null) {
                    ((ColumnView)object).getReferencedColumn().addObjectListener(this);
                }
                if (((ColumnView)object).getView() != null && ((ColumnView)object).getView() != this) {
                    ContainedObject[] cols = ((ColumnView)object).getView().getElements();
                    for (int i = 0; i < cols.length; ++i) {
                        if (((ColumnView)cols[i]).getReferencedColumn() != ((ColumnView)object).getReferencedColumn()) continue;
                        cols[i].addObjectListener(this);
                    }
                }
                return (ColumnView)object;
            }
            ColumnView adapter = new ColumnView(this.getDesignPart());
            adapter.setObjectID(this.getDesign().getAppView().getIDGenerator().createNewID());
            adapter.setName(object.getName());
            adapter.setDesign(this.getDesign());
            adapter.setReferencedColumn((Column)object);
            adapter.setDataType(((Column)object).getDataType().toString());
            this.getColumnViewSet().add(adapter);
            adapter.setContainer(this);
            adapter.setTable((Table)object.getContainer());
            this.phelements.add(new ViewColumnPlaceHolder(this.getDesignPart(), adapter));
            super.add(adapter);
            if (adapter.getView() != this) {
                adapter.addObjectListener(this);
            }
            object.addObjectListener(this);
            return adapter;
        }
        return null;
    }

    private boolean exists(ContainedObject object) {
        if (object instanceof ColumnView) {
            return this.getElementsCollection().contains(object);
        }
        for (ColumnView contained : this.getElementsCollection()) {
            if (object != contained.getReferencedColumn()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove(ContainedObject object) {
        this.phelements.removePlaceHolderFor(object);
        this.removeFromOrderBy(object);
        super.remove(object);
        this.getColumnViewSet().remove(object);
    }

    @Override
    public void addToOrderBy(ContainedObject object, String sortOrder) {
        if (object.getObjectID() == null) {
            this.assignLocalID(object);
        }
        object.setContainer(this);
        this.getColumnViewSet().add(object);
        this.orderByMap.put(object.getObjectID(), sortOrder);
        this.orderByList.add(object);
        if (((AbstractViewElement)object).getReferencedColumn() != null) {
            ((AbstractViewElement)object).getReferencedColumn().addObjectListener(this);
        }
    }

    public ContainedObject[] getColumns() {
        return this.getElements();
    }

    public ColumnView getColumnByObjectID(String objectID) {
        for (ColumnView contained : this.getElementsCollection()) {
            if (!contained.getObjectID().equals(objectID)) continue;
            return contained;
        }
        return null;
    }

    @Override
    public void addToContainers(ContainerObject container, String alias) {
        this.containerMap.put(alias, container.getObjectID());
        if (container instanceof Table) {
            if (!this.tables.contains(container)) {
                this.tables.add(container);
                this.usedContainers.add(new AbstractView.ContainerHolder(container, alias));
            }
        } else if (container instanceof TableView && !this.views.contains(container)) {
            this.views.add(container);
            this.usedContainers.add(new AbstractView.ContainerHolder(container, alias));
        }
        container.addObjectListener(this);
    }

    @Override
    public void clearContainers() {
        this.containerMap.clear();
        this.tables.clear();
        this.views.clear();
        this.usedContainers.clear();
    }

    @Override
    public void addToContainers(String objectID, String alias) {
        this.containerMap.put(alias, objectID);
        ContainerObject container = (ContainerObject)this.getTableSet().getObjectByID(objectID);
        if (container != null) {
            if (!this.tables.contains(container)) {
                this.tables.add(container);
            }
            this.usedContainers.add(new AbstractView.ContainerHolder(container, alias));
            container.addObjectListener(this);
            this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(objectID, alias));
        } else {
            TableView v = (TableView)((RelationalDesign)this.getDesignPart()).getTableViewSet().getObjectByID(objectID);
            if (v != null) {
                if (!this.views.contains(v)) {
                    this.views.add(v);
                }
                this.usedContainers.add(new AbstractView.ContainerHolder(v, alias));
                v.addObjectListener(this);
                this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(objectID, alias));
            } else {
                this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(objectID, alias));
            }
        }
    }

    public ColumnView getColumnViewByName(String name) {
        for (ColumnView contained : this.getElementsCollection()) {
            if (!contained.getName().equalsIgnoreCase(name)) continue;
            return contained;
        }
        return null;
    }

    public ColumnView getColumnViewByLongName(String name) {
        for (ColumnView contained : this.getElementsCollection()) {
            if (!contained.getLongName().equalsIgnoreCase(name)) continue;
            return contained;
        }
        return null;
    }

    public String getUserDefinedSQLAsDDL() {
        String sql = this.userDefinedSQL;
        if (!this.optimizerHints.isEmpty()) {
            String beforeSelect = Token.getStringBeforeToken(sql, "SELECT");
            String afterSelect = Token.getStringAfterToken(sql, "SELECT");
            if (!afterSelect.startsWith("/*+")) {
                for (int i = 0; i < this.optimizerHints.size(); ++i) {
                    OptimizerHint hint = (OptimizerHint)this.optimizerHints.get(i);
                    if (!hint.isOrderedHint()) continue;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(beforeSelect).append(" SELECT /*+ ");
                    buffer.append(hint.getHint()).append(" ");
                    buffer.append("*/ ").append(afterSelect);
                    sql = buffer.toString();
                    break;
                }
            }
        }
        if (!sql.toUpperCase().startsWith("CREATE ")) {
            sql = ((RelationalDesign)this.getDesignPart()).getStorageDesign() instanceof StorageDesignOracle ? "CREATE OR REPLACE VIEW " + this.getName() + "\nAS \n" + sql : "CREATE VIEW " + this.getName() + "\nAS \n" + sql;
        }
        return sql;
    }

    @Override
    public void clear(ContainerObject container) {
        this.tables.remove(container);
        this.views.remove(container);
        Object[] obj = this.containerMap.keySet().toArray();
        for (int i = obj.length - 1; i >= 0; --i) {
            String alias = (String)obj[i];
            String containerID = (String)this.containerMap.get(alias);
            if (!container.getObjectID().equalsIgnoreCase(containerID)) continue;
            this.containerMap.remove(alias);
        }
        if (container != this) {
            this.clearElements(container);
        }
        this.clearOrderByElements(container);
        AbstractView.ContainerHolder ch = this.getContainerHolderFor(container);
        if (ch != null) {
            this.usedContainers.remove(ch);
        }
    }

    public void clear(ColumnView column) {
        if (column.getContainer() == this) {
            this.removeFromOrderBy(column);
            column.remove();
        }
    }

    @Override
    public void clearElements(ContainerObject container) {
        block5: {
            block4: {
                if (!(container instanceof TableView)) break block4;
                ContainedObject[] cos = container.getElements();
                for (int i = 0; i < cos.length; ++i) {
                    if (!this.getElementsCollection().contains(cos[i])) continue;
                    this.remove(cos[i]);
                }
                break block5;
            }
            if (!(container instanceof Table)) break block5;
            ArrayList<ColumnView> forRemove = new ArrayList<ColumnView>();
            Iterator it = this.getElementsCollection().iterator();
            ContainedObject[] cos = container.getElements();
            block1: while (it.hasNext()) {
                ColumnView colView = (ColumnView)it.next();
                if (colView.getReferencedColumn() == null) continue;
                for (int i = 0; i < cos.length; ++i) {
                    if (colView.getReferencedColumn() != cos[i]) continue;
                    forRemove.add(colView);
                    continue block1;
                }
            }
            it = forRemove.iterator();
            while (it.hasNext()) {
                this.remove((ColumnView)it.next());
            }
        }
    }

    @Override
    public void clearOrderByElements(ContainerObject container) {
        block7: {
            block6: {
                if (!(container instanceof TableView)) break block6;
                ArrayList<ColumnView> forRemove = new ArrayList<ColumnView>();
                for (ColumnView col : container.getElementsCollection()) {
                    for (ColumnView column : this.orderByList) {
                        if (col.getReferencedColumn() != column.getReferencedColumn()) continue;
                        forRemove.add(column);
                    }
                }
                Iterator it = forRemove.iterator();
                while (it.hasNext()) {
                    this.removeFromOrderBy((ColumnView)it.next());
                }
                break block7;
            }
            if (!(container instanceof Table)) break block7;
            ArrayList<ColumnView> forRemove = new ArrayList<ColumnView>();
            block3: for (ColumnView colView : this.orderByList) {
                if (colView.getReferencedColumn() == null) continue;
                for (Column col : container.getElementsCollection()) {
                    if (colView.getReferencedColumn() != col) continue;
                    forRemove.add(colView);
                    continue block3;
                }
            }
            Iterator it = forRemove.iterator();
            while (it.hasNext()) {
                this.removeFromOrderBy((ColumnView)it.next());
            }
        }
    }

    @Override
    public void remove() {
        Iterator it = ((RelationalDesign)this.getDesignPart()).getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView view = (TableView)it.next();
            view.clear(this);
        }
        for (ColumnView col : this.getElementsCollection()) {
            this.getColumnViewSet().remove(col);
        }
        ArrayList<ColumnView> forDelete = new ArrayList<ColumnView>();
        it = this.getColumnViewSet().iterator();
        while (it.hasNext()) {
            ColumnView col = (ColumnView)it.next();
            if (col.getView() != this) continue;
            forDelete.add(col);
        }
        for (ColumnView col : forDelete) {
            this.getColumnViewSet().remove(col);
            col.getContainer().remove(col);
        }
        super.remove();
        SetEvent.OBJECT_REMOVED.setAffected(this);
        ((RelationalDesign)this.getDesignPart()).getTableViewSet().fireChange(SetEvent.OBJECT_REMOVED);
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (set instanceof StructuredTypeSet || set instanceof SchemaObjectSet) {
            super.changed(set, event);
            return;
        }
        if (SetEvent.OBJECT_REMOVED.equals(event) && event.getAffected() instanceof ContainerObject) {
            ((ContainerObject)event.getAffected()).removeContainerListener(this);
        }
    }

    protected void invalidateLinkedViews() {
        Iterator it = ((RelationalDesign)this.getDesignPart()).getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView tableView = (TableView)it.next();
            if (tableView == null || !tableView.isValidSQL() || !tableView.sqlNameExists(this.getObjectID())) continue;
            tableView.setValidSQL(false);
            tableView.invalidateLinkedViews();
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        boolean containsObject = false;
        if (!ApplicationView.loading && (event.isType(ObjectChangeEvent.OBJECT_REMOVED) || event.isType(ObjectChangeEvent.NAME_CHANGED) || event.isType(ObjectChangeEvent.SCHEMA_CHANGED))) {
            if (this.sqlNameExists(object.getObjectID())) {
                containsObject = true;
            }
            if (!containsObject) {
                if (object instanceof ContainerObject) {
                    if (this.sqlNameExists(object.getObjectID())) {
                        containsObject = true;
                    }
                } else if (object instanceof Column) {
                    for (ColumnView colView : this.getElementsCollection()) {
                        if (colView.getReferencedColumn() == null || colView.getReferencedColumn() != object) continue;
                        containsObject = true;
                        break;
                    }
                } else if (object instanceof ColumnView) {
                    for (ColumnView colView : this.getElementsCollection()) {
                        if (colView != object && colView.getReferencedColumnView() != object) continue;
                        containsObject = true;
                        break;
                    }
                }
            }
            if (containsObject) {
                this.setValidSQL(!this.isSQLNamesChanged());
                if (!this.isValidSQL()) {
                    this.invalidateLinkedViews();
                }
            }
        }
    }

    @Override
    public void copy(DesignObject desObject) {
        ColumnView col;
        TableView view = (TableView)desObject;
        super.copy(view);
        view.setSyntaxProvider(this.getSyntaxProvider());
        view.setWhere(this.getWhere());
        view.setGroupBy(this.getGroupBy());
        view.setHaving(this.getHaving());
        view.setUserDefined(this.getUserDefined());
        view.setUserDefinedSQL(this.getUserDefinedSQL(view.getName()));
        view.setOptimizerHints(this.getOptimizerHints());
        view.setBasedOnStructuredType(this.getBasedOnStructuredType());
        for (String alias : this.getContainerMap().keySet()) {
            String cID = this.getContainerID(alias);
            view.addToContainers(cID, alias);
        }
        for (String id : this.getOrderByMap().keySet()) {
            ColumnView key = (ColumnView)this.getObjectByID(this.orderByList, id);
            if (key != null) {
                ColumnView col2 = new ColumnView(this.getDesignPart());
                key.copy(col2);
                col2.setView(view);
                view.addToOrderBy(col2, (String)this.getOrderByMap().get(id));
                continue;
            }
            System.out.println("TableView.copy: Unable to find ColumnView: " + id);
        }
        for (int i = 0; i < this.getGroupByList().size(); ++i) {
            col = (ColumnView)this.getGroupByList().get(i);
            view.addGroupByList(col);
        }
        if (!this.isBST()) {
            view.getElementsCollection().clear();
            ContainedObject[] cos = this.getElements();
            for (int i = 0; i < cos.length; ++i) {
                col = new ColumnView(this.getDesignPart());
                ((ColumnView)cos[i]).copy(col);
                col.setView(view);
                col.setContainer(view);
                view.add(col);
            }
        }
        if (view.isRemoteObject()) {
            view.setParsed(this.isParsed());
            view.setValidSQL(this.isValidSQL());
        }
        if (this.getDesignPart() == view.getDesignPart()) {
            this.copySQLNames(view);
        }
    }

    @Override
    public void importView(DesignObject desObject) {
        ColumnView col;
        TableView view = (TableView)desObject;
        super.copy(view);
        view.setWhere(this.getWhere());
        view.setGroupBy(this.getGroupBy());
        view.setHaving(this.getHaving());
        view.setUserDefined(this.getUserDefined());
        view.setUserDefinedSQL(this.getUserDefinedSQL());
        view.setOptimizerHints(this.getOptimizerHints());
        view.setBasedOnStructuredType(this.getBasedOnStructuredType());
        for (String alias : this.getContainerMap().keySet()) {
            String cID = this.getContainerID(alias);
            DesignObject object = view.getDesign().getCorrObject(cID);
            if (object == null) continue;
            view.addToContainers(object.getObjectID(), alias);
        }
        for (String id : this.getOrderByMap().keySet()) {
            ColumnView key = (ColumnView)this.getObjectByID(this.orderByList, id);
            if (key != null) {
                Column newColumn;
                ColumnView col2 = new ColumnView(this.getDesignPart());
                Column oldColumn = (Column)key.getReferencedColumn();
                if (oldColumn != null && (newColumn = (Column)view.getDesign().getCorrObject(oldColumn.getObjectID())) != null) {
                    col2.setReferencedColumn(newColumn);
                    col2.setName(key.getName());
                    col2.setDataType(newColumn.getDataType().toString());
                    col2.setTable((Table)newColumn.getContainer());
                    col2.setView(view);
                    col2.setDesign(view.getDesign());
                    view.addToOrderBy(col2, (String)this.getOrderByMap().get(id));
                }
                col2.setImportedDesign(this.getDesign());
                col2.setImportedId(key.getObjectID());
                continue;
            }
            System.out.println("TableView.copy: Unable to find ColumnView: " + id);
        }
        if (!this.isBST()) {
            for (int i = 0; i < this.getElements().length; ++i) {
                Table table;
                Column newColumn;
                col = new ColumnView(view.getDesignPart());
                ColumnView oldColumnView = (ColumnView)this.getElements()[i];
                Column oldColumn = (Column)oldColumnView.getReferencedColumn();
                if (oldColumn != null && (newColumn = (Column)view.getDesign().getCorrObject(oldColumn.getObjectID())) != null) {
                    col.setReferencedColumn(newColumn);
                }
                col.setName(oldColumnView.getName());
                col.setDataType(oldColumnView.getDataType().toString());
                if (oldColumnView.getTable() != null && (table = (Table)view.getDesign().getCorrObject(oldColumnView.getTable().getObjectID())) != null) {
                    col.setTable(table);
                }
                col.setView(view);
                col.setDesign(view.getDesign());
                col.setContainer(view);
                view.add(col);
                col.setImportedDesign(this.getDesign());
                col.setImportedId(oldColumnView.getObjectID());
            }
        }
        for (int i = 0; i < this.getGroupByList().size(); ++i) {
            ColumnView newcol;
            col = (ColumnView)this.getGroupByList().get(i);
            if (col == null || (newcol = (ColumnView)view.getDesign().getCorrObject(col.getObjectID())) == null) continue;
            view.addGroupByList(newcol);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableViewPropertiesDialogEx dialog = new TableViewPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void updateElements(List telems) {
        for (int i = 0; i < telems.size(); ++i) {
            TypeElement te = (TypeElement)telems.get(i);
            ColumnView column = (ColumnView)this.getElementByStructAttributeID(te.getObjectID());
            if (column == null) {
                column = new ColumnView(this.getDesignPart());
                column.setName(te.getName());
                column.setStructAttributeID(te.getObjectID());
                column.setAlias(te.getName());
                this.addColumn(column);
            }
            this.copyTEtoColumn(te, column);
        }
    }

    private void copyTEtoColumn(TypeElement te, ColumnView column) {
        column.setName(te.getName());
        column.setDataType(te.getDataType(this.getDesignPart().getSelectedRDBMSSite().getName()));
        column.setReference(te.isReference());
        column.setTypeElement(te);
        if (te.getType() instanceof StructuredType) {
            column.setStructuredType((StructuredType)te.getType());
        } else {
            column.setStructuredType(null);
        }
    }

    public void addColumn(ColumnView column) {
        column.setDesign(this.getDesign());
        column.setContainer(this);
        this.add(column);
    }

    public List getRefColumns() {
        ArrayList<ColumnView> list = new ArrayList<ColumnView>();
        if (this.isBST()) {
            ContainedObject[] columns = this.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                ColumnView col = (ColumnView)columns[i];
                if (!col.isReference()) continue;
                list.add(col);
            }
        }
        return list;
    }

    public void getColumns(String statement) {
        this.getElements(statement);
    }

    @Override
    public AbstractViewElement createViewElement(DesignPart designPart) {
        return new ColumnView(designPart);
    }

    public XtdMapping getDeletedMapping() {
        List list = this.getRMExtendedMap().getDeletedMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            XtdMapping mapping = (XtdMapping)list.get(0);
            return mapping;
        }
        return null;
    }

    public EntityView getEngEntityView() {
        XtdMapping mapping;
        DesignObject obj;
        MappingCollector mw = this.getRMExtendedMap().getOrCreateCollector(this);
        List list = mw.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (obj = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null && obj instanceof EntityView) {
            return (EntityView)obj;
        }
        EntityView entView = (EntityView)this.getGenerator();
        if (entView == null) {
            if (!ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID())) {
                entView = (EntityView)this.getDesign().getLogicalDesign().getEntityViewSet().getObjectByID(this.getGeneratorID());
            }
            if (entView == null) {
                entView = (EntityView)this.getDesign().getLogicalDesign().getEntityViewSet().getObjectGeneratedBy(this.getObjectID());
            }
        }
        return entView;
    }

    public void updateDeletedMappings(String oldContainerID, String recreatedID, String designPartID) {
        for (ContainedObject co : this.getElementsCollection()) {
            XtdMapping mapping = co.getDeletedMapping(oldContainerID, designPartID);
            if (mapping == null) continue;
            mapping.setRecreatedContainerID(recreatedID);
        }
    }

    @Override
    public String getFCObjectType() {
        return "Relational View";
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    public String getOidText() {
        return this.oidText;
    }

    public void setOidText(String oidText) {
        this.oidText = oidText;
    }

    @Override
    protected String appendQuotes(String name) {
        StorageDesign sd = ((RelationalDesign)this.getDesignPart()).getStorageDesign();
        if (sd != null) {
            return sd.getFormatedName(name);
        }
        return super.appendQuotes(name);
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "view/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getLongName() {
        if (this.getSchemaObject() != null) {
            return new StringBuffer(this.getSchemaObject().getName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean hasProxyToDelete() {
        return true;
    }

    public boolean canSetSchemaToTablesOnRE() {
        if (this.includeSchemaNameInQuery()) {
            return true;
        }
        if (this.getSchemaObject() == null) {
            for (SQLNameHelper helper : this.getSQLNames()) {
                DesignObject desObj = this.getDesign().getDesignObject(helper.getID());
                if (desObj == null || !(desObj instanceof ContainerObject) || ((ContainerObject)desObj).getSchema() == null) continue;
                return true;
            }
        }
        return false;
    }

    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }

    @Override
    public DesignObject getTempObject() {
        return new TableView(this.getDesignPart());
    }

    @Override
    public boolean hasValidHeader() {
        boolean result = false;
        Iterator it = this.getElementsCollection().iterator();
        if (it.hasNext()) {
            boolean allHaveHeaders = true;
            while (it.hasNext()) {
                ColumnView cv = (ColumnView)it.next();
                String ch = cv.getHeaderAlias();
                if (ch == null || ch.trim().length() == 0) {
                    allHaveHeaders = false;
                    continue;
                }
                if (ch.trim().equals(cv.getPresentationName(false))) continue;
                return true;
            }
            result = allHaveHeaders;
        }
        return result;
    }

    public List<String> getHeaderAliases() {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.isBST()) {
            ContainedObject[] elements = this.getElements();
            for (int i = 0; i < elements.length; ++i) {
                String headerAlias = ((AbstractViewElement)elements[i]).getPresentationName(true);
                result.add(headerAlias);
            }
        }
        return result;
    }
}

