/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.NameValidator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public class ColumnProxy
extends RelationalObjectProxy {
    protected transient TableProxy tableProxy;
    private boolean generateAlwaysChanged;
    private boolean startWithChanged;
    private boolean incrementByChanged;
    private boolean minValueChanged;
    private boolean maxValueChanged;
    private boolean cycleChanged;
    private boolean cacheChanged;
    public static final String TYPE_NAME = "Column";

    public ColumnProxy(Column column, StorageDesign storage) {
        super(column, storage);
        this.tableProxy = (TableProxy)storage.getTableProxySet().getProxy(column.getContainerWithKeyObject().getObjectID());
        if (this.tableProxy != null) {
            this.tableProxy.addObject(this);
        }
    }

    public ColumnProxy(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public Column getColumn() {
        return (Column)this.getObject();
    }

    public Datatype getDataType() {
        return this.getColumn().getDataType(this.getRDBMSType().toString());
    }

    public String getDatatypeString() {
        Datatype type = this.getColumn().getDataType(this.getRDBMSType().toString());
        StringBuffer buff = new StringBuffer();
        if (this.getColumn().isReference()) {
            buff.append("REF ");
        }
        buff.append(type.toString());
        return buff.toString();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void remove() {
        if (this.tableProxy != null) {
            this.tableProxy.removeObject(this);
        }
        super.remove();
    }

    public TableProxy getTableProxyR() {
        return this.tableProxy;
    }

    public void setTableProxyW(TableProxy tableProxy) {
        this.tableProxy = tableProxy;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        if (this.tableProxy != null) {
            if (this.pac_Element == null) {
                this.setPAC_Element(this.tableProxy);
            }
            return this.tableProxy;
        }
        if (this.pac_Element == null) {
            Table table = null;
            table = (Table)this.getColumn().getContainer();
            if (table != null) {
                StorageObject obj = this.getStorageDesign().getStorageObject(table.getObjectID());
                if (obj == null) {
                    this.getStorageDesign().getTableProxySet().getObjectGeneratedBy(table);
                }
                if (obj != null && obj instanceof TableProxy) {
                    this.setPAC_Element(obj);
                }
            }
        }
        return super.getPAC_Element();
    }

    public boolean isGenerateAlwaysChanged() {
        return this.generateAlwaysChanged;
    }

    public void setGenerateAlwaysChanged(boolean generateAlwaysChanged) {
        this.generateAlwaysChanged = generateAlwaysChanged;
    }

    public boolean isStartWithChanged() {
        return this.startWithChanged;
    }

    public void setStartWithChanged(boolean startWithChanged) {
        this.startWithChanged = startWithChanged;
    }

    public boolean isIncrementByChanged() {
        return this.incrementByChanged;
    }

    public void setIncrementByChanged(boolean incrementByChanged) {
        this.incrementByChanged = incrementByChanged;
    }

    public boolean isMinValueChanged() {
        return this.minValueChanged;
    }

    public void setMinValueChanged(boolean minValueChanged) {
        this.minValueChanged = minValueChanged;
    }

    public boolean isMaxValueChanged() {
        return this.maxValueChanged;
    }

    public void setMaxValueChanged(boolean maxValueChanged) {
        this.maxValueChanged = maxValueChanged;
    }

    public boolean isCycleChanged() {
        return this.cycleChanged;
    }

    public void setCycleChanged(boolean cycleChanged) {
        this.cycleChanged = cycleChanged;
    }

    public boolean isCacheChanged() {
        return this.cacheChanged;
    }

    public void setCacheChanged(boolean cacheChanged) {
        this.cacheChanged = cacheChanged;
    }

    @Override
    public String getLongName(boolean includeContainerSchema) {
        if (includeContainerSchema) {
            if (this.tableProxy != null) {
                return this.tableProxy.getLongName() + "." + this.getName();
            }
            return this.getObject().getLongName(includeContainerSchema);
        }
        if (this.tableProxy != null) {
            return this.tableProxy.getName() + "." + this.getName();
        }
        return this.getObject().getLongName(includeContainerSchema);
    }

    @Override
    public String getFormatedName(NameValidator sd, boolean quoted) {
        Column col = (Column)this.getObject();
        if (col.isNested()) {
            return col.getFormatedName(sd, quoted);
        }
        return super.getFormatedName(sd, quoted);
    }
}

