/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.ProxyDesignObjectSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.util.GUID;

public class ColumnProxySet
extends ProxyDesignObjectSet {
    public ColumnProxySet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected DesignObjectSet getPhysicalDesignObjectSet() {
        return this.getStorageDesign().getPhysicalDesign().getColumnSet();
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject object) {
        return new ColumnProxy((Column)object, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        return new ColumnProxy(design, id, longName, this.getStorageDesign());
    }

    @Override
    public void add(DesignObject object) {
        if (!this.isBackupObject(object)) {
            RelationalObjectProxy proxy;
            if (object instanceof Column && ((Column)object).getContainerWithKeyObject() == null) {
                return;
            }
            String id = object.getObjectID();
            if (id == null) {
                id = new GUID().toString();
                object.setObjectID(id);
            }
            if ((proxy = this.getProxy(id)) != null) {
                if (!proxy.isLoaded()) {
                    proxy.loadDesignObject();
                }
            } else {
                proxy = this.createProxy(object);
                this.add(proxy);
                this.fireUpdate();
            }
        }
    }
}

