/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.MethodParamProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public class MethodProxy
extends RelationalObjectProxy
implements RelationalObjectProxySetListener {
    private boolean bodyChanged = false;
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    protected StorageObjectCollection params;
    public static final String TYPE_NAME = "Method";

    public MethodProxy(Method method, StorageDesign storageDesign) {
        super(method, storageDesign);
        this.initParams(storageDesign);
    }

    public MethodProxy(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.initParams(storageDesign);
    }

    private void initParams(StorageDesign storageDesign) {
        this.params = new StorageObjectCollection();
        this.params.setParent(this);
        this.params.setName(Messages.getString("MethodProxy.MethodParams"));
        storageDesign.getMethodParamProxySet();
        this.addMethodParamProxiesFromDesign();
        storageDesign.getMethodParamProxySet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return "MethodParam";
    }

    public StructuredType getStructuredType() {
        return ((Method)this.getObject()).getStructuredType();
    }

    public Method getMethod() {
        return (Method)this.getObject();
    }

    public boolean isBodyChanged() {
        return this.bodyChanged;
    }

    public void setBodyChanged(boolean bodyChanged) {
        this.bodyChanged = bodyChanged;
    }

    @Override
    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    @Override
    public void setCommentChanged(boolean commentChanged) {
        this.commentChanged = commentChanged;
    }

    @Override
    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    @Override
    public void setCommentInRDBMSChanged(boolean commentInRDBMSChanged) {
        this.commentInRDBMSChanged = commentInRDBMSChanged;
    }

    @Override
    public String getComment() {
        if (this.isCommentChanged()) {
            return super.getComment();
        }
        return this.getObject().getComment();
    }

    @Override
    public void setComment(String comment) {
        if (!comment.equals(this.getObject().getComment())) {
            super.setComment(comment);
            this.setCommentChanged(true);
        } else {
            this.setCommentChanged(false);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.params;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.params) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.params) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        MethodParamProxy map;
        if (event.isType(1)) {
            if (event.getAffected() instanceof MethodParamProxy) {
                MethodParamProxy map2 = (MethodParamProxy)event.getAffected();
                if (this.getObject() == map2.getObject().getParent()) {
                    map2.setParent(this.params);
                    this.params.add(event.getAffected());
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof MethodParamProxy && (map = (MethodParamProxy)event.getAffected()) != null && map.getObject() != null) {
            try {
                this.params.remove(map.getObject().getObjectID());
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
    }

    private void addMethodParamProxiesFromDesign() {
        for (MethodParam methodParam : this.getMethod().getParameters()) {
            MethodParamProxy methodParamProxy = (MethodParamProxy)this.getStorageDesign().getStorageObject(methodParam.getObjectID());
            if (methodParamProxy == null) continue;
            methodParamProxy.setParent(this.params);
            this.params.add(methodParamProxy);
        }
    }

    public StorageObjectCollection getParams() {
        return this.params;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        StructuredType structuredType;
        if (this.pac_Element == null && (structuredType = this.getStructuredType()) != null) {
            StorageObject structuredTypeProxy = this.getStorageDesign().getStorageObject(structuredType.getObjectID());
            this.setPAC_Element(structuredTypeProxy);
        }
        return super.getPAC_Element();
    }
}

