/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.AbstractRDBMSObject;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.util.GUID;

public class RDBMSSite
extends AbstractRDBMSObject
implements Comparable {
    private RDBMSType type;
    private String name;
    private boolean isDefault = false;
    private String objectID = new GUID().toString();
    private int pathID = 0;
    private RDBMSSiteSet set;
    private boolean designLevel = false;
    private Design design;

    public RDBMSSite(String name, Design design) {
        this.name = name;
        this.design = design;
    }

    public RDBMSSite(String name, RDBMSType type, Design design) {
        this.name = name;
        this.type = type;
        this.design = design;
    }

    public void setType(RDBMSType type) {
        this.type = type;
    }

    public RDBMSType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String objectID) {
        if (objectID != null && !"".equalsIgnoreCase(objectID)) {
            this.objectID = objectID;
        }
    }

    public String getShortObjectID() {
        int pos;
        if (this.objectID != null && !"".equalsIgnoreCase(this.objectID) && (pos = this.objectID.indexOf(45)) > -1) {
            String s1 = this.objectID.substring(0, pos);
            pos = this.objectID.lastIndexOf(45);
            String s2 = this.objectID.substring(pos + 1);
            return s1 + '-' + s2;
        }
        return this.objectID;
    }

    public String toString() {
        return this.getLongName();
    }

    public boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public int getPathID() {
        if (this.pathID == 0) {
            this.pathID = this.set.nextIndex();
        }
        return this.pathID;
    }

    public void setPathID(int pathID) {
        this.pathID = pathID;
    }

    public String getPathIDString() {
        return String.valueOf(this.getPathID());
    }

    public void setRDBMSSiteSet(RDBMSSiteSet set) {
        this.set = set;
    }

    public boolean isDesignLevel() {
        return this.designLevel;
    }

    public void setDesignLevel(boolean designLevel) {
        this.designLevel = designLevel;
    }

    public void setTypeID(int id) {
        RDBMSType rdbmsType = this.design.getRDBMSTypeSet().get(id);
        if (rdbmsType == null) {
            rdbmsType = this.design.getRDBMSTypeSet().get(9);
        }
        this.setType(rdbmsType);
    }

    public int getTypeID() {
        return this.getType().getType();
    }
}

