/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.AbstractRDBMSSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;

public class RDBMSSiteSet
extends AbstractRDBMSSet
implements RepositoryObject {
    public static final Object[] PROTO_ARRAY = new RDBMSSite[0];
    private RDBMSSite[] array = null;
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private boolean checkedOut = false;
    private boolean checkedOutByMe = false;
    private String checkedOutBy = "";
    private boolean dirty = false;
    private boolean saveDefaults = false;
    private boolean loadFromRepository = false;
    private RepositoryObject pac_Element;
    private int maxIndex = 0;
    private Design design;

    public RDBMSSiteSet(Design design) {
        this.design = design;
    }

    public void add(RDBMSSite site) {
        this.basicAdd(site);
        this.array = null;
        site.setRDBMSSiteSet(this);
    }

    public void remove(RDBMSSite site) {
        this.getValueSet().remove(site);
        this.array = (RDBMSSite[])this.getValueSet().toArray(PROTO_ARRAY);
    }

    public void removeAll(Collection<RDBMSSite> site) {
        this.getValueSet().removeAll(site);
        this.array = (RDBMSSite[])this.getValueSet().toArray(PROTO_ARRAY);
    }

    public void removeAll() {
        this.getValueSet().clear();
        this.array = (RDBMSSite[])this.getValueSet().toArray(PROTO_ARRAY);
    }

    public RDBMSSite[] toSiteArray() {
        if (this.array == null) {
            this.array = (RDBMSSite[])this.getValueSet().toArray(PROTO_ARRAY);
        }
        return this.array;
    }

    public Object[] toArray() {
        return this.toSiteArray();
    }

    public RDBMSType getDefaultType() {
        return this.design.getDefaultRDBMSTypeSet().get(this.design.getAppView().getSettings().getDefaultRDBMSType());
    }

    public RDBMSSite createSite(String name, RDBMSType type, Design design) {
        RDBMSSite site = new RDBMSSite(name, design);
        site.setType(type);
        this.add(site);
        return site;
    }

    public RDBMSSite createSite(String name, Design design) {
        return this.createSite(name, this.getDefaultType(), design);
    }

    public RDBMSSite get(RDBMSType type) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            RDBMSSite site = (RDBMSSite)it.next();
            if (site.getType() != type) continue;
            return site;
        }
        return null;
    }

    public RDBMSSite getByObjectID(String objectID) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            RDBMSSite site = (RDBMSSite)it.next();
            if (!site.getObjectID().equalsIgnoreCase(objectID)) continue;
            return site;
        }
        return null;
    }

    public RDBMSSite getByPathIDString(String pathID) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            RDBMSSite site = (RDBMSSite)it.next();
            if (!site.getPathIDString().equalsIgnoreCase(pathID)) continue;
            return site;
        }
        return null;
    }

    public RDBMSSite getByShortObjectIDString(String shortObjectID) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            RDBMSSite site = (RDBMSSite)it.next();
            if (!site.getShortObjectID().equalsIgnoreCase(shortObjectID)) continue;
            return site;
        }
        return null;
    }

    public RDBMSSite getByName(String name) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            RDBMSSite site = (RDBMSSite)it.next();
            if (!site.getName().equalsIgnoreCase(name)) continue;
            return site;
        }
        return null;
    }

    public boolean canSaveDefaults() {
        return this.saveDefaults;
    }

    public void setSaveDefaults(boolean save) {
        this.saveDefaults = save;
    }

    @Override
    public boolean canBedeleted() {
        return false;
    }

    @Override
    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    @Override
    public boolean isCheckedOutByMe() {
        return this.checkedOutByMe;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setCheckedOut(boolean checkedOut) {
        this.checkedOut = checkedOut;
    }

    @Override
    public void setCheckedOutBy(String checkedOutBy) {
        this.checkedOutBy = checkedOutBy;
    }

    @Override
    public void setCheckedOutByMe(boolean checkedOutByMe) {
        this.checkedOutByMe = checkedOutByMe;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void setRepositoryOID(String repositoryOID) {
        this.repositoryOID = repositoryOID;
    }

    @Override
    public void setRepositoryOVID(String repositoryOVID) {
        this.repositoryOVID = repositoryOVID;
    }

    @Override
    public String getName() {
        return "RDBMSSiteSet";
    }

    public boolean isLoadFromRepository() {
        return this.loadFromRepository;
    }

    public void setLoadFromRepository(boolean loadFromRepository) {
        this.loadFromRepository = loadFromRepository;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return true;
    }

    @Override
    public void setPAC_Element(RepositoryObject object) {
        if (!this.isPAC_Element()) {
            this.pac_Element = object;
        }
    }

    public void updateMaxIndex(int index) {
        this.maxIndex = Math.max(this.maxIndex, index);
    }

    public int nextIndex() {
        return ++this.maxIndex;
    }

    public List getRDBMSSitesForTypes(List rdbmsTypes) {
        ArrayList<RDBMSSite> list = new ArrayList<RDBMSSite>();
        for (RDBMSType type : rdbmsTypes) {
            Iterator its = this.iterator();
            while (its.hasNext()) {
                RDBMSSite site = (RDBMSSite)its.next();
                if (site.getType() != type) continue;
                list.add(site);
            }
        }
        return list;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    public RDBMSSite getDefaultRDBMSSite(Settings settings) {
        RDBMSSite selectedRDBMSSite;
        String siteID = settings.getDefaultRDBMSSite();
        if (StringUtilities.isNotEmpty(siteID) && (selectedRDBMSSite = this.getByObjectID(siteID)) != null) {
            return selectedRDBMSSite;
        }
        return this.get(StorageDesignOraclev11g.RDBMS_TYPE);
    }
}

