/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.exports.ddl.SQLAnalyzer;
import oracle.dbtools.crest.exports.ddl.SSBDropFK;
import oracle.dbtools.crest.exports.ddl.SSBDropIndex;
import oracle.dbtools.crest.exports.ddl.SSBDropTable;
import oracle.dbtools.crest.exports.ddl.SSBDropView;
import oracle.dbtools.crest.exports.ddl.SSBEndScript;
import oracle.dbtools.crest.exports.ddl.SSBErrorHandler;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.imports.ddl.DDLHandler;
import oracle.dbtools.crest.model.AbstractDesign;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.NameValidator;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SegmentNameManager;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignPartListener;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxySet;
import oracle.dbtools.crest.model.design.storage.ColumnProxySet;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.MethodParamProxySet;
import oracle.dbtools.crest.model.design.storage.MethodProxySet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.ReadRequest;
import oracle.dbtools.crest.model.design.storage.ReadRequestQueue;
import oracle.dbtools.crest.model.design.storage.ReadRequestStorageDesign;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPropertyTranslator;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageObjectSetEvent;
import oracle.dbtools.crest.model.design.storage.StorageObjectSetListener;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxySet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxySet;
import oracle.dbtools.crest.model.design.storage.TypeElementProxySet;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.model.metadata.XMLToObjectTransformer;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.db.RepDeleteDescr;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.storage.AbstractRXMLStorageDesign;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.search.Searchable;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.w3c.dom.Document;

public abstract class StorageDesign
extends AbstractDesign
implements DesignPartListener,
StorageObjectSetListener,
DesignListener,
Searchable,
NameValidator {
    public static final String RDBMS_DB2_V7_0 = "db2v7.0";
    public static String TYPE_NAME = "StorageDesign";
    public static final StorageDesign[] PROTOTYPE_ARRAY = new StorageDesign[0];
    protected List<ElementSet> ddlSelectionSetsList;
    private RDBMSSite rdbmsSite = null;
    private Map physicalProxyMap = new TreeMap();
    private Map storageObjectMap = new TreeMap();
    private RuleHandler ruleHandler;
    private DDLGenerator generator;
    private DDLGenerator dropGenerator;
    private DDLGenerator incompleteTypeGenerator;
    private DDLGenerator packageGenerator;
    private DDLGenerator typeGenerator;
    private DDLGenerator scopeGenerator;
    private DDLGenerator physicalTriggerGenerator;
    private DDLGenerator triggerGenerator;
    private DDLGenerator autoIncrementColumnGenerator;
    private DDLGenerator redactionPolicyGenerator;
    private DDLGenerator tsdpGenerator;
    private DDLGenerator userGenerator;
    private List endGenerators;
    private boolean initialReadBackDone = false;
    private ReadRequestQueue readRequestQueue;
    private MDDataTypeFactory dataTypeFactory = null;
    private boolean isLoading = true;
    protected List elements = new ArrayList();
    private boolean open = false;
    private RelationalDesign physicalDesign;
    private boolean closing = false;
    private boolean storageObjectsOnly = false;
    private TreeMap repositoryMap = new TreeMap();
    private float loadedVersion = 2.2f;
    private float version = 2.2f;
    private boolean cloneOperation = false;
    private RDBMSSite clonedSite = null;
    private boolean objectListChanged = false;
    protected Map f2tMap = null;
    private boolean tempModel = true;
    private static File lastFolder = null;
    private List lastSearchResult;
    private static final Logger LOGGER = new Logger(StorageDesign.class);
    private TreeMap filesMap = new TreeMap();
    private Map substitutionMap = new TreeMap();
    private PropertyTranslator[] translators;
    private List substitutionList;
    protected Map correspondenceMap;
    protected Map reverseMap;
    private static GetHelper getHelper = new GetHelper();

    public StorageDesign(RelationalDesign physicalDesign, RDBMSSite site, Design design) {
        this.id = new GUID().toString();
        this.physicalDesign = physicalDesign;
        this.setRDBMSSite(site);
        this.setDesign(design);
    }

    public ReadRequestQueue getReadRequestQueue() {
        if (this.readRequestQueue == null) {
            this.readRequestQueue = new ReadRequestQueue();
            this.readRequestQueue.setDesign(this.getDesign());
            this.readRequestQueue.setStorageDesign(this);
        }
        return this.readRequestQueue;
    }

    public ReadRequest getReadRequestFor(String id) {
        return this.getReadRequestQueue().getReadRequest(id);
    }

    public void removeReadRequestFor(String id) {
        this.removeReadRequestFor(this.getReadRequestFor(id));
    }

    public void removeReadRequestFor(ReadRequest readRequest) {
        this.getReadRequestQueue().removeReadRequest(readRequest);
    }

    public ReadRequest[] getReadRequests() {
        return this.getReadRequestQueue().getReadRequests();
    }

    public MDDataTypeFactory getDataTypeFactory() {
        if (this.dataTypeFactory == null) {
            this.dataTypeFactory = this.createDataTypeFactory();
        }
        return this.dataTypeFactory;
    }

    public MDDataTypeFactory createDataTypeFactory() {
        return MDDataTypeFactory.getInstance(this.getRDBMSType(), this.getDesign().getAppView().getSettings());
    }

    protected void initialize() {
        this.getDataTypeFactory();
        this.initializeImportedDesigns();
    }

    public boolean hasSpaceCalculation() {
        return false;
    }

    public void showSpaceCalculation() {
    }

    public boolean hasDistinctTypes() {
        return false;
    }

    public void showDistinctTypes() {
    }

    public boolean hasUserDefinedTypes() {
        return false;
    }

    public void showUserDefinedTypes() {
    }

    public List getDropableSets() {
        ArrayList list = new ArrayList();
        return list;
    }

    public void initializeProxiesForExistingDesignObjects() {
        if (this.getDesign() != null) {
            LOGGER.debug("StorageDesign.initializeProxiesForExistingDesignObjects should not be used. PhysicalObjectProxySets do that now");
            Collection tlobj = this.getDesign().getRelationalDesign().getAllTopLevelObjects();
            Iterator it = tlobj.iterator();
            while (it.hasNext()) {
                this.addPhysicalObject((DesignObject)it.next());
            }
            this.getDesign().getRelationalDesign().addDesignPartListener(this);
        }
    }

    @Override
    public String getFileName() {
        return this.getDesign().getFileName();
    }

    @Override
    public Collection getAllTopLevelObjects() {
        LinkedList<Object> list = new LinkedList<Object>();
        for (ElementSet objectSet : this.getAllSetsList()) {
            list.addAll(Arrays.asList(objectSet.toArray()));
        }
        return list;
    }

    public static StorageDesign createStorageDesign(RelationalDesign physicalDesign, RDBMSSite site, Design design) {
        if (physicalDesign == null || site == null || site.getType() == null || site.getType().getStorageDesignClassName() == null) {
            return StorageDesign.createNullInstanceWith(site, design);
        }
        RDBMSType type = site.getType();
        String className = type.getStorageDesignClassName();
        StorageDesign stoDes = null;
        ArrayList<String> msg = null;
        try {
            Class<?> stoDesClass = Class.forName(className);
            Constructor<?> constructor = stoDesClass.getDeclaredConstructor(RelationalDesign.class, RDBMSSite.class, Design.class);
            stoDes = (StorageDesign)constructor.newInstance(physicalDesign, site, design);
            design.addDesignListener(stoDes);
            stoDes.initialize();
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Can not find class " + className, e);
            msg = new ArrayList();
            msg.add("Can not find class (cnfe)");
            msg.add(className);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.error("Can not find class (ncdfe)" + className);
            msg = new ArrayList();
            msg.add("Can not find class (ncdfe)");
            msg.add(className);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("There is no appropriate constructor Xxx(PhysicalDesign, RDBMSSite, design).", e);
            msg = new ArrayList<String>();
            msg.add("There is no appropriate constructor Xxx(PhysicalDesign, RDBMSSite, design)");
            msg.add(className);
        }
        catch (Exception e) {
            LOGGER.error("Can not instantiate StorageDesign:", e);
            msg = new ArrayList();
            msg.add("Can not instantiate StorageDesign");
            msg.add(className);
        }
        if (stoDes == null) {
            stoDes = new NullStorageDesign(null, "No Storage Design loaded", msg.toArray(), site, design);
        }
        return stoDes;
    }

    private static StorageDesign createNullInstanceWith(RDBMSSite site, Design design) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("Storage Design can not be instantiated due to: ");
        if (site == null) {
            msg.add("No RDBMSSite information (null)");
        } else if (site.getType() == null) {
            msg.add("No RDBMSType information (null)");
        } else if (site.getType().getStorageDesignClassName() == null) {
            msg.add("No StorageDesignClassName information (null)");
        }
        if (design == null) {
            msg.add("Design (null).");
        }
        return new NullStorageDesign(null, Messages.getString("StorageDesign.NoStorageDesignLoaded"), msg.toArray(), site, design);
    }

    public void setRDBMSSite(RDBMSSite site) {
        this.rdbmsSite = site;
    }

    public RDBMSSite getRDBMSSite() {
        return this.rdbmsSite;
    }

    public RDBMSTypeSet getRDBMSTypeSet() {
        return this.getDesign().getRDBMSTypeSet();
    }

    public boolean isRDBMSSite(RDBMSSite site) {
        return this.getRDBMSSite().equals(site);
    }

    public abstract RDBMSType getRDBMSType();

    public abstract PropertyHolder getPropertyHolder();

    @Override
    public String getIDPrefix() {
        return "STODES";
    }

    public void addStorageObject(StorageObject object) {
        this.storageObjectMap.put(object.getObjectID(), object);
    }

    public void removeStorageObject(StorageObject object) {
        this.storageObjectMap.remove(object.getObjectID());
    }

    public void addPhysicalObject(DesignObject object) {
        throw new RuntimeException("addPhysicalObject(DesignObject) is deprecated");
    }

    public void addPhysicalObject(String objectID) {
        throw new RuntimeException("addPhysicalObject(String) is deprecated");
    }

    public void addPhysicalObject(String objectID, String longName) {
        throw new RuntimeException("addPhysicalObject(String, String) is deprecated");
    }

    public void removePhysicalObject(DesignObject object) {
        throw new RuntimeException("removePhysicalObject(DesignObject) is deprecated");
    }

    public void removePhysicalObject(String objectID) {
        throw new RuntimeException("removePhysicalObject(String) is deprecated");
    }

    public RelationalObjectProxy getObject(String id) {
        return this.getPhysicalObject(id);
    }

    public RelationalObjectProxy getPhysicalObject(String id) {
        throw new RuntimeException("getPhysicalObject(String) is deprecated");
    }

    public ModelIDObject getModelIDObject(String objectId) {
        if (this.storageObjectMap.containsKey(objectId)) {
            return (ModelIDObject)this.storageObjectMap.get(objectId);
        }
        if (this.physicalProxyMap.containsKey(objectId)) {
            LOGGER.error("StorageDesign.getModelIDObject(String): should not return PhysicalObjectProxy");
            return this.getPhysicalObject(objectId);
        }
        return null;
    }

    public StorageObject getStorageObject(String id) {
        return (StorageObject)this.getModelIDObject(id);
    }

    protected void registerModelIDObject(ModelIDObject object) {
        String id = object.getObjectID();
        if (object != null && id != null) {
            this.storageObjectMap.put(object.getObjectID(), object);
            this.setObjectListChanged(true);
        }
    }

    protected void unregisterModelIDObject(ModelIDObject object) {
        if (object != null && object.getObjectID() != null) {
            this.storageObjectMap.remove(object.getObjectID());
            this.setObjectListChanged(true);
        }
    }

    public void unregisterAll() {
        this.storageObjectMap.clear();
    }

    public boolean hasModelIDObject(ModelIDObject object) {
        return this.hasModelIDObject(object.getObjectID());
    }

    public boolean hasModelIDObject(String id) {
        return this.storageObjectMap.containsKey(id);
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject object) {
        if (object instanceof Table || object instanceof Index) {
            this.addPhysicalObject(object);
        }
    }

    @Override
    public void objectRemoved(DesignPart designPart, DesignObject object) {
        this.removePhysicalObject(object);
    }

    public boolean isNullInstance() {
        return false;
    }

    public Map getFunctionalities() {
        return Collections.EMPTY_MAP;
    }

    public abstract TableProxySet getTableProxySet();

    public abstract TableProxySet getSubViewTableProxySet();

    public abstract IndexProxySet getIndexProxySet();

    public abstract ColumnProxySet getColumnProxySet();

    public abstract TableViewProxySet getTableViewProxySet();

    public abstract TableViewProxySet getSubViewTableViewProxySet();

    public abstract StructuredTypeProxySet getStructuredTypeProxySet();

    public abstract TypeElementProxySet getTypeElementProxySet();

    public abstract MethodProxySet getMethodProxySet();

    public abstract MethodParamProxySet getMethodParamProxySet();

    public abstract StorageObjectSet getStorageObjectSetForType(String var1);

    public abstract CollectionTypeProxySet getCollectionTypeProxySet();

    public abstract void sortCollections();

    public List getAllSetsList() {
        ArrayList<RelationalObjectProxySet> list = new ArrayList<RelationalObjectProxySet>();
        list.add(this.getTableProxySet());
        list.add(this.getColumnProxySet());
        list.add(this.getIndexProxySet());
        list.add(this.getTableViewProxySet());
        list.add(this.getStructuredTypeProxySet());
        list.add(this.getTypeElementProxySet());
        list.add(this.getMethodProxySet());
        return list;
    }

    public RelationalObjectProxy getProxy(Object object) {
        String id = null;
        if (object instanceof ModelIDObject) {
            id = ((ModelIDObject)object).getObjectID();
        } else if (object instanceof String) {
            id = (String)object;
        }
        if (this.getTableProxySet().containsId(id)) {
            return this.getTableProxySet().getProxy(id);
        }
        if (this.getIndexProxySet().containsId(id)) {
            return this.getIndexProxySet().getProxy(id);
        }
        if (this.getColumnProxySet().containsId(id)) {
            return this.getColumnProxySet().getProxy(id);
        }
        if (this.getTableViewProxySet().containsId(id)) {
            return this.getTableViewProxySet().getProxy(id);
        }
        if (this.getStructuredTypeProxySet() != null && this.getStructuredTypeProxySet().containsId(id)) {
            return this.getStructuredTypeProxySet().getProxy(id);
        }
        if (this.getTypeElementProxySet() != null && this.getTypeElementProxySet().containsId(id)) {
            return this.getTypeElementProxySet().getProxy(id);
        }
        if (this.getMethodProxySet() != null && this.getMethodProxySet().containsId(id)) {
            return this.getMethodProxySet().getProxy(id);
        }
        if (this.getMethodParamProxySet() != null && this.getMethodParamProxySet().containsId(id)) {
            return this.getMethodParamProxySet().getProxy(id);
        }
        if (this.getCollectionTypeProxySet() != null && this.getCollectionTypeProxySet().containsId(id)) {
            return this.getCollectionTypeProxySet().getProxy(id);
        }
        return null;
    }

    public RuleHandler getRuleHandler() {
        if (this.ruleHandler == null) {
            this.ruleHandler = this.createRuleHandler();
            this.ruleHandler.setLabel(this.getLongName());
        }
        return this.ruleHandler;
    }

    protected RuleHandler createRuleHandler() {
        return RuleHandler.getNullInstance();
    }

    public List getDDLEndScriptGenerators() {
        if (this.endGenerators == null) {
            this.endGenerators = this.createDDLEndScriptGenerators();
            for (DDLGenerator generator : this.endGenerators) {
                generator.setLabel(this.getRDBMSType().getLongName());
            }
        }
        return this.endGenerators;
    }

    protected List createDDLEndScriptGenerators() {
        ArrayList<DDLGeneratorSpecific> list = new ArrayList<DDLGeneratorSpecific>();
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        ddlGenerator.append(new SSBEndScript());
        list.add(ddlGenerator);
        return list;
    }

    public DDLGenerator getDDLGenerator() {
        if (this.generator == null) {
            this.generator = this.createDDLGenerator();
            this.generator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
            this.generator.setLabel(this.getRDBMSType().getLongName());
        }
        return this.generator;
    }

    protected DDLGenerator createDDLGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    public DDLGenerator getDDLDropGenerator() {
        if (this.dropGenerator == null) {
            this.dropGenerator = this.createDDLDropGenerator();
            this.dropGenerator.setLabel("DropGen");
            this.dropGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.dropGenerator;
    }

    protected DDLGenerator createDDLDropGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        ddlGenerator.append(new SSBDropFK());
        ddlGenerator.append(new SSBDropIndex());
        ddlGenerator.append(new SSBDropView());
        ddlGenerator.append(new SSBDropTable());
        return ddlGenerator;
    }

    public DDLGenerator getDDLIncompleteTypeGenerator() {
        if (this.incompleteTypeGenerator == null) {
            this.incompleteTypeGenerator = this.createDDLIncompleteTypeGenerator();
            this.incompleteTypeGenerator.setLabel("TypesGen");
            this.incompleteTypeGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.incompleteTypeGenerator;
    }

    public DDLGenerator getDDLUserGenerator() {
        if (this.userGenerator == null) {
            this.userGenerator = this.createDDLUserGenerator();
            this.userGenerator.setLabel("UserGen");
            this.userGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.userGenerator;
    }

    protected DDLGenerator createDDLIncompleteTypeGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    public DDLGenerator getDDLTypeGenerator() {
        if (this.typeGenerator == null) {
            this.typeGenerator = this.createDDLTypeGenerator();
            this.typeGenerator.setLabel("CompileTypesGen");
            this.typeGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.typeGenerator;
    }

    protected DDLGenerator createDDLTypeGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    public DDLGenerator getDDLScopeGenerator() {
        if (this.scopeGenerator == null) {
            this.scopeGenerator = this.createDDLScopeGenerator();
            this.scopeGenerator.setLabel("ScopeGenerator");
            this.scopeGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.scopeGenerator;
    }

    protected DDLGenerator createDDLScopeGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    protected DDLGenerator createDDLUserGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    public DDLGenerator getDDLPhysicalTriggerGenerator() {
        if (this.physicalTriggerGenerator == null) {
            this.physicalTriggerGenerator = this.createDDLPhysicalTriggerGenerator();
            this.physicalTriggerGenerator.setLabel("PhysicalTriggerGenerator");
            this.physicalTriggerGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.physicalTriggerGenerator;
    }

    protected DDLGenerator createDDLPhysicalTriggerGenerator() {
        return new DDLGeneratorSpecific();
    }

    public DDLGenerator getDDLTriggerGenerator() {
        if (this.triggerGenerator == null) {
            this.triggerGenerator = this.createDDLTriggerGenerator();
            this.triggerGenerator.setLabel("TriggerGenerator");
            this.triggerGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.triggerGenerator;
    }

    public DDLGenerator getDDLAutoIncrementColumnGenerator() {
        if (this.autoIncrementColumnGenerator == null) {
            this.autoIncrementColumnGenerator = this.createDDLAutoIncrementColumnGenerator();
            this.autoIncrementColumnGenerator.setLabel("AutoIncrementColumnGenerator");
            this.autoIncrementColumnGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.autoIncrementColumnGenerator;
    }

    public DDLGenerator getRedactionPolicyGenerator() {
        if (this.redactionPolicyGenerator == null) {
            this.redactionPolicyGenerator = this.createRedactionPolicyGenerator();
            this.redactionPolicyGenerator.setLabel("RedactionPolicyGenerator");
            this.redactionPolicyGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.redactionPolicyGenerator;
    }

    public DDLGenerator getTSDPGenerator() {
        if (this.tsdpGenerator == null) {
            this.tsdpGenerator = this.createTSDPGenerator();
            this.tsdpGenerator.setLabel("TSDPGenerator");
            this.tsdpGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.tsdpGenerator;
    }

    protected DDLGenerator createDDLTriggerGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    protected DDLGenerator createDDLAutoIncrementColumnGenerator() {
        return new DDLGeneratorSpecific();
    }

    protected DDLGenerator createRedactionPolicyGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    protected DDLGenerator createTSDPGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    public Iterator ddlObjects() {
        ArrayList list = new ArrayList();
        this.addDDLStorageObjects(list, this.getTableProxySet());
        this.addDDLStorageObjects(list, this.getIndexProxySet());
        this.addDDLStorageObjects(list, this.getTableViewProxySet());
        return list.iterator();
    }

    public abstract List getListOfDDLObjects();

    public Iterator ddlDropObjects() {
        ArrayList list = new ArrayList();
        this.addDDLStorageObjects(list, this.getIndexProxySet());
        this.addDDLStorageObjects(list, this.getTableViewProxySet());
        this.addDDLStorageObjects(list, this.getTableProxySet());
        return list.iterator();
    }

    public Iterator ddlIncompleteTypeObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    public Iterator ddlTypeObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    public Iterator ddlScopeObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    public Iterator ddlUserObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    public Iterator ddlAutoIncrementColumnObjects() {
        ArrayList list = new ArrayList();
        this.addDDLStorageObjects(list, this.getTableProxySet());
        return list.iterator();
    }

    public Iterator ddlEndScriptObjects() {
        ArrayList list = new ArrayList();
        this.addDDLStorageObjects(list, this.getTableProxySet());
        this.addDDLStorageObjects(list, this.getTableViewProxySet());
        return list.iterator();
    }

    public Iterator ddlTriggersCausingObjects() {
        ArrayList<TableProxy> list = new ArrayList<TableProxy>();
        Iterator it = this.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxy tp = (TableProxy)it.next();
            if (!((Table)tp.getObject()).hasNoneTransferableFK()) continue;
            list.add(tp);
        }
        this.getPhysicalDesign().getArcSet().addAllElementsTo(list);
        return list.iterator();
    }

    public Iterator ddlRedactionPolicyObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    public Iterator ddlTSDPPolicyObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    protected void addDDLStorageObjects(Collection collection, RelationalObjectProxySet set) {
        this.addDDLStorageObjects(collection, (StorageObject[])set.toArray());
    }

    protected void addDDLStorageObjectsNosort(Collection collection, RelationalObjectProxySet set) {
        this.addDDLStorageObjectsNoSort(collection, (StorageObject[])set.toArray());
    }

    protected void addDDLStorageObjects(Collection collection, StorageObjectSet set) {
        this.addDDLStorageObjects(collection, (StorageObject[])set.toArray());
    }

    protected void addDDLStorageObjects(Collection collection, StorageObject[] objects) {
        ArrayList<StorageObject> list = new ArrayList<StorageObject>();
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i].isNullInstance() || !objects[i].belongsToDesign()) continue;
            StorageObject object = objects[i];
            list.add(object);
        }
        Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
        collection.addAll(list);
    }

    protected void addDDLStorageObjectsNoSort(Collection collection, StorageObject[] objects) {
        DesignPartView dpv = this.getDesign().getSelectedSubView();
        for (int i = 0; i < objects.length; ++i) {
            StorageObject object;
            if (objects[i].isNullInstance() || !objects[i].belongsToDesign() || !this.canProcesProxy(dpv, object = objects[i])) continue;
            collection.add(object);
        }
    }

    protected void addDDLStorageObjectsNoSort(Collection collection, List list) {
        for (StorageObject sto : list) {
            if (sto.isNullInstance() || !sto.belongsToDesign()) continue;
            collection.add(sto);
        }
    }

    public boolean canProcesProxy(DesignPartView dpv, Object object) {
        if (dpv == null) {
            return true;
        }
        DesignObject cob = null;
        DesignObject obj = null;
        if (object instanceof RelationalObjectProxy) {
            obj = ((RelationalObjectProxy)object).getObject();
        }
        if (obj != null) {
            if (obj instanceof Table) {
                cob = obj;
            } else if (obj instanceof TableView) {
                cob = obj;
            } else if (obj instanceof Index) {
                cob = ((Index)obj).getTable();
            } else if (obj instanceof FKIndexAssociation) {
                cob = ((FKIndexAssociation)obj).getTable();
            }
            if (cob != null) {
                return cob.getFirstViewForDPV(dpv) != null;
            }
        }
        return true;
    }

    public Iterator siteObjects() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator designSpecificObjects() {
        ArrayList list = new ArrayList();
        this.addStorageObjects(list, this.getStructuredTypeProxySet());
        this.addStorageObjects(list, this.getTableProxySet());
        this.addStorageObjects(list, this.getIndexProxySet());
        this.addStorageObjects(list, this.getTableViewProxySet());
        return list.iterator();
    }

    protected void addStorageObjects(Collection collection, RelationalObjectProxySet set) {
        this.addStorageObjects(collection, (StorageObject[])set.toArray());
    }

    protected void addStorageObjects(Collection collection, StorageObjectSet set) {
        this.addDDLStorageObjects(collection, (StorageObject[])set.toArray());
    }

    protected void addStorageObjects(Collection collection, StorageObject[] objects) {
        collection.add(Arrays.asList(objects));
    }

    public PropertyTranslator[] getPropertyTranslators() {
        if (this.translators == null) {
            this.translators = new PropertyTranslator[]{new StorageObjectPropertyTranslator(this)};
        }
        return this.translators;
    }

    public void doTableSpaceCalculations() {
    }

    public void doIndexSpaceCalculations() {
    }

    public void copyCommentInRDBMS() {
        this.copyCommentInRDBMS(this.getTableProxySet());
        this.copyCommentInRDBMS(this.getTableViewProxySet());
        this.copyCommentInRDBMS(this.getColumnProxySet());
        this.copyCommentInRDBMS(this.getIndexProxySet());
    }

    public void copyCommentInRDBMS(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            RelationalObjectProxy proxy = (RelationalObjectProxy)it.next();
            System.out.println("copying: " + proxy);
            proxy.copyCommentInRDBMS();
        }
    }

    @Override
    public void changed(StorageObjectSet set, StorageObjectSetEvent event) {
        if (event.isAdded()) {
            this.addStorageObject(event.getAffectedStorageObject());
        } else if (event.isRemoved()) {
            this.removeStorageObject(event.getAffectedStorageObject());
        }
    }

    public boolean isInitialReadBackDone() {
        return this.initialReadBackDone;
    }

    public void setInitialReadBackDone(boolean value) {
        this.initialReadBackDone = value;
    }

    @Override
    public void designChanged(DesignEvent event) {
    }

    public void importDesign(Object name) {
        ReadRequestStorageDesign request = new ReadRequestStorageDesign();
        request.setStorageDesign(this);
        request.setDesignName((String)name);
        request.setRequestLock(false);
        this.getDesign().getAppView().getPersistenceManager().read(request, this.getDesign());
    }

    protected void initializeImportedDesigns() {
        String[] names = this.getDesign().getImportedDesignNames();
        for (int i = 0; i < names.length; ++i) {
            this.importDesign(names[i]);
        }
    }

    @Override
    public String[] getImportedDesignNames() {
        return this.getDesign().getImportedDesignNames();
    }

    public void setLoading(boolean state) {
        this.isLoading = state;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void clearAll() {
        for (Object obj : this.getAllSetsList()) {
            if (obj instanceof StorageObjectSet) {
                ((StorageObjectSet)obj).removeAll();
                continue;
            }
            if (!(obj instanceof RelationalObjectProxySet)) continue;
            ((RelationalObjectProxySet)obj).clearAll();
        }
        this.unregisterAll();
        this.getReadRequestQueue().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.closing = true;
            DataModelerAddin.closeAllEditors(this, false);
            this.getDesign().getAppView().getPersistenceManager().getPMWPoolMap().clearPMWPoolMap();
            this.setVisible(false);
            this.setOpen(false);
            this.clearAll();
            this.reloadAllProxies();
            this.reloadDefaults();
        }
        finally {
            this.closing = false;
        }
        System.gc();
    }

    public void reloadDefaults() {
    }

    public void delete() {
        this.delete(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(boolean confirm) {
        int option;
        if (confirm && (option = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), "Are you sure you want to delete this physical model?", "Warning", 0, 3)) == 1) {
            return;
        }
        try {
            String storagePath;
            this.closing = true;
            this.getDesign().getAppView().setCurrentDesign(this.getDesign());
            DataModelerAddin.closeAllEditors(this, false);
            if (this.getDesign().isOldRepositoryType()) {
                this.getDesign().getAppView().getPersistenceManager().getPMWPoolMap().clearPMWPoolMap();
            }
            this.setVisible(false);
            this.setOpen(false);
            this.getDesign().removeDesignListener(this);
            this.getPhysicalDesign().removeDesignPartListener(this);
            this.clearAll();
            if (this.getPhysicalDesign().getStorageDesignFactory() != null) {
                this.getPhysicalDesign().getStorageDesignFactory().removeStorageDesign(this);
            }
            if ((storagePath = this.getStoragePath()) != null) {
                File deleted = new File(storagePath);
                if (Extension.isSVNExtensionLoaded()) {
                    SVNClientHelper svnClientHelper = SVNClientHelper.getInstance();
                    if (svnClientHelper.isVersioned(deleted)) {
                        svnClientHelper.doRemove(new File[]{deleted});
                    } else {
                        this.getAppView().getXMLTransformationManager().deleteDirectory(deleted);
                    }
                } else {
                    this.getAppView().getXMLTransformationManager().deleteDirectory(deleted);
                }
            }
            this.physicalDesign = null;
            this.setDesign(null);
        }
        finally {
            this.closing = false;
        }
        System.gc();
    }

    @Override
    public int getNumberOfChildren() {
        if (!this.isOpen()) {
            return 0;
        }
        return this.elements.size();
    }

    @Override
    public ModelObject getChild(int index) {
        return (ModelObject)this.elements.get(index);
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return this.elements.indexOf(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        return this.elements.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public void doAfterLoad() {
        this.checkAndSetIDGenerator();
        this.createFilesMap();
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.setAllStorableObjectsDirty(false);
        this.sortCollections();
        this.getAppView().getXMLTransformationManager().restoreDDLSelection(this);
    }

    public void load() {
        XMLPersistenceManager pm = this.getDesign().getAppView().getPersistenceManager();
        pm.removePMWPoolMap();
        pm.read((Object)this, this.getDesign(), true);
        this.checkAndSetIDGenerator();
        this.createFilesMap();
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.setAllStorableObjectsDirty(false);
    }

    public void checkAndSetIDGenerator() {
        Collection col = this.getAllTopLevelObjects();
        Iterator it = col.iterator();
        long max = 0L;
        long temp = 0L;
        while (it.hasNext()) {
            ModelIDObject mo = (ModelIDObject)it.next();
            String id = mo.getObjectID();
            temp = this.getCounter(id);
            if (temp <= max) continue;
            max = temp;
        }
        long startCounter = this.getDesign().getAppView().getIDGenerator().getStartCounter();
        long lastIndex = this.getDesign().getAppView().getIDGenerator().getLastIDIndex();
        if (max > lastIndex) {
            this.getDesign().getAppView().getIDGenerator().setCounter(max - startCounter + 1L);
        }
    }

    private long getCounter(String id) {
        int ind = 9;
        int length = id.length();
        long counter = 0L;
        if (ind > length) {
            ind = length - 1;
        }
        while (true) {
            try {
                counter = Integer.parseInt(id.substring(length - ind));
                return counter;
            }
            catch (NumberFormatException e) {
                if (--ind >= 1) continue;
                return 0L;
            }
            break;
        }
    }

    public void createRepositoryMap() {
        this.repositoryMap.clear();
        List col = this.getStorableObjects();
        for (ModelIDObject dobj : col) {
            if (dobj.getRepositoryOID() == null) continue;
            RepDeleteDescr descr = new RepDeleteDescr();
            descr.objectType = dobj.getObjectTypeName();
            descr.repOID = dobj.getRepositoryOID();
            descr.repOVID = dobj.getRepositoryOVID();
            this.repositoryMap.put(dobj.getObjectID(), descr);
        }
    }

    public List getObjectsToDeleteFromRepository() {
        List col = this.getStorableObjects();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (ModelIDObject dobj : col) {
            if (dobj.getRepositoryOID() == null) continue;
            map.put(dobj.getObjectID(), dobj.getObjectID());
        }
        ArrayList deleted = new ArrayList();
        for (Map.Entry entry : this.repositoryMap.entrySet()) {
            Object obj = map.get(entry.getKey());
            if (obj != null) continue;
            deleted.add(entry.getValue());
        }
        return deleted;
    }

    public void doAfterSave() {
        if (this.getPhysicalDesign().getDesign().getCurrentOperation() != 5) {
            this.synchronizeFilesMap(true);
        }
        this.setDirty(false);
        this.setAllStorableObjectsDirty(false);
    }

    public void synchronizeFilesMap(boolean removeFromVCS) {
        this.removeDeletedObjects(removeFromVCS);
        this.createFilesMap();
    }

    public void save() {
        if (!this.isTempModel()) {
            if (this.getDesign().isOldRepositoryType()) {
                MessageDialogs.showWarningMessage("This design is saved in an old format and can't be overwritten!\nPlease use \"Save As..\" option to save it as new design.");
            } else {
                DataModelerAddin.saveAllEditors(this);
                this.getAppView().setCurrentDesign(this.getDesign());
                this.getAppView().getXMLTransformationManager().savePhysicalModel(this);
            }
            this.setDirty(false);
            this.setAllStorableObjectsDirty(false);
        }
    }

    protected void createFilesMap() {
        this.filesMap.clear();
        List col = this.getStorableObjects();
        for (Object obj : col) {
            ModelIDObject dobj;
            if (!(obj instanceof ModelIDObject) || (dobj = (ModelIDObject)obj).getSegmentedStorageName() == null) continue;
            this.filesMap.put(dobj.getObjectID(), dobj.getSegmentedStorageName());
        }
    }

    private void removeDeletedObjects(boolean removeFromVCS) {
        List col = this.getStorableObjects();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (ModelIDObject dobj : col) {
            map.put(dobj.getObjectID(), dobj.getObjectID());
        }
        ArrayList<String> deleted = new ArrayList<String>();
        for (Map.Entry entry : this.filesMap.entrySet()) {
            Object obj = map.get(entry.getKey());
            if (obj != null || entry.getValue() == null) continue;
            deleted.add((String)entry.getValue());
        }
        if (deleted.size() > 0) {
            this.getAppView().setCurrentDesign(this.getDesign());
            if (Extension.isSVNExtensionLoaded() && removeFromVCS && this.getDesign().isVersioned()) {
                SVNClientHelper.getInstance().doRemove(deleted);
            } else {
                this.getAppView().getXMLTransformationManager().deleteFiles(deleted);
            }
        }
    }

    public abstract String getFormatedName(String var1);

    public String getFormatedName(ModelIDObject obj) {
        boolean quoted = this.getAppView().getSettings().isUseQuotedIdentifiers();
        return obj.getFormatedName(this, quoted);
    }

    public String getFormatedLongNameDDL(ModelIDObject obj) {
        TableProxyOracle prebuiltTable;
        if (obj instanceof SnapshotOracle && (prebuiltTable = ((SnapshotOracle)obj).getOnPrebuildTable()) != null) {
            obj = prebuiltTable;
        }
        if (this.getAppView().getSettings().isIncludeSchemaInDDL()) {
            return this.getFormatedLongName(obj);
        }
        return this.getFormatedName(obj);
    }

    public String getFormatedLongName(ModelIDObject obj) {
        boolean quoted = this.getAppView().getSettings().isUseQuotedIdentifiers();
        String fschema = null;
        String fname = obj.getFormatedName(this, quoted);
        ModelIDObject sch_impl = null;
        if (obj instanceof TableProxy) {
            sch_impl = ((TableProxy)obj).getSchemaImplementingObject();
        } else if (obj instanceof TableViewProxy) {
            sch_impl = ((TableViewProxy)obj).getSchemaImplementingObject();
        } else if (obj instanceof IndexProxyOracle) {
            sch_impl = ((IndexProxyOracle)obj).getSchemaImplementingObject();
        } else if (obj instanceof OwnedObjectOracle) {
            OwnedObjectOracle ob_ora = (OwnedObjectOracle)((Object)obj);
            StorageObject user = ob_ora.getUser();
            if (user != null) {
                fschema = user.getFormatedName(this, quoted);
            } else if (obj instanceof RelationalObjectProxy) {
                SchemaObject sch;
                DesignObject dobj = ((RelationalObjectProxy)obj).getObject();
                if (dobj != null && dobj instanceof ContainerObject && (sch = ((ContainerObject)dobj).getSchemaObject()) != null) {
                    user = this.getUserSchemaSet().getBySchemaObject(sch);
                    if (user != null) {
                        fschema = user.getFormatedName(this, quoted);
                    } else if (!this.isOpen()) {
                        fschema = sch.getFormatedName(this, quoted);
                    }
                }
            } else if (ob_ora.getSchemaObject() != null) {
                user = this.getUserSchemaSet().getBySchemaObject(ob_ora.getSchemaObject());
                if (user != null) {
                    fschema = user.getFormatedName(this, quoted);
                } else if (!this.isOpen()) {
                    fschema = ob_ora.getSchemaObject().getFormatedName(this, quoted);
                }
            }
        } else if (obj instanceof ContainerObject) {
            ContainerObject co = (ContainerObject)obj;
            if (co.getSchemaObject() != null) {
                fschema = this.getFormatedName(co.getSchemaObject());
            }
        } else {
            int ind;
            String name = obj.getName();
            String lname = obj.getLongName();
            if (lname.length() > name.length() && (ind = lname.lastIndexOf(name)) > 0) {
                String schema = lname.substring(0, ind - 1);
                fschema = this.getFormatedSimpleName(schema);
            }
        }
        if (sch_impl != null) {
            fschema = sch_impl.getFormatedName(this, quoted);
        }
        if (fschema == null) {
            return fname;
        }
        return fschema + "." + fname;
    }

    public String getFormatedSimpleName(String name) {
        if (this.getAppView().getSettings().isUseQuotedIdentifiers() || !this.isValidName(name)) {
            return "\"" + name + "\"";
        }
        return name;
    }

    public String getFormatedNameNoUseQIflag(ModelIDObject obj) {
        String name = obj.getName();
        if (obj.getNameHasQuotes() || !this.isValidName(name)) {
            return "\"" + name + "\"";
        }
        return name;
    }

    public String getFormatedNamesFromIDs(String idList, ElementSet elementSet) {
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(idList, ",");
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken().trim();
            ModelIDObject modelObject = elementSet.getObjectByID(id);
            if (modelObject == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(this.getFormatedName(modelObject));
        }
        return result.toString();
    }

    public boolean isNameShouildBeQuoted(ModelIDObject obj) {
        String name = obj.getName();
        return obj.getNameHasQuotes() || !this.isValidName(name);
    }

    public static boolean hasForbiddenCharsOracle(String name) {
        return name.indexOf(32) > -1 || name.indexOf(46) > -1 || name.indexOf(38) > -1 || name.indexOf(33) > -1 || name.indexOf(126) > -1 || name.indexOf(37) > -1 || name.indexOf(94) > -1 || name.indexOf(40) > -1 || name.indexOf(41) > -1 || name.indexOf(45) > -1 || name.indexOf(123) > -1 || name.indexOf(125) > -1 || name.indexOf(92) > -1 || name.indexOf(47) > -1 || name.indexOf(124) > -1 || name.indexOf(58) > -1 || name.indexOf(59) > -1 || name.indexOf(42) > -1 || name.indexOf(63) > -1 || name.indexOf(62) > -1 || name.indexOf(60) > -1 || name.indexOf(44) > -1 || name.indexOf(39) > -1 || name.indexOf(34) > -1 || name.indexOf(63) > -1 || name.indexOf(43) > -1 || name.indexOf(96) > -1;
    }

    public boolean startsWithNumber(String name) {
        String[] NUMBERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        for (int i = 0; i < NUMBERS.length; ++i) {
            if (!name.startsWith(NUMBERS[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidName(String name) {
        return !StorageDesign.hasForbiddenCharsOracle(name) && !this.startsWithNumber(name);
    }

    public DDLAdvancedGenerator createDDLAdvancedGenerator() {
        return null;
    }

    public Map getNameSubstituionTypes() {
        if (this.substitutionMap.isEmpty()) {
            this.substitutionMap.put("Table", new ObjectType("Table"));
            this.substitutionMap.put("Schema", new ObjectType("Schema"));
        }
        return this.substitutionMap;
    }

    public List getNameSubstitutionTypesList() {
        if (this.substitutionList == null) {
            this.substitutionList = Arrays.asList(this.getNameSubstituionTypes().values().toArray());
        }
        return this.substitutionList;
    }

    public boolean isNameSubstitutionTypeSelected(String name) {
        ObjectType obj = (ObjectType)this.getNameSubstituionTypes().get(name);
        if (obj != null) {
            return obj.isSelected();
        }
        return false;
    }

    public boolean isClosing() {
        return this.closing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStorageObjectsFromDDL() {
        block11: {
            try {
                File file;
                URLFilter ddlFilter = new URLFilter(){

                    public boolean accept(URL url) {
                        File file = new File(url.getPath());
                        return file.getName().toLowerCase().endsWith(".sql") || file.getName().toLowerCase().endsWith(".ddl") || file.isDirectory();
                    }

                    public String toString() {
                        return "DDL Files (*.sql; *.ddl)";
                    }
                };
                URLChooser fileChooser = DialogUtil.newURLChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(0);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setURLFilter(ddlFilter);
                ApplicationView.waitLoadFilesThreadToComplete();
                if (lastFolder != null) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
                } else {
                    String lastDir = this.getAppView().getSettings().getDefaultImportPath();
                    if (lastDir != null && lastDir.length() > 0) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                    } else {
                        URL url = this.getAppView().getUserHomeDirectory();
                        if (url != null) {
                            fileChooser.setSelectedURL(url);
                        }
                    }
                }
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), "Select File");
                if (status != 0 || (file = new File(fileChooser.getSelectedURL().getPath())) == null) break block11;
                lastFolder = file.getParentFile();
                FileOpenHistory.getInstance().updateFileHistory(lastFolder.toURI().toURL());
                try {
                    String designName = file.getName();
                    int ext = designName.lastIndexOf(46);
                    if (ext > -1) {
                        designName = designName.substring(0, ext);
                    }
                    String oldDesignPath = this.physicalDesign.getDesign().getDesignPath();
                    ApplicationView.log(Messages.getString("StorageDesign.ImportingStorageObjectsFromDDL"));
                    DDLHandler ddlHandler = new DDLHandler(this.physicalDesign.getAppView(), this.physicalDesign, false, true, this);
                    ddlHandler.parse(new Object[]{file}, designName, oldDesignPath);
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            catch (Exception error) {
                LOGGER.error("Error Importing Storage Objects from DDL", error);
            }
        }
    }

    public boolean importStorageObjectsOnly() {
        return this.storageObjectsOnly;
    }

    public void setImportStorageObjectsOnly(boolean storageObjectsOnly) {
        this.storageObjectsOnly = storageObjectsOnly;
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public List getTypeOrder() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("TSpace");
        list.add("TmpTSpace");
        list.add("UTSpace");
        list.add("DB");
        list.add("DataFile");
        list.add("RLGrp");
        list.add("Segment");
        list.add("User");
        list.add("QuotaItem");
        list.add("Cluster");
        list.add("Snapshot");
        list.add("PartList");
        list.add("Partition");
        list.add("Level");
        list.add("Hierarchy");
        list.add("DimenAttr");
        list.add("Dimension");
        list.add("SType");
        list.add("TypeElement");
        list.add("Method");
        list.add(MethodParam.TYPE_NAME);
        list.add("CollectionType");
        list.add("Table");
        list.add("Column");
        list.add("Index");
        return list;
    }

    public List getOrderedTypes(List types) {
        ArrayList temp = new ArrayList(types);
        List order = this.getTypeOrder();
        if (order.size() == 0) {
            return types;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String type : order) {
            String inp_type = null;
            for (int i = 0; i < types.size(); ++i) {
                String str = (String)types.get(i);
                if (!str.equalsIgnoreCase(type)) continue;
                inp_type = str;
                temp.remove(str);
                break;
            }
            if (inp_type == null) continue;
            result.add(inp_type);
        }
        result.addAll(temp);
        return result;
    }

    public float getLoadedVersion() {
        return this.loadedVersion;
    }

    public void setLoadedVersion(float loadedVersion) {
        this.loadedVersion = loadedVersion;
    }

    public float getVersion() {
        return this.version;
    }

    public List getStorableObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ElementSet objectSet : this.getStorableSetsList()) {
            list.addAll(Arrays.asList(objectSet.toArray()));
        }
        return list;
    }

    public abstract List getStorableSetsList();

    public abstract List getUniqueList();

    public abstract List getFKProxyList();

    public abstract List getPKProxyList();

    public boolean hasDirtyStorableObjects() {
        for (ModelIDObject dobj : this.getStorableObjects()) {
            if (!dobj.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void setAllStorableObjectsDirty(boolean dirty) {
        for (ModelIDObject dobj : this.getStorableObjects()) {
            dobj.setDirty(dirty);
        }
    }

    public List getDirtyObjects() {
        ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
        for (ModelIDObject dobj : this.getStorableObjects()) {
            if (!dobj.isDirty()) continue;
            list.add(dobj);
        }
        return list;
    }

    public boolean isCloneOperation() {
        return this.cloneOperation;
    }

    public void setCloneOperation(boolean cloneOperation) {
        this.cloneOperation = cloneOperation;
    }

    public RDBMSSite getClonedSite() {
        return this.clonedSite;
    }

    public void setClonedSite(RDBMSSite clonedSite) {
        this.clonedSite = clonedSite;
    }

    public abstract List getRDBMSTypesForClone();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneFromMemoryToAnother(StorageDesign compatibleSD, Map correspondenceMap, boolean checkMerge) {
        List list = this.getRDBMSTypesForClone();
        StorageDesign targetSD = compatibleSD;
        StorageDesign sourceSD = this;
        if (list.contains(targetSD.getRDBMSType())) {
            try {
                TreeMap<String, String> reverse;
                boolean dirty = false;
                this.correspondenceMap = correspondenceMap;
                targetSD.correspondenceMap = correspondenceMap;
                targetSD.reverseMap = reverse = new TreeMap<String, String>();
                targetSD.setLoading(true);
                this.getDesign().getAppView().getPersistenceManager().setCheckDirty(false);
                AbstractRXMLStorageDesign reader = (AbstractRXMLStorageDesign)this.getDesign().getAppView().getPersistenceManager().getReaderFor(targetSD);
                AbstractXMLWriter sdWriter = this.getDesign().getAppView().getPersistenceManager().getWriterFor(sourceSD);
                ArrayList<StorageObject> proxys = new ArrayList<StorageObject>();
                ArrayList<StorageObject> stobjects = new ArrayList<StorageObject>();
                for (StorageObject so : sourceSD.getStorableObjects()) {
                    if (!StorageDesign.shouldMerge(so, checkMerge)) continue;
                    if (so instanceof RelationalObjectProxy) {
                        String id;
                        ModelIDObject obj;
                        proxys.add(so);
                        if (correspondenceMap == null || (obj = (ModelIDObject)correspondenceMap.get(id = so.getObjectID())) == null) continue;
                        String newID = obj.getObjectID();
                        if (reverse == null) continue;
                        reverse.put(newID, id);
                        continue;
                    }
                    if (so instanceof SnapshotOracle || so instanceof SequenceOracle) continue;
                    stobjects.add(so);
                    this.createReadRequestForTargetObject(so, targetSD);
                }
                stobjects.addAll(proxys);
                for (StorageObject so : stobjects) {
                    if (correspondenceMap == null || !so.isTopLevelObject()) continue;
                    Object to = correspondenceMap.get(so.getObjectID());
                    StorageObject target = null;
                    if (to == null) continue;
                    if (to instanceof DesignObject) {
                        DesignObject dob = (DesignObject)to;
                        if (to instanceof Table) {
                            target = targetSD.getTableProxySet().getProxy(dob.getObjectID());
                        } else if (to instanceof TableView) {
                            target = targetSD.getTableViewProxySet().getProxy(dob.getObjectID());
                        }
                    } else {
                        target = (StorageObject)to;
                    }
                    if (target == null) continue;
                    target.clearNoneMergableStructure();
                    target.clearMergableStructure(reverse);
                }
                for (StorageObject so : stobjects) {
                    Document doc;
                    StorageObject sto;
                    String type = so.getObjectTypeName();
                    AbstractXMLWriter writer = sdWriter.getWriterFor(so);
                    if (writer == null || (sto = reader.recreateStorageObject(doc = writer.getDocument(so), type, targetSD, true)) == null) continue;
                    sto.setDirty(true);
                    dirty = true;
                }
                if (dirty) {
                    targetSD.setDirty(dirty);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error during clone of physical model " + this.getName() + "/n", e);
            }
            finally {
                this.getDesign().getAppView().getPersistenceManager().setCheckDirty(true);
                this.correspondenceMap = null;
                targetSD.setLoading(false);
                targetSD.correspondenceMap = null;
            }
        }
    }

    public void cloneFromMemoryToAnotherSD_MD(StorageDesign compatibleSD, Map correspondenceMap, boolean checkMerge) {
        this.cloneFromMemoryToAnotherSD_MD(compatibleSD, correspondenceMap, checkMerge, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneFromMemoryToAnotherSD_MD(StorageDesign compatibleSD, Map correspondenceMap, boolean checkMerge, String schema) {
        List list = this.getRDBMSTypesForClone();
        StorageDesign targetSD = compatibleSD;
        StorageDesign sourceSD = this;
        if (list.contains(targetSD.getRDBMSType())) {
            XMLTransformationManager trm = this.getAppView().getXMLTransformationManager();
            boolean oldCheckDirty = trm.isCheckDirty();
            try {
                TreeMap<String, String> reverse;
                StorageObject sch;
                boolean dirty = false;
                this.correspondenceMap = correspondenceMap;
                targetSD.correspondenceMap = correspondenceMap;
                String userName = schema;
                if (schema != null && (sch = this.getUserSchemaSet().getBySchemaObjectName(schema)) != null) {
                    userName = sch.getName();
                }
                targetSD.reverseMap = reverse = new TreeMap<String, String>();
                targetSD.setLoading(true);
                trm.setCheckDirty(false);
                ArrayList<StorageObject> proxys = new ArrayList<StorageObject>();
                ArrayList<Object> stobjects = new ArrayList<Object>();
                this.processMatchByNameSets(sourceSD, targetSD);
                for (StorageObject storageObject : sourceSD.getStorableObjects()) {
                    if (!StorageDesign.shouldMerge(storageObject, checkMerge) || !sourceSD.isOwnedBy(userName, storageObject) && sourceSD.hasOwner(storageObject)) continue;
                    if (storageObject instanceof RelationalObjectProxy) {
                        String string;
                        ModelIDObject obj;
                        proxys.add(storageObject);
                        if (correspondenceMap == null || (obj = (ModelIDObject)correspondenceMap.get(string = storageObject.getObjectID())) == null) continue;
                        String newID = obj.getObjectID();
                        if (reverse == null) continue;
                        reverse.put(newID, string);
                        continue;
                    }
                    if (schema == null && (storageObject instanceof SnapshotOracle || storageObject instanceof SequenceOracle)) continue;
                    stobjects.add(storageObject);
                }
                stobjects.addAll(proxys);
                if (sourceSD instanceof StorageDesignOracle) {
                    stobjects.addAll(Arrays.asList(((StorageDesignOracle)sourceSD).getUserSet().toArray()));
                }
                for (StorageObject storageObject : stobjects) {
                    if (correspondenceMap == null || !storageObject.isTopLevelObject()) continue;
                    Object v = correspondenceMap.get(storageObject.getObjectID());
                    StorageObject target = null;
                    if (v == null) continue;
                    if (v instanceof DesignObject) {
                        DesignObject dob = (DesignObject)v;
                        if (v instanceof Table) {
                            target = targetSD.getTableProxySet().getProxy(dob.getObjectID());
                        } else if (v instanceof TableView) {
                            target = targetSD.getTableViewProxySet().getProxy(dob.getObjectID());
                        }
                    } else {
                        target = (StorageObject)v;
                    }
                    if (target == null) continue;
                    target.clearMergableStructure(reverse);
                }
                XMLToObjectTransformer.processCreatedTime = false;
                String string = targetSD.getDesign().getName();
                for (StorageObject storageObject : stobjects) {
                    GetHelper gh = this.getOrCreateTargetObject(storageObject, targetSD);
                    StorageObject target = gh.object;
                    if (target == null) continue;
                    if (target instanceof SegmentOracle && gh.exists) {
                        target.setDirty(true);
                    } else {
                        String id = target.getObjectID();
                        String segment = target.getDirectorySegmentName();
                        String createdTime = storageObject.getCreatedTime();
                        String createdBy = storageObject.getCreatedBy();
                        String t_createdBy = target.getCreatedBy();
                        Document doc = trm.getXMLContent(storageObject);
                        if (doc != null) {
                            trm.transformFromXMLToObject(target, doc);
                            target.setOwnerDesignName(string);
                            if (!id.equals(target.getObjectID())) {
                                target.setObjectID(id);
                            }
                            target.setDirectorySegmentName(segment, true);
                            if (!gh.exists) {
                                target.setCreatedTime(createdTime);
                                target.setCreatedBy(createdBy);
                            } else {
                                target.setCreatedBy(t_createdBy);
                            }
                            if (target instanceof SegmentOracle && !gh.exists) {
                                SegmentSetOracle set = (SegmentSetOracle)target.getObjectSet();
                                String name = set.createUniqueName(storageObject.getName());
                                target.setName(name);
                            }
                            target.setDirty(true);
                        }
                    }
                    if (!target.isDirty()) continue;
                    dirty = true;
                }
                if (dirty) {
                    targetSD.setDirty(dirty);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error during in memory clone of physical model " + this.getName() + "/n", e);
            }
            finally {
                XMLToObjectTransformer.processCreatedTime = true;
                targetSD.setOwnerDesignName(targetSD.getDesign().getName());
                this.getDesign().getAppView().getPersistenceManager().setCheckDirty(true);
                this.correspondenceMap = null;
                targetSD.setLoading(false);
                targetSD.correspondenceMap = null;
                trm.setCheckDirty(oldCheckDirty);
            }
        }
    }

    public Map getCorrespondenceMap() {
        return this.correspondenceMap;
    }

    private GetHelper getOrCreateTargetObject(StorageObject sourceObject, StorageDesign targetSD) {
        if (sourceObject instanceof RelationalObjectProxy) {
            StorageDesign.getHelper.object = this.getTargetProxy(sourceObject, targetSD);
            StorageDesign.getHelper.exists = StorageDesign.getHelper.object != null;
            return getHelper;
        }
        StorageObject target = this.getMatchedTargetObject(sourceObject, targetSD);
        if (target == null) {
            String type = sourceObject.getObjectTypeName();
            StorageObjectSet set = targetSD.getStorageObjectSetForType(type);
            if (set != null) {
                String id = sourceObject.getObjectID();
                target = (StorageObject)set.createElement(id);
                if (target != null && targetSD.getCorrespondenceMap() != null) {
                    targetSD.getCorrespondenceMap().put(id, target);
                }
                if (target != null && targetSD.getReverseMap() != null) {
                    targetSD.getReverseMap().put(target.getObjectID(), id);
                }
            }
            StorageDesign.getHelper.exists = false;
        } else {
            StorageDesign.getHelper.exists = true;
        }
        StorageDesign.getHelper.object = target;
        return getHelper;
    }

    private StorageObject getTargetProxy(StorageObject sourceObject, StorageDesign targetSD) {
        ModelIDObject obj;
        String id = sourceObject.getObjectID();
        String newID = null;
        StorageObject target = null;
        Map map = targetSD.getCorrespondenceMap();
        Map revmap = targetSD.getReverseMap();
        if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
            newID = obj.getObjectID();
            if (revmap != null) {
                revmap.put(newID, id);
            }
        }
        target = newID != null ? targetSD.getStorageObject(newID) : targetSD.getStorageObject(id);
        return target;
    }

    private void createReadRequestForTargetObject(StorageObject sourceObject, StorageDesign storageDesign) {
        String dbName;
        AbstractStorageObjectSqlServer sto;
        StorageObjectSet set;
        ReadRequest readRequest;
        ModelIDObject obj;
        String id = sourceObject.getObjectID();
        String type = sourceObject.getObjectTypeName();
        String newID = null;
        storageDesign.setInitialReadBackDone(true);
        Map map = storageDesign.getCorrespondenceMap();
        Map revmap = storageDesign.getReverseMap();
        if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
            newID = obj.getObjectID();
            if (revmap != null) {
                revmap.put(newID, id);
            }
        }
        if (!(readRequest = newID != null ? storageDesign.getReadRequestFor(newID) : storageDesign.getReadRequestFor(id)).hasObjectSet() && (set = storageDesign.getStorageObjectSetForType(type)) != null) {
            readRequest.setObjectSet(set);
        }
        readRequest.setRequestLock(true);
        readRequest.setName(sourceObject.getName());
        if (sourceObject instanceof AbstractStorageObjectSqlServer && (sto = (AbstractStorageObjectSqlServer)sourceObject).getDatabase() != null && !"".equals(dbName = sto.getDatabase().getName().trim())) {
            readRequest.setDataBaseName(dbName);
        }
        readRequest.setTopLevelObject(sourceObject.isTopLevelObject());
        readRequest.getStorageObject();
    }

    public Map getReverseMap() {
        return this.reverseMap;
    }

    public static boolean shouldMerge(ModelIDObject object, boolean checkMerge) {
        DesignObject obj;
        if (object instanceof RelationalObjectProxy && (obj = ((RelationalObjectProxy)object).getObject()).isCopyForIncrementalDDL()) {
            return false;
        }
        if (checkMerge) {
            if (object instanceof RelationalObjectProxy) {
                obj = ((RelationalObjectProxy)object).getObject();
                if (obj instanceof TypeElement) {
                    StructuredType st = ((TypeElement)obj).getStructuredType();
                    return st.shouldBeMerge() && obj.shouldBeMerge();
                }
                if (obj instanceof Method) {
                    StructuredType st = ((Method)obj).getStructuredType();
                    return st.shouldBeMerge() && obj.shouldBeMerge();
                }
                if (obj instanceof MethodParam && ((MethodParam)obj).getMethod() != null) {
                    StructuredType st = ((MethodParam)obj).getMethod().getStructuredType();
                    return st.shouldBeMerge() && ((MethodParam)obj).getMethod().shouldBeMerge();
                }
                return obj.shouldBeMerge();
            }
            if (object instanceof SnapshotOracle || object instanceof SequenceOracle) {
                return object.shouldBeMerge();
            }
        }
        return true;
    }

    @Override
    public String getShortObjectID() {
        String siteID = this.getRDBMSSite().getShortObjectID();
        if (this.isCloneOperation() && this.getClonedSite() != null) {
            siteID = this.getClonedSite().getShortObjectID();
        }
        return siteID;
    }

    @Override
    public String getStoragePath() {
        String relPath = this.getPhysicalDesign().getStoragePath();
        if (relPath != null && relPath.length() > 0) {
            try {
                String siteID = this.getRDBMSSite().getShortObjectID();
                if (this.isCloneOperation() && this.getClonedSite() != null) {
                    siteID = this.getClonedSite().getShortObjectID();
                }
                return new File(relPath, "phys/" + siteID).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String relPath = this.getPhysicalDesign().getStoragePath();
        if (relPath != null && relPath.length() > 0) {
            try {
                String siteID = this.getRDBMSSite().getShortObjectID();
                if (this.isCloneOperation() && this.getClonedSite() != null) {
                    siteID = this.getClonedSite().getShortObjectID();
                }
                return new File(relPath, "phys/" + siteID + "/" + siteID + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setObjectListChanged(boolean objectListChanged) {
        this.objectListChanged = objectListChanged;
    }

    public boolean isObjectListChanged() {
        return this.objectListChanged;
    }

    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
        }
        return this.f2tMap;
    }

    public void dumpObjectTypes() {
        for (Object next : this.getStorableSetsList()) {
            try {
                if (next instanceof StorageObjectSet) {
                    StorageObjectSet objectSet = (StorageObjectSet)next;
                    ModelIDObject mObj = objectSet.createElement(null);
                    System.out.println("f2tMap.put(" + mObj.getClass().getSimpleName() + ".TYPE_NAME, " + mObj.getClass().getSimpleName() + ".TYPE_NAME);");
                    continue;
                }
                if (next instanceof RelationalObjectProxySet) {
                    RelationalObjectProxySet proxySet = (RelationalObjectProxySet)next;
                    System.out.println("f2tMap.put(" + proxySet.getClass().getSimpleName() + ".TYPE_NAME, " + proxySet.getClass().getSimpleName() + ".TYPE_NAME);");
                    continue;
                }
                System.out.println("---" + next);
            }
            catch (Exception exception) {}
        }
    }

    public void reloadAllProxies() {
        if (this.getTableProxySet() != null) {
            this.getTableProxySet().setDesign(this.getDesign());
        }
        if (this.getTableViewProxySet() != null) {
            this.getTableViewProxySet().setDesign(this.getDesign());
        }
        if (this.getColumnProxySet() != null) {
            this.getColumnProxySet().setDesign(this.getDesign());
        }
        if (this.getIndexProxySet() != null) {
            this.getIndexProxySet().setDesign(this.getDesign());
        }
        if (this.getStructuredTypeProxySet() != null) {
            this.getStructuredTypeProxySet().setDesign(this.getDesign());
        }
        if (this.getTypeElementProxySet() != null) {
            this.getTypeElementProxySet().setDesign(this.getDesign());
        }
        if (this.getMethodProxySet() != null) {
            this.getMethodProxySet().setDesign(this.getDesign());
        }
        if (this.getMethodParamProxySet() != null) {
            this.getMethodParamProxySet().setDesign(this.getDesign());
        }
        if (this.getCollectionTypeProxySet() != null) {
            this.getCollectionTypeProxySet().setDesign(this.getDesign());
        }
    }

    public boolean isTempModel() {
        return this.tempModel;
    }

    public void setTempModel(boolean tempModel) {
        this.tempModel = tempModel;
        if (this.getPhysicalDesign() != null) {
            this.getPhysicalDesign().getStorageDesignFactory().sdTempStatusChanged(this);
        }
    }

    public static void initObjectDetails(Design design, File file, SVNUrl url, boolean remoteStatus, String type, StorableObjectStatusHelper sosHelper, String storableObjectID, StorageDesign storageDesign) {
        SVNObjectHelper parentSVNOH;
        File parentFolder;
        SVNClientHelper svnClientHelper = SVNClientHelper.getInstance();
        SVNObjectHelper svnOH = SVNClientHelper.svnOHMap.get(storageDesign.getShortObjectID() + "_" + storableObjectID);
        if (svnOH == null) {
            svnOH = svnClientHelper.createSVNObjectHelper(file, url, remoteStatus, storageDesign.getShortObjectID());
        }
        if ((parentFolder = file.getParentFile()).getName().startsWith(SegmentNameManager.NAME_PREFIX)) {
            parentFolder = parentFolder.getParentFile();
        }
        if ((parentSVNOH = SVNClientHelper.svnOHMap.get(svnOH.parentID)) != null) {
            sosHelper.treePath.add(new TreePathHelper(parentSVNOH.propName, new File(parentSVNOH.fileName), StorageDesign.class));
        } else {
            sosHelper.treePath.add(new TreePathHelper(storageDesign.getName(), new File(storageDesign.getStoragePath()), StorageDesign.class));
        }
        sosHelper.objectType = type;
        sosHelper.storableObject = storageDesign.getStorageObject(svnOH.propID);
        if (svnOH.className != null) {
            try {
                Class<?> aClass;
                sosHelper.objectClass = aClass = Class.forName(svnOH.className);
                sosHelper.treePath.add(new TreePathHelper(type, parentFolder, aClass));
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e);
            }
        }
    }

    public List<ModelIDObject> getNotMarkedGenerateObjects() {
        ArrayList<ModelIDObject> notMarkedGenerateObjects = new ArrayList<ModelIDObject>();
        for (ElementSet objectSet : this.createDDLSelectionSetsList()) {
            this.addNotMarkedGenerateObjects(objectSet, notMarkedGenerateObjects);
        }
        return notMarkedGenerateObjects;
    }

    public List<ModelIDObject> getMarkedGenerateObjects() {
        ArrayList<ModelIDObject> markedGenerateObjects = new ArrayList<ModelIDObject>();
        for (ElementSet objectSet : this.createDDLSelectionSetsList()) {
            this.addMarkedGenerateObjects(objectSet, markedGenerateObjects);
        }
        return markedGenerateObjects;
    }

    public List<ModelIDObject> getAllMarkedAndNotMarkedGenerateObjects() {
        ArrayList<ModelIDObject> markedGenerateObjects = new ArrayList<ModelIDObject>();
        for (ElementSet objectSet : this.createDDLSelectionSetsList()) {
            this.addAllMarkedAndNotMarkedGenerateObjects(objectSet, markedGenerateObjects);
        }
        return markedGenerateObjects;
    }

    public List<ElementSet> getDDLSelectionSetsList() {
        if (this.ddlSelectionSetsList == null) {
            this.ddlSelectionSetsList = this.createDDLSelectionSetsList();
        }
        return this.ddlSelectionSetsList;
    }

    protected List<ElementSet> createDDLSelectionSetsList() {
        return new ArrayList<ElementSet>();
    }

    private void addNotMarkedGenerateObjects(ElementSet objectSet, List<ModelIDObject> notMarkedGenerateObjects) {
        Iterator setIterator = objectSet.iterator();
        while (setIterator.hasNext()) {
            ModelIDObject designObject = (ModelIDObject)setIterator.next();
            if (designObject.isMarkedGenerate()) continue;
            notMarkedGenerateObjects.add(designObject);
        }
    }

    private void addMarkedGenerateObjects(ElementSet objectSet, List<ModelIDObject> markedGenerateObjects) {
        Iterator setIterator = objectSet.iterator();
        while (setIterator.hasNext()) {
            ModelIDObject designObject = (ModelIDObject)setIterator.next();
            if (!designObject.isMarkedGenerate()) continue;
            markedGenerateObjects.add(designObject);
        }
    }

    private void addAllMarkedAndNotMarkedGenerateObjects(ElementSet objectSet, List<ModelIDObject> markedGenerateObjects) {
        Iterator setIterator = objectSet.iterator();
        while (setIterator.hasNext()) {
            ModelIDObject designObject = (ModelIDObject)setIterator.next();
            markedGenerateObjects.add(designObject);
        }
    }

    public List getStructuredTypesOrderedByParent() {
        ArrayList<StructuredTypeProxy> list = new ArrayList<StructuredTypeProxy>();
        for (StructuredType st : this.getDesign().getDataTypesDesign().getStructuredTypesOrderedByParent()) {
            StructuredTypeProxy pr = (StructuredTypeProxy)this.getStructuredTypeProxySet().getObjectGeneratedBy(st);
            if (pr == null) continue;
            list.add(pr);
        }
        return list;
    }

    public TableProxy getTableProxyBySchemaAndName(String schema, String name) {
        Table table = this.getPhysicalDesign().getTableSet().getBySchemaAndName(schema, name);
        if (table != null) {
            return (TableProxy)this.getTableProxySet().getObjectGeneratedBy(table);
        }
        return null;
    }

    public StorageObjectSet getUserSchemaSet() {
        return null;
    }

    public String getSchemaImplementationNane(SchemaObject schema) {
        StorageObject so;
        if (schema != null && (so = this.getUserSchemaSet().getBySchemaObject(schema)) != null) {
            return so.getName();
        }
        return "";
    }

    public String getSiteName() {
        if (this.rdbmsSite != null) {
            return this.rdbmsSite.getName();
        }
        return "";
    }

    public void setSiteName(String name) {
    }

    public String getSiteID() {
        if (this.rdbmsSite != null) {
            return this.rdbmsSite.getObjectID();
        }
        return "";
    }

    public void setSiteID(String oid) {
    }

    public int getSiteType() {
        if (this.rdbmsSite != null) {
            return this.rdbmsSite.getType().getType();
        }
        return -1;
    }

    public void setSiteType(int type) {
    }

    public void openStorageDesign() {
        if (!this.isOpen()) {
            this.getAppView().getXMLTransformationManager().openPhysicalModel(this);
            this.setOpen(true);
        }
    }

    public List getMatchByNameSets() {
        return Collections.EMPTY_LIST;
    }

    private void processMatchByNameSets(StorageDesign sourceSD, StorageDesign targetSD) {
        for (Object obj : sourceSD.getMatchByNameSets()) {
            if (!(obj instanceof StorageObjectSet)) continue;
            StorageObjectSet set = (StorageObjectSet)obj;
            Iterator its = set.iterator();
            while (its.hasNext()) {
                StorageObjectSet tset;
                StorageObject sourceObject = (StorageObject)its.next();
                StorageObject target = this.getMatchedTargetObject(sourceObject, targetSD);
                if (target != null || (tset = targetSD.getStorageObjectSetForType(sourceObject.getObjectTypeName())) == null) continue;
                target = (StorageObject)tset.createElement(sourceObject.getObjectID());
            }
        }
    }

    private StorageObject getMatchedTargetObject(StorageObject sourceObject, StorageDesign targetSD) {
        StorageObjectSet set;
        ModelIDObject obj;
        StorageObject target = null;
        String id = sourceObject.getObjectID();
        String type = sourceObject.getObjectTypeName();
        String newID = null;
        Map map = targetSD.getCorrespondenceMap();
        Map revmap = targetSD.getReverseMap();
        if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
            newID = obj.getObjectID();
            if (revmap != null) {
                revmap.put(newID, id);
            }
        }
        if (newID != null) {
            id = newID;
        }
        if ((set = targetSD.getStorageObjectSetForType(type)) != null) {
            if (set instanceof SegmentSetOracle && sourceObject instanceof SegmentOracle) {
                target = ((SegmentSetOracle)set).getEqual((SegmentOracle)sourceObject);
                if (target != null) {
                    targetSD.getCorrespondenceMap().put(id, target);
                }
            } else {
                target = (StorageObject)set.getObjectByID(id);
                if (target == null && sourceObject.isTopLevelObject()) {
                    String dbName;
                    AbstractStorageObjectSqlServer sto;
                    String dataBaseName = null;
                    String name = sourceObject.getName();
                    if (sourceObject instanceof AbstractStorageObjectSqlServer && (sto = (AbstractStorageObjectSqlServer)sourceObject).getDatabase() != null && !"".equals(dbName = sto.getDatabase().getName().trim())) {
                        dataBaseName = dbName;
                    }
                    if (name != null && name.length() > 0) {
                        if (dataBaseName != null) {
                            target = set.getByNameAndDatabase(name, dataBaseName);
                        } else {
                            target = (StorageObject)set.getByName(name);
                            if (target != null && !sourceObject.getLongName().equalsIgnoreCase(target.getLongName())) {
                                target = null;
                            }
                        }
                        if (target != null) {
                            targetSD.getCorrespondenceMap().put(id, target);
                        }
                    }
                }
            }
            if (target != null && revmap != null) {
                revmap.put(target.getObjectID(), id);
            }
        }
        return target;
    }

    @Override
    public void setOwnerDesignName(String designName) {
        super.setOwnerDesignName(designName);
        for (Object obj : this.getAllSetsList()) {
            if (!(obj instanceof ElementSet)) continue;
            ElementSet set = (ElementSet)obj;
            Iterator its = set.iterator();
            while (its.hasNext()) {
                Object mo = its.next();
                if (!(mo instanceof ModelIDObject)) continue;
                ((ModelIDObject)mo).setOwnerDesignName(designName);
            }
        }
    }

    public List getLastSearchResult() {
        if (this.lastSearchResult == null) {
            this.lastSearchResult = new ArrayList();
        }
        return this.lastSearchResult;
    }

    public String[] getFKDeleteRules() {
        return FKIndexAssociation.DELETE_RULES;
    }

    public String[] getFKDeleteRulesMandatory() {
        return FKIndexAssociation.DELETE_RULES_WITHOUT_NULL;
    }

    public String[] getFKDeleteRulesNonTransferable() {
        return FKIndexAssociation.DELETE_RULES_RESTRICT_CASCADE;
    }

    public String getValidFKRule(String fkRule) {
        if ("SET DEFAULT".equals(fkRule)) {
            return "NO ACTION";
        }
        return fkRule;
    }

    public void parse(List<ModelIDObject> objects) {
        Iterator<ModelIDObject> it = objects.iterator();
        while (it.hasNext()) {
            this.processDependencies(it.next(), Collections.EMPTY_LIST, null);
        }
    }

    public void processDependencies(ModelIDObject obj, List<SQLAnalyzer.PDescriptor> dependencies, List<StructuredTypeProxy> refList) {
        TableView view;
        if (obj instanceof TableViewProxy && (view = (TableView)((TableViewProxy)obj).getObject()) != null) {
            List<ModelIDObject> list = obj.getParsedDependOnList();
            list.clear();
            for (TableView refView : view.getViews()) {
                TableViewProxy refViewProxy = (TableViewProxy)this.getProxy(refView.getObjectID());
                if (refViewProxy == null) continue;
                list.add(refViewProxy);
            }
        }
    }

    public boolean isOwnedBy(String user, StorageObject sto) {
        if (user != null && !"".equals(user)) {
            if (sto instanceof OwnedObjectOracle) {
                SchemaObject so;
                UserOracle owner = ((OwnedObjectOracle)((Object)sto)).getUser();
                if (owner != null && user.equalsIgnoreCase(owner.getName())) {
                    return true;
                }
                if (owner == null && (so = sto.getSchemaObject()) != null && user.equalsIgnoreCase(so.getName())) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean hasOwner(StorageObject sto) {
        if (sto instanceof OwnedObjectOracle) {
            UserOracle owner = ((OwnedObjectOracle)((Object)sto)).getUser();
            if (owner != null) {
                return true;
            }
            SchemaObject so = sto.getSchemaObject();
            if (so != null) {
                return true;
            }
        }
        return false;
    }

    static class GetHelper {
        StorageObject object;
        boolean exists = true;

        GetHelper() {
        }
    }

    public class ObjectType {
        private boolean isSelected = false;
        private String typeName = "";

        public ObjectType(String name) {
            this.typeName = name;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String toString() {
            return this.typeName;
        }
    }

    public static class NullStorageDesign
    extends StorageDesign {
        private String label;
        private Object msg;

        NullStorageDesign(RelationalDesign physicalDesign, String label, Object msg, RDBMSSite site, Design design) {
            super(physicalDesign, site, design);
            this.label = label;
            this.msg = msg;
        }

        @Override
        public RDBMSType getRDBMSType() {
            return this.getRDBMSSite().getType();
        }

        public RDBMSSite getDefaultRDBMSSite() {
            return this.getRDBMSSite();
        }

        @Override
        public PropertyHolder getPropertyHolder() {
            return null;
        }

        @Override
        public void objectAdded(DesignPart designPart, DesignObject object) {
        }

        @Override
        public void objectRemoved(DesignPart designPart, DesignObject object) {
        }

        @Override
        public void addPhysicalObject(DesignObject object) {
        }

        @Override
        public void removePhysicalObject(DesignObject object) {
        }

        @Override
        public void removePhysicalObject(String objectID) {
        }

        @Override
        public TableProxySet getTableProxySet() {
            return null;
        }

        @Override
        public IndexProxySet getIndexProxySet() {
            return null;
        }

        @Override
        public ColumnProxySet getColumnProxySet() {
            return null;
        }

        @Override
        public TableViewProxySet getTableViewProxySet() {
            return null;
        }

        @Override
        public StructuredTypeProxySet getStructuredTypeProxySet() {
            return null;
        }

        @Override
        public CollectionTypeProxySet getCollectionTypeProxySet() {
            return null;
        }

        @Override
        public MethodProxySet getMethodProxySet() {
            return null;
        }

        @Override
        public TypeElementProxySet getTypeElementProxySet() {
            return null;
        }

        @Override
        public MethodParamProxySet getMethodParamProxySet() {
            return null;
        }

        @Override
        public StorageObjectSet getStorageObjectSetForType(String objectType) {
            return null;
        }

        @Override
        public Collection getAllTopLevelObjects() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public String getIDPrefix() {
            return "NULLSTODES";
        }

        @Override
        public String getObjectID() {
            return this.getIDPrefix();
        }

        @Override
        public boolean isNullInstance() {
            return true;
        }

        public Object getMessage() {
            return this.msg;
        }

        @Override
        public String getName() {
            return this.label;
        }

        @Override
        public MDDataTypeFactory createDataTypeFactory() {
            return null;
        }

        @Override
        public String getFormatedName(String name) {
            return name;
        }

        @Override
        public List getStorableSetsList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getUniqueList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getFKProxyList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getPKProxyList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getRDBMSTypesForClone() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public void sortCollections() {
        }

        @Override
        public TableProxySet getSubViewTableProxySet() {
            return null;
        }

        @Override
        public TableViewProxySet getSubViewTableViewProxySet() {
            return null;
        }

        @Override
        public List getSearchableSets() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getListOfDDLObjects() {
            return Collections.EMPTY_LIST;
        }
    }
}

