/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.DataBasePropertyDialogDB2;

public class DataBaseDB2
extends StorageObject
implements ModelObjectSetListener,
StorageObjectListener {
    private static final String[] TYPES = new String[]{"USUAL", "WORKFILE", "TEMP"};
    private static final String[] CCSID_CHOICES = new String[]{"", "ASCII", "EBCDIC", "UNICODE"};
    private BufferPoolDB2 bufferPool = null;
    private BufferPoolDB2 indexBufferPool = null;
    private String type = TYPES[0];
    private String member = "";
    private StorageGroupDB2 storageGroup = null;
    private String ccsid = CCSID_CHOICES[0];
    private StorageObjectCollection tablespaces;
    public static final String TYPE_NAME = "DataBase";

    public DataBaseDB2() {
    }

    public DataBaseDB2(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.tablespaces = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getTableSpaceSet());
        this.tablespaces.setParent(this);
        this.tablespaces.setName(Messages.getString("DataBaseDB2.Tablespaces"));
        this.tablespaces.setSetMethod("setDataBase");
        this.tablespaces.setClassForParent(DataBaseDB2.class);
        this.tablespaces.setIcon(GUIConfiguration.getInstance().getIcon("TABLESPACE_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getTableSpaceSet().addSetListener(this);
        this.addTablespacesFromDesign(((AbstractStorageDesignDB2)storageDesign).getTableSpaceSet());
    }

    public void setBufferPool(BufferPoolDB2 bufferPool) {
        this.bufferPool = bufferPool;
        this.fireDataFieldChange();
    }

    public void setIndexBufferPool(BufferPoolDB2 indexBufferPool) {
        this.indexBufferPool = indexBufferPool;
        this.fireDataFieldChange();
    }

    public void setType(String type) {
        this.type = type;
        this.fireDataFieldChange();
    }

    public void setMember(String member) {
        this.member = member;
        this.fireDataFieldChange();
    }

    public void setStorageGroup(StorageGroupDB2 storageGroup) {
        this.storageGroup = storageGroup;
        this.fireDataFieldChange();
    }

    public void setCcsid(String value) {
        this.ccsid = value;
        this.fireDataFieldChange();
    }

    @Override
    public PropertyHolder getPropertyHolder() {
        return null;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "DB";
    }

    public BufferPoolDB2 getBufferPool() {
        return this.bufferPool;
    }

    public BufferPoolDB2 getIndexBufferPool() {
        return this.indexBufferPool;
    }

    public String getType() {
        return this.type;
    }

    public String getMember() {
        return this.member;
    }

    public StorageGroupDB2 getStorageGroup() {
        return this.storageGroup;
    }

    public String getCcsid() {
        return this.ccsid;
    }

    public static String[] getCcsidChoices() {
        return CCSID_CHOICES;
    }

    public static String[] getTypesChoices() {
        return TYPES;
    }

    public boolean isSystemDatabase() {
        return false;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataBasePropertyDialogDB2 dialog = new DataBasePropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.tablespaces;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.tablespaces) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.tablespaces) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    private void addTablespacesFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TableSpaceDB2 ts = (TableSpaceDB2)it.next();
            ts.addObjectListener(this);
            if (ts.getDataBase() != null && ts.getDataBase() == this) {
                ts.setParent(this.tablespaces);
                this.tablespaces.add(ts);
                continue;
            }
            this.tablespaces.justRemove(ts);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof TableSpaceDB2) {
            TableSpaceDB2 ts = (TableSpaceDB2)event.getAffected();
            if (ts.getDataBase() != null && ts.getDataBase() == this) {
                ts.setParent(this.tablespaces);
                this.tablespaces.add(ts);
            } else {
                this.tablespaces.justRemove(ts);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof TableSpaceDB2) {
                TableSpaceDB2 ts = (TableSpaceDB2)event.getAffected();
                ts.addObjectListener(this);
                if (ts.getDataBase() != null && ts.getDataBase() == this) {
                    ts.setParent(this.tablespaces);
                    this.tablespaces.add(ts);
                } else {
                    this.tablespaces.justRemove(ts);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof TableSpaceDB2) {
            TableSpaceDB2 ts = (TableSpaceDB2)event.getAffected();
            this.tablespaces.justRemove(ts);
            ts.removeObjectListener(this);
        }
    }

    public boolean containsTable(TableProxyDB2 table) {
        return this.getName().equalsIgnoreCase("DSNDB04") ? table.getTableSpace() != null && table.getTableSpace().getDataBase() != null && this == table.getTableSpace().getDataBase() || table.getTableSpace() != null && table.getTableSpace().getDataBase() == null || table.getTableSpace() == null : table.getTableSpace() != null && table.getTableSpace().getDataBase() != null && this == table.getTableSpace().getDataBase();
    }

    public List getTablespaces() {
        ArrayList list = new ArrayList();
        this.tablespaces.addAllElementsTo(list);
        return list;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        DataBaseDB2 db2 = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getDataBaseSet().getByName(this.getName());
        if (storageObject != null) {
            if (storageObject.isRawObject()) {
                db2 = (DataBaseDB2)storageObject;
            }
        } else {
            db2 = ((AbstractStorageDesignDB2)targetDesign).getDataBaseSet().createDataBase();
        }
        if (db2 != null) {
            db2.setName(this.getName());
            for (TableSpaceDB2 tableSpace : this.getTablespaces()) {
                TableSpaceDB2 targetTableSpace = (TableSpaceDB2)((AbstractStorageDesignDB2)targetDesign).getTableSpaceSet().getByName(tableSpace.getName());
                if (targetTableSpace == null) {
                    TableSpaceDB2 newTableSpace = ((AbstractStorageDesignDB2)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(tableSpace.getName());
                    newTableSpace.setDataBase(db2);
                    newTableSpace.setRawObject(true);
                    db2.addTablespacesFromDesign(((AbstractStorageDesignDB2)targetDesign).getTableSpaceSet());
                    continue;
                }
                targetTableSpace.setDataBase(db2);
                db2.addTablespacesFromDesign(((AbstractStorageDesignDB2)targetDesign).getTableSpaceSet());
            }
            if (this.getBufferPool() != null) {
                BufferPoolDB2 targetBufferPool = (BufferPoolDB2)((AbstractStorageDesignDB2)targetDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (targetBufferPool == null) {
                    BufferPoolDB2 newBufferPool = (BufferPoolDB2)((AbstractStorageDesignDB2)targetDesign).getBufferPoolSet().createElement(null);
                    newBufferPool.setName(this.getBufferPool().getName());
                    newBufferPool.setRawObject(true);
                    db2.setBufferPool(newBufferPool);
                } else {
                    db2.setBufferPool(targetBufferPool);
                }
            }
            if (this.getIndexBufferPool() != null) {
                BufferPoolDB2 targetIdxBufferPool = (BufferPoolDB2)((AbstractStorageDesignDB2)targetDesign).getBufferPoolSet().getByName(this.getIndexBufferPool().getName());
                if (targetIdxBufferPool == null) {
                    BufferPoolDB2 newIndxBuffPool = (BufferPoolDB2)((AbstractStorageDesignDB2)targetDesign).getBufferPoolSet().createElement(null);
                    newIndxBuffPool.setName(this.getIndexBufferPool().getName());
                    newIndxBuffPool.setRawObject(true);
                    db2.setIndexBufferPool(newIndxBuffPool);
                } else {
                    db2.setIndexBufferPool(targetIdxBufferPool);
                }
            }
            db2.setType(this.getType());
            db2.setMember(this.getMember());
            if (this.getStorageGroup() != null) {
                StorageGroupDB2 targetGroup = (StorageGroupDB2)((AbstractStorageDesignDB2)targetDesign).getStorageGroupSet().getByName(this.getStorageGroup().getName());
                if (targetGroup == null) {
                    StorageGroupDB2 newGroup = ((AbstractStorageDesignDB2)targetDesign).getStorageGroupSet().createStorageGroup();
                    newGroup.setName(this.getStorageGroup().getName());
                    newGroup.setRawObject(true);
                    db2.setStorageGroup(newGroup);
                } else {
                    db2.setStorageGroup(targetGroup);
                }
            }
            db2.setCcsid(this.getCcsid());
            db2.setComment(this.getComment());
            db2.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DATABASE_ICON", 16);
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            this.tablespaces.addAllElementsTo(list);
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    protected static class SystemDataBase
    extends DataBaseDB2 {
        public SystemDataBase(StorageDesign storageDesign) {
            super(storageDesign);
        }

        @Override
        public boolean isSystemDatabase() {
            return true;
        }
    }
}

