/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageEvent;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnDB2;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObject;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObjectImpl;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.TablePropertyDialogDB2;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxyDB2
extends TableProxy
implements OwnedObject,
ModelObjectSetListener,
PropertiesPropagator {
    protected static final String[] CCSID = new String[]{"", "ASCII", "EBCDIC", "UNICODE"};
    protected static final String[] AUDIT_CHOICES = new String[]{"NONE", "CHANGES", "ALL"};
    protected static final String[] DATA_CAPTURE_VALUES = new String[]{"NONE", "CHANGES"};
    public static final StorageEvent PRIMARY_QTY_CHANGED = new StorageEvent("Primary quantity changed");
    protected OwnedObjectImpl ownedObjectImpl;
    protected String label = "";
    protected long initialRowNumber = 0L;
    protected long maxRowNumber = 0L;
    protected boolean initialRowNumberChanged = false;
    protected boolean maxRowNumberChanged = false;
    protected boolean freepageExcluded = false;
    protected float annualUpdateRateInsert = 0.0f;
    protected float annualUpdateRateDelete = 0.0f;
    protected float annualUpdateRateNetGrowth = 0.0f;
    protected float activeGroupInsert = 0.0f;
    protected float activeGroupDelete = 0.0f;
    protected float activeGroupData = 0.0f;
    protected int growthHorizon = 0;
    protected static String[] growthMethodChoices = new String[]{"Random", "Refresh", "Resume"};
    protected String growthMethod = growthMethodChoices[0];
    protected long numberOfRows = 0L;
    protected int recordLength = 0;
    protected int numberOfPages = 0;
    protected int percentageOfPages = 0;
    protected int primaryQuantity;
    protected int secondaryQuantity;
    protected boolean calculatePrimaryQuantity = true;
    protected boolean calculateSecondaryQuantity = true;
    protected String audit = AUDIT_CHOICES[0];
    protected boolean dataCapture = false;
    protected boolean dropRestrict = false;
    protected String createdBy = "";
    protected int obid = 0;
    protected boolean excludeFreepage = false;
    protected String editProc = "";
    protected String validProc = "";
    protected String ccsid = CCSID[0];
    protected TableSpaceDB2 tableSpace = null;
    public static final String IMINSERT = "SQL Insert";
    public static final String IMLOAD = "Load/Reorg";
    protected static String[] insertMethodChoices = new String[]{"SQL Insert", "Load/Reorg"};
    protected String insertMethod = "SQL Insert";
    protected int pctFilling = 66;
    protected boolean usePCTFilling = false;
    private List propertyWrapperList = null;
    protected StorageObjectCollection tablePartitions;
    protected static Logger LOGGER = new Logger(TableProxyDB2.class);
    protected StorageObjectCollection triggers;
    protected StorageObjectCollection synonyms;
    protected StorageObjectCollection instDescriptorCols;
    int numbChildren = 4;

    public TableProxyDB2(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        if (table.getTypeSubstitution() == null) {
            this.addColumnsFromSuccessor(table);
        }
        this.triggers = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("AbstractStorageDesignDB2.Triggers"));
        this.triggers.setClassForParent(TableProxyDB2.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((AbstractStorageDesignDB2)storageDesign).getTriggerSet());
        this.synonyms = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("TableViewProxyDB2.Synonyms"));
        this.synonyms.setClassForParent(TableProxyDB2.class);
        this.synonyms.setSetMethod("setTable");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
        this.instDescriptorCols = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getInstanceDescriptorColumnSet());
        ((AbstractStorageDesignDB2)storageDesign).getInstanceDescriptorColumnSet().addSetListener(this);
    }

    public TableProxyDB2(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        Table table = (Table)this.getObject();
        if (table.getTypeSubstitution() == null) {
            this.addColumnsFromSuccessor(table);
        }
        this.triggers = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("AbstractStorageDesignDB2.Triggers"));
        this.triggers.setClassForParent(TableProxyDB2.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((AbstractStorageDesignDB2)storageDesign).getTriggerSet());
        this.synonyms = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("TableViewProxyDB2.Synonyms"));
        this.synonyms.setClassForParent(TableProxyDB2.class);
        this.synonyms.setSetMethod("setTable");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
        this.instDescriptorCols = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getInstanceDescriptorColumnSet());
        ((AbstractStorageDesignDB2)storageDesign).getInstanceDescriptorColumnSet().addSetListener(this);
    }

    private void addColumnsFromSuccessor(Table table) {
        for (Column col : table.getAllNestedElements()) {
            ColumnProxy colProxy;
            if (!col.isAtomic() || (colProxy = (ColumnProxy)this.getStorageDesign().getProxy(col)) == null) continue;
            colProxy.setParent(this.columns);
            this.columns.add(colProxy);
            colProxy.setName(col.getName());
        }
    }

    @Override
    public int getNumberOfChildren() {
        return this.numbChildren;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index == this.numbChildren - 1) {
            return this.triggers;
        }
        if (index == this.numbChildren - 2) {
            return this.synonyms;
        }
        return super.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.triggers) {
            return this.numbChildren - 1;
        }
        if (child == this.synonyms) {
            return this.numbChildren - 2;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.triggers) {
            return this.numbChildren - 1;
        }
        if (child == this.synonyms) {
            return this.numbChildren - 2;
        }
        return super.getIndexForChild(child);
    }

    protected void addTriggersFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TriggerDB2 trigger = (TriggerDB2)it.next();
            trigger.addObjectListener(this);
            if (trigger.getTable() != null && trigger.getTable() == this) {
                trigger.setParent(this.triggers);
                this.triggers.add(trigger);
                continue;
            }
            this.triggers.remove(trigger);
        }
    }

    private void addSynonymsFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            SynonymDB2 syn = (SynonymDB2)it.next();
            if (syn.getTable() != null && syn.getTable() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
                continue;
            }
            this.synonyms.remove(syn);
        }
    }

    @Override
    public void changed(DesignObject obj, ObjectChangeEvent event) {
        super.changed(obj, event);
        if (event.isType(ObjectChangeEvent.NAME_CHANGED)) {
            this.synchronizeTableSpaceName();
        }
    }

    public void synchronizeTableSpaceName() {
        TableSpaceDB2 ts;
        if (this.getDesign().getAppView().getSettings().newDB2TableSpacePerTable() && (ts = this.getTableSpace()) != null && !ts.isUsedInOtherDefinitions(this)) {
            String namingRule = this.getDesign().getAppView().getSettings().getNamingRuleTablespaceDB2();
            String tname = ApplyNamingStandards.createTableSpaceDB2_Name(this.getObject().getName(), namingRule, this.getObject().getDesignPart().getName());
            ts.setName(tname);
            ts.synchronizeStorageTemplateName();
        }
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof ColumnProxy) {
                ColumnProxy cp = (ColumnProxy)event.getAffected();
                if (((Table)this.getObject()).getTypeSubstitution() == null && ((Table)this.getObject()).getAllNestedElements().contains(cp.getObject())) {
                    cp.setParent(this.columns);
                    this.columns.add(event.getAffected());
                    cp.setPAC_Element(this);
                }
            } else if (event.getAffected() instanceof IndexProxy) {
                IndexProxy ip = (IndexProxy)event.getAffected();
                if (this.getObject() == ((Index)ip.getObject()).getContainerWithKeyObject()) {
                    ip.addObjectListener(this);
                    if (!this.indexes.contains(ip)) {
                        this.addIndexProxyWithoutCheck(ip);
                    }
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof ColumnProxy) {
                this.columns.remove(((ColumnProxy)event.getAffected()).getObject().getObjectID());
            } else if (event.getAffected() instanceof IndexProxy) {
                IndexProxy ip = (IndexProxy)event.getAffected();
                ip.removeObjectListener(this);
                if (this.indexes.contains(ip)) {
                    this.indexes.remove(event.getAffected());
                }
                if (this.integrityIndexes.contains(ip)) {
                    this.integrityIndexes.remove(event.getAffected());
                }
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof TriggerDB2) {
            TriggerDB2 tr = (TriggerDB2)event.getAffected();
            if (tr.getTable() != null && tr.getTable() == this) {
                tr.setParent(this.triggers);
                this.triggers.add(tr);
            } else {
                this.triggers.remove(tr);
            }
        } else if (event.getAffected() instanceof SynonymDB2) {
            SynonymDB2 syn = (SynonymDB2)event.getAffected();
            if (syn.getTable() != null && syn.getTable() == this) {
                syn.setParent(this.synonyms);
                syn.setPAC_Element(this);
                this.synonyms.add(syn);
            } else {
                this.synonyms.remove(syn);
            }
        } else if (event.getAffected() instanceof InstanceDescriptorColumnDB2) {
            InstanceDescriptorColumnDB2 instCol = (InstanceDescriptorColumnDB2)event.getAffected();
            if (instCol.getTable() != null && instCol.getTable() == this) {
                instCol.setParent(this.instDescriptorCols);
                instCol.setPAC_Element(this);
                this.instDescriptorCols.add(instCol);
            } else {
                this.instDescriptorCols.remove(instCol);
            }
        } else if (event.getAffected() instanceof IndexProxyDB2) {
            IndexProxyDB2 ind = (IndexProxyDB2)event.getAffected();
            if (this.getObject() == ((Index)ind.getObject()).getContainerWithKeyObject() && ind.getOldStatusGroup() != ind.getStatusGroup()) {
                int stat = ind.getOldStatusGroup();
                if (1 == stat) {
                    this.integrityIndexes.justRemove(ind);
                } else {
                    this.indexes.justRemove(ind);
                }
                this.addIndexProxyWithoutCheck(ind);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof TriggerDB2) {
                TriggerDB2 tr = (TriggerDB2)event.getAffected();
                tr.addObjectListener(this);
                if (tr.getTable() != null && tr.getTable() == this) {
                    tr.setParent(this.triggers);
                    this.triggers.add(tr);
                } else {
                    this.triggers.remove(tr);
                }
            } else if (event.getAffected() instanceof SynonymDB2) {
                SynonymDB2 syn = (SynonymDB2)event.getAffected();
                syn.addObjectListener(this);
                if (syn.getTable() != null && syn.getTable() == this) {
                    syn.setParent(this.synonyms);
                    syn.setPAC_Element(this);
                    this.synonyms.add(syn);
                } else {
                    this.synonyms.remove(syn);
                }
            } else if (event.getAffected() instanceof InstanceDescriptorColumnDB2) {
                InstanceDescriptorColumnDB2 instCol = (InstanceDescriptorColumnDB2)event.getAffected();
                instCol.addObjectListener(this);
                if (instCol.getTable() != null && instCol.getTable() == this) {
                    instCol.setParent(this.instDescriptorCols);
                    instCol.setPAC_Element(this);
                    this.instDescriptorCols.add(instCol);
                } else {
                    this.instDescriptorCols.remove(instCol);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof TriggerDB2) {
                TriggerDB2 tr = (TriggerDB2)event.getAffected();
                this.triggers.remove(tr);
                tr.removeObjectListener(this);
            } else if (event.getAffected() instanceof SynonymDB2) {
                SynonymDB2 syn = (SynonymDB2)event.getAffected();
                this.synonyms.remove(syn);
                syn.removeObjectListener(this);
            } else if (event.getAffected() instanceof InstanceDescriptorColumnDB2) {
                InstanceDescriptorColumnDB2 instCol = (InstanceDescriptorColumnDB2)event.getAffected();
                this.instDescriptorCols.remove(instCol);
                instCol.removeObjectListener(this);
            }
        }
    }

    public void setPrimaryQuantity(int value) {
        this.primaryQuantity = value;
        this.fireUpdate();
        PRIMARY_QTY_CHANGED.setAffected(this);
        this.fireChange(PRIMARY_QTY_CHANGED);
        PRIMARY_QTY_CHANGED.setAffected(null);
    }

    public int getPrimaryQuantity() {
        return this.primaryQuantity;
    }

    public void setSecondaryQuantity(int value) {
        this.secondaryQuantity = value;
        this.fireDataFieldChange();
    }

    public int getSecondaryQuantity() {
        return this.secondaryQuantity;
    }

    @Override
    public void setOwner(Owner owner) {
        this.getOwnedObjectImpl().setOwner(owner);
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public Owner getOwner() {
        return this.getOwnedObjectImpl().getOwner();
    }

    private OwnedObjectImpl getOwnedObjectImpl() {
        if (this.ownedObjectImpl == null) {
            this.ownedObjectImpl = new OwnedObjectImpl();
            this.ownedObjectImpl.setOwnerSet(((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet());
        }
        return this.ownedObjectImpl;
    }

    public void setLabel(String label) {
        this.label = label;
        this.fireDataFieldChange();
    }

    public String getLabel() {
        return this.label;
    }

    public boolean checkMaxRowNumber(long rows) {
        return rows >= 1L && rows <= 0xFFFFFFFEL;
    }

    public void setMaxRowNumber(long rows) {
        if (this.checkMaxRowNumber(rows)) {
            this.maxRowNumber = rows;
            this.maxRowNumberChanged = true;
            this.fireDataFieldChange();
        }
    }

    public long getMaxRowNumber() {
        if (!this.getMaxRowNumberChanged()) {
            return Long.parseLong(((Table)this.getObject()).getMaxVolumes());
        }
        return this.maxRowNumber;
    }

    public int getPctfree() {
        return (int)(1L - this.getInitialRowNumber() / this.getMaxRowNumber() * 100L);
    }

    public void setFreepageExcluded(boolean exclude) {
        this.freepageExcluded = exclude;
        this.fireDataFieldChange();
    }

    public boolean getFreepageExcluded() {
        return this.freepageExcluded;
    }

    public boolean checkAnnualUpdateRateGroup(float value) {
        return value >= 0.0f && value <= 10000.0f;
    }

    public void setAnnualUpdateRateInsert(float value) {
        if (this.checkAnnualUpdateRateGroup(value)) {
            this.annualUpdateRateInsert = value;
            this.setAnnualUpdateRateNetGrowth();
            this.fireDataFieldChange();
        }
    }

    public float getAnnualUpdateRateInsert() {
        return this.annualUpdateRateInsert;
    }

    public void setAnnualUpdateRateDelete(float value) {
        if (this.checkAnnualUpdateRateGroup(value)) {
            this.annualUpdateRateDelete = value;
            this.setAnnualUpdateRateNetGrowth();
            this.fireDataFieldChange();
        }
    }

    public float getAnnualUpdateRateDelete() {
        return this.annualUpdateRateDelete;
    }

    private void setAnnualUpdateRateNetGrowth() {
        this.annualUpdateRateNetGrowth = this.getAnnualUpdateRateInsert() - this.getAnnualUpdateRateDelete();
        this.fireDataFieldChange();
    }

    public float getAnnualUpdateRateNetGrowth() {
        return this.annualUpdateRateNetGrowth;
    }

    public boolean checkActiveGroup(float value) {
        return value >= 0.0f && value <= 100.0f;
    }

    public void setActiveGroupInsert(float value) {
        if (this.checkActiveGroup(value)) {
            this.activeGroupInsert = value;
            this.fireDataFieldChange();
        }
    }

    public float getActiveGroupInsert() {
        return this.activeGroupInsert;
    }

    public void setActiveGroupDelete(float value) {
        if (this.checkActiveGroup(value)) {
            this.activeGroupDelete = value;
            this.fireDataFieldChange();
        }
    }

    public float getActiveGroupDelete() {
        return this.activeGroupDelete;
    }

    public void setActiveGroupData(float value) {
        if (this.checkActiveGroup(value)) {
            this.activeGroupData = value;
            this.fireDataFieldChange();
        }
    }

    public float getActiveGroupData() {
        return this.activeGroupData;
    }

    public boolean checkGrowthHorizon(int value) {
        return value >= 0 && value <= 999999;
    }

    public void setGrowthHorizon(int value) {
        if (this.checkGrowthHorizon(value)) {
            this.growthHorizon = value;
            this.fireDataFieldChange();
        }
    }

    public int getGrowthHorizon() {
        return this.growthHorizon;
    }

    public void setGrowthMethod(String method) {
        this.growthMethod = method;
        this.fireDataFieldChange();
    }

    public String getGrowthMethod() {
        return this.growthMethod;
    }

    public void setNumberOfRows(long value) {
        this.numberOfRows = value;
        this.fireDataFieldChange();
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public boolean checkInitialRowNumber(long rows) {
        return rows >= 1L && rows <= 0xFFFFFFFEL;
    }

    public void setInitialRowNumber(long rows) {
        if (this.getMaxRowNumber() < rows) {
            this.setMaxRowNumber(rows);
        }
        if (this.checkInitialRowNumber(rows)) {
            this.initialRowNumber = rows;
            this.initialRowNumberChanged = true;
            this.fireDataFieldChange();
        }
    }

    public long getInitialRowNumber() {
        if (!this.getInitialRowNumberChanged()) {
            return Long.parseLong(((Table)this.getObject()).getMinVolumes());
        }
        return this.initialRowNumber;
    }

    public boolean getInitialRowNumberChanged() {
        return this.initialRowNumberChanged;
    }

    public void setInitialRowNumberChanged(boolean initialRowNumberChanged) {
        this.initialRowNumberChanged = initialRowNumberChanged;
    }

    public boolean getMaxRowNumberChanged() {
        return this.maxRowNumberChanged;
    }

    public void setMaxRowNumberChanged(boolean maxRowNumberChanged) {
        this.maxRowNumberChanged = maxRowNumberChanged;
    }

    public void setRecordLength(int value) {
        this.recordLength = value >= 0 ? value : 0;
        this.fireDataFieldChange();
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void setNumberOfPages(int value) {
        this.numberOfPages = value >= 0 ? value : 0;
        this.fireDataFieldChange();
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setPercentageOfPages(int value) {
        this.percentageOfPages = value >= 0 ? value : 0;
        this.fireDataFieldChange();
    }

    public int getPercentageOfPages() {
        return this.percentageOfPages;
    }

    public boolean getCalculatePrimaryQuantity() {
        return this.calculatePrimaryQuantity;
    }

    public void setCalculatePrimaryQuantity(boolean calculate) {
        this.calculatePrimaryQuantity = calculate;
        this.fireDataFieldChange();
    }

    public boolean getCalculateSecondaryQuantity() {
        return this.calculateSecondaryQuantity;
    }

    public void setCalculateSecondaryQuantity(boolean calculate) {
        this.calculateSecondaryQuantity = calculate;
        this.fireDataFieldChange();
    }

    public void setAudit(String value) {
        this.audit = value;
        this.fireDataFieldChange();
    }

    public String getAudit() {
        return this.audit;
    }

    public void setDataCapture(boolean value) {
        this.dataCapture = value;
        this.fireDataFieldChange();
    }

    public boolean getDataCapture() {
        return this.dataCapture;
    }

    public void setDropRestrict(boolean value) {
        this.dropRestrict = value;
        this.fireDataFieldChange();
    }

    public boolean getDropRestrict() {
        return this.dropRestrict;
    }

    public void setClusterType(boolean value) {
        this.setDropRestrict(value);
    }

    public boolean getClusterType() {
        return this.getDropRestrict();
    }

    @Override
    public void setCreatedBy(String value) {
        this.createdBy = value;
        this.fireDataFieldChange();
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setObid(int value) {
        this.obid = value;
        this.fireDataFieldChange();
    }

    public int getObid() {
        return this.obid;
    }

    public void setExcludeFreepage(boolean value) {
        this.excludeFreepage = value;
        this.fireDataFieldChange();
    }

    public boolean getExcludeFreepage() {
        return this.excludeFreepage;
    }

    public static String[] getGrowthMethodChoices() {
        return growthMethodChoices;
    }

    public static String[] getAuditChoices() {
        return AUDIT_CHOICES;
    }

    public String getEditProc() {
        return this.editProc;
    }

    public void setEditProc(String editProc) {
        this.editProc = editProc;
        this.fireDataFieldChange();
    }

    public String getValidProc() {
        return this.validProc;
    }

    public void setValidProc(String validProc) {
        this.validProc = validProc;
        this.fireDataFieldChange();
    }

    public String getCcsid() {
        return this.ccsid;
    }

    public void setCcsid(String ccsid) {
        this.ccsid = ccsid;
        this.fireDataFieldChange();
    }

    public static String[] getCcsidValues() {
        return CCSID;
    }

    public static String[] getDataCaptureValues() {
        return DATA_CAPTURE_VALUES;
    }

    public TableSpaceDB2 getTableSpace() {
        return this.tableSpace;
    }

    public DataBaseDB2 getDataBase() {
        if (this.tableSpace == null) {
            return null;
        }
        return this.tableSpace.getDataBase();
    }

    private IndexProxyDB2 getPartIndex() {
        IndexProxy[] proxies = this.getIndexProxies();
        for (int i = 0; i < proxies.length; ++i) {
            IndexProxy index = proxies[i];
            if (!(index instanceof IndexProxyDB2) || !((IndexProxyDB2)index).isPartitioned()) continue;
            return (IndexProxyDB2)index;
        }
        return null;
    }

    public void setTableSpace(TableSpaceDB2 tableSpace) {
        if (this.tableSpace != tableSpace) {
            IndexProxyDB2 partIndex = this.getPartIndex();
            if (this.tableSpace != null && this.tableSpace.getPartIndex() == partIndex) {
                this.tableSpace.setPartIndex(null);
                this.tableSpace.setMaxPartitionCount(0);
            }
            this.tableSpace = tableSpace;
            if (partIndex != null) {
                this.tableSpace.setPartIndex(partIndex);
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogDB2 dialog = new TablePropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAverageRecordLength() {
        int result = 8;
        Table table = (Table)this.getObject();
        Column[] columns = (Column[])table.getElements();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("varchar") || columns[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("vargraphic")) {
                if (this.isUsePCTFilling()) {
                    result += columns[i].getDataType(this.getRDBMSType().toString()).getByteSize() * this.pctFilling / 100;
                    try {
                        result += columns[i].getDataType(this.getRDBMSType().toString()).getByteSize() * this.pctFilling / 100;
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in TableProxyDB2.getAverageRecordLength() - unsuported data type" + columns[i].getDataType(this.getRDBMSType().toString()).getName());
                    }
                    finally {
                        result += 0;
                    }
                } else {
                    result = (int)((float)result + this.getColumnProxy(columns[i]).getAverageLength());
                }
            } else {
                try {
                    result += columns[i].getDataType(this.getRDBMSType().toString()).getByteSize();
                }
                catch (Exception e) {
                    LOGGER.error("Error in TableProxyDB2.getAverageRecordLength() - unsuported data type" + columns[i].getDataType(this.getRDBMSType().toString()).getName());
                }
                finally {
                    result += 0;
                }
            }
            if (columns[i].getNullsAllowed()) {
                ++result;
            }
            if (!columns[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("blob") && !columns[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("clob") && !columns[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("dbclob")) continue;
            result += 17;
        }
        return result > 32 ? (long)result : 32L;
    }

    public ColumnProxyDB2 getColumnProxy(Column column) {
        AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign();
        return (ColumnProxyDB2)storageDesign.getColumnProxySet().getProxy(column.getObjectID());
    }

    public boolean hasLongColumn() {
        Table table = (Table)this.getObject();
        Column[] columns = (Column[])table.getElements();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("longvarchar") && !columns[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("longvargraphic")) continue;
            return true;
        }
        return false;
    }

    public int getUsablePageSize() {
        int ups = this.getTableSpace() != null && this.getTableSpace().getBufferPool() != null ? this.getTableSpace().getBufferPool().usablePageSize() : 4056;
        if (this.getEditProc().equalsIgnoreCase("")) {
            ups -= 10;
        }
        if (IMLOAD.equalsIgnoreCase(this.getInsertMethod())) {
            ups = this.getTableSpace() != null && this.getTableSpace().getStorageTemplate() != null ? ups * (100 - this.getTableSpace().getStorageTemplate().getPctFree()) / 100 : ups * 95 / 100;
        }
        return ups;
    }

    public int getPageSize() {
        int ps = this.getTableSpace() != null && this.getTableSpace().getBufferPool() != null ? this.getTableSpace().getBufferPool().pageSize() : 4096;
        return ps;
    }

    public static String[] getInsertMethodChoices() {
        return insertMethodChoices;
    }

    public String getInsertMethod() {
        return this.insertMethod;
    }

    public void setInsertMethod(String insertMethod) {
        this.insertMethod = insertMethod;
        this.fireDataFieldChange();
    }

    public int getNumberRecordsPerPage() {
        int result;
        int maxRows = 255;
        if (this.getTableSpace() != null) {
            maxRows = this.getTableSpace().getMaxRows();
        }
        if ((result = Math.min(maxRows, (int)Math.ceil((float)this.getUsablePageSize() / (float)this.getAverageRecordLength()))) <= 255 && result <= maxRows) {
            return result;
        }
        return maxRows > 255 ? 255 : maxRows;
    }

    public int getInitialNumberUsedPages() {
        int fp;
        int result = Math.max(3, (int)Math.ceil((float)this.getInitialRowNumber() / (float)this.getNumberRecordsPerPage()));
        if (IMLOAD.equalsIgnoreCase(this.getInsertMethod()) && this.getTableSpace() != null && this.getTableSpace().getStorageTemplate() != null && (fp = this.getTableSpace().getStorageTemplate().getFreePage()) > 0) {
            result = (int)Math.ceil((double)result * ((double)(1 + fp) / (double)fp));
        }
        if (this.getTableSpace() != null && this.getTableSpace().isCompress()) {
            result = result * (100 - this.getTableSpace().getCompressionRatio()) / 100;
        }
        return result;
    }

    public int getMaxNumberUsedPages() {
        int fp;
        int result = Math.max(3, (int)Math.ceil((float)this.getMaxRowNumber() / (float)this.getNumberRecordsPerPage()));
        if (IMLOAD.equalsIgnoreCase(this.getInsertMethod()) && this.getTableSpace() != null && this.getTableSpace().getStorageTemplate() != null && (fp = this.getTableSpace().getStorageTemplate().getFreePage()) > 0) {
            result = (int)Math.ceil((double)result * ((double)(1 + fp) / (double)fp));
        }
        if (this.getTableSpace() != null && this.getTableSpace().isCompress()) {
            result = result * (100 - this.getTableSpace().getCompressionRatio()) / 100;
        }
        return result;
    }

    public int getMaxStorageKB() {
        return this.getPageSize() / 1024 * this.getMaxNumberUsedPages();
    }

    public int getInitialStorageKB() {
        return this.getPageSize() / 1024 * this.getInitialNumberUsedPages();
    }

    public int getPctFilling() {
        return this.pctFilling;
    }

    public void setPctFilling(int pctFilling) {
        this.pctFilling = pctFilling;
        this.fireDataFieldChange();
    }

    public boolean isUsePCTFilling() {
        return this.usePCTFilling;
    }

    public void setUsePCTFilling(boolean usePCTFilling) {
        this.usePCTFilling = usePCTFilling;
        this.fireDataFieldChange();
    }

    public ColumnProxyDB2 getColumn(String colName) {
        for (int i = 0; i < this.getColumnProxies().length; ++i) {
            if (!colName.equalsIgnoreCase(this.getColumnProxies()[i].getName())) continue;
            return (ColumnProxyDB2)this.getColumnProxies()[i];
        }
        return null;
    }

    @Override
    protected void addIndexProxyWithoutCheck(IndexProxy ind) {
        int stat = ((IndexProxyDB2)ind).getStatusGroup();
        if (1 == stat) {
            ind.setParent(this.integrityIndexes);
            this.integrityIndexes.add(ind);
            ind.setPAC_Element(this);
        } else {
            super.addIndexProxyWithoutCheck(ind);
        }
    }

    public List getIntegrityIndexes() {
        ArrayList list = new ArrayList();
        this.integrityIndexes.addAllElementsTo(list);
        return list;
    }

    public StorageObjectCollection getIntIndexes() {
        return this.integrityIndexes;
    }

    @Override
    public StorageObject getUserSchema() {
        return this.getOwner();
    }

    public StorageObjectCollection getInstDescriptorCols() {
        return this.instDescriptorCols;
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    @Override
    public StorageObjectCollection getTriggers() {
        return this.triggers;
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            if (this.getDataBase() != null) {
                return this.getDataBase().isDropEnabled() || this.getDataBase().shouldBeDroppedIndirectly();
            }
            if (this.getTableSpace() != null) {
                return this.getTableSpace().isDropEnabled() || this.getTableSpace().shouldBeDroppedIndirectly();
            }
        }
        return false;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Owner", this, "getOwner", "setOwner", Owner.class));
            this.propertyWrapperList.add(new PropertyWrapper("TableSpace", this, "getTableSpace", "setTableSpace", TableSpaceDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Edit Proc", this, "getEditProc", "setEditProc", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Valid Proc", this, "getValidProc", "setValidProc", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Audit", this, "getAudit", "setAudit", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Data Capture", this, "getDataCapture", "setDataCapture", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Drop Restrict", this, "getDropRestrict", "setDropRestrict", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("CCSID", this, "getCcsid", "setCcsid", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void remove() {
        Object[] trigs = this.triggers.toArray();
        for (int i = 0; i < trigs.length; ++i) {
            TriggerDB2 trig = (TriggerDB2)trigs[i];
            trig.remove();
            trig.setTable(null);
            this.triggers.remove(trig);
        }
        super.remove();
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            this.triggers.addAllElementsTo(list);
            this.synonyms.addAllElementsTo(list);
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    @Override
    public void clearNoneMergableStructure() {
        if (this.tablePartitions != null) {
            this.tablePartitions.removeAll();
        }
    }

    public SynonymDB2 createSynonym() {
        SynonymDB2 syn = (SynonymDB2)this.synonyms.createElement(null);
        syn.setTable(this);
        syn.setPAC_Element(this);
        return syn;
    }

    public InstanceDescriptorColumnDB2 createInstanceDescriptorColumn() {
        InstanceDescriptorColumnDB2 col = (InstanceDescriptorColumnDB2)this.instDescriptorCols.createElement(null);
        col.setTable(this);
        col.setPAC_Element(this);
        return col;
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !this.getOwner().isNullInstance()) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        Table table = (Table)this.getObject();
        SchemaObject so = table.getSchemaObject();
        if (so != null) {
            StorageObject user = ((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getBySchemaObject(so);
            if (user != null && !user.isNullInstance()) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }
}

