/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.IndexProxySetDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableSpacePropertyDialogDB2;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableSpaceDB2
extends DataBaseSpaceDB2
implements ModelObjectSetListener,
PropertiesPropagator {
    public static final String NEW_LINE = "\n";
    public static final String TYPE_NORMAL = "REGULAR";
    public static final String TYPE_MEMBER_CLUSTER = "MEMBER_CLUSTER";
    public static final String TYPE_PARTITIONED = "PARTITIONED";
    public static final String TYPE_MC_PARTITIONED = "MC_PARTITIONED";
    public static final String TYPE_LOB = "LOB";
    public static final String LOCKSIZE_ANY = "ANY";
    public static final String LOCKSIZE_PAGE = "PAGE";
    public static final String LOCKSIZE_TABLESPACE = "TABLESPACE";
    public static final String LOCKSIZE_TABLE = "TABLE";
    public static final String LOCKSIZE_ROW = "ROW";
    public static final String LOCKSIZE_LOB = "LOB";
    public static final String CCSID_ASCII = "ASCII";
    public static final String CCSID_EBCDIC = "EBCDIC";
    public static final String CCSID_UNICODE = "UNICODE";
    private static final String[] CCSIDS = new String[]{"", "ASCII", "EBCDIC", "UNICODE"};
    private static final String[] TYPES = new String[]{"REGULAR", "PARTITIONED", "LOB"};
    private static final String[] LOCKSIZES = new String[]{"ANY", "PAGE", "TABLESPACE", "TABLE", "ROW", "LOB"};
    private static final String[] DS_SIZE = new String[]{"", "1 G", "2 G", "4 G", "8 G", "16 G", "32 G", "64 G"};
    private static final String[] SEG_SIZE = new String[]{"0", "4", "8", "12", "16", "20", "24", "28", "32", "36", "40", "44", "48", "52", "56", "60", "64"};
    protected String type = TYPES[0];
    private String clustered = YES_NO_STATES[1];
    private DataBaseDB2 dataBase = null;
    private StorageTemplateDB2 storageTemplate = null;
    private boolean lobLogging = true;
    private String dsSize = DS_SIZE[0];
    private String segSize = SEG_SIZE[0];
    protected IndexProxyDB2 partIndex = null;
    private BufferPoolDB2 bufferPool = null;
    private String lockSize = LOCKSIZES[0];
    private int lockMax = 0;
    private boolean close = true;
    private boolean compress = false;
    private String ccsid = CCSIDS[0];
    private boolean lockPart = false;
    private int maxRows = 0;
    protected int numParts = 0;
    private int obid = 0;
    private int psid = 0;
    private int nactive = 0;
    private String createdBy = "";
    private int pageSave = 0;
    private static final int PRIQTY = 1;
    private static final int SECQTY = 2;
    private StringBuffer proposedQTYRemarks = new StringBuffer();
    private int fragmentationPCT = 10;
    private int compressionPercentage = 0;
    private StorageObjectCollection partitions;
    private String users = "";
    private UserSet userSet = null;
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private List propertyWrapperList = null;
    public static final String TYPE_NAME = "TSpace";
    public static final String OLD_TYPE_NAME = "TableSpace";
    private static int maxQTY = 0x400000;

    public TableSpaceDB2() {
    }

    public TableSpaceDB2(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.partitions = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getPartitionSet());
        this.partitions.setParent(this);
        this.partitions.setName(Messages.getString("TableSpaceDB2.Partitions"));
        this.partitions.setSetMethod("setTableSpace");
        this.partitions.setClassForParent(TableSpaceDB2.class);
        this.partitions.setAllowedNumberOfElements(0);
        this.partitions.addSetListener(this);
        this.partitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getPartitionSet().addSetListener(this);
    }

    public StorageObjectCollection getTSPartitions() {
        return this.partitions;
    }

    @Override
    public String getIDPrefix() {
        return "TS";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type != null && type.equals(this.type)) {
            return;
        }
        if (TYPE_MC_PARTITIONED.equalsIgnoreCase(type)) {
            this.type = TYPE_PARTITIONED;
            this.clustered = YES;
        } else if (TYPE_MEMBER_CLUSTER.equalsIgnoreCase(type)) {
            this.clustered = YES;
        } else {
            this.type = type;
        }
        this.fireDataFieldChange();
    }

    @Override
    public DataBaseDB2 getDataBase() {
        return this.dataBase;
    }

    @Override
    public void setDataBase(DataBaseDB2 dataBase) {
        if (dataBase == null) {
            DataBaseDB2 db = null;
            Iterator it = ((AbstractStorageDesignDB2)this.getStorageDesign()).getDataBaseSet().iterator();
            while (it.hasNext() && !(db = (DataBaseDB2)it.next()).isSystemDatabase()) {
            }
            if (db != null) {
                this.dataBase = db;
                this.fireDataFieldChange();
            }
        } else if (dataBase != this.dataBase) {
            this.dataBase = dataBase;
            this.fireDataFieldChange();
        }
    }

    public StorageTemplateDB2 getStorageTemplate() {
        return this.storageTemplate;
    }

    public void setStorageTemplate(StorageTemplateDB2 storageTemplate) {
        this.storageTemplate = storageTemplate;
        this.fireDataFieldChange();
    }

    public boolean isLobLogging() {
        return this.lobLogging;
    }

    public void setLobLogging(boolean lobLogging) {
        this.lobLogging = lobLogging;
        this.fireDataFieldChange();
    }

    public String getDsSize() {
        return this.dsSize;
    }

    public void setDsSize(String dsSize) {
        this.dsSize = dsSize;
        this.fireDataFieldChange();
    }

    public String getSegSize() {
        return this.segSize;
    }

    public void setSegSize(String segSize) {
        this.segSize = segSize;
        this.fireDataFieldChange();
    }

    public IndexProxyDB2 getPartIndex() {
        return this.partIndex;
    }

    public void setPartIndex(IndexProxyDB2 partIndex) {
        if (this.partIndex != partIndex) {
            this.partIndex = partIndex;
            if (partIndex != null) {
                this.setMaxPartitionCount(partIndex.getNumParts());
            } else {
                this.setMaxPartitionCount(0);
            }
            this.fireDataFieldChange();
        }
        if (this.partIndex != null && !this.isPartitioned()) {
            this.type = TYPE_PARTITIONED;
            this.fireDataFieldChange();
        }
    }

    public boolean isPartitioned() {
        return this.type.equalsIgnoreCase(TYPE_PARTITIONED) || this.type.equalsIgnoreCase(TYPE_MC_PARTITIONED);
    }

    @Override
    public BufferPoolDB2 getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public void setBufferPool(BufferPoolDB2 bufferPool) {
        this.bufferPool = bufferPool;
        this.fireDataFieldChange();
    }

    public String getLockSize() {
        return this.lockSize;
    }

    public void setLockSize(String lockSize) {
        this.lockSize = lockSize;
        this.fireDataFieldChange();
    }

    public int getLockMax() {
        return this.lockMax;
    }

    public void setLockMax(int lockMax) {
        this.lockMax = lockMax;
        this.fireDataFieldChange();
    }

    public boolean isClose() {
        return this.close;
    }

    public void setClose(boolean close) {
        this.close = close;
        this.fireDataFieldChange();
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
        this.fireDataFieldChange();
    }

    public String getCcsid() {
        return this.ccsid;
    }

    public void setCcsid(String ccsid) {
        this.ccsid = ccsid;
        this.fireDataFieldChange();
    }

    public boolean isLockPart() {
        return this.lockPart;
    }

    public void setLockPart(boolean lockPart) {
        this.lockPart = lockPart;
        this.fireDataFieldChange();
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        this.fireDataFieldChange();
    }

    public int getNumParts() {
        if (this.partIndex != null) {
            return this.partIndex.getNumParts();
        }
        return this.numParts;
    }

    public void setNumParts(int numParts) {
        this.numParts = numParts;
        this.fireDataFieldChange();
    }

    public static String[] getCCSIDValues() {
        return CCSIDS;
    }

    public static String[] getTypeValues() {
        return TYPES;
    }

    public static String[] getLockSizeValues() {
        return LOCKSIZES;
    }

    public static String[] getDSSizeValues() {
        return DS_SIZE;
    }

    public static String[] getSegSizeValues() {
        return SEG_SIZE;
    }

    public void setObid(int value) {
        this.obid = value;
        this.fireDataFieldChange();
    }

    public void setPsid(int value) {
        this.psid = value;
        this.fireDataFieldChange();
    }

    public void setNactive(int value) {
        this.nactive = value;
        this.fireDataFieldChange();
    }

    public int getObid() {
        return this.obid;
    }

    public int getPsid() {
        return this.psid;
    }

    public int getNactive() {
        return this.nactive;
    }

    @Override
    public void setCreatedBy(String value) {
        this.createdBy = value;
        this.fireDataFieldChange();
    }

    public void setPageSave(int value) {
        this.pageSave = value;
        this.fireDataFieldChange();
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    public int getPageSave() {
        return this.pageSave;
    }

    public void setCompressionPercentage(int value) {
        this.compressionPercentage = value;
        this.fireDataFieldChange();
    }

    public void setCompressionRatio(int value) {
        this.setCompressionPercentage(value);
        this.fireDataFieldChange();
    }

    public int getCompressionPercentage() {
        return this.compressionPercentage;
    }

    public int getCompressionRatio() {
        return this.getCompressionPercentage();
    }

    public PartitionDB2[] getPartitions() {
        PartitionSetDB2 partitionsSet = ((AbstractStorageDesignDB2)this.getStorageDesign()).getPartitionSet();
        return partitionsSet.getPartitionsFor(this);
    }

    public PartitionSetDB2 getPartitionSet() {
        return ((AbstractStorageDesignDB2)this.getStorageDesign()).getPartitionSet();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableSpacePropertyDialogDB2 dialog = new TableSpacePropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.partitions;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.partitions) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.partitions) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        block8: {
            block9: {
                block7: {
                    PartitionDB2 ip;
                    if (set != this.partitions) break block7;
                    if (event.isType(1) && event.getAffected() instanceof PartitionDB2 && (ip = (PartitionDB2)event.getAffected()).getTableSpace() == null) {
                        ip.setTableSpace(this);
                        ip.removeObjectListener(this);
                        if (!this.getStorageDesign().isLoading()) {
                            ip.setPartNumber(this.partitions.size());
                        }
                        ip.addObjectListener(this);
                    }
                    break block8;
                }
                if (!event.isType(1)) break block9;
                if (!(event.getAffected() instanceof PartitionDB2)) break block8;
                PartitionDB2 ip = (PartitionDB2)event.getAffected();
                ip.addObjectListener(this);
                if (this != ip.getTableSpace()) break block8;
                this.partitions.add(event.getAffected());
                ip.removeObjectListener(this);
                if (!this.getStorageDesign().isLoading()) {
                    ip.setPartNumber(this.partitions.size());
                }
                ip.addObjectListener(this);
                break block8;
            }
            if (event.isType(0) && event.getAffected() instanceof PartitionDB2) {
                PartitionDB2 ip = (PartitionDB2)event.getAffected();
                ip.removeObjectListener(this);
                if (this.partitions.contains(ip)) {
                    this.partitions.remove(event.getAffected());
                    if (!this.getStorageDesign().isLoading()) {
                        for (int i = 0; i < this.partitions.size(); ++i) {
                            ip.removeObjectListener(this);
                            ((PartitionDB2)this.partitions.getElement(i)).setPartNumber(i + 1);
                            ip.addObjectListener(this);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof PartitionDB2) {
            PartitionDB2 ip = (PartitionDB2)event.getAffected();
            if (ip.getTableSpace() != null && ip.getTableSpace() == this && !this.partitions.contains(ip)) {
                this.partitions.add(ip);
                ip.removeObjectListener(this);
                if (!this.getStorageDesign().isLoading()) {
                    ip.setPartNumber(this.partitions.size());
                }
                ip.addObjectListener(this);
            } else if ((ip.getTableSpace() == null || ip.getTableSpace() != null && ip.getTableSpace() != this) && this.partitions.contains(ip)) {
                this.partitions.remove(ip);
            }
        }
    }

    public int getProposedPRIQTY() {
        return this.getProposedQTY(1);
    }

    public ArrayList getTables() {
        ArrayList<TableProxyDB2> list = new ArrayList<TableProxyDB2>();
        Iterator it = this.getStorageDesign().getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyDB2 table = (TableProxyDB2)it.next();
            if (table.getTableSpace() != this) continue;
            list.add(table);
        }
        return list;
    }

    public int getProposedQTY(int qtyType) {
        int totPriQTY = 0;
        int totSecQTY = 0;
        Iterator it = this.getTables().iterator();
        this.proposedQTYRemarks.setLength(0);
        int psizeInK = 4;
        if (this.getBufferPool() != null) {
            psizeInK = this.getBufferPool().pageSize() / 1024;
        }
        int segSize = Integer.parseInt(this.getSegSize());
        while (it.hasNext()) {
            int minPages = 0;
            int maxPages = 0;
            int priQTY = 0;
            int secQTY = 0;
            TableProxyDB2 tp = (TableProxyDB2)it.next();
            maxPages += tp.getMaxNumberUsedPages();
            minPages += tp.getInitialNumberUsedPages();
            minPages = Math.max(3, minPages);
            maxPages = Math.max(3, maxPages);
            if (segSize > 0) {
                if (minPages != segSize && minPages != minPages / segSize * segSize) {
                    minPages = (minPages / segSize + 1) * segSize;
                    this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("TableSpaceDB2.SizeAdjustedMultiple"), this.getSegSize(), tp.getName()) + NEW_LINE);
                }
                if ((maxPages = Math.max(minPages, maxPages)) > minPages && maxPages != segSize && maxPages != maxPages / segSize * segSize) {
                    maxPages = (maxPages / segSize + 1) * segSize;
                    this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("TableSpaceDB2.SizeAdjustedMultiple"), this.getSegSize(), tp.getName()) + NEW_LINE);
                }
            } else if ("LOB".equalsIgnoreCase(this.getType())) {
                if (minPages < 50 || maxPages < 50) {
                    this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("TableSpaceDB2.SizeAdjustedMinimum"), tp.getName()) + NEW_LINE);
                }
                minPages = Math.max(50, minPages);
                maxPages = Math.max(50, maxPages);
            }
            if (minPages * 123 < maxPages) {
                minPages = (int)Math.ceil((float)maxPages / 123.0f);
                this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("TableSpaceDB2.SizeAdjustedMaximum"), tp.getName()) + NEW_LINE);
                if (segSize > 0 && minPages != segSize && minPages != minPages / segSize * segSize) {
                    minPages = (minPages / segSize + 1) * segSize;
                    this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("TableSpaceDB2.SizeAdjustedMultiple"), this.getSegSize(), tp.getName()) + NEW_LINE);
                }
                secQTY = priQTY = minPages;
            } else {
                priQTY = minPages;
                secQTY = (maxPages - minPages) / 122;
                secQTY = Math.max(secQTY, priQTY * 10 / 100);
                secQTY = Math.max(secQTY, 3);
                secQTY = Math.max(secQTY, segSize);
            }
            priQTY *= psizeInK;
            secQTY *= psizeInK;
            if (minPages == maxPages) {
                secQTY = 0;
            }
            totPriQTY += priQTY;
            totSecQTY += secQTY;
        }
        if (this.isSimpleTablespace() && this.getTableCount() > 1 && this.getFragmentationPCT() > 0) {
            this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("TableSpaceDB2.SizeIncreased"), Integer.toString(this.getFragmentationPCT())));
            totPriQTY = (int)((double)totPriQTY * 1.1);
            totSecQTY = (int)((double)totSecQTY * 1.1);
        }
        totPriQTY = Math.min(totPriQTY, maxQTY);
        totSecQTY = Math.min(totSecQTY, maxQTY);
        return qtyType == 1 ? totPriQTY : totSecQTY;
    }

    public int getProposedSECQTY() {
        return this.getProposedQTY(2);
    }

    private boolean isSimpleTablespace() {
        if (this.getType().equalsIgnoreCase("LOB") || this.getType().equalsIgnoreCase(TYPE_MC_PARTITIONED) || this.getType().equalsIgnoreCase(TYPE_PARTITIONED)) {
            return false;
        }
        return Integer.parseInt(this.getSegSize()) <= 0 && this.getNumParts() <= 0 && this.getDsSize().equalsIgnoreCase("");
    }

    private int getTableCount() {
        return this.getTables().size();
    }

    public String getProposedQTYRemarks() {
        return this.proposedQTYRemarks.toString();
    }

    public int getFragmentationPCT() {
        return this.fragmentationPCT;
    }

    public void setFragmentationPCT(int fragmentationPCT) {
        this.fragmentationPCT = fragmentationPCT;
        this.fireDataFieldChange();
    }

    public int getInitialNumberUsedPages() {
        Iterator it = this.getTables().iterator();
        int minPages = 0;
        while (it.hasNext()) {
            TableProxyDB2 tp = (TableProxyDB2)it.next();
            minPages += tp.getInitialNumberUsedPages();
        }
        return minPages;
    }

    public int getMaxNumberUsedPages() {
        Iterator it = this.getTables().iterator();
        int maxPages = 0;
        while (it.hasNext()) {
            TableProxyDB2 tp = (TableProxyDB2)it.next();
            maxPages += tp.getMaxNumberUsedPages();
        }
        return maxPages;
    }

    public int getInitialNumberUsedKB() {
        int psizeInK = 4;
        if (this.getBufferPool() != null) {
            psizeInK = this.getBufferPool().pageSize() / 1024;
        }
        return this.getInitialNumberUsedPages() * psizeInK;
    }

    public int getMaxNumberUsedKB() {
        int psizeInK = 4;
        if (this.getBufferPool() != null) {
            psizeInK = this.getBufferPool().pageSize() / 1024;
        }
        return this.getMaxNumberUsedPages() * psizeInK;
    }

    public void setMaxPartitionCount(int count) {
        this.partitions.setAllowedNumberOfElements(count);
        if (this.partIndex != null && !this.isPartitioned()) {
            this.type = TYPE_PARTITIONED;
            this.fireDataFieldChange();
        }
    }

    public String getClustered() {
        return this.clustered;
    }

    public void setClustered(String clustered) {
        this.clustered = clustered;
        this.fireDataFieldChange();
    }

    private void addUser(String user) {
        String userName = user.substring(user.lastIndexOf(46) + 1, user.length());
        if (!this.getUserSet().contains(userName)) {
            this.getUserSet().add(userName);
        }
    }

    public void recreateUserSet(String users) {
        this.getUserSet().clear();
        StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            this.getUserSet().add(st.nextToken().trim());
        }
    }

    public void setUsers(String users) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(users);
        } else {
            this.addUser(users);
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public String getUsers() {
        return this.users;
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    public void clear() {
        this.getUserSet().removeAllElements();
        this.users = "";
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(value);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String grantOption) {
        if (grantOption != null && grantOption.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(grantOption)) {
            this.grantOption = grantOption;
            this.fireDataFieldChange();
        }
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY && this.getDataBase() != null) {
            return this.getDataBase().isDropEnabled() || this.getDataBase().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Type", this, "getType", "setType", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Clustered", this, "getClustered", "setClustered", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("DataBase", this, "getDataBase", "setDataBase", DataBaseDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Storage Template", this, "getStorageTemplate", "setStorageTemplate", StorageTemplateDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("DS Size", this, "getDsSize", "setDsSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Seg Size", this, "getSegSize", "setSegSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Buffer Pool", this, "getBufferPool", "setBufferPool", BufferPoolDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Lock Size", this, "getLockSize", "setLockSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Lock Max", this, "getLockMax", "setLockMax", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Close", this, "isClose", "setClose", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Compress", this, "isCompress", "setCompress", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("CCSID", this, "getCcsid", "setCcsid", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Lock Part", this, "isLockPart", "setLockPart", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Max Rows", this, "getMaxRows", "setMaxRows", Integer.TYPE));
        }
        return this.propertyWrapperList;
    }

    public List getPartitionsList() {
        ArrayList list = new ArrayList();
        this.partitions.addAllElementsTo(list);
        return list;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableSpaceDB2 tableSpace = null;
        StorageObject stObject = (StorageObject)((StorageDesignDB2v70)targetDesign).getTableSpaceSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                tableSpace = (TableSpaceDB2)stObject;
            }
        } else {
            tableSpace = ((StorageDesignDB2v70)targetDesign).getTableSpaceSet().createTableSpace();
        }
        if (tableSpace != null) {
            tableSpace.setName(this.getName());
            for (PartitionDB2 partition : this.getPartitionsList()) {
                PartitionDB2 targetPartition = (PartitionDB2)((StorageDesignDB2v70)targetDesign).getPartitionSet().getByName(partition.getName());
                if (targetPartition == null) {
                    PartitionDB2 newPartition = ((StorageDesignDB2v70)targetDesign).getPartitionSet().createPartition();
                    newPartition.setName(partition.getName());
                    newPartition.setTableSpace(tableSpace);
                    newPartition.setRawObject(true);
                    ((StorageDesignDB2v70)targetDesign).getPartitionSet().add(newPartition);
                    continue;
                }
                targetPartition.setTableSpace(tableSpace);
                ((StorageDesignDB2v70)targetDesign).getPartitionSet().add(targetPartition);
            }
            tableSpace.setType(this.getType());
            tableSpace.setClustered(this.getClustered());
            if (this.getDataBase() != null) {
                DataBaseDB2 database = (DataBaseDB2)((StorageDesignDB2v70)targetDesign).getDataBaseSet().getByName(this.getDataBase().getName());
                if (database == null) {
                    DataBaseDB2 newDataBase = ((StorageDesignDB2v70)targetDesign).getDataBaseSet().createDataBase();
                    newDataBase.setName(this.getDataBase().getName());
                    newDataBase.setRawObject(true);
                    tableSpace.setDataBase(newDataBase);
                } else {
                    tableSpace.setDataBase(database);
                }
            }
            if (this.getStorageTemplate() != null) {
                StorageTemplateDB2 stTemplate = (StorageTemplateDB2)((StorageDesignDB2v70)targetDesign).getStorageTemplateSet().getByName(this.getStorageTemplate().getName());
                if (stTemplate == null) {
                    StorageTemplateDB2 newStorageTempl = ((StorageDesignDB2v70)targetDesign).getStorageTemplateSet().createStorageTemplate();
                    newStorageTempl.setName(this.getStorageTemplate().getName());
                    newStorageTempl.setRawObject(true);
                    tableSpace.setStorageTemplate(newStorageTempl);
                } else {
                    tableSpace.setStorageTemplate(stTemplate);
                }
            }
            tableSpace.setLobLogging(this.isLobLogging());
            tableSpace.setDsSize(this.getDsSize());
            tableSpace.setSegSize(this.getSegSize());
            if (this.getPartIndex() != null) {
                IndexProxyDB2 index = (IndexProxyDB2)((StorageDesignDB2v70)targetDesign).getIndexProxySet().getByName(this.getPartIndex().getName());
                if (index == null) {
                    IndexProxyDB2 newIndex = (IndexProxyDB2)((IndexProxySetDB2v70)((StorageDesignDB2v70)targetDesign).getIndexProxySet()).createProxy(this.getPartIndex().getObject());
                    newIndex.setName(this.getPartIndex().getName());
                    newIndex.setRawObject(true);
                    tableSpace.setPartIndex(newIndex);
                } else {
                    tableSpace.setPartIndex(index);
                }
            }
            tableSpace.setNumParts(this.getNumParts());
            if (this.getBufferPool() != null) {
                BufferPoolDB2 targetBufferPool = (BufferPoolDB2)((StorageDesignDB2v70)targetDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (targetBufferPool == null) {
                    BufferPoolDB2 newBuffPool = (BufferPoolDB2)((StorageDesignDB2v70)targetDesign).getBufferPoolSet().createElement(null);
                    newBuffPool.setName(this.getBufferPool().getName());
                    newBuffPool.setRawObject(true);
                    tableSpace.setBufferPool(newBuffPool);
                } else {
                    tableSpace.setBufferPool(targetBufferPool);
                }
            }
            tableSpace.setLockSize(this.getLockSize());
            tableSpace.setLockMax(this.getLockMax());
            tableSpace.setClose(this.isClose());
            tableSpace.setCompress(this.isCompress());
            tableSpace.setCcsid(this.getCcsid());
            tableSpace.setLockPart(this.isLockPart());
            tableSpace.setMaxRows(this.getMaxRows());
            tableSpace.recreateUserSet(this.getUserSet().toString());
            tableSpace.setGrantOption(this.getGrantOption());
            tableSpace.setComment(this.getComment());
            tableSpace.setRawObject(false);
        }
    }

    public boolean isUsedInOtherDefinitions(TableProxyDB2 tp) {
        Iterator it = this.getStorageDesign().getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyDB2 table = (TableProxyDB2)it.next();
            if (table.getTableSpace() == null || table == tp || table.getTableSpace() != this) continue;
            return true;
        }
        return false;
    }

    public void synchronizeStorageTemplateName() {
        StorageTemplateDB2 template;
        if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerTableSpace() && (template = this.getStorageTemplate()) != null && !template.isUsedInOtherDefinitions(this)) {
            String namingRule = this.getDesign().getAppView().getSettings().getNamingRuleStTablespaceDB2();
            String tname = ApplyNamingStandards.createTableSpaceStorageTemplateDB2_Name(this.getName(), namingRule, this.getStorageDesign().getPhysicalDesign().getName());
            template.setName(tname);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLESPACE_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        this.partitions.removeAll();
    }

    public PartitionDB2 createPartition() {
        PartitionDB2 part = (PartitionDB2)this.partitions.createElement(null);
        part.setTableSpace(this);
        return part;
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

