/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Iterator;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.VCatPropertyDialogDB2;

public class VCatDB2
extends AbstractStorageObjectDB2
implements ModelObjectSetListener,
StorageObjectListener {
    private StorageObjectCollection storageGroups;
    public static final String TYPE_NAME = "VCat";

    public VCatDB2(StorageDesign storage) {
        this.setStorageDesign(storage);
        this.storageGroups = new StorageObjectCollection(((AbstractStorageDesignDB2)storage).getStorageGroupSet());
        this.storageGroups.setParent(this);
        this.storageGroups.setName(Messages.getString("VCatDB2.StorageGroups"));
        this.storageGroups.setClassForParent(VCatDB2.class);
        this.storageGroups.setSetMethod("setVCat");
        this.storageGroups.setIcon(GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16));
        ((AbstractStorageDesignDB2)storage).getStorageGroupSet().addSetListener(this);
        this.addStorageGroupsFromDesign(((AbstractStorageDesignDB2)storage).getStorageGroupSet());
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof StorageGroupDB2) {
            StorageGroupDB2 group = (StorageGroupDB2)event.getAffected();
            if (group.getVCat() != null && group.getVCat() == this) {
                group.setParent(this.storageGroups);
                this.storageGroups.add(group);
            } else {
                this.storageGroups.remove(group);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof StorageGroupDB2) {
                StorageGroupDB2 group = (StorageGroupDB2)event.getAffected();
                group.addObjectListener(this);
                if (group.getVCat() != null && group.getVCat() == this) {
                    group.setParent(this.storageGroups);
                    this.storageGroups.add(group);
                } else {
                    this.storageGroups.remove(group);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof StorageGroupDB2) {
            StorageGroupDB2 group = (StorageGroupDB2)event.getAffected();
            this.storageGroups.remove(group);
            group.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.storageGroups;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.storageGroups) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.storageGroups) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.storageGroups.removeAll();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "VCAT";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            VCatPropertyDialogDB2 dialog = new VCatPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    private void addStorageGroupsFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            StorageGroupDB2 group = (StorageGroupDB2)it.next();
            if (group.getVCat() != null && group.getVCat() == this) {
                group.setParent(this.storageGroups);
                this.storageGroups.add(group);
                continue;
            }
            this.storageGroups.remove(group);
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        VCatDB2 vCat = null;
        StorageObject stObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getVCatSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                vCat = (VCatDB2)stObject;
            }
        } else {
            vCat = ((AbstractStorageDesignDB2)targetDesign).getVCatSet().createVCat();
        }
        if (vCat != null) {
            vCat.setName(this.getName());
            Iterator it = this.storageGroups.iterator();
            while (it.hasNext()) {
                StorageGroupDB2 stGroup = (StorageGroupDB2)it.next();
                StorageGroupDB2 targetGroup = (StorageGroupDB2)((AbstractStorageDesignDB2)targetDesign).getStorageGroupSet().getByName(stGroup.getName());
                if (targetGroup == null) {
                    StorageGroupDB2 newGroup = ((AbstractStorageDesignDB2)targetDesign).getStorageGroupSet().createStorageGroup();
                    newGroup.setName(stGroup.getName());
                    newGroup.setVCat(vCat);
                    newGroup.setRawObject(true);
                    vCat.addStorageGroupsFromDesign(((AbstractStorageDesignDB2)targetDesign).getStorageGroupSet());
                    continue;
                }
                targetGroup.setVCat(vCat);
                vCat.addStorageGroupsFromDesign(((AbstractStorageDesignDB2)targetDesign).getStorageGroupSet());
            }
            vCat.setComment(this.getComment());
            vCat.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("CATALOG_ICON", 16);
    }
}

