/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v80;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;

public class TableViewProxyDB2v80
extends TableViewProxyDB2 {
    public TableViewProxyDB2v80(TableView view, StorageDesign storage) {
        super(view, storage);
    }

    public TableViewProxyDB2v80(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableView tableView = (TableView)((StorageDesignDB2v80)targetDesign).getPhysicalDesign().getTableViewSet().getByName(this.getObject().getName());
        TableViewProxyDB2v80 tableViewProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignDB2v80)targetDesign).getTableViewProxySet().getProxy(tableView.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            tableViewProxy = (TableViewProxyDB2v80)storageObject;
        }
        if (tableViewProxy != null) {
            tableViewProxy.setName(this.getName());
            Iterator it = this.getSynonyms().iterator();
            while (it.hasNext()) {
                SynonymDB2 synonym = (SynonymDB2)it.next();
                SynonymDB2 targetSynonym = (SynonymDB2)((StorageDesignDB2v80)targetDesign).getSynonymSet().getByName(synonym.getName());
                if (targetSynonym == null) {
                    SynonymDB2 newSynonym = ((StorageDesignDB2v80)targetDesign).getSynonymSet().createSynonym();
                    newSynonym.setName(synonym.getName());
                    newSynonym.setRawObject(true);
                    newSynonym.setView(tableViewProxy);
                    continue;
                }
                targetSynonym.setView(tableViewProxy);
            }
            if (this.getOwner() != null) {
                Owner owner = (Owner)((StorageDesignDB2v80)targetDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (owner == null) {
                    Owner newOwner = (Owner)((StorageDesignDB2v80)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    tableViewProxy.setOwner(newOwner);
                } else {
                    tableViewProxy.setOwner(owner);
                }
            }
            tableViewProxy.setCheckOption(this.getCheckOption());
            tableViewProxy.setCheckOptionScope(this.getCheckOptionScope());
            tableViewProxy.setDefinition(this.getDefinition());
            tableViewProxy.setLabelOn(this.getLabelOn());
            tableViewProxy.setComment(this.getComment());
            tableViewProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            tableViewProxy.setRawObject(false);
        }
    }
}

