/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;

public abstract class CollectionTypeProxyOracle
extends CollectionTypeProxy {
    private UserOracle owner;

    public CollectionTypeProxyOracle(CollectionType structType, StorageDesign storageDesign) {
        super(structType, storageDesign);
    }

    public CollectionTypeProxyOracle(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public void setOwner(UserOracle owner) {
        if (this.owner != owner) {
            this.owner = owner;
            boolean isPredefined = owner.getName().equalsIgnoreCase("MDSYS") || owner.getName().equalsIgnoreCase("SYS") || owner.getName().equalsIgnoreCase("ORDSYS");
            this.getCollectionType().setPredefined(isPredefined);
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public String getType() {
        return ((CollectionType)this.getObject()).getType();
    }

    public String getDataType() {
        return ((CollectionType)this.getObject()).getElementType().getDataType();
    }

    public String getDataType(String rdbms) {
        return ((CollectionType)this.getObject()).getElementType().getDataType(rdbms);
    }

    public int getMaxElement() {
        return ((CollectionType)this.getObject()).getMaxElement();
    }

    public boolean isArrayType(String type) {
        return ((CollectionType)this.getObject()).isArrayType();
    }

    @Override
    public String getLongName() {
        String ownerName;
        if (this.getOwner() != null && (ownerName = this.getOwner().getLongName()).length() > 0) {
            return new StringBuffer(ownerName).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public StorageObject getSchemaOrOwner() {
        return this.getOwner();
    }
}

