/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.DimensionAttributePropertyDialogOraclev9i;

public abstract class DimensionAttributeOracle
extends AbstractStorageObjectOracle {
    private String columns = "";
    private InlineList columnSet = null;
    private LevelOracle level;
    private DimensionOracle dimension;
    public static final String TYPE_NAME = "DimenAttr";
    public static final String OLD_TYPE_NAME = "DimensionAttr";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DimensionAttributePropertyDialogOraclev9i dialog = new DimensionAttributePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Attr";
    }

    private void addColumn(String columnID) {
        if (!this.getColumnSet().contains(columnID)) {
            this.getColumnSet().add(columnID);
        }
    }

    public void recreateColumnSet(String columns) {
        this.getColumnSet().clear();
        StringTokenizer st = new StringTokenizer(columns, ",");
        while (st.hasMoreTokens()) {
            this.getColumnSet().add(st.nextToken().trim());
        }
    }

    public void setColumns(String columns) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnSet(columns);
        } else {
            this.addColumn(columns);
        }
        this.columns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public InlineList getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new InlineList();
        }
        return this.columnSet;
    }

    public void clearColumns() {
        this.getColumnSet().removeAllElements();
        this.columns = "";
    }

    public DimensionOracle getDimension() {
        return this.dimension;
    }

    public void setDimension(DimensionOracle dimension) {
        if (this.dimension != dimension) {
            this.dimension = dimension;
            this.setPAC_Element(dimension);
            this.fireDataFieldChange();
        }
    }

    public LevelOracle getLevel() {
        return this.level;
    }

    public void setLevel(LevelOracle level) {
        this.level = level;
        if (level.getDimension() != null) {
            this.dimension = level.getDimension();
            this.setPAC_Element(this.dimension);
        }
        this.fireDataFieldChange();
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(",");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

