/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class ListPartitionOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    protected PartitionListOracle partitionList;
    protected StorageObjectCollection lobs;
    private String valueList = "";
    private String dataSegmentCompression = "";
    private TableSpaceOracle tablespace;
    private String logging = "";
    private SegmentOracle segment;
    private int position = 0;
    public static final String TYPE_NAME = "ListPartition";

    public ListPartitionOracle(StorageDesign storage) {
        this.setStorageDesign(storage);
        this.lobs = new StorageObjectCollection(((StorageDesignOracle)storage).getLobStorageSet());
        this.lobs.setParent(this);
        this.lobs.setName(Messages.getString("ListPartitionOracle.LobStorages"));
        this.lobs.setClassForParent(ListPartitionOracle.class);
        this.lobs.setSetMethod("setListPartition");
        ((StorageDesignOracle)storage).getLobStorageSet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "LP";
    }

    public void setColumns(String valueList) {
        if (!this.valueList.equals(valueList)) {
            this.valueList = valueList;
            this.fireDataFieldChange();
        }
    }

    public String getColumns() {
        return this.valueList;
    }

    public String getDataSegmentCompression() {
        return this.dataSegmentCompression;
    }

    public void setDataSegmentCompression(String dataSegmentCompression) {
        if (!this.dataSegmentCompression.equals(dataSegmentCompression) && (ConstantsOracle.checkYesNo(dataSegmentCompression) || "".equals(dataSegmentCompression))) {
            this.dataSegmentCompression = dataSegmentCompression;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String logging) {
        if (!this.logging.equals(logging) && (ConstantsOracle.checkYesNo(logging) || "".equals(logging))) {
            this.logging = logging;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segment) {
        if (this.segment != segment) {
            this.segment = segment;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOracle getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(TableSpaceOracle tablespace) {
        if (this.tablespace != tablespace) {
            this.tablespace = tablespace;
            this.fireDataFieldChange();
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        if (this.position != position) {
            this.position = position;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof LobStorageOracle) {
            LobStorageOracle lob = (LobStorageOracle)event.getAffected();
            if (lob.getListPartition() == this) {
                lob.setParent(this.lobs);
                this.lobs.add(lob);
            } else {
                this.lobs.remove(lob);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lob = (LobStorageOracle)event.getAffected();
                lob.addObjectListener(this);
                if (lob.getListPartition() == this) {
                    lob.setParent(this.lobs);
                    this.lobs.add(lob);
                } else {
                    this.lobs.remove(lob);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof LobStorageOracle) {
            LobStorageOracle lob = (LobStorageOracle)event.getAffected();
            this.lobs.remove(lob);
            lob.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.lobs;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.lobs) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.lobs) {
            return 0;
        }
        return -1;
    }

    @Override
    public void clearChildren() {
        this.lobs.removeAll();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public PartitionListOracle getPartitionList() {
        return this.partitionList;
    }

    public void setPartitionList(PartitionListOracle partitionList) {
        if (this.partitionList != partitionList) {
            this.partitionList = partitionList;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        ListPartitionOracle listPart = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOracle)targetDesign).getListPartitionSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                listPart = (ListPartitionOracle)storageObject;
            }
        } else {
            listPart = ((StorageDesignOracle)targetDesign).getListPartitionSet().createListPartition();
        }
        if (listPart != null) {
            listPart.setName(this.getName());
            if (this.getPartitionList() != null) {
                PartitionListOracle partList = (PartitionListOracle)((StorageDesignOracle)targetDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (partList == null) {
                    PartitionListOracle newPartList = ((StorageDesignOracle)targetDesign).getPartitionListSet().createPartitionList();
                    newPartList.setName(this.getPartitionList().getName());
                    newPartList.setRawObject(true);
                    listPart.setPartitionList(newPartList);
                } else {
                    listPart.setPartitionList(partList);
                }
            }
            Iterator it = this.lobs.iterator();
            while (it.hasNext()) {
                LobStorageOracle lob = (LobStorageOracle)it.next();
                LobStorageOracle targetLob = (LobStorageOracle)((StorageDesignOracle)targetDesign).getLobStorageSet().getByName(lob.getName());
                if (targetLob == null) {
                    LobStorageOracle newLob = ((StorageDesignOracle)targetDesign).getLobStorageSet().createLobStorage();
                    newLob.setName(lob.getName());
                    newLob.setRawObject(true);
                    newLob.setListPartition(listPart);
                    continue;
                }
                targetLob.setListPartition(listPart);
            }
            listPart.setColumns(this.getColumns());
            listPart.setDataSegmentCompression(this.getDataSegmentCompression());
            if (this.getTablespace() != null) {
                TableSpaceOracle tablespace = (TableSpaceOracle)((StorageDesignOracle)targetDesign).getTableSpaceSet().getByName(this.getTablespace().getName());
                if (tablespace == null) {
                    TableSpaceOracle newTablespace = ((StorageDesignOracle)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getTablespace().getName());
                    newTablespace.setRawObject(true);
                    listPart.setTablespace(newTablespace);
                } else {
                    listPart.setTablespace(tablespace);
                }
            }
            listPart.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                SegmentOracle segment = (SegmentOracle)((StorageDesignOracle)targetDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (segment == null) {
                    SegmentOracle newSegment = ((StorageDesignOracle)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getSegment().getName());
                    newSegment.setRawObject(true);
                    listPart.setSegment(newSegment);
                } else {
                    listPart.setSegment(segment);
                }
            }
            listPart.setComment(this.getComment());
            listPart.setRawObject(false);
        }
    }

    public StorageObjectCollection getLobStorages() {
        return this.lobs;
    }

    public LobStorageOracle createLobStorage() {
        if (this.lobs.getStorageObjectSet() != null) {
            return (LobStorageOracle)this.lobs.createElement(null);
        }
        return null;
    }

    public List getLocalIndexProperties() {
        ArrayList<LocalIndexProperties> lips = new ArrayList<LocalIndexProperties>();
        Iterator it = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().iterator();
        while (it.hasNext()) {
            LocalIndexProperties lip = (LocalIndexProperties)it.next();
            if (lip.getPartition() != this || lip.getIndex() == null) continue;
            lips.add(lip);
        }
        return lips;
    }

    public LocalIndexProperties createLocalIndexProperties() {
        LocalIndexProperties lip = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().createLocalIndexProperties();
        lip.setPartition(this);
        return lip;
    }

    @Override
    public void setParent(Object parent) {
        RepositoryObject parentObject;
        super.setParent(parent);
        RepositoryObject storableObject = null;
        if (parent instanceof StorageObjectCollection && (storableObject = (parentObject = (RepositoryObject)((StorageObjectCollection)parent).getParent()).getPAC_Element()) == null) {
            storableObject = parentObject;
        }
        this.setPAC_Element(storableObject);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16);
    }
}

