/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.JMenuItem;
import oracle.dbtools.crest.fcp.plSqlSourceEditors.PlSqlSourceURLStreamHandlerFactory;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.DefaultPropertyDialogOracle;

public class PackageOracle
extends PlSqlSourceStorageObjectOracle {
    public static final String TYPE_NAME = "Package";
    protected PackageBodyOracle body;

    public PackageOracle(StorageDesign storageDesign, String id, String name) {
        super(storageDesign, id, name);
    }

    @Override
    public List<JMenuItem> getAdditionalActions() {
        List<JMenuItem> additionalMenuItems = super.getAdditionalActions();
        final PackageOracle packageOracle = this;
        JMenuItem menuItemCreateBody = new JMenuItem(Messages.getString("PackageOracle.CreateBody"));
        menuItemCreateBody.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageOracle.this.body = new PackageBodyOracle(packageOracle);
                PackageOracle.this.body.initSource();
                PackageOracle.this.body.openEditor();
            }
        });
        menuItemCreateBody.setEnabled(this.body == null);
        additionalMenuItems.add(menuItemCreateBody);
        return additionalMenuItems;
    }

    @Override
    protected DefaultPropertyDialogOracle createPropertyDialog() {
        return new DefaultPropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
    }

    @Override
    protected URL getUrl() {
        return PlSqlSourceURLStreamHandlerFactory.generateUrl("file", this);
    }

    @Override
    public boolean setName(String name) {
        boolean result = super.setName(name);
        if (result && this.body != null) {
            this.body.setName(name);
        }
        return result;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public void setBody(PackageBodyOracle packageBody) {
        this.body = packageBody;
        this.getStorageDesign().setDirty(true);
    }

    public PackageBodyOracle getBody() {
        return this.body;
    }

    public PackageBodyOracle createBody() {
        this.body = new PackageBodyOracle(this);
        this.setBody(this.body);
        return this.body;
    }

    public void clearBody() {
        if (this.body != null) {
            this.body.remove();
        }
    }

    @Override
    public ModelObject getChild(int index) {
        if (index == 0) {
            return this.body;
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.body) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.body) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return this.body == null;
    }

    @Override
    public int getNumberOfChildren() {
        return this.body == null ? 0 : 1;
    }

    @Override
    public void remove() {
        if (this.body != null) {
            this.body.remove();
        }
        super.remove();
    }

    @Override
    public void remove(boolean force) {
        if (this.body != null) {
            this.body.remove(force);
        }
        super.remove(force);
    }

    public void setBodySource(String source) {
        if (source != null && this.body == null) {
            this.body = this.createBody();
        }
        if (this.body != null) {
            this.body.setSource(source);
        }
    }

    public String getBodySource() {
        return this.body != null ? this.body.getSource() : null;
    }

    @Override
    public void setOwner(UserOracle owner) {
        super.setOwner(owner);
        if (this.body != null) {
            this.body.setOwner(owner);
        }
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDataObject() {
        return false;
    }
}

