/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;

public abstract class PermissionsOracle
extends AbstractStorageObjectOracle
implements OwnedObjectOracle {
    private static final String[] TABLE_PRIVS_FOR_USER = new String[]{"ALL PRIVILEGES", "ALTER", "DELETE", "INDEX", "INSERT", "REFERENCES", "SELECT", "UPDATE", "DEBUG"};
    private static final String[] TABLE_PRIVS_FOR_ROLE = new String[]{"ALL PRIVILEGES", "ALTER", "DELETE", "INDEX", "INSERT", "SELECT", "UPDATE", "DEBUG"};
    private static final String[] VIEW_PRIVILEGES = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "REFERENCES", "SELECT", "UPDATE", "MERGE VIEW", "DEBUG", "UNDER"};
    private static final String[] SEQ_PRIVILEGES = new String[]{"ALL PRIVILEGES", "ALTER", "SELECT", "KEEP SEQUENCE"};
    private static final String[] SNAPSHOT_PRIVILEGES = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "SELECT", "UPDATE", "ON COMMIT REFRESH", "QUERY REWRITE"};
    private static final String[] PROCEDURE_PRIVILEGES = new String[]{"ALL PRIVILEGES", "EXECUTE", "DEBUG"};
    private static final String[] COLUMNS_PRIVILEGES = new String[]{"ALL PRIVILEGES", "INSERT", "UPDATE", "REFERENCES"};
    private static final String[] PACKAGE_PRIVILEGES = new String[]{"ALL PRIVILEGES", "EXECUTE", "DEBUG"};
    private static final String[] DIRECTORY_PRIVILEGES = new String[]{"ALL PRIVILEGES", "READ", "WRITE", "EXECUTE"};
    private static final String[] ST_PRIVILEGES = new String[]{"ALL PRIVILEGES", "EXECUTE", "DEBUG", "UNDER"};
    private static final String[] CT_PRIVILEGES = new String[]{"ALL PRIVILEGES", "EXECUTE", "DEBUG"};
    private static final String[] EXT_TAB_PRIVILEGES = new String[]{"ALL PRIVILEGES", "ALTER", "SELECT"};
    protected PermissionsSet privilegesSet = null;
    protected PermissionsSet privilegesWithGrantOptionSet = null;
    protected PermissionsSet privilegesWithHierarchyOptionSet = null;
    protected TableProxyOracle table = null;
    protected TableViewProxyOracle view = null;
    protected SequenceOracle sequence = null;
    protected SnapshotOracle snapshot = null;
    protected StoredProcedureOracle proc = null;
    protected PackageOracle packageOracle = null;
    protected FunctionOracle functionOracle = null;
    protected DirectoryOracle directoryOracle = null;
    protected StructuredTypeProxyOracle structuredTypeOracle = null;
    protected CollectionTypeProxyOracle collectionTypeOracle = null;
    protected ExternalTableOracle externalTableOracle = null;
    protected TableProxyOracle columnsTable = null;
    protected String privileges = "";
    protected String privilegesWithGrantOption = "";
    protected String privilegesWithHierarchyOption = "";
    protected String columnList = "";
    protected String columnWithGrantOptionList = "";
    protected String isPublic = "NO";
    protected UserOracle user;
    protected RoleOracle role;
    public static final String TYPE_NAME = "Permissions";

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setTable(TableProxyOracle table) {
        this.table = table;
        if (table != null) {
            this.view = null;
            this.sequence = null;
            this.proc = null;
            this.snapshot = null;
        }
        this.fireDataFieldChange();
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setView(TableViewProxyOracle view) {
        this.view = view;
        if (view != null) {
            this.table = null;
            this.sequence = null;
            this.proc = null;
            this.snapshot = null;
        }
        this.fireDataFieldChange();
    }

    public TableViewProxyOracle getView() {
        return this.view;
    }

    public StoredProcedureOracle getProc() {
        return this.proc;
    }

    public void setProc(StoredProcedureOracle proc) {
        this.proc = proc;
        if (proc != null) {
            this.table = null;
            this.view = null;
            this.sequence = null;
            this.snapshot = null;
        }
        this.fireDataFieldChange();
    }

    public PackageOracle getPackage() {
        return this.packageOracle;
    }

    public void setPackage(PackageOracle packageOracle) {
        this.packageOracle = packageOracle;
        this.fireDataFieldChange();
    }

    public FunctionOracle getFunctionOracle() {
        return this.functionOracle;
    }

    public void setFunctionOracle(FunctionOracle functionOracle) {
        this.functionOracle = functionOracle;
        this.fireDataFieldChange();
    }

    public DirectoryOracle getDirectoryOracle() {
        return this.directoryOracle;
    }

    public void setDirectoryOracle(DirectoryOracle directoryOracle) {
        this.directoryOracle = directoryOracle;
        this.fireDataFieldChange();
    }

    public StructuredTypeProxyOracle getStructuredTypeOracle() {
        return this.structuredTypeOracle;
    }

    public void setStructuredTypeOracle(StructuredTypeProxyOracle structuredTypeOracle) {
        this.structuredTypeOracle = structuredTypeOracle;
        this.fireDataFieldChange();
    }

    public CollectionTypeProxyOracle getCollectionTypeOracle() {
        return this.collectionTypeOracle;
    }

    public void setCollectionTypeOracle(CollectionTypeProxyOracle collectionTypeOracle) {
        this.collectionTypeOracle = collectionTypeOracle;
        this.fireDataFieldChange();
    }

    public ExternalTableOracle getExternalTableOracle() {
        return this.externalTableOracle;
    }

    public void setExternalTableOracle(ExternalTableOracle externalTableOracle) {
        this.externalTableOracle = externalTableOracle;
        this.fireDataFieldChange();
    }

    public SnapshotOracle getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(SnapshotOracle snapshot) {
        this.snapshot = snapshot;
        if (snapshot != null) {
            this.table = null;
            this.view = null;
            this.sequence = null;
            this.proc = null;
        }
        this.fireDataFieldChange();
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public String getPrivilegesWithGrantOption() {
        return this.privilegesWithGrantOption;
    }

    public String getPrivilegesWithHierarchyOption() {
        return this.privilegesWithHierarchyOption;
    }

    public String getColumnList() {
        return this.columnList;
    }

    public String getColumnWithGrantOptionList() {
        return this.columnWithGrantOptionList;
    }

    public void setSequence(SequenceOracle sequence) {
        this.sequence = sequence;
        if (sequence != null) {
            this.view = null;
            this.table = null;
            this.proc = null;
            this.snapshot = null;
        }
        this.fireDataFieldChange();
    }

    public SequenceOracle getSequence() {
        return this.sequence;
    }

    protected void addPrivilege(String privilege) {
        if (!this.getPrivilegesSet().contains(privilege)) {
            this.getPrivilegesSet().add(privilege);
            this.getPrivilegesWithGrantOptionSet().remove(privilege);
        }
    }

    protected void addPrivilegeWithGrantOption(String privilege) {
        if (!this.getPrivilegesWithGrantOptionSet().contains(privilege)) {
            this.getPrivilegesWithGrantOptionSet().add(privilege);
            this.getPrivilegesSet().remove(privilege);
        }
    }

    protected void addPrivilegeWithHierarchyOption(String privilege) {
        if (!this.getPrivilegesWithHierarchyOptionSet().contains(privilege)) {
            this.getPrivilegesWithHierarchyOptionSet().add(privilege);
            this.getPrivilegesSet().remove(privilege);
        }
    }

    public void addColumn(String column) {
        if (!this.columnList.trim().equalsIgnoreCase("")) {
            this.columnList = this.columnList + "|";
        }
        this.columnList = this.columnList + column;
    }

    public void addColumnWithGrantOption(String column) {
        if (!this.columnWithGrantOptionList.trim().equalsIgnoreCase("")) {
            this.columnWithGrantOptionList = this.columnWithGrantOptionList + "|";
        }
        this.columnWithGrantOptionList = this.columnWithGrantOptionList + column;
    }

    public abstract void setPrivileges(String var1);

    public void setPrivilegesWithGrantOption(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithGrantOptionSet(privilege);
        } else {
            this.addPrivilegeWithGrantOption(privilege);
        }
        this.privilegesWithGrantOption = this.getPrivilegesWithGrantOptionSet().toString();
        this.privileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public void setPrivilegesWithHierarchyOption(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithHierarchyOptionSet(privilege);
        } else {
            this.addPrivilegeWithHierarchyOption(privilege);
        }
        this.privilegesWithHierarchyOption = this.getPrivilegesWithHierarchyOptionSet().toString();
        this.privileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    protected void recreatePrivilegesSet(String privs) {
        this.getPrivilegesSet().clear();
        StringTokenizer st = new StringTokenizer(privs, ",");
        while (st.hasMoreTokens()) {
            this.getPrivilegesSet().add(st.nextToken().trim());
        }
    }

    protected void recreatePrivilegesWithGrantOptionSet(String privs) {
        this.getPrivilegesWithGrantOptionSet().clear();
        StringTokenizer st = new StringTokenizer(privs, ",");
        while (st.hasMoreTokens()) {
            this.getPrivilegesWithGrantOptionSet().add(st.nextToken().trim());
        }
    }

    protected void recreatePrivilegesWithHierarchyOptionSet(String privs) {
        this.getPrivilegesWithHierarchyOptionSet().clear();
        StringTokenizer st = new StringTokenizer(privs, ",");
        while (st.hasMoreTokens()) {
            this.getPrivilegesWithHierarchyOptionSet().add(st.nextToken().trim());
        }
    }

    private void recreateColumnList(String columns) {
        this.columnList = columns;
    }

    private void recreateColumnWithGranOptionList(String columns) {
        this.columnWithGrantOptionList = columns;
    }

    public void setColumnList(String column) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnList(column);
        } else {
            this.addColumn(column);
        }
        this.fireDataFieldChange();
    }

    public void setColumnListWithGrantOption(String column) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnWithGranOptionList(column);
        } else {
            this.addColumnWithGrantOption(column);
        }
        this.fireDataFieldChange();
    }

    public static String[] getTablePrivilegesForUser() {
        return TABLE_PRIVS_FOR_USER;
    }

    public static String[] getTablePrivilegesForRole() {
        return TABLE_PRIVS_FOR_ROLE;
    }

    public static String[] getViewPrivilegesValues() {
        return VIEW_PRIVILEGES;
    }

    public static String[] getSeqPrivilegesValues() {
        return SEQ_PRIVILEGES;
    }

    public static String[] getSnapshotPrivilegesValues() {
        return SNAPSHOT_PRIVILEGES;
    }

    public static String[] getProcedurePrivilegesValues() {
        return PROCEDURE_PRIVILEGES;
    }

    public static String[] getPackagePrivilegesValues() {
        return PACKAGE_PRIVILEGES;
    }

    public static String[] getDirectoryPrivilegesValues() {
        return DIRECTORY_PRIVILEGES;
    }

    public static String[] getStructuredTypePrivilegesValues() {
        return ST_PRIVILEGES;
    }

    public static String[] getCollectionTypePrivilegesValues() {
        return CT_PRIVILEGES;
    }

    public static String[] getExtTablesPrivilegesValues() {
        return EXT_TAB_PRIVILEGES;
    }

    public void setPublic(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.isPublic = value;
            this.fireDataFieldChange();
        }
    }

    public String getPublic() {
        return this.isPublic;
    }

    public PermissionsSet getPrivilegesSet() {
        if (this.privilegesSet == null) {
            this.privilegesSet = new PermissionsSet();
        }
        return this.privilegesSet;
    }

    public PermissionsSet getPrivilegesWithGrantOptionSet() {
        if (this.privilegesWithGrantOptionSet == null) {
            this.privilegesWithGrantOptionSet = new PermissionsSet();
        }
        return this.privilegesWithGrantOptionSet;
    }

    public PermissionsSet getPrivilegesWithHierarchyOptionSet() {
        if (this.privilegesWithHierarchyOptionSet == null) {
            this.privilegesWithHierarchyOptionSet = new PermissionsSet();
        }
        return this.privilegesWithHierarchyOptionSet;
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.getPrivilegesWithGrantOptionSet().removeAllElements();
        this.getPrivilegesWithHierarchyOptionSet().removeAllElements();
        this.privileges = "";
        this.privilegesWithGrantOption = "";
        this.privilegesWithHierarchyOption = "";
    }

    public void clearColPermissions() {
        this.columnList = "";
        this.columnWithGrantOptionList = "";
    }

    public RoleOracle getRole() {
        return this.role;
    }

    public void setRole(RoleOracle role) {
        if (this.role != role) {
            this.role = role;
            if (role != null) {
                this.setPAC_Element(role);
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        if (this.user != user) {
            this.user = user;
            if (user != null) {
                this.setPAC_Element(user);
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public static String[] getColumnPermissionsValues() {
        return COLUMNS_PRIVILEGES;
    }

    public String getPrivs(ColumnProxyOracle col) {
        return this.getPrivs(col.getName());
    }

    public String getPrivs(String cname) {
        StringTokenizer st = new StringTokenizer(this.getColumnList(), "|");
        String privs = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String[] parts = token.split(",");
            if (!cname.equalsIgnoreCase(parts[0])) continue;
            if (privs.length() > 0) {
                privs = privs + "," + parts[1];
                continue;
            }
            privs = parts[1];
        }
        return privs.trim();
    }

    public String getPrivsWithGrantOption(String cname) {
        StringTokenizer st = new StringTokenizer(this.getColumnWithGrantOptionList(), "|");
        String privs = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String[] parts = token.split(",");
            if (!cname.equalsIgnoreCase(parts[0])) continue;
            if (privs.length() > 0) {
                privs = privs + "," + parts[1];
                continue;
            }
            privs = parts[1];
        }
        return privs.trim();
    }

    public String getPrivsWithGrantOption(ColumnProxyOracle col) {
        return this.getPrivsWithGrantOption(col.getName());
    }

    public ArrayList getColumns() {
        ArrayList<String> cols = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.getColumnList(), "|");
        while (st.hasMoreTokens()) {
            String col = st.nextToken();
            if (col.indexOf(44) > -1) {
                col = col.substring(0, col.indexOf(44));
            }
            if (cols.contains(col)) continue;
            cols.add(col);
        }
        return cols;
    }

    public ArrayList getColumnsWithGrantOption() {
        ArrayList<String> cols = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.getColumnWithGrantOptionList(), "|");
        while (st.hasMoreTokens()) {
            String col = st.nextToken();
            if (col.indexOf(44) > -1) {
                col = col.substring(0, col.indexOf(44));
            }
            if (cols.contains(col)) continue;
            cols.add(col);
        }
        return cols;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public TableProxyOracle getColumnsTable() {
        return this.columnsTable;
    }

    public void setColumnsTable(TableProxyOracle columnsTable) {
        this.columnsTable = columnsTable;
        this.table = null;
        this.view = null;
        this.sequence = null;
        this.proc = null;
        this.snapshot = null;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        if (id == null) {
            return null;
        }
        StorageObject result = this.getStorageDesign().getStorageObject(id);
        if (result == null) {
            ModelIDObject obj;
            String newID = null;
            Map map = this.getStorageDesign().getCorrespondenceMap();
            if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
                newID = obj.getObjectID();
                result = this.getStorageDesign().getStorageObject(newID);
            }
        }
        if (result != null) {
            PackageOracle pkg;
            if ("package".equals(propertyName) && result instanceof PackageBodyOracle && id.equals((pkg = ((PackageBodyOracle)result).getPackageOracle()).getObjectID())) {
                result = pkg;
            }
            return result;
        }
        if (!("table".equals(propertyName) || "view".equals(propertyName) || "columnsTable".equals(propertyName))) {
            return super.translateIdToObject(propertyName, id);
        }
        return null;
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object one, Object two) {
            return String.valueOf(one).compareTo(String.valueOf(two));
        }
    }

    public class PermissionsSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

