/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.SegmentPropertyDialogOraclev9i;

public abstract class SegmentOracle
extends AbstractStorageObjectOracle {
    private static final String[] SC_BUFFER_POOL = new String[]{"DEFAULT", "RECYCLE", "KEEP"};
    public static final String UNLIMITED = "UNLIMITED";
    private TableSpaceOracle tableSpace = null;
    private int pctFree = 10;
    private int pctUsed = 40;
    private int initrans = 1;
    private int maxtrans = 1;
    private long scInitialExtent = 0L;
    private long scNextExtent = 0L;
    private int scMinExtents = 1;
    private String scMaxExtents = "UNLIMITED";
    private int scPctIncrease = 0;
    private static Set scBufferPoolSet = null;
    private String scBufferPool = SC_BUFFER_POOL[0];
    private int scFreeLists = 1;
    private int scFreelistGroups = 1;
    private boolean currentlyUsed = true;
    public static final String TYPE_NAME = "Segment";

    @Override
    public String getIDPrefix() {
        return "Storage";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        if (this.tableSpace != tableSpace) {
            this.tableSpace = tableSpace;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public int getPCTFree() {
        return this.pctFree;
    }

    public void setPCTFree(int pctFree) {
        if (pctFree >= 0 && pctFree <= 99) {
            this.pctFree = pctFree;
        }
    }

    public int getPCTUsed() {
        return this.pctUsed;
    }

    public void setPCTUsed(int pctUsed) {
        if (pctUsed >= 0 && pctUsed <= 99) {
            this.pctUsed = pctUsed;
        }
    }

    public int getInitrans() {
        return this.initrans;
    }

    public void setInitrans(int initrans) {
        if (initrans >= 1 && initrans <= 255) {
            this.initrans = initrans;
        }
    }

    public int getMaxTrans() {
        return this.maxtrans;
    }

    public void setMaxTrans(int maxtrans) {
        if (maxtrans >= 1 && maxtrans <= 255) {
            this.maxtrans = maxtrans;
        } else if (this instanceof SegmentOraclev10g) {
            this.maxtrans = 255;
        }
    }

    public long getSCInitialExtent() {
        return this.scInitialExtent;
    }

    public void setSCInitialExtent(long scInitialExtent) {
        this.scInitialExtent = scInitialExtent;
    }

    public long getSCNextExtent() {
        return this.scNextExtent;
    }

    public void setSCNextExtent(long scNextExtent) {
        this.scNextExtent = scNextExtent;
    }

    public int getSCMinExtents() {
        return this.scMinExtents;
    }

    public void setSCMinExtents(int scMinExtents) {
        if (scMinExtents >= 1) {
            this.scMinExtents = scMinExtents;
        }
    }

    public String getSCMaxExtents() {
        return this.scMaxExtents;
    }

    public void setSCMaxExtents(String scMaxExtents) {
        try {
            this.scMaxExtents = Integer.parseInt(scMaxExtents) > 0 ? scMaxExtents : UNLIMITED;
        }
        catch (NumberFormatException E) {
            this.scMaxExtents = UNLIMITED;
        }
    }

    public int getSCPctIncrease() {
        return this.scPctIncrease;
    }

    public void setSCPctIncrease(int scPctIncrease) {
        this.scPctIncrease = scPctIncrease;
    }

    public static String[] getSCBufferPoolValues() {
        return SC_BUFFER_POOL;
    }

    protected boolean checkSCBufferPoolValue(String value) {
        if (scBufferPoolSet == null) {
            scBufferPoolSet = new HashSet();
            scBufferPoolSet.addAll(Arrays.asList(SegmentOracle.getSCBufferPoolValues()));
        }
        return scBufferPoolSet.contains(value);
    }

    public void setSCBufferPool(String value) {
        if (this.checkSCBufferPoolValue(value)) {
            this.scBufferPool = value;
            this.fireDataFieldChange();
        }
    }

    public String getSCBufferPool() {
        return this.scBufferPool;
    }

    public int getSCFreeLists() {
        return this.scFreeLists;
    }

    public void setSCFreeLists(int scFreeLists) {
        if (scFreeLists >= 1) {
            this.scFreeLists = scFreeLists;
        }
    }

    public int getSCFreelistGroups() {
        return this.scFreelistGroups;
    }

    public void setSCFreelistGroups(int scFreelistGroups) {
        if (scFreelistGroups >= 1) {
            this.scFreelistGroups = scFreelistGroups;
        }
    }

    public boolean isCurrentlyUsed() {
        return this.currentlyUsed;
    }

    public void setCurrentlyUsed(boolean used) {
        this.currentlyUsed = used;
    }

    public void updateCurrentlyUsed() {
        int i;
        boolean used = false;
        Object[] objs = this.getStorageDesign().getTableProxySet().toArray();
        for (i = 0; i < objs.length; ++i) {
            if (((TableProxyOracle)objs[i]).getSegment() != this) continue;
            used = true;
            break;
        }
        if (!used) {
            objs = this.getStorageDesign().getIndexProxySet().toArray();
            for (i = 0; i < objs.length; ++i) {
                if (((IndexProxyOracle)objs[i]).getSegment() != this) continue;
                used = true;
                break;
            }
        }
        if (!used) {
            objs = ((StorageDesignOracle)this.getStorageDesign()).getSnapshotSet().toArray();
            for (i = 0; i < objs.length; ++i) {
                if (((SnapshotOracle)objs[i]).getSegment() != this) continue;
                used = true;
                break;
            }
        }
        if (!used) {
            objs = ((StorageDesignOracle)this.getStorageDesign()).getClusterSet().toArray();
            for (i = 0; i < objs.length; ++i) {
                if (((ClusterOracle)objs[i]).getSegment() != this) continue;
                used = true;
                break;
            }
        }
        this.setCurrentlyUsed(used);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SegmentPropertyDialogOraclev9i dialog = new SegmentPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        this.getCopy(targetDesign);
    }

    public abstract SegmentOracle getCopy(StorageDesign var1);

    private boolean equalStrings(String s1, String s2) {
        return s1.equalsIgnoreCase(s2);
    }

    public boolean isEqualTo(SegmentOracle segment) {
        if (segment == null) {
            return false;
        }
        if (segment.getPCTFree() != this.getPCTFree()) {
            return false;
        }
        if (segment.getPCTUsed() != this.getPCTUsed()) {
            return false;
        }
        if (segment.getInitrans() != this.getInitrans()) {
            return false;
        }
        if (segment.getMaxTrans() != this.getMaxTrans()) {
            return false;
        }
        if (segment.getSCInitialExtent() != this.getSCInitialExtent()) {
            return false;
        }
        if (segment.getSCNextExtent() != this.getSCNextExtent()) {
            return false;
        }
        if (segment.getSCMinExtents() != this.getSCMinExtents()) {
            return false;
        }
        if (!this.equalStrings(segment.getSCMaxExtents(), this.getSCMaxExtents())) {
            return false;
        }
        if (segment.getSCPctIncrease() != this.getSCPctIncrease()) {
            return false;
        }
        if (!this.equalStrings(segment.getSCBufferPool(), this.getSCBufferPool())) {
            return false;
        }
        if (segment.getSCFreeLists() != this.getSCFreeLists()) {
            return false;
        }
        return segment.getSCFreelistGroups() == this.getSCFreelistGroups();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SEGMENT_ICON", 16);
    }
}

