/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SequenceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public abstract class SequenceOracle
extends AbstractStorageObjectOracle
implements PropertiesPropagator,
OwnedObjectOracle {
    private UserOracle user = null;
    private String startWith = "";
    private String incrementBy = "";
    private String maxValue = "";
    private String minValue = "";
    private String cycle = "NO";
    private String noCache = "NO";
    private String cache = "";
    private String order = "NO";
    private String session = "NO";
    private List propertyWrapperList = null;
    public static final String TYPE_NAME = "Sequence";

    public SequenceOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        this.user = user;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public String getStartWith() {
        return this.startWith;
    }

    public void setStartWith(String startWith) {
        this.startWith = startWith;
        this.fireDataFieldChange();
    }

    public String getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(String incrementBy) {
        this.incrementBy = incrementBy;
        this.fireDataFieldChange();
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
        this.fireDataFieldChange();
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
        this.fireDataFieldChange();
    }

    public void setCycle(String cycle) {
        if (ConstantsOracle.checkYesNo(cycle)) {
            this.cycle = cycle;
            this.fireDataFieldChange();
        }
    }

    public String getCycle() {
        return this.cycle;
    }

    public String getNoCache() {
        return this.noCache;
    }

    public void setNoCache(String noCache) {
        if (ConstantsOracle.checkYesNo(noCache)) {
            this.noCache = noCache;
            this.fireDataFieldChange();
        }
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
        this.fireDataFieldChange();
    }

    public void setOrder(String order) {
        if (ConstantsOracle.checkYesNo(order)) {
            this.order = order;
            this.fireDataFieldChange();
        }
    }

    public String getOrder() {
        return this.order;
    }

    public void setSession(String session) {
        if (ConstantsOracle.checkYesNo(session)) {
            this.session = session;
        }
    }

    public String getSession() {
        return this.session;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && !"".equals(this.getUser().getLongName())) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getUser() != null) {
            name = this.getUser().getLongName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.USER_NAME, this, "getUser", "setUser", UserOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.START_WITH, this, "getStartWith", "setStartWith", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.INCREMENT_BY, this, "getIncrementBy", "setIncrementBy", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.MIN_VALUE, this, "getMinValue", "setMinValue", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.MAX_VALUE, this, "getMaxValue", "setMaxValue", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.CYCLE, this, "getCycle", "setCycle", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.NOCACHE, this, "getNoCache", "setNoCache", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.CACHE, this, "getCache", "setCache", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.ORDER, this, "getOrder", "setOrder", String.class));
            if (this.getStorageDesign() instanceof StorageDesignOraclev12c) {
                this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.SESSION, this, "getSession", "setSession", String.class));
            }
        }
        return this.propertyWrapperList;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SEQUENCE_ICON", 16);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        SequenceOraclev10g sequence = null;
        StorageObject stObject = (StorageObject)((StorageDesignOracle)targetDesign).getSequenceSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                sequence = (SequenceOraclev10g)stObject;
            }
        } else {
            sequence = (SequenceOraclev10g)((StorageDesignOracle)targetDesign).getSequenceSet().createSequence();
        }
        if (sequence != null) {
            sequence.setName(this.getName());
            if (this.getUser() != null) {
                UserOracle user = (UserOracle)((StorageDesignOracle)targetDesign).getUserSet().getByName(this.getUser().getName());
                if (user == null) {
                    UserOracle newUser = ((StorageDesignOracle)targetDesign).getUserSet().createUser();
                    newUser.setName(this.getUser().getName());
                    newUser.setRawObject(true);
                    sequence.setUser(newUser);
                } else {
                    sequence.setUser(user);
                }
            }
            sequence.setStartWith(this.getStartWith());
            sequence.setIncrementBy(this.getIncrementBy());
            sequence.setMaxValue(this.getMaxValue());
            sequence.setMinValue(this.getMinValue());
            sequence.setCycle(this.getCycle());
            sequence.setNoCache(this.getNoCache());
            sequence.setCache(this.getCache());
            sequence.setOrder(this.getOrder());
            sequence.setSession(this.getSession());
            sequence.setComment(this.getComment());
            sequence.setRawObject(false);
        }
    }

    public void copy(SequenceOracle targetSequence) {
        if (targetSequence != null) {
            StorageDesign targetDesign = targetSequence.getStorageDesign();
            targetSequence.setName(this.getName());
            targetSequence.setNameHasQuotes(this.getNameHasQuotes());
            if (this.getUser() != null) {
                UserOracle user = (UserOracle)((StorageDesignOracle)targetDesign).getUserSet().getByName(this.getUser().getName());
                if (user == null) {
                    UserOracle newUser = ((StorageDesignOracle)targetDesign).getUserSet().createUser();
                    newUser.setName(this.getUser().getName());
                    newUser.setRawObject(true);
                    targetSequence.setUser(newUser);
                } else {
                    targetSequence.setUser(user);
                }
            }
            targetSequence.setStartWith(this.getStartWith());
            targetSequence.setIncrementBy(this.getIncrementBy());
            targetSequence.setMaxValue(this.getMaxValue());
            targetSequence.setMinValue(this.getMinValue());
            targetSequence.setCycle(this.getCycle());
            targetSequence.setNoCache(this.getNoCache());
            targetSequence.setCache(this.getCache());
            targetSequence.setOrder(this.getOrder());
            targetSequence.setSession(this.getSession());
            targetSequence.setComment(this.getComment());
            targetSequence.setRawObject(false);
        }
    }
}

