/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public abstract class SnapshotOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener,
PropertiesPropagator,
OwnedObjectOracle {
    private DesignObject object = null;
    private UserOracle user = null;
    protected StorageObjectCollection partitions;
    protected StorageObjectCollection lobs;
    private PartitionListOracle partitionList = null;
    private String partType = "";
    private String subpartType = "";
    private SegmentOracle segment;
    private LobStorageOracle lobStorage;
    private ClusterOracle cluster;
    private String partitioned = "NO";
    private String paralelClause = "NO";
    private int degree = 0;
    private String build = "IMMEDIATE";
    private String reducedPrecision = "NO";
    private TableProxyOracle onPrebuildTable;
    private String useIndex = "NONE";
    private SegmentOracle indexSegment;
    private String forUpdate = "NO";
    private String queryRewrite = "DISABLE";
    private String refresh = "NONE";
    private String refreshType = "FORCE";
    private String action = "";
    private String startDate = "";
    private String nextDate = "";
    private String with = "";
    private String defaultSegment = "NO";
    private String segmentType = "LOCAL";
    private RollbackSegmentOracle rollbackSegment;
    public static final String IMMEDIATE = "IMMEDIATE";
    public static final String DEFERRED = "DEFERRED";
    public static final String[] BUILD_STATES = new String[]{"IMMEDIATE", "DEFERRED"};
    private static Set buildSet = null;
    public static final String DISABLE = "DISABLE";
    public static final String ENABLE = "ENABLE";
    public static final String[] QUERY_REWRITE_STATES = new String[]{"DISABLE", "ENABLE"};
    private static Set queryRewriteSet = null;
    public static final String NEVER = "NEVER";
    public static final String[] REFRESH_STATES = new String[]{"NONE", "YES", "NEVER"};
    private static Set refreshSet = null;
    public static final String FAST = "FAST";
    public static final String COMPLETE = "COMPLETE";
    public static final String FORCE = "FORCE";
    public static final String[] REFRESH_TYPE_STATES = new String[]{"FAST", "COMPLETE", "FORCE"};
    private static Set refreshTypeSet = null;
    public static final String ON_DEMAND = "ON DEMAND";
    public static final String ON_COMMIT = "ON COMMIT";
    public static final String[] ACTION_STATES = new String[]{"", "ON DEMAND", "ON COMMIT"};
    private static Set actionSet = null;
    public static final String PRIMARY_KEY = "PRIMARY KEY";
    public static final String ROWID = "ROWID";
    public static final String[] WITH_STATES = new String[]{"", "PRIMARY KEY", "ROWID"};
    private static Set withSet = null;
    public static final String MASTER = "MASTER";
    public static final String LOCAL = "LOCAL";
    public static final String[] SEGMENT_TYPE_STATES = new String[]{"MASTER", "LOCAL"};
    private static Set segmentTypeSet = null;
    private String subquery = "";
    private String columns = "";
    private String subPartColumns = "";
    private TableSpaceOracle tablespace;
    private TableSpaceOracle indexTablespace;
    private String logging = "NONE";
    private String cache = "NONE";
    private String clusterColumns = "";
    protected String commentInRdbms = "";
    protected String alias = "";
    private List propertyWrapperList = null;
    public static final String TYPE_NAME = "Snapshot";

    public SnapshotOracle(StorageDesign storage) {
        this.setStorageDesign(storage);
        this.partitions = new StorageObjectCollection(((StorageDesignOracle)storage).getPartitionSet());
        this.partitions.setParent(this);
        this.partitions.setName(Messages.getString("SnapshotOracle.Partitions"));
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.setClassForParent(PartitionListOracle.class);
        this.partitions.setSetMethod("setPartitionList");
        this.partitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        ((StorageDesignOracle)storage).getPartitionSet().addSetListener(this);
        ((StorageDesignOracle)storage).getHashPartitionSet().addSetListener(this);
        ((StorageDesignOracle)storage).getListPartitionSet().addSetListener(this);
        this.lobs = new StorageObjectCollection(((StorageDesignOracle)storage).getLobStorageSet());
        this.lobs.setParent(this);
        this.lobs.setName(Messages.getString("SnapshotOracle.LobStorages"));
        this.lobs.setClassForParent(SnapshotOracle.class);
        this.lobs.setSetMethod("setSnapshot");
        ((StorageDesignOracle)storage).getLobStorageSet().addSetListener(this);
    }

    public DesignObject getObject() {
        return this.object;
    }

    public void setObject(DesignObject object) {
        this.object = object;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public UserOracle getUser() {
        TableProxyOracle tp = this.getOnPrebuildTable();
        if (tp != null) {
            return tp.getUser();
        }
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        this.user = user;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public String getLongName() {
        TableProxyOracle tp = this.getOnPrebuildTable();
        if (tp != null) {
            return ((RelationalObjectProxy)tp).getLongName();
        }
        if (this.getUser() != null) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        TableProxyOracle implementedTableProxy = this.getImplementedTable();
        if (implementedTableProxy != null && implementedTableProxy.getName().equals(this.getName())) {
            return implementedTableProxy.getLongName();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getUser() != null) {
            name = this.getUser().getLongName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof PartitionOracle) {
            PartitionOracle part = (PartitionOracle)event.getAffected();
            if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                part.setParent(this.partitions);
                this.partitions.add(part);
            } else {
                this.partitions.remove(part);
            }
        } else if (event.getAffected() instanceof HashPartitionOracle) {
            HashPartitionOracle part = (HashPartitionOracle)event.getAffected();
            if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                part.setParent(this.partitions);
                this.partitions.add(part);
            } else {
                this.partitions.remove(part);
            }
        } else if (event.getAffected() instanceof ListPartitionOracle) {
            ListPartitionOracle part = (ListPartitionOracle)event.getAffected();
            if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                part.setParent(this.partitions);
                this.partitions.add(part);
            } else {
                this.partitions.remove(part);
            }
        } else if (event.getAffected() instanceof LobStorageOracle) {
            LobStorageOracle lob = (LobStorageOracle)event.getAffected();
            if (lob.getSnapshot() == this) {
                lob.setParent(this.lobs);
                this.lobs.add(lob);
            } else {
                this.lobs.remove(lob);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof PartitionOracle) {
                PartitionOracle part = (PartitionOracle)event.getAffected();
                part.addObjectListener(this);
                if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                    part.setParent(this.partitions);
                    this.partitions.add(part);
                } else {
                    this.partitions.remove(part);
                }
            } else if (event.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle part = (HashPartitionOracle)event.getAffected();
                part.addObjectListener(this);
                if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                    part.setParent(this.partitions);
                    this.partitions.add(part);
                } else {
                    this.partitions.remove(part);
                }
            } else if (event.getAffected() instanceof ListPartitionOracle) {
                ListPartitionOracle part = (ListPartitionOracle)event.getAffected();
                part.addObjectListener(this);
                if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                    part.setParent(this.partitions);
                    this.partitions.add(part);
                } else {
                    this.partitions.remove(part);
                }
            } else if (event.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lob = (LobStorageOracle)event.getAffected();
                lob.addObjectListener(this);
                if (lob.getSnapshot() == this) {
                    lob.setParent(this.lobs);
                    this.lobs.add(lob);
                } else {
                    this.lobs.remove(lob);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof PartitionOracle || event.getAffected() instanceof HashPartitionOracle || event.getAffected() instanceof ListPartitionOracle) {
                AbstractStorageObjectOracle part = (AbstractStorageObjectOracle)event.getAffected();
                this.partitions.remove(part);
                part.removeObjectListener(this);
            } else if (event.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lob = (LobStorageOracle)event.getAffected();
                this.lobs.remove(lob);
                lob.removeObjectListener(this);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.partitions;
            }
            case 1: {
                return this.lobs;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.partitions) {
            return 0;
        }
        if (child == this.lobs) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.partitions) {
            return 0;
        }
        if (child == this.lobs) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.partitions.removeAll();
        this.lobs.removeAll();
        Iterator it = this.getStorageDesign().getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyOracle tableProxy = (TableProxyOracle)it.next();
            if (tableProxy.getSnapshot() != this) continue;
            tableProxy.setSnapshot(null);
        }
    }

    public void addPartFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            PartitionOracle part = (PartitionOracle)it.next();
            part.addObjectListener(this);
            if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                part.setParent(this.partitions);
                this.partitions.add(part);
                continue;
            }
            this.partitions.remove(part);
        }
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        if (this.checkAction(action)) {
            this.action = action;
            this.fireDataFieldChange();
        }
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String build) {
        if (this.checkBuild(build)) {
            this.build = build;
            this.fireDataFieldChange();
        } else if (build.equalsIgnoreCase("DEFFERED")) {
            this.build = DEFERRED;
        }
    }

    public ClusterOracle getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterOracle cluster) {
        this.cluster = cluster;
        this.fireDataFieldChange();
    }

    public String getDefaultSegment() {
        return this.defaultSegment;
    }

    public void setDefaultSegment(String defaultSegment) {
        if (ConstantsOracle.checkYesNo(defaultSegment)) {
            this.defaultSegment = defaultSegment;
            this.fireDataFieldChange();
        }
    }

    public String getForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(String forUpdate) {
        if (ConstantsOracle.checkYesNo(forUpdate)) {
            this.forUpdate = forUpdate;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getIndexSegment() {
        return this.indexSegment;
    }

    public void setIndexSegment(SegmentOracle indexSegment) {
        this.indexSegment = indexSegment;
        this.fireDataFieldChange();
    }

    public LobStorageOracle getLobStorage() {
        return this.lobStorage;
    }

    public void setLobStorage(LobStorageOracle lobStorage) {
        this.lobStorage = lobStorage;
        this.fireDataFieldChange();
    }

    public TableProxyOracle getOnPrebuildTable() {
        return this.onPrebuildTable;
    }

    public void setOnPrebuildTable(TableProxyOracle onPrebuildTable) {
        this.onPrebuildTable = onPrebuildTable;
        this.fireDataFieldChange();
    }

    public String getParalelClause() {
        return this.paralelClause;
    }

    public void setParalelClause(String paralelClause) {
        if (ConstantsOracle.checkYesNo(paralelClause)) {
            this.paralelClause = paralelClause;
            this.fireDataFieldChange();
        }
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = degree;
    }

    public String getPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(String partitioned) {
        if (ConstantsOracle.checkYesNo(partitioned)) {
            this.partitioned = partitioned;
            this.fireDataFieldChange();
        }
    }

    public String getQueryRewrite() {
        return this.queryRewrite;
    }

    public void setQueryRewrite(String queryRewrite) {
        if (this.checkQueryRewrite(queryRewrite)) {
            this.queryRewrite = queryRewrite;
            this.fireDataFieldChange();
        }
    }

    public String getReducedPrecision() {
        return this.reducedPrecision;
    }

    public void setReducedPrecision(String reducedPrecision) {
        if (ConstantsOracle.checkYesNo(reducedPrecision)) {
            this.reducedPrecision = reducedPrecision;
            this.fireDataFieldChange();
        }
    }

    public String getRefresh() {
        return this.refresh;
    }

    public void setRefresh(String refresh) {
        if (this.checkRefresh(refresh)) {
            this.refresh = refresh;
            this.fireDataFieldChange();
        }
    }

    public String getRefreshType() {
        return this.refreshType;
    }

    public void setRefreshType(String refreshType) {
        if (this.checkRefreshType(refreshType)) {
            this.refreshType = refreshType;
            this.fireDataFieldChange();
        }
    }

    public RollbackSegmentOracle getRollbackSegment() {
        return this.rollbackSegment;
    }

    public void setRollbackSegment(RollbackSegmentOracle rollbackSegment) {
        this.rollbackSegment = rollbackSegment;
        this.fireDataFieldChange();
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segment) {
        this.segment = segment;
        this.fireDataFieldChange();
    }

    public String getSegmentType() {
        return this.segmentType;
    }

    public void setSegmentType(String segmentType) {
        if (this.checkSegmentType(segmentType)) {
            this.segmentType = segmentType;
            this.fireDataFieldChange();
        }
    }

    public String getUseIndex() {
        return this.useIndex;
    }

    public void setUseIndex(String useIndex) {
        if (ConstantsOracle.checkNoneYesNo(useIndex)) {
            this.useIndex = useIndex;
            this.fireDataFieldChange();
        }
    }

    public String getWith() {
        return this.with;
    }

    public void setWith(String with) {
        if (this.checkWith(with)) {
            this.with = with;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkBuild(String value) {
        if (buildSet == null) {
            buildSet = new HashSet();
            buildSet.addAll(Arrays.asList(BUILD_STATES));
        }
        return buildSet.contains(value);
    }

    protected boolean checkQueryRewrite(String value) {
        if (queryRewriteSet == null) {
            queryRewriteSet = new HashSet();
            queryRewriteSet.addAll(Arrays.asList(QUERY_REWRITE_STATES));
        }
        return queryRewriteSet.contains(value);
    }

    protected boolean checkRefresh(String value) {
        if (refreshSet == null) {
            refreshSet = new HashSet();
            refreshSet.addAll(Arrays.asList(REFRESH_STATES));
        }
        return refreshSet.contains(value);
    }

    protected boolean checkRefreshType(String value) {
        if (refreshTypeSet == null) {
            refreshTypeSet = new HashSet();
            refreshTypeSet.addAll(Arrays.asList(REFRESH_TYPE_STATES));
        }
        return refreshTypeSet.contains(value);
    }

    protected boolean checkAction(String value) {
        if (actionSet == null) {
            actionSet = new HashSet();
            actionSet.addAll(Arrays.asList(ACTION_STATES));
        }
        return actionSet.contains(value);
    }

    protected boolean checkWith(String value) {
        if (withSet == null) {
            withSet = new HashSet();
            withSet.addAll(Arrays.asList(WITH_STATES));
        }
        return withSet.contains(value);
    }

    protected boolean checkSegmentType(String value) {
        if (segmentTypeSet == null) {
            segmentTypeSet = new HashSet();
            segmentTypeSet.addAll(Arrays.asList(SEGMENT_TYPE_STATES));
        }
        return segmentTypeSet.contains(value);
    }

    public PartitionListOracle getPartitionList() {
        return this.partitionList;
    }

    public void setPartitionList(PartitionListOracle partitionList) {
        String newPartType = "";
        String newSubpartType = "";
        if (partitionList != null) {
            newPartType = partitionList.getPartitionType();
            if (newPartType.equalsIgnoreCase("COMPOSITE BY HASH") || newPartType.equalsIgnoreCase("COMPOSITE BY LIST")) {
                newPartType = "RANGE";
            }
            newSubpartType = partitionList.getSubpartitionType();
        }
        if (this.partitionList != null && !this.partType.equalsIgnoreCase(newPartType)) {
            this.partitions.removeAll();
        }
        this.partType = newPartType;
        this.subpartType = newSubpartType;
        this.partitionList = partitionList;
        if (this.partitionList == null) {
            this.partitions.setForbiddenCreateElement(true);
        } else {
            this.partitionList.setSnapshot(this);
            this.partitioned = "YES";
            if (this.partType.equalsIgnoreCase("HASH BY QUANTITY")) {
                this.partitions.setForbiddenCreateElement(true);
            } else {
                this.partitions.setForbiddenCreateElement(false);
                this.partitions.setLogicalParent(partitionList);
            }
            StorageDesignOracle storageDesign = this.getStorageDesignOracle();
            if (this.partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                this.partitions.setStorageObjectSet(storageDesign.getHashPartitionSet());
                this.addHashPartFromDesign(storageDesign.getHashPartitionSet());
            } else if (this.partType.equalsIgnoreCase("LIST")) {
                this.partitions.setStorageObjectSet(storageDesign.getListPartitionSet());
                this.addListPartFromDesign(storageDesign.getListPartitionSet());
            } else {
                this.partitions.setStorageObjectSet(storageDesign.getPartitionSet());
                this.addPartFromDesign(storageDesign.getPartitionSet());
            }
        }
        this.fireDataFieldChange();
    }

    public void addHashPartFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            HashPartitionOracle part = (HashPartitionOracle)it.next();
            part.addObjectListener(this);
            if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                part.setParent(this.partitions);
                this.partitions.add(part);
                continue;
            }
            this.partitions.remove(part);
        }
        this.fireDataFieldChange();
    }

    private void addListPartFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ListPartitionOracle part = (ListPartitionOracle)it.next();
            part.addObjectListener(this);
            if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                part.setParent(this.partitions);
                this.partitions.add(part);
                continue;
            }
            this.partitions.remove(part);
        }
    }

    public String getSubquery() {
        return this.subquery;
    }

    public void setSubquery(String subquery) {
        if (!this.subquery.equals(subquery)) {
            this.subquery = subquery;
            this.setParsedForDependency(false);
            this.fireDataFieldChange();
        }
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
        this.fireDataFieldChange();
    }

    public String getSubPartColumns() {
        return this.subPartColumns;
    }

    public void setSubPartColumns(String subPartColumns) {
        this.subPartColumns = subPartColumns;
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(TableSpaceOracle tablespace) {
        if (this.tablespace != tablespace) {
            this.tablespace = tablespace;
            this.fireDataFieldChange();
        }
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        if (ConstantsOracle.checkNoneYesNo(cache)) {
            this.cache = cache;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String logging) {
        if (ConstantsOracle.checkNoneYesNo(logging)) {
            this.logging = logging;
            this.fireDataFieldChange();
        }
    }

    public String getClusterColumns() {
        return this.clusterColumns;
    }

    public void setClusterColumns(String clusterColumns) {
        this.clusterColumns = clusterColumns;
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getIndexTablespace() {
        return this.indexTablespace;
    }

    public void setIndexTablespace(TableSpaceOracle indexTablespace) {
        this.indexTablespace = indexTablespace;
        this.fireDataFieldChange();
    }

    public String getCommentInRdbms() {
        return this.commentInRdbms;
    }

    public void setCommentInRdbms(String commentInRdbms) {
        this.commentInRdbms = commentInRdbms;
        this.fireDataFieldChange();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
        this.fireDataFieldChange();
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
        this.fireDataFieldChange();
    }

    public String getNextDate() {
        return this.nextDate;
    }

    public void setNextDate(String nextDate) {
        this.nextDate = nextDate;
        this.fireDataFieldChange();
    }

    public TableProxyOracle getImplementedTable() {
        Iterator it = this.getStorageDesignOracle().getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyOracle table = (TableProxyOracle)it.next();
            if (table.getSnapshot() != this) continue;
            return table;
        }
        return null;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.Alias"), this, "getAlias", "setAlias", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.User"), this, "getUser", "setUser", UserOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.Partitioned"), this, "getPartitioned", "setPartitioned", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.Cluster"), this, "getCluster", "setCluster", ClusterOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.Tablespace"), this, "getTablespace", "setTablespace", TableSpaceOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.Logging"), this, "getLogging", "setLogging", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.Segment"), this, "getSegment", "setSegment", SegmentOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.ParalelClause"), this, "getParalelClause", "setParalelClause", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.Build"), this, "getBuild", "setBuild", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.OnPrebuildTable"), this, "getOnPrebuildTable", "setOnPrebuildTable", TableProxyOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.ReducedPrecision"), this, "getReducedPrecision", "setReducedPrecision", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.ForUpdate"), this, "getForUpdate", "setForUpdate", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.QueryRewrite"), this, "getQueryRewrite", "setQueryRewrite", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.UseIndex"), this, "getUseIndex", "setUseIndex", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.IndexTablespace"), this, "getIndexTablespace", "setIndexTablespace", TableSpaceOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("SnapshotPropertyDialogOracle.Cache"), this, "getCache", "setCache", String.class));
        }
        return this.propertyWrapperList;
    }

    protected String getPropertyDialogName(String messageKey) {
        String uiText = oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString(messageKey);
        if (uiText.endsWith(":")) {
            uiText = uiText.substring(0, uiText.length() - 1).trim();
        }
        return uiText;
    }

    public StorageObjectCollection getPartitionsCollection() {
        return this.partitions;
    }

    public List getPartitions() {
        ArrayList list = new ArrayList();
        this.partitions.addAllElementsTo(list);
        return list;
    }

    public List getLobs() {
        ArrayList list = new ArrayList();
        this.lobs.addAllElementsTo(list);
        return list;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("MATERIALIZED_VIEW_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        this.lobs.removeAll();
        this.partitions.removeAll();
    }

    public abstract void copy(SnapshotOracle var1);

    public PartitionListOracle createPartitionList() {
        PartitionListOracle pl = (PartitionListOracle)((StorageDesignOracle)this.getStorageDesign()).getPartitionListSet().createElement(null);
        pl.setSnapshot(this);
        return pl;
    }

    public void clearPartitionList() {
        PartitionListOracle partitionList = this.partitionList;
        if (partitionList != null) {
            this.setPartitionList(null);
            partitionList.remove();
        }
    }

    public StorageObject createPartitionOracle() {
        if (this.partitions.getStorageObjectSet() != null) {
            return (StorageObject)this.partitions.createElement(null);
        }
        return null;
    }

    public LobStorageOracle createLobStorage() {
        if (this.lobs.getStorageObjectSet() != null) {
            return (LobStorageOracle)this.lobs.createElement(null);
        }
        return null;
    }

    public StorageObjectCollection getLobsCollection() {
        return this.lobs;
    }

    @Override
    public String getName() {
        TableProxyOracle tp = this.getOnPrebuildTable();
        if (tp != null) {
            return tp.getName();
        }
        return super.getName();
    }

    @Override
    public SchemaObject getSchemaObject() {
        TableProxyOracle tp = this.getImplementedTable();
        if (tp != null) {
            return ((Table)tp.getObject()).getSchemaObject();
        }
        return super.getSchemaObject();
    }
}

