/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class SnapshotSetOracle
extends StorageObjectSet {
    private static final Object[] PROTO_ARRAY = new SnapshotOracle[0];

    public SnapshotOracle createSnapshot() {
        return this.createSnapshot(null);
    }

    public SnapshotOracle createSnapshot(String id) {
        return (SnapshotOracle)this.createElement(id);
    }

    @Override
    public String getDefaultNamePrefix() {
        return "MatView";
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public ModelObject getByName(String name) {
        name = name.startsWith("\"") ? name.replaceAll("\"", "") : name.toUpperCase();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            SnapshotOracle so = (SnapshotOracle)it.next();
            String soName = so.getName();
            if (!so.getNameHasQuotes()) {
                soName = soName.toUpperCase();
            }
            if (!name.equals(soName)) continue;
            return so;
        }
        return null;
    }

    public StorageObject getBySchemaAndName(String schema, String name) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Table table;
            SnapshotOracle so = (SnapshotOracle)it.next();
            String soName = so.getName();
            if (!so.getNameHasQuotes()) {
                soName = soName.toUpperCase();
            }
            if (!name.equalsIgnoreCase(soName)) continue;
            UserOracle user = so.getUser();
            if (user != null && user.getName().equalsIgnoreCase(schema)) {
                return so;
            }
            TableProxyOracle tp = so.getOnPrebuildTable();
            if (tp == null) {
                tp = so.getImplementedTable();
            }
            if (tp == null || !(table = (Table)tp.getObject()).getSchema().equalsIgnoreCase(schema) || !name.equalsIgnoreCase(so.getName())) continue;
            return so;
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("MATERIALIZED_VIEW_FOLDER_ICON", 16);
    }
}

