/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.StructuredTypePropertyDialogOraclev9i;

public class StructuredTypeProxyOracle
extends StructuredTypeProxy {
    public static final String CURRENT_USER = "CURRENT_USER";
    public static final String DEFINER = "DEFINER";
    public static final String MAP = "MAP";
    public static final String ORDER = "ORDER";
    private UserOracle owner;
    private String invokerRights = "";
    private MethodProxyOracle mapOrderFunction = null;
    private String mapOrderType = "MAP";
    public static final String[] INVOKER_RIGHTS = new String[]{"", "CURRENT_USER", "DEFINER"};
    private static Set invokerRightSet = null;
    public static final String[] MAP_ORDER_RIGHTS = new String[]{"MAP", "ORDER"};
    private static Set mapOrderSet = null;

    public StructuredTypeProxyOracle(StructuredType structType, StorageDesign storageDesign) {
        super(structType, storageDesign);
    }

    public StructuredTypeProxyOracle(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public String getInvokerRights() {
        return this.invokerRights;
    }

    public void setInvokerRights(String invokerRights) {
        if (this.checkInvokerRight(invokerRights)) {
            this.invokerRights = invokerRights;
            this.fireDataFieldChange();
        }
    }

    public MethodProxyOracle getMapOrderFunction() {
        return this.mapOrderFunction;
    }

    public void setMapOrderFunction(MethodProxyOracle mapOrderFunction) {
        if (this.mapOrderFunction != mapOrderFunction && ((StructuredType)this.getObject()).getParentType() == null) {
            this.mapOrderFunction = mapOrderFunction;
            this.fireDataFieldChange();
        }
    }

    public String getMapOrderType() {
        return this.mapOrderType;
    }

    public void setMapOrderType(String mapOrderType) {
        if (this.checkMapOrder(mapOrderType)) {
            this.mapOrderType = mapOrderType;
            this.fireDataFieldChange();
        }
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public void setOwner(UserOracle owner) {
        if (this.owner != owner) {
            this.owner = owner;
            if (owner != null) {
                boolean isPredefined = owner.getName().equalsIgnoreCase("MDSYS") || owner.getName().equalsIgnoreCase("SYS") || owner.getName().equalsIgnoreCase("ORDSYS");
                this.getStructuredType().setPredefined(isPredefined);
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public static String[] getInvokerRightChoices() {
        return INVOKER_RIGHTS;
    }

    protected boolean checkInvokerRight(String value) {
        if (invokerRightSet == null) {
            invokerRightSet = new HashSet();
            invokerRightSet.addAll(Arrays.asList(StructuredTypeProxyOracle.getInvokerRightChoices()));
        }
        return invokerRightSet.contains(value);
    }

    public static String[] getMapOrderChoices() {
        return MAP_ORDER_RIGHTS;
    }

    protected boolean checkMapOrder(String value) {
        if (mapOrderSet == null) {
            mapOrderSet = new HashSet();
            mapOrderSet.addAll(Arrays.asList(StructuredTypeProxyOracle.getMapOrderChoices()));
        }
        return mapOrderSet.contains(value);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StructuredTypePropertyDialogOraclev9i dialog = new StructuredTypePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !"".equals(this.getOwner().getLongName())) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public StorageObject getSchemaOrUser() {
        return this.getOwner();
    }
}

