/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class SynonymOracle
extends AbstractStorageObjectOracle
implements OwnedObjectOracle {
    private UserOracle user = null;
    private String isPublic = "NO";
    private UserOracle objectUser = null;
    private String object = "";
    private boolean objNameHasQuotes = false;
    private String dbLink = "";
    public static final String TYPE_NAME = "Synonym";

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        this.user = user;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public void setPublic(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.isPublic = value;
            this.fireDataFieldChange();
        }
    }

    public String getPublic() {
        return this.isPublic;
    }

    public UserOracle getObjectUser() {
        return this.objectUser;
    }

    public void setObjectUser(UserOracle objectUser) {
        this.objectUser = objectUser;
        this.fireDataFieldChange();
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public boolean getObjNameHasQuotes() {
        return this.objNameHasQuotes;
    }

    public void setObjNameHasQuotes(boolean objNameHasQuotes) {
        this.objNameHasQuotes = objNameHasQuotes;
    }

    public String getDBLink() {
        return this.dbLink;
    }

    public void setDBLink(String dbLink) {
        this.dbLink = dbLink;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && "NO".equalsIgnoreCase(this.isPublic)) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getUser() != null && "NO".equalsIgnoreCase(this.isPublic)) {
            name = this.getUser().getLongName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SYNONYM_ICON", 16);
    }
}

