/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.options.oracle.OracleTableTemplate;

public abstract class TableProxySetOracle
extends TableProxySet {
    public TableProxySetOracle(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected abstract RelationalObjectProxy createProxy(DesignObject var1);

    @Override
    protected abstract RelationalObjectProxy createProxy(Design var1, String var2, String var3);

    @Override
    public void doAfterAdd(RelationalObjectProxy addedProxy) {
    }

    @Override
    public void add(DesignObject object) {
        String id = object.getObjectID();
        if (this.containsId(id)) {
            if (!this.getProxy(id).isLoaded()) {
                this.getProxy(id).loadDesignObject();
            }
        } else {
            RelationalObjectProxy proxy = this.createProxy(object);
            this.add(proxy);
            if (!this.getStorageDesign().isLoading()) {
                TableSpaceOracle defaultTablespace;
                TableProxyOracle tableProxy = (TableProxyOracle)proxy;
                this.applyTemplate(tableProxy);
                StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
                UserOracle defaultUser = storageDesign.getDefaultUser();
                if (defaultUser != null) {
                    tableProxy.setUser(defaultUser);
                }
                if (tableProxy.getTableSpace() == null && (defaultTablespace = storageDesign.getDefaultTableSpace()) != null) {
                    tableProxy.setTableSpace(defaultTablespace);
                }
            }
            this.fireUpdate();
        }
    }

    protected void applyTemplate(TableProxyOracle proxy) {
        if (this.getDesign().getAppView().getSettings().useOracleTableTemplate()) {
            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
            OracleTableTemplate ott = this.getDesign().getAppView().getSettings().getOracleTableTemplate();
            proxy.setTemporary(ott.getTemporary());
            proxy.setTempPreserveRows(ott.getPreserveRows());
            String tsName = ott.getTableSpace().trim();
            if (!"".equalsIgnoreCase(tsName) && storageDesign.isOpen()) {
                TableSpaceOracle ts = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
                if (ts == null) {
                    ts = storageDesign.getTableSpaceSet().createTableSpace();
                    ts.setName(tsName);
                }
                proxy.setTableSpace(ts);
            }
            proxy.setOrganization(ott.getOrganization());
            proxy.setLogging(ott.getLogging());
            String segName = ott.getSegment().trim();
            if (!"".equalsIgnoreCase(segName) && storageDesign.isOpen()) {
                SegmentOracle segment = (SegmentOracle)storageDesign.getSegmentSet().getByName(segName);
                if (segment == null) {
                    segment = storageDesign.getSegmentSet().createSegment();
                    segment.setName(segName);
                }
                proxy.setSegment(segment);
            }
            proxy.setCache(ott.getCache());
            proxy.setMonitoring(ott.getMonitoring());
            proxy.setParallel(ott.getParallel());
            proxy.setDegree(ott.getDegree());
            proxy.setRowDependency(ott.getRowDependency());
            proxy.setPartitioned(ott.getPartitioned());
            proxy.setParttitionedRowMovement(ott.getRowMovement());
            proxy.setDataSegmentCompression(ott.getDataCompression());
        }
    }

    protected SnapshotOracle createSnapshot(String id) {
        return ((StorageDesignOracle)this.getStorageDesign()).getSnapshotSet().createSnapshot(id);
    }

    @Override
    public TableProxyOracle getByName(String name) {
        name = name.startsWith("\"") ? name.replaceAll("\"", "") : name.toUpperCase();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            TableProxyOracle tpo = (TableProxyOracle)it.next();
            String tpoName = tpo.getName();
            if (!tpo.getNameHasQuotes()) {
                tpoName = tpoName.toUpperCase();
            }
            if (!name.equals(tpoName)) continue;
            return tpo;
        }
        return null;
    }

    public TableProxyOracle getByLongName(String name, String username) {
        if (username == null) {
            return this.getByName(name);
        }
        if (username.startsWith("\"")) {
            username = username.replaceAll("\"", "");
        }
        name = name.startsWith("\"") ? name.replaceAll("\"", "") : name.toUpperCase();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Table table;
            TableProxyOracle tpo = (TableProxyOracle)it.next();
            String tpoName = tpo.getName();
            if (!name.equalsIgnoreCase(tpoName) || tpo.getNameHasQuotes() && !name.equals(tpoName)) continue;
            UserOracle tpoUser = tpo.getUser();
            if (tpoUser != null && tpoUser.getName().equalsIgnoreCase(username)) {
                return tpo;
            }
            if (tpoUser != null || !(table = (Table)tpo.getObject()).getSchema().equalsIgnoreCase(username)) continue;
            return tpo;
        }
        return null;
    }
}

