/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableViewProxyOracle
extends TableViewProxy
implements ModelObjectSetListener,
StorageObjectListener,
PropertiesPropagator,
OwnedObjectOracle {
    private UserOracle user = null;
    private String force = "NO";
    private String readOnly = "NO";
    private String checkOptionName = "";
    protected StorageObjectCollection triggers;
    private String xmlSchemaUrl = "";
    private String xmlSchemaElement = "";
    private String useOID = "";
    public static final String[] USE_OID_CHOICES = new String[]{"", "DEFAULT", "LIST OF ATTRIBUTES"};
    private static Set useOidSet = null;
    protected List propertyWrapperList = null;

    public TableViewProxyOracle(TableView view, StorageDesign storage) {
        super(view, storage);
        this.triggers = new StorageObjectCollection(((StorageDesignOracle)storage).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableViewProxyOracle.class);
        this.triggers.setSetMethod("setView");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignOracle)storage).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignOracle)storage).getTriggerSet());
    }

    public TableViewProxyOracle(Design design, String id, String longName, StorageDesign storage) {
        super(design, id, longName, storage);
        this.triggers = new StorageObjectCollection(((StorageDesignOracle)storage).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableViewProxyOracle.class);
        this.triggers.setSetMethod("setView");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignOracle)storage).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignOracle)storage).getTriggerSet());
    }

    @Override
    public String getIDPrefix() {
        return "VIEW";
    }

    @Override
    public String getObjectTypeName() {
        return "View";
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        this.user = user;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public void setForce(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.force = value;
            this.fireDataFieldChange();
        }
    }

    public String getForce() {
        return this.force;
    }

    public void setReadOnly(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.readOnly = value;
            this.fireDataFieldChange();
        }
    }

    public String getReadOnly() {
        return this.readOnly;
    }

    public void setViewReadOnly(String value) {
        this.setReadOnly(value);
    }

    public String getViewReadOnly() {
        return this.getReadOnly();
    }

    public String getCheckOptionName() {
        return this.checkOptionName;
    }

    public void setCheckOptionName(String checkOptionName) {
        this.checkOptionName = checkOptionName;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject co = (ContainerObject)this.getObject();
        SchemaObject so = co.getSchemaObject();
        if (so != null) {
            UserOracle user = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(so);
            if (user != null) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof TriggerOracle) {
            TriggerOracle tr = (TriggerOracle)event.getAffected();
            if (tr.getView() != null && tr.getView() == this) {
                tr.setParent(this.triggers);
                this.triggers.add(tr);
            } else if (!ApplicationView.loading) {
                this.triggers.remove(tr);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof TriggerOracle) {
                TriggerOracle tr = (TriggerOracle)event.getAffected();
                tr.addObjectListener(this);
                if (tr.getView() != null && tr.getView() == this) {
                    tr.setParent(this.triggers);
                    this.triggers.add(tr);
                } else if (!ApplicationView.loading) {
                    this.triggers.remove(tr);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof TriggerOracle) {
            TriggerOracle tr = (TriggerOracle)event.getAffected();
            this.triggers.remove(tr);
            tr.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.triggers;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.triggers) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.triggers) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.triggers.removeAll();
    }

    protected void addTriggersFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TriggerOracle trigger = (TriggerOracle)it.next();
            trigger.addObjectListener(this);
            if (trigger.getView() != null && trigger.getView() == this) {
                trigger.setParent(this.triggers);
                this.triggers.add(trigger);
                continue;
            }
            this.triggers.remove(trigger);
        }
    }

    public ColumnProxyOracle getColumnProxyByName(String name) {
        ColumnProxy[] columns = this.getColumnProxies();
        for (int i = 0; i < columns.length; ++i) {
            ColumnProxyOracle cpo = (ColumnProxyOracle)columns[i];
            if (!name.equals(cpo.getName())) continue;
            return cpo;
        }
        return null;
    }

    public String getXmlSchemaElement() {
        return this.xmlSchemaElement;
    }

    public void setXmlSchemaElement(String xmlSchemaElement) {
        this.xmlSchemaElement = xmlSchemaElement;
        this.fireDataFieldChange();
    }

    public String getXmlSchemaUrl() {
        return this.xmlSchemaUrl;
    }

    public void setXmlSchemaUrl(String xmlSchemaUrl) {
        this.xmlSchemaUrl = xmlSchemaUrl;
        this.fireDataFieldChange();
    }

    public String getOidAttributes() {
        return ((TableView)this.getObject()).getOidText();
    }

    public void setOidAttributes(String oidAttributes) {
    }

    public String getUseOID() {
        return this.useOID;
    }

    public void setUseOID(String useOID) {
        if (this.checkUseOid(useOID)) {
            this.useOID = useOID;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkUseOid(String value) {
        if (useOidSet == null) {
            useOidSet = new HashSet();
            useOidSet.addAll(Arrays.asList(USE_OID_CHOICES));
        }
        return useOidSet.contains(value);
    }

    public String getBasedOnStructuredType() {
        if (((TableView)this.getObject()).getBasedOnStructuredType() == null) {
            return "";
        }
        return ((TableView)this.getObject()).getBasedOnStructuredType().getName();
    }

    @Override
    public StorageObject getUserSchema() {
        return this.getUser();
    }

    @Override
    public void setUserSchema(String schema) {
        if (schema != null) {
            UserOracle user = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().getByName(schema);
            if (user == null) {
                user = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().createUser();
                user.setName(schema);
            }
            if (user != null) {
                this.setUser(user);
            }
        }
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            this.triggers.addAllElementsTo(list);
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    public StorageObjectCollection getTriggers() {
        return this.triggers;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableViewPropertyDialogOraclev9i.User"), this, "getUser", "setUser", UserOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableViewPropertyDialogOraclev9i.CheckOption"), this, "getCheckOption", "setCheckOption", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableViewPropertyDialogOraclev9i.Force"), this, "getForce", "setForce", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableViewPropertyDialogOraclev9i.ReadOnly"), this, "getReadOnly", "setReadOnly", String.class));
            if (this.getStorageDesign() instanceof StorageDesignOraclev11g) {
                this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableViewPropertyDialogOraclev9i.Editioning"), this, "getEditioning", "setEditioning", String.class));
            }
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableViewPropertyDialogOraclev9i.UseOID"), this, "getUseOID", "setUseOID", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableViewPropertyDialogOraclev9i.CheckOptionName"), this, "getCheckOptionName", "setCheckOptionName", String.class));
        }
        return this.propertyWrapperList;
    }

    protected String getPropertyDialogName(String messageKey) {
        String uiText = oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString(messageKey);
        if (uiText.endsWith(":")) {
            uiText = uiText.substring(0, uiText.length() - 1).trim();
        }
        return uiText;
    }
}

