/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;

public abstract class TriggerOracle
extends Trigger
implements OwnedObjectOracle {
    protected TableProxyOracle table;
    protected TableViewProxyOracle view;
    protected UserOracle owner;
    private String columns = "";
    private ArraySet columnSet = null;
    protected String scope = SCOPE_TYPES[0];
    protected String state = "";
    protected String ref_OLD_AS = "";
    protected String ref_NEW_AS = "";
    protected String ref_PARENT_AS = "";
    protected String condition = "";
    public static final String BEFORE = "BEFORE";
    public static final String AFTER = "AFTER";
    public static final String INSTEAD_OF = "INSTEAD OF";
    public static final String[] TRIGGER_TIMES = new String[]{"BEFORE", "AFTER", "INSTEAD OF"};
    private static List triggerTimeList = Arrays.asList(TRIGGER_TIMES);
    private static Set triggerTimeSet = null;
    public static final String[] SCOPE_TYPES = new String[]{"FOR EACH ROW", "FOR EACH STATEMENT"};
    private static List scopeList = Arrays.asList(SCOPE_TYPES);
    public static final String[] STATE_TYPES = new String[]{"", "ENABLE", "DISABLE"};
    private static List stateList = Arrays.asList(STATE_TYPES);
    private String tempTableOwner;

    public TriggerOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setTriggerTime(BEFORE);
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setTable(TableProxyOracle table) {
        if (this.table != null) {
            this.table.removeObject(this);
        }
        this.table = table;
        if (table != null) {
            table.addObject(this);
        }
        this.fireDataFieldChange();
    }

    public TableViewProxyOracle getView() {
        return this.view;
    }

    public void setView(TableViewProxyOracle view) {
        this.view = view;
        if (view != null) {
            this.setTriggerTime(INSTEAD_OF);
        }
        this.fireDataFieldChange();
    }

    public static String[] getTriggerTimes() {
        return TRIGGER_TIMES;
    }

    public static List getTriggerValues() {
        return triggerTimeList;
    }

    @Override
    protected boolean checkTriggerTime(String value) {
        if (triggerTimeSet == null) {
            triggerTimeSet = new HashSet();
            triggerTimeSet.addAll(Arrays.asList(TriggerOracle.getTriggerTimes()));
        }
        return triggerTimeSet.contains(value);
    }

    public static String[] getScopeTypes() {
        return SCOPE_TYPES;
    }

    public static List getScopeValues() {
        return scopeList;
    }

    protected boolean checkScope(String value) {
        return scopeList.contains(value);
    }

    private void addColumn(String column) {
        String columnName = column.substring(column.lastIndexOf(46) + 1, column.length());
        if (!this.getColumnSet().contains(columnName)) {
            this.getColumnSet().add(columnName);
        }
    }

    private void recreateColumnSet(String columns) {
        this.getColumnSet().clear();
        StringTokenizer st = new StringTokenizer(columns, ",");
        while (st.hasMoreTokens()) {
            this.getColumnSet().add(st.nextToken().trim());
        }
    }

    public void setColumns(String columns) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnSet(columns);
        } else {
            this.addColumn(columns);
        }
        this.columns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public ArraySet getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new ArraySet();
        }
        return this.columnSet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
        this.columns = "";
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
        this.fireDataFieldChange();
    }

    public String getRef_PARENT_AS() {
        return this.ref_PARENT_AS;
    }

    public void setRef_PARENT_AS(String ref_PARENT_AS) {
        this.ref_PARENT_AS = ref_PARENT_AS;
        this.fireDataFieldChange();
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public void setOwner(UserOracle owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public String getRef_NEW_AS() {
        return this.ref_NEW_AS;
    }

    public void setRef_NEW_AS(String ref_NEW_AS) {
        this.ref_NEW_AS = ref_NEW_AS;
        this.fireDataFieldChange();
    }

    public String getRef_OLD_AS() {
        return this.ref_OLD_AS;
    }

    public void setRef_OLD_AS(String ref_OLD_AS) {
        this.ref_OLD_AS = ref_OLD_AS;
        this.fireDataFieldChange();
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (this.checkScope(scope)) {
            this.scope = scope;
            this.fireDataFieldChange();
        }
    }

    public boolean isScopeForEachRow() {
        return this.getScope().equalsIgnoreCase(SCOPE_TYPES[0]);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        if (stateList.contains(state)) {
            this.state = state;
        }
    }

    @Override
    public void remove() {
        if (this.table != null) {
            this.table.removeObject(this);
        }
        super.remove();
    }

    public String getColumnsNames() {
        String names = "";
        if (this.getTable() != null) {
            boolean first = true;
            ColumnProxy[] columnSet = this.getTable().getColumnProxies();
            for (int i = 0; i < columnSet.length; ++i) {
                ColumnProxy column = columnSet[i];
                if (!this.getColumnSet().contains(column.getObjectID())) continue;
                if (first) {
                    names = column.getName();
                    first = false;
                    continue;
                }
                names = names + "," + column.getName();
            }
        }
        return names;
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getOwner() != null) {
            name = this.getOwner().getLongName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    @Override
    public void setUser(UserOracle user) {
        this.setOwner(user);
    }

    @Override
    public UserOracle getUser() {
        return this.getOwner();
    }

    public String getTempTableOwner() {
        return this.tempTableOwner;
    }

    public void setTempTableOwner(String tempTableOwner) {
        this.tempTableOwner = tempTableOwner;
    }

    public class ArraySet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

