/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;

public abstract class UniqueSetOracle
extends IndexProxySet {
    public UniqueSetOracle(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        Index ind;
        if (event.isAdded()) {
            Index ind2 = (Index)event.getAffected();
            if (ind2.isUnique()) {
                this.add(ind2);
                this.fireUpdate();
            }
        } else if (event.isRemoved() && this.containsId((ind = (Index)event.getAffected()).getObjectID())) {
            this.remove((Index)event.getAffected());
            this.fireUpdate();
        }
    }

    @Override
    protected void add(Index[] array) {
        for (int i = 0; i < array.length; ++i) {
            Index ind = array[i];
            if (!ind.isUnique()) continue;
            this.add(ind);
        }
    }

    @Override
    public void add(DesignObject object) {
        String id = object.getObjectID();
        if (this.containsId(id)) {
            if (!this.getProxy(id).isLoaded()) {
                this.getProxy(id).loadDesignObject();
            }
        } else if (object instanceof KeyObject && ((KeyObject)object).isUnique()) {
            RelationalObjectProxy proxy = this.createProxy(object);
            try {
                this.add(proxy);
            }
            catch (IllegalStateException e) {
                System.out.println("Error in UniqueSetOracle.add");
            }
            this.fireUpdate();
        }
    }

    public boolean hasDublicateNames() {
        for (int i = 0; i < this.elements.size(); ++i) {
            UniqueOracle current = (UniqueOracle)this.elements.get(i);
            for (int j = i + 1; j < this.elements.size(); ++j) {
                UniqueOracle another = (UniqueOracle)this.elements.get(j);
                if (!current.getName().equalsIgnoreCase(another.getName()) || ((TableProxyOracle)current.getTableProxy()).getUser() != ((TableProxyOracle)another.getTableProxy()).getUser()) continue;
                return true;
            }
        }
        return false;
    }
}

