/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.IndexPropertyDialogOraclev10g;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxyOraclev10g
extends IndexProxyOracle {
    private static final String[] PARTITIONED = new String[]{"NON_PARTITIONED", "LOCAL", "GLOBAL BY RANGE", "GLOBAL HASH PARTITIONED BY QUANTITY", "GLOBAL HASH PARTITIONED BY LIST"};
    private static Set partitionedSet = null;
    private String invisible = "NO";
    private String nonLeaf = "NO";
    private int batchSize = 1000;
    private TableSpaceOracle workTablespace = null;

    public IndexProxyOraclev10g(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxyOraclev10g(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    protected void initPartitions(StorageDesignOracle storageDesign) {
        super.initPartitions(storageDesign);
        ((StorageDesignOraclev10g)storageDesign).getIndexHashPartitionSet().addSetListener(this);
    }

    public static String[] getPartitionedChoices() {
        return PARTITIONED;
    }

    @Override
    public void setIndexPartitioned(String partitioned) {
        if (this.checkPartitionedChoices(partitioned)) {
            if (!this.partitioned.equalsIgnoreCase(partitioned)) {
                this.partitions.removeAll();
            }
            this.partitioned = partitioned;
            if (partitioned.equalsIgnoreCase(PARTITIONED[2])) {
                this.enableSubPartitionsByRange();
            } else if (partitioned.equalsIgnoreCase(PARTITIONED[4])) {
                this.enableSubPartitionsByHash();
            } else {
                this.partitions.setForbiddenCreateElement(true);
                this.partitions.removeAll();
            }
            this.fireDataFieldChange();
        }
    }

    private void enableSubPartitionsByRange() {
        Iterator it = ((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet().iterator();
        while (it.hasNext()) {
            IndexGlobalPartitionOraclev10g part = (IndexGlobalPartitionOraclev10g)it.next();
            if (part.getIndexGlobalPartList() == null || part.getIndexGlobalPartList() != this.getIndexGlobalPartitionsList()) continue;
            this.partitions.setForbiddenCreateElement(true);
        }
    }

    private void enableSubPartitionsByHash() {
        Iterator it = ((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet().iterator();
        while (it.hasNext()) {
            IndexHashPartitionOraclev10g part = (IndexHashPartitionOraclev10g)it.next();
            if (part.getIndexGlobalPartList() == null || part.getIndexGlobalPartList() != this.getIndexGlobalPartitionsList()) continue;
            this.partitions.setForbiddenCreateElement(true);
        }
    }

    private boolean checkPartitionedChoices(String value) {
        if (partitionedSet == null) {
            partitionedSet = new HashSet();
            partitionedSet.addAll(Arrays.asList(IndexProxyOraclev10g.getPartitionedChoices()));
        }
        return partitionedSet.contains(value);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogOraclev10g dialog = new IndexPropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof IndexGlobalPartitionOracle) {
            IndexGlobalPartitionOracle igp = (IndexGlobalPartitionOracle)event.getAffected();
            if (igp.getIndexGlobalPartList() != null && igp.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                igp.setParent(this.partitions);
                this.partitions.add(igp);
            } else {
                this.partitions.remove(igp);
            }
        } else if (event.getAffected() instanceof IndexHashPartitionOraclev10g) {
            IndexHashPartitionOraclev10g ihp = (IndexHashPartitionOraclev10g)event.getAffected();
            if (ihp.getIndexGlobalPartList() != null && ihp.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                ihp.setParent(this.partitions);
                this.partitions.add(ihp);
            } else {
                this.partitions.remove(ihp);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle igp = (IndexGlobalPartitionOracle)event.getAffected();
                igp.addObjectListener(this);
                if (igp.getIndexGlobalPartList() != null && igp.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList() && !this.partitions.contains(igp)) {
                    igp.setParent(this.partitions);
                    this.partitions.add(igp);
                } else {
                    this.partitions.remove(igp);
                }
            } else if (event.getAffected() instanceof IndexHashPartitionOraclev10g) {
                IndexHashPartitionOraclev10g ihp = (IndexHashPartitionOraclev10g)event.getAffected();
                ihp.addObjectListener(this);
                if (ihp.getIndexGlobalPartList() != null && ihp.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList() && !this.partitions.contains(ihp)) {
                    ihp.setParent(this.partitions);
                    this.partitions.add(ihp);
                } else {
                    this.partitions.remove(ihp);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle igp = (IndexGlobalPartitionOracle)event.getAffected();
                this.partitions.remove(igp);
                igp.removeObjectListener(this);
            } else if (event.getAffected() instanceof IndexHashPartitionOraclev10g) {
                IndexHashPartitionOraclev10g igp = (IndexHashPartitionOraclev10g)event.getAffected();
                this.partitions.remove(igp);
                igp.removeObjectListener(this);
            }
        }
    }

    @Override
    public void setIndexGlobalPartitionsList(IndexGlobalPartitionsListOracle indexGlobalPartList) {
        if (this.indexGlobalPartList != null && this.indexGlobalPartList != indexGlobalPartList) {
            this.partitions.removeAll();
            this.partitions.setForbiddenCreateElement(true);
        }
        if (indexGlobalPartList != null) {
            this.indexGlobalPartList = indexGlobalPartList;
            this.indexGlobalPartList.setIndex(this);
            this.partitions.setForbiddenCreateElement(false);
            this.partitions.setLogicalParent(indexGlobalPartList);
            if (((IndexProxyOracle)indexGlobalPartList.getIndex()).getIndexPartitioned().equalsIgnoreCase(PARTITIONED[2])) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet());
                this.addIGPFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet());
            } else if (((IndexProxyOracle)indexGlobalPartList.getIndex()).getIndexPartitioned().equalsIgnoreCase(PARTITIONED[4])) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet());
                this.addIndexHashPartitionFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet());
            } else {
                this.partitions.removeAll();
                this.partitions.setForbiddenCreateElement(true);
            }
        }
        this.fireDataFieldChange();
    }

    protected void addIndexHashPartitionFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            IndexHashPartitionOraclev10g ihp = (IndexHashPartitionOraclev10g)it.next();
            ihp.addObjectListener(this);
            if (ihp.getIndexGlobalPartList() != null && ihp.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                ihp.setParent(this.partitions);
                this.partitions.add(ihp);
                continue;
            }
            this.partitions.remove(ihp);
        }
    }

    public String getInvisible() {
        return this.invisible;
    }

    public void setInvisible(String invisible) {
        if (ConstantsOracle.checkYesNo(invisible)) {
            this.invisible = invisible;
        }
    }

    public String getLayerType() {
        return this.getIndex().getLayerType();
    }

    public String getGeodetic() {
        return this.getIndex().getGeodetic();
    }

    public String getDimensionsNumber() {
        return String.valueOf(this.getIndex().getDimensionsNumber());
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public TableSpaceOracle getWorkTablespace() {
        return this.workTablespace;
    }

    public void setWorkTablespace(TableSpaceOracle workTablespace) {
        this.workTablespace = workTablespace;
    }

    public String getNonLeaf() {
        return this.nonLeaf;
    }

    public void setNonLeaf(String nonLeaf) {
        if (ConstantsOracle.checkYesNo(nonLeaf)) {
            this.nonLeaf = nonLeaf;
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = super.getPropertyWrapperList();
            if (this.getStorageDesign() instanceof StorageDesignOraclev11g) {
                this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.Invisible"), this, "getInvisible", "setInvisible", String.class));
            }
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index index = (Index)targetDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        IndexProxyOraclev10g indexProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignOraclev10g)targetDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            indexProxy = (IndexProxyOraclev10g)storageObject;
        }
        if (indexProxy != null) {
            indexProxy.setName(this.getName());
            if (this.getIndexGlobalPartitionsList() != null) {
                IndexGlobalPartitionsListOraclev10g indexList = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionsListSet().getByName(this.getIndexGlobalPartitionsList().getName());
                if (indexList == null) {
                    IndexGlobalPartitionsListOraclev10g newIndexList = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    newIndexList.setName(this.getIndexGlobalPartitionsList().getName());
                    newIndexList.setRawObject(true);
                    newIndexList.setIndex(indexProxy);
                    indexProxy.setIndexGlobalPartitionsList(newIndexList);
                } else {
                    indexList.setIndex(indexProxy);
                    indexProxy.setIndexGlobalPartitionsList(indexList);
                }
            }
            Iterator it = this.partitions.iterator();
            while (it.hasNext()) {
                IndexGlobalPartitionOraclev10g indexPart = (IndexGlobalPartitionOraclev10g)it.next();
                IndexGlobalPartitionOraclev10g targetIndexPart = (IndexGlobalPartitionOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionSet().getByName(indexPart.getName());
                if (targetIndexPart == null) {
                    IndexGlobalPartitionOraclev10g newIndexPart = (IndexGlobalPartitionOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionSet().createIndexGlobalPartition();
                    newIndexPart.setName(indexPart.getName());
                    newIndexPart.setRawObject(true);
                    newIndexPart.setIndexGlobalPartList(indexProxy.getIndexGlobalPartitionsList());
                    indexProxy.addIGPFromDesign(((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionSet());
                    continue;
                }
                indexPart.setIndexGlobalPartList(indexProxy.getIndexGlobalPartitionsList());
                indexProxy.addIGPFromDesign(((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionSet());
            }
            if (this.getUser() != null) {
                UserOraclev10g idxUser = (UserOraclev10g)((StorageDesignOraclev10g)targetDesign).getUserSet().getByName(this.getUser().getName());
                if (idxUser == null) {
                    UserOraclev10g newIdxUser = (UserOraclev10g)((StorageDesignOraclev10g)targetDesign).getUserSet().createUser();
                    newIdxUser.setName(this.getUser().getName());
                    newIdxUser.setRawObject(true);
                    indexProxy.setUser(newIdxUser);
                } else {
                    indexProxy.setUser(idxUser);
                }
            }
            indexProxy.setBitmapIndex(this.getBitmapIndex());
            indexProxy.setIndexPartitioned(this.getIndexPartitioned());
            if (this.getTableSpace() != null) {
                TableSpaceOraclev10g idxTblSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (idxTblSpace == null) {
                    TableSpaceOraclev10g newTableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    indexProxy.setTableSpace(newTableSpace);
                } else {
                    indexProxy.setTableSpace(idxTblSpace);
                }
            }
            indexProxy.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                SegmentOraclev10g idxSegment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (idxSegment == null) {
                    SegmentOraclev10g newSegment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getSegment().getName());
                    newSegment.setRawObject(true);
                    indexProxy.setSegment(newSegment);
                } else {
                    indexProxy.setSegment(idxSegment);
                }
            }
            indexProxy.setCompress(this.getCompress());
            indexProxy.setParallel(this.getParallel());
            indexProxy.setDegree(this.getDegree());
            indexProxy.setSortedRows(this.getSortedRows());
            indexProxy.setComputeStatistics(this.getComputeStatistics());
            indexProxy.setOnline(this.getOnline());
            indexProxy.setInvisible(this.getInvisible());
            indexProxy.setBatchSize(this.getBatchSize());
            indexProxy.setWorkTablespace(this.getWorkTablespace());
            indexProxy.setNonLeaf(this.getNonLeaf());
            indexProxy.setRawObject(false);
        }
    }
}

