/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.util.options.oracle.OracleIndexTemplate;

public class IndexProxySetOraclev10g
extends IndexProxySet
implements Constants {
    public IndexProxySetOraclev10g(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject object) {
        return new IndexProxyOraclev10g((Index)object, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        return new IndexProxyOraclev10g(design, id, longName, this.getStorageDesign());
    }

    @Override
    public void add(DesignObject object) {
        String id = object.getObjectID();
        if (this.containsId(id)) {
            if (!this.getProxy(id).isLoaded()) {
                this.getProxy(id).loadDesignObject();
            }
        } else if (object instanceof KeyObject && !((KeyObject)object).isPK() && !((KeyObject)object).isFK() && !((Index)object).getIndexState().equalsIgnoreCase("Unique Constraint")) {
            RelationalObjectProxy proxy = this.createProxy(object);
            try {
                this.add(proxy);
                if (!this.getStorageDesign().isLoading()) {
                    IndexProxyOracle indexProxy = (IndexProxyOracle)proxy;
                    TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
                    if (tableProxy != null) {
                        indexProxy.setUser(tableProxy.getUser());
                        indexProxy.setTableSpace(tableProxy.getTableSpace());
                    }
                    this.applyTemplate(indexProxy);
                }
            }
            catch (IllegalStateException e) {
                System.out.println("Error in IndexProxySetOraclev10g.add");
            }
            this.fireUpdate();
        }
    }

    protected void applyTemplate(IndexProxyOracle proxy) {
        if (this.getDesign().getAppView().getSettings().useOracleIndexTemplate()) {
            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
            OracleIndexTemplate oit = this.getDesign().getAppView().getSettings().getOracleIndexTemplate();
            proxy.setBitmapIndex(oit.isBitmapIndex());
            proxy.setIndexPartitioned(oit.getPartitioned());
            String tsName = oit.getTableSpace().trim();
            if (!"".equalsIgnoreCase(tsName) && storageDesign.isOpen()) {
                TableSpaceOracle ts = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
                if (ts == null) {
                    ts = storageDesign.getTableSpaceSet().createTableSpace();
                    ts.setName(tsName);
                }
                proxy.setTableSpace(ts);
            }
            proxy.setLogging(oit.getLogging());
            String segName = oit.getSegment().trim();
            if (!"".equalsIgnoreCase(segName) && storageDesign.isOpen()) {
                SegmentOracle segment = (SegmentOracle)storageDesign.getSegmentSet().getByName(segName);
                if (segment == null) {
                    segment = storageDesign.getSegmentSet().createSegment();
                    segment.setName(segName);
                }
                proxy.setSegment(segment);
            }
            proxy.setCompress(oit.getCompress());
            proxy.setParallel(oit.getParallel());
            proxy.setDegree(oit.getDegree());
            proxy.setSortedRows(oit.getSortedRows());
            proxy.setComputeStatistics(oit.getComputeStatistics());
            proxy.setOnline(oit.getOnline());
        }
    }
}

