/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxySetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.PKPropertyDialogOraclev10g;

public class PKProxyOraclev10g
extends PKProxyOracle {
    public static final String LOCAL = "LOCAL";
    public static final String GLOBAL_BY_RANGE = "GLOBAL BY RANGE";
    public static final String GLOBAL_HASH_PARTITIONED_BY_QUANTITY = "GLOBAL HASH PARTITIONED BY QUANTITY";
    public static final String GLOBAL_HASH_PARTITIONED_BY_LIST = "GLOBAL HASH PARTITIONED BY LIST";
    public static final String BY_INDEX_NAME = "BY INDEX NAME";
    public static final String BY_CREATE_INDEX_STATEMENT = "BY CREATE INDEX STATEMENT";
    public static final String SORTED = "SORTED";
    public static final String REVERSE = "REVERSE";
    private static final String[] USING_INDEX = new String[]{"NO", "LOCAL", "GLOBAL BY RANGE", "GLOBAL HASH PARTITIONED BY QUANTITY", "GLOBAL HASH PARTITIONED BY LIST", "BY INDEX NAME", "BY CREATE INDEX STATEMENT"};
    private static Set usingIndexSet = null;
    private String usingIndex = "NO";
    private String createIndexStatement = "";
    private static final String[] INDEX_SORT = new String[]{"NO", "SORTED", "REVERSE"};
    private static Set indexSortSet = null;
    private String indexSort = "SORTED";
    private String computeStatistics = "NO";

    public PKProxyOraclev10g(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public PKProxyOraclev10g(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    protected void initPartitions(StorageDesignOracle storageDesign) {
        super.initPartitions(storageDesign);
        ((StorageDesignOraclev10g)storageDesign).getIndexHashPartitionSet().addSetListener(this);
    }

    public static String[] getUsingIndexChoices() {
        return USING_INDEX;
    }

    private boolean checkUsingIndex(String value) {
        if (usingIndexSet == null) {
            usingIndexSet = new HashSet();
            usingIndexSet.addAll(Arrays.asList(PKProxyOraclev10g.getUsingIndexChoices()));
        }
        return usingIndexSet.contains(value);
    }

    @Override
    public void setUsingIndex(String using) {
        if (this.checkUsingIndex(using)) {
            if (!this.usingIndex.equalsIgnoreCase(using)) {
                this.partitions.removeAll();
            }
            this.usingIndex = using;
            if (this.usingIndex.equalsIgnoreCase(GLOBAL_BY_RANGE)) {
                this.enableSubPartitionsByRange();
            } else if (this.usingIndex.equalsIgnoreCase(GLOBAL_HASH_PARTITIONED_BY_LIST)) {
                this.enableSubPartitionsByHash();
            } else {
                this.partitions.setForbiddenCreateElement(true);
                this.partitions.removeAll();
            }
            this.fireDataFieldChange();
        }
    }

    private void enableSubPartitionsByRange() {
        Iterator it = ((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet().iterator();
        while (it.hasNext()) {
            IndexGlobalPartitionOraclev10g part = (IndexGlobalPartitionOraclev10g)it.next();
            if (part.getIndexGlobalPartList() == null || part.getIndexGlobalPartList() != this.getIndexGlobalPL()) continue;
            this.partitions.setForbiddenCreateElement(true);
        }
    }

    private void enableSubPartitionsByHash() {
        Iterator it = ((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet().iterator();
        while (it.hasNext()) {
            IndexHashPartitionOraclev10g part = (IndexHashPartitionOraclev10g)it.next();
            if (part.getIndexGlobalPartList() == null || part.getIndexGlobalPartList() != this.getIndexGlobalPL()) continue;
            this.partitions.setForbiddenCreateElement(true);
        }
    }

    @Override
    public String getUsingIndex() {
        return this.usingIndex;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            PKPropertyDialogOraclev10g dialog = new PKPropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof IndexGlobalPartitionOracle) {
            IndexGlobalPartitionOracle igp = (IndexGlobalPartitionOracle)event.getAffected();
            if (igp.getIndexGlobalPartList() != null && igp.getIndexGlobalPartList() == this.getIndexGlobalPL()) {
                igp.setParent(this.partitions);
                this.partitions.add(igp);
            } else {
                this.partitions.remove(igp);
            }
        } else if (event.getAffected() instanceof IndexHashPartitionOraclev10g) {
            IndexHashPartitionOraclev10g ihp = (IndexHashPartitionOraclev10g)event.getAffected();
            if (ihp.getIndexGlobalPartList() != null && ihp.getIndexGlobalPartList() == this.getIndexGlobalPL()) {
                ihp.setParent(this.partitions);
                this.partitions.add(ihp);
            } else {
                this.partitions.remove(ihp);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle igp = (IndexGlobalPartitionOracle)event.getAffected();
                igp.addObjectListener(this);
                if (igp.getIndexGlobalPartList() != null && igp.getIndexGlobalPartList() == this.getIndexGlobalPL() && !this.partitions.contains(igp)) {
                    igp.setParent(this.partitions);
                    this.partitions.add(igp);
                } else {
                    this.partitions.remove(igp);
                }
            } else if (event.getAffected() instanceof IndexHashPartitionOraclev10g) {
                IndexHashPartitionOraclev10g ihp = (IndexHashPartitionOraclev10g)event.getAffected();
                ihp.addObjectListener(this);
                if (ihp.getIndexGlobalPartList() != null && ihp.getIndexGlobalPartList() == this.getIndexGlobalPL() && !this.partitions.contains(ihp)) {
                    ihp.setParent(this.partitions);
                    this.partitions.add(ihp);
                } else {
                    this.partitions.remove(ihp);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle igp = (IndexGlobalPartitionOracle)event.getAffected();
                this.partitions.remove(igp);
                igp.removeObjectListener(this);
            } else if (event.getAffected() instanceof IndexHashPartitionOraclev10g) {
                IndexHashPartitionOraclev10g igp = (IndexHashPartitionOraclev10g)event.getAffected();
                this.partitions.remove(igp);
                igp.removeObjectListener(this);
            }
        }
    }

    @Override
    public void setIndexGlobalPL(IndexGlobalPartitionsListOracle indexGlobalPartitionList) {
        if (this.indexGlobalPartitionList != null && this.indexGlobalPartitionList != indexGlobalPartitionList) {
            this.partitions.removeAll();
            this.partitions.setForbiddenCreateElement(true);
        }
        this.indexGlobalPartitionList = indexGlobalPartitionList;
        if (indexGlobalPartitionList != null) {
            this.indexGlobalPartitionList.setIndex(this);
            this.partitions.setForbiddenCreateElement(false);
            this.partitions.setLogicalParent(indexGlobalPartitionList);
            if (((PKProxyOracle)indexGlobalPartitionList.getIndex()).getUsingIndex().equalsIgnoreCase(GLOBAL_BY_RANGE)) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet());
                this.addIGPFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet());
            } else if (((PKProxyOracle)indexGlobalPartitionList.getIndex()).getUsingIndex().equalsIgnoreCase(GLOBAL_HASH_PARTITIONED_BY_LIST)) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet());
                this.addIndexHashPartitionFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet());
            } else {
                this.partitions.removeAll();
                this.partitions.setForbiddenCreateElement(true);
            }
        }
        this.fireDataFieldChange();
    }

    protected void addIndexHashPartitionFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            IndexHashPartitionOraclev10g ihp = (IndexHashPartitionOraclev10g)it.next();
            ihp.addObjectListener(this);
            if (ihp.getIndexGlobalPartList() != null && ihp.getIndexGlobalPartList() == this.getIndexGlobalPL()) {
                ihp.setParent(this.partitions);
                this.partitions.add(ihp);
                continue;
            }
            this.partitions.remove(ihp);
        }
    }

    public static String[] getIndexSortChoices() {
        return INDEX_SORT;
    }

    private boolean checkIndexSort(String value) {
        if (indexSortSet == null) {
            indexSortSet = new HashSet();
            indexSortSet.addAll(Arrays.asList(PKProxyOraclev10g.getIndexSortChoices()));
        }
        return indexSortSet.contains(value);
    }

    @Override
    public void setIndexSort(String using) {
        if (this.checkIndexSort(using)) {
            this.indexSort = using;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getIndexSort() {
        return this.indexSort;
    }

    public String getCreateIndexStatement() {
        return this.createIndexStatement;
    }

    public void setCreateIndexStatement(String createIndexStatement) {
        this.createIndexStatement = createIndexStatement;
        this.fireDataFieldChange();
    }

    @Override
    public String getComputeStatistics() {
        return this.computeStatistics;
    }

    @Override
    public void setComputeStatistics(String computeStatistics) {
        if (ConstantsOracle.checkYesNo(computeStatistics)) {
            this.computeStatistics = computeStatistics;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index indexPK = (Index)targetDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        PKProxyOraclev10g pkProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignOraclev10g)targetDesign).getPKProxySet().getProxy(indexPK.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            pkProxy = (PKProxyOraclev10g)storageObject;
        }
        if (pkProxy != null) {
            pkProxy.setName(this.getName());
            pkProxy.setDeferrable(this.getDeferrable());
            pkProxy.setInitially(this.getInitially());
            pkProxy.setEnable(this.getEnable());
            pkProxy.setValidate(this.getValidate());
            pkProxy.setRely(this.getRely());
            pkProxy.setUsingIndex(this.getUsingIndex());
            if (this.getExceptionsTable() != null) {
                TableProxyOraclev10g table = (TableProxyOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableProxySet().getProxy(this.getExceptionsTable().getObjectID());
                if (table == null) {
                    TableProxyOraclev10g newTable = (TableProxyOraclev10g)((TableProxySetOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableProxySet()).createProxy(this.getExceptionsTable().getObject());
                    newTable.setName(this.getName());
                    newTable.setRawObject(true);
                    pkProxy.setExceptionsTable(newTable);
                } else {
                    pkProxy.setExceptionsTable(table);
                }
            }
            if (this.getIndexGlobalPL() != null) {
                IndexGlobalPartitionsListOraclev10g list = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionsListSet().getByName(this.getIndexGlobalPL().getName());
                if (list == null) {
                    IndexGlobalPartitionsListOraclev10g newList = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    newList.setName(this.getName());
                    newList.setRawObject(true);
                    newList.setIndex(pkProxy);
                    pkProxy.setIndexGlobalPL(newList);
                } else {
                    list.setIndex(pkProxy);
                    pkProxy.setIndexGlobalPL(list);
                }
            }
            if (this.getIndexSegment() != null) {
                SegmentOraclev10g segment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().getByName(this.getIndexSegment().getName());
                if (segment == null) {
                    SegmentOraclev10g newSegment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getIndexSegment().getName());
                    newSegment.setRawObject(true);
                    pkProxy.setIndexSegment(newSegment);
                } else {
                    pkProxy.setIndexSegment(segment);
                }
            }
            pkProxy.setIndexSort(this.getIndexSort());
            if (this.getTableSpace() != null) {
                TableSpaceOraclev10g tablespace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tablespace == null) {
                    TableSpaceOraclev10g newTablespace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getTableSpace().getName());
                    newTablespace.setRawObject(true);
                    pkProxy.setTableSpace(newTablespace);
                } else {
                    pkProxy.setTableSpace(tablespace);
                }
            }
            pkProxy.setLogging(this.getLogging());
            pkProxy.setComment(this.getComment());
            pkProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            pkProxy.setRawObject(false);
        }
    }
}

