/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.TBPartitionPropertyDialogOraclev10g;

public class PartitionOraclev10g
extends PartitionOracle {
    public PartitionOraclev10g(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TBPartitionPropertyDialogOraclev10g dialog = new TBPartitionPropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void setPartitionList(PartitionListOracle partitionList) {
        if (this.partitionList != partitionList) {
            if (this.partitionList != null) {
                this.partitionList.removeObjectListener(this);
            }
            this.partitionList = partitionList;
            this.fireDataFieldChange();
            if (partitionList != null) {
                partitionList.addObjectListener(this);
            }
        }
        if (partitionList != null) {
            if ("HASH".equalsIgnoreCase(partitionList.getSubpartitionType())) {
                this.enableSubPartitionsByHash();
            } else if ("LIST".equalsIgnoreCase(partitionList.getSubpartitionType())) {
                this.enableSubPartitionsByList();
            } else {
                this.disableSubPartitions();
            }
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        PartitionOraclev10g partition = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev10g)targetDesign).getPartitionSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                partition = (PartitionOraclev10g)stObject;
            }
        } else {
            partition = (PartitionOraclev10g)((StorageDesignOraclev10g)targetDesign).getPartitionSet().createPartition();
        }
        if (partition != null) {
            SegmentOraclev10g newSegment;
            SegmentOraclev10g segment;
            partition.setName(this.getName());
            if (this.getPartitionList() != null) {
                PartitionListOraclev10g partList = (PartitionListOraclev10g)((StorageDesignOraclev10g)targetDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (partList == null) {
                    PartitionListOraclev10g newPartList = (PartitionListOraclev10g)((StorageDesignOraclev10g)targetDesign).getPartitionListSet().createPartitionList();
                    newPartList.setName(this.getPartitionList().getName());
                    newPartList.setRawObject(true);
                    partition.setPartitionList(newPartList);
                } else {
                    partition.setPartitionList(partList);
                }
            }
            Iterator it = this.getPartitions().iterator();
            while (it.hasNext()) {
                HashPartitionOraclev10g hashPart = (HashPartitionOraclev10g)it.next();
                HashPartitionOraclev10g targetHashPart = (HashPartitionOraclev10g)((StorageDesignOraclev10g)targetDesign).getHashPartitionSet().getByName(hashPart.getName());
                if (targetHashPart == null) {
                    HashPartitionOraclev10g newHashPart = (HashPartitionOraclev10g)((StorageDesignOraclev10g)targetDesign).getHashPartitionSet().createHashPartition();
                    newHashPart.setName(hashPart.getName());
                    newHashPart.setRawObject(true);
                    newHashPart.setSubPartitionOf(partition);
                    partition.getPartitions().add(newHashPart);
                    continue;
                }
                targetHashPart.setSubPartitionOf(partition);
                partition.getPartitions().add(targetHashPart);
            }
            it = this.getLobs().iterator();
            while (it.hasNext()) {
                LobStorageOraclev10g lobStorage = (LobStorageOraclev10g)it.next();
                LobStorageOraclev10g targetLobStorage = (LobStorageOraclev10g)((StorageDesignOraclev10g)targetDesign).getLobStorageSet().getByName(lobStorage.getName());
                if (targetLobStorage == null) {
                    LobStorageOraclev10g newLobStorage = (LobStorageOraclev10g)((StorageDesignOraclev10g)targetDesign).getLobStorageSet().createLobStorage();
                    newLobStorage.setName(lobStorage.getName());
                    newLobStorage.setRawObject(true);
                    newLobStorage.setPartition(partition);
                    partition.getLobs().add(newLobStorage);
                    continue;
                }
                targetLobStorage.setPartition(partition);
                partition.getLobs().add(targetLobStorage);
            }
            it = this.getListPartitions().iterator();
            while (it.hasNext()) {
                ListStorageTemplatePartitionOraclev10g partList = (ListStorageTemplatePartitionOraclev10g)it.next();
                ListStorageTemplatePartitionOraclev10g targetPartList = (ListStorageTemplatePartitionOraclev10g)((StorageDesignOraclev10g)targetDesign).getListStorageTemplatePartitionSet().getByName(partList.getName());
                if (targetPartList == null) {
                    ListStorageTemplatePartitionOraclev10g newPartList = (ListStorageTemplatePartitionOraclev10g)((StorageDesignOraclev10g)targetDesign).getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                    newPartList.setName(partList.getName());
                    newPartList.setRawObject(true);
                    newPartList.setSubPartitionOf(partition);
                    partition.getListPartitions().add(newPartList);
                    continue;
                }
                targetPartList.setSubPartitionOf(partition);
                partition.getListPartitions().add(targetPartList);
            }
            partition.setValueList(this.getValueList());
            partition.setPosition(this.getPosition());
            if (this.getTableSpace() != null) {
                TableSpaceOraclev10g tableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tableSpace == null) {
                    TableSpaceOraclev10g newTableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    partition.setTableSpace(newTableSpace);
                } else {
                    partition.setTableSpace(tableSpace);
                }
            }
            partition.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                segment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (segment == null) {
                    newSegment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getSegment().getName());
                    newSegment.setRawObject(true);
                    partition.setSegment(newSegment);
                } else {
                    partition.setSegment(segment);
                }
            }
            partition.setDataSegmentCompression(this.getDataSegmentCompression());
            partition.setIOTCompress(this.getIOTCompress());
            if (this.getIOTOverflowSegment() != null) {
                segment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().getByName(this.getIOTOverflowSegment().getName());
                if (segment == null) {
                    newSegment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getIOTOverflowSegment().getName());
                    newSegment.setRawObject(true);
                    partition.setIOTOverflowSegment(newSegment);
                } else {
                    partition.setIOTOverflowSegment(segment);
                }
            }
            partition.setSubPartitionsQuantity(this.getSubPartitionsQuantity());
            partition.recreateSubPartitionsTSSet(this.getSubPartTSSet().toString());
            partition.setComment(this.getComment());
            partition.setRawObject(false);
        }
    }
}

