/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxySetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableSpaceOraclev10g
extends TableSpaceOraclev9i {
    private static Set fileTypeSet = null;
    public static final String BIGFILE = "BIGFILE";
    public static final String SMALLFILE = "SMALLFILE";
    private String fileType = FILE_TYPES[0];
    private static final String[] FILE_TYPES = new String[]{"", "BIGFILE", "SMALLFILE"};
    private static final String[] FLASHBACK_STATES = new String[]{"ON", "OFF"};
    private static List flashBackList = Arrays.asList(FLASHBACK_STATES);
    private static Set flashBackSet = null;
    private String flashBack = FLASHBACK_STATES[0];
    private static Set dsCompressionSet = null;
    private String dsCompression = DS_COMPRESSION_CHOICES[0];
    private static final String[] DS_COMPRESSION_CHOICES = new String[]{"", "NOCOMPRESS", "COMPRESS"};

    public TableSpaceOraclev10g(StorageDesign storageDesign) {
        super(storageDesign);
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String value) {
        if (this.checkFileTypeState(value)) {
            this.fileType = value;
            this.fireDataFieldChange();
        }
    }

    private boolean checkFileTypeState(String value) {
        if (fileTypeSet == null) {
            fileTypeSet = new HashSet();
            fileTypeSet.addAll(Arrays.asList(TableSpaceOraclev10g.getFileTypes()));
        }
        return fileTypeSet.contains(value);
    }

    public static String[] getFileTypes() {
        return FILE_TYPES;
    }

    public static String[] getFlashBackChoices() {
        return FLASHBACK_STATES;
    }

    protected boolean checkFlashBack(String value) {
        if (flashBackSet == null) {
            flashBackSet = new HashSet();
            flashBackSet.addAll(Arrays.asList(TableSpaceOraclev10g.getFlashBackChoices()));
        }
        return flashBackSet.contains(value);
    }

    public void setFlashBack(String value) {
        if (this.checkFlashBack(value)) {
            this.flashBack = value;
            this.fireDataFieldChange();
        }
    }

    public String getFlashBack() {
        return this.flashBack;
    }

    public static List getFlashBackValues() {
        return flashBackList;
    }

    public String getDSCompression() {
        return this.dsCompression;
    }

    public void setDSCompression(String value) {
        if (this.checkDSCompressionState(value)) {
            this.dsCompression = value;
            this.fireDataFieldChange();
        }
    }

    private boolean checkDSCompressionState(String value) {
        if (dsCompressionSet == null) {
            dsCompressionSet = new HashSet();
            dsCompressionSet.addAll(Arrays.asList(TableSpaceOraclev10g.getDSCompressionStates()));
        }
        return dsCompressionSet.contains(value);
    }

    public static String[] getDSCompressionStates() {
        return DS_COMPRESSION_CHOICES;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = super.getPropertyWrapperList();
            this.propertyWrapperList.add(0, new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.FileType"), this, "getFileType", "setFileType", String.class));
            this.propertyWrapperList.add(7, new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.DefaultCompression"), this, "getDSCompression", "setDSCompression", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.FlashbackMode"), this, "getFlashBack", "setFlashBack", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableSpaceOraclev10g tableSpace = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                tableSpace = (TableSpaceOraclev10g)stObject;
            }
        } else {
            tableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().createTableSpace();
        }
        if (tableSpace != null) {
            tableSpace.setObjectID(this.getObjectID());
            tableSpace.setName(this.getName());
            Iterator it = this.getTabcoll().iterator();
            while (it.hasNext()) {
                StorageObjectPlaceHolder tables = (StorageObjectPlaceHolder)it.next();
                TableProxyOraclev10g targetTables = (TableProxyOraclev10g)((TableProxySetOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableProxySet()).getByName(tables.getName());
                if (targetTables == null) {
                    TableProxyOraclev10g newTable = (TableProxyOraclev10g)((TableProxySetOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableProxySet()).createProxy(tables.getGenerator());
                    newTable.setName(tables.getName());
                    newTable.setTableSpace(tableSpace);
                    newTable.setRawObject(true);
                    tableSpace.registerToTableProxyFromDesign(((StorageDesignOraclev10g)targetDesign).getTableProxySet());
                    continue;
                }
                targetTables.setTableSpace(tableSpace);
                tableSpace.registerToTableProxyFromDesign(((StorageDesignOraclev10g)targetDesign).getTableProxySet());
            }
            it = this.getDfiles().iterator();
            while (it.hasNext()) {
                DataFileOraclev10g dataFile = (DataFileOraclev10g)it.next();
                DataFileOraclev10g targetDataFile = (DataFileOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataFileSet().getByName(dataFile.getName());
                if (targetDataFile == null) {
                    DataFileOraclev10g newDataFile = (DataFileOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataFileSet().createDataFile();
                    newDataFile.setName(dataFile.getName());
                    newDataFile.setTableSpace(tableSpace);
                    newDataFile.setRawObject(true);
                    tableSpace.getDfiles().add(newDataFile);
                    continue;
                }
                targetDataFile.setTableSpace(tableSpace);
                tableSpace.getDfiles().add(targetDataFile);
            }
            tableSpace.setMinExtLen(this.getMinExtLen());
            tableSpace.setBlockSize(this.getBlockSize());
            tableSpace.setLogging(this.getLogging());
            tableSpace.setForceLogging(this.getForceLogging());
            tableSpace.setStatus(this.getStatus());
            tableSpace.setContents(this.getContents());
            tableSpace.setDSInitialExtent(this.getDSInitialExtent());
            tableSpace.setDSNextExtent(this.getDSNextExtent());
            tableSpace.setDSMinExtents(this.getDSMinExtents());
            tableSpace.setDSMaxExtents(this.getDSMaxExtents());
            tableSpace.setDSPctIncrease(this.getDSPctIncrease());
            tableSpace.setExtentManagement(this.getExtentManagement());
            tableSpace.setEMLocalSubtype(this.getEMLocalSubtype());
            tableSpace.setEMUniformSize(this.getEMUniformSize());
            tableSpace.setSegmentManagement(this.getSegmentManagement());
            tableSpace.setFileType(this.getFileType());
            tableSpace.setFlashBack(this.getFlashBack());
            tableSpace.setDSCompression(this.getDSCompression());
            tableSpace.setComment(this.getComment());
            tableSpace.setRawObject(false);
        }
    }
}

