/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TemporaryTablespaceOraclev9i;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.TemporaryTablespacePropertyDialogOraclev10g;

public class TemporaryTablespaceOraclev10g
extends TemporaryTablespaceOraclev9i
implements ModelObjectSetListener,
StorageObjectListener {
    private static Set fileTypeSet = null;
    private String fileType = FILE_TYPES[0];
    public static String BIGFILE = "BIGFILE";
    public static String SMALLFILE = "SMALLFILE";
    private static final String[] FILE_TYPES = new String[]{"", BIGFILE, SMALLFILE};
    private String tableSpaceGroup = "";
    private StorageObjectCollection dfiles;
    private String oracleManagedFiles = "NO";

    public TemporaryTablespaceOraclev10g(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.setParent(((StorageDesignOraclev10g)storageDesign).getTableSpaceSet());
        this.dfiles = new StorageObjectCollection(((StorageDesignOraclev10g)storageDesign).getDataFileSet());
        this.dfiles.setParent(this);
        this.dfiles.setName(Messages.getString("TableSpaceOracle.DataFiles"));
        this.dfiles.setSetMethod("setTemporaryTablespace");
        this.dfiles.setClassForParent(TemporaryTablespaceOraclev10g.class);
        this.dfiles.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        ((StorageDesignOraclev10g)storageDesign).getDataFileSet().addSetListener(this);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TemporaryTablespacePropertyDialogOraclev10g dialog = new TemporaryTablespacePropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String value) {
        if (this.checkFileTypeState(value)) {
            this.fileType = value;
            this.fireDataFieldChange();
        }
    }

    private boolean checkFileTypeState(String value) {
        if (fileTypeSet == null) {
            fileTypeSet = new HashSet();
            fileTypeSet.addAll(Arrays.asList(TemporaryTablespaceOraclev10g.getFileTypes()));
        }
        return fileTypeSet.contains(value);
    }

    public static String[] getFileTypes() {
        return FILE_TYPES;
    }

    public String getTableSpaceGroup() {
        return this.tableSpaceGroup;
    }

    public void setTableSpaceGroup(String tableSpaceGroup) {
        this.tableSpaceGroup = tableSpaceGroup;
    }

    public void setOracleManagedFiles(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.oracleManagedFiles = value;
        }
    }

    public String getOracleManagedFiles() {
        return this.oracleManagedFiles;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof DataFileOraclev10g) {
                DataFileOraclev10g df = (DataFileOraclev10g)event.getAffected();
                df.addObjectListener(this);
                if (df.getTemporaryTablespace() != null && df.getTemporaryTablespace() == this) {
                    df.setParent(this.dfiles);
                    this.dfiles.add(df);
                } else {
                    this.dfiles.remove(df);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof DataFileOraclev10g) {
            DataFileOraclev10g df = (DataFileOraclev10g)event.getAffected();
            this.dfiles.remove(df);
            df.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof DataFileOraclev10g) {
            DataFileOraclev10g df = (DataFileOraclev10g)event.getAffected();
            if (df.getTemporaryTablespace() != null && df.getTemporaryTablespace() == this) {
                if (this.getOracleManagedFiles().equalsIgnoreCase("YES")) {
                    this.dfiles.setAllowedNumberOfElements(1);
                } else {
                    this.dfiles.setAllowedNumberOfElements(99999);
                }
                df.setParent(this.dfiles);
                this.dfiles.add(df);
            } else {
                this.dfiles.remove(df);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.dfiles;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.dfiles) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.dfiles) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.dfiles.removeAll();
    }

    public StorageObjectCollection getDFiles() {
        return this.dfiles;
    }

    public DataFileOracle createDataFile() {
        if (this.dfiles.getStorageObjectSet() != null) {
            return (DataFileOracle)this.dfiles.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TemporaryTablespaceOraclev10g tempTableSpace = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev10g)targetDesign).getTemporaryTablespaceSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                tempTableSpace = (TemporaryTablespaceOraclev10g)stObject;
            }
        } else {
            tempTableSpace = (TemporaryTablespaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTemporaryTablespaceSet().createTemporaryTablespace();
        }
        if (tempTableSpace != null) {
            tempTableSpace.setName(this.getName());
            Iterator it = this.getDFiles().iterator();
            while (it.hasNext()) {
                DataFileOraclev10g dataFile = (DataFileOraclev10g)it.next();
                DataFileOraclev10g targetFile = (DataFileOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataFileSet().getByName(dataFile.getName());
                if (targetFile == null) {
                    DataFileOraclev10g newFile = (DataFileOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataFileSet().createDataFile();
                    newFile.setName(dataFile.getName());
                    newFile.setRawObject(true);
                    newFile.setTemporaryTablespace(tempTableSpace);
                    ((StorageDesignOraclev10g)targetDesign).getDataFileSet().add(newFile);
                    tempTableSpace.getDFiles().add(newFile);
                    continue;
                }
                ((StorageDesignOraclev10g)targetDesign).getDataFileSet().add(targetFile);
                targetFile.setTemporaryTablespace(tempTableSpace);
                tempTableSpace.getDFiles().add(targetFile);
            }
            tempTableSpace.setTableSpaceGroup(this.getTableSpaceGroup());
            tempTableSpace.setUniformSize(this.getUniformSize());
            tempTableSpace.setMeasureUnitUniformSize(this.getMeasureUnitUniformSize());
            tempTableSpace.setFileType(this.getFileType());
            tempTableSpace.setOracleManagedFiles(this.getOracleManagedFiles());
            tempTableSpace.setComment(this.getComment());
            tempTableSpace.setRawObject(false);
        }
    }

    @Override
    public void clearNoneMergableStructure() {
        this.dfiles.removeAll();
    }
}

