/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UndoTablespaceOraclev9i;

public class UndoTablespaceOraclev10g
extends UndoTablespaceOraclev9i
implements ModelObjectSetListener,
StorageObjectListener {
    public UndoTablespaceOraclev10g(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof DataFileOraclev10g) {
            DataFileOraclev10g df = (DataFileOraclev10g)event.getAffected();
            if (df.getUndoTablespace() == this) {
                df.setParent(this.dfiles);
                this.dfiles.add(df);
            } else {
                this.dfiles.remove(df);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof DataFileOraclev10g) {
                DataFileOraclev10g df = (DataFileOraclev10g)event.getAffected();
                df.addObjectListener(this);
                if (df.getUndoTablespace() == this) {
                    df.setParent(this.dfiles);
                    this.dfiles.add(df);
                } else {
                    this.dfiles.remove(df);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof DataFileOraclev10g) {
            DataFileOraclev10g df = (DataFileOraclev10g)event.getAffected();
            this.dfiles.remove(df);
            df.removeObjectListener(this);
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        UndoTablespaceOraclev10g undoTableSpace = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev10g)targetDesign).getUndoTablespaceSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                undoTableSpace = (UndoTablespaceOraclev10g)stObject;
            }
        } else {
            undoTableSpace = (UndoTablespaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getUndoTablespaceSet().createElement(null);
        }
        if (undoTableSpace != null) {
            undoTableSpace.setName(this.getName());
            Iterator it = this.getDfiles().iterator();
            while (it.hasNext()) {
                DataFileOraclev10g dataFile = (DataFileOraclev10g)it.next();
                DataFileOraclev10g targetFile = (DataFileOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataFileSet().getByName(dataFile.getName());
                if (targetFile == null) {
                    DataFileOraclev10g newFile = (DataFileOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataFileSet().createDataFile();
                    newFile.setName(dataFile.getName());
                    newFile.setRawObject(true);
                    newFile.setUndoTablespace(undoTableSpace);
                    ((StorageDesignOraclev10g)targetDesign).getDataFileSet().add(newFile);
                    undoTableSpace.getDfiles().add(newFile);
                    continue;
                }
                ((StorageDesignOraclev10g)targetDesign).getDataFileSet().add(targetFile);
                targetFile.setUndoTablespace(undoTableSpace);
                undoTableSpace.getDfiles().add(targetFile);
            }
            undoTableSpace.setFileType(this.getFileType());
            undoTableSpace.setRetention(this.getRetention());
            undoTableSpace.setOracleManagesFiles(this.getOracleManagesFiles());
            undoTableSpace.setComment(this.getComment());
            undoTableSpace.setRawObject(false);
        }
    }
}

