/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v11g;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v11g.ListPartitionPropertyDialogOraclev11g;

public class ListPartitionOraclev11g
extends ListPartitionOraclev10g
implements ModelObjectSetListener,
StorageObjectListener {
    private InlineList subPartitionsTableSpacesSet = null;
    private int subPartitionsQuantity = 0;
    private String subPartitionsTableSpaces = "";
    private StorageObjectCollection hashSubpartitions;
    private StorageObjectCollection listSubpartitions;
    private StorageObjectCollection rangeSubpartitions;

    public ListPartitionOraclev11g(StorageDesign stoDesign) {
        super(stoDesign);
        StorageDesignOracle storageDesign = (StorageDesignOracle)stoDesign;
        this.setStorageDesign(storageDesign);
        this.hashSubpartitions = new StorageObjectCollection(storageDesign.getHashPartitionSet());
        this.hashSubpartitions.setParent(this);
        this.hashSubpartitions.setName(Messages.getString("PartitionOracle.HashSubpartitions"));
        this.hashSubpartitions.setForbiddenCreateElement(true);
        this.hashSubpartitions.setClassForParent(AbstractStorageObjectOracle.class);
        this.hashSubpartitions.setSetMethod("setSubPartitionOf");
        this.hashSubpartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        storageDesign.getHashPartitionSet().addSetListener(this);
        this.listSubpartitions = new StorageObjectCollection(storageDesign.getListStorageTemplatePartitionSet());
        this.listSubpartitions.setParent(this);
        this.listSubpartitions.setName(Messages.getString("PartitionOracle.ListSubpartitions"));
        this.listSubpartitions.setClassForParent(AbstractStorageObjectOracle.class);
        this.listSubpartitions.setSetMethod("setSubPartitionOf");
        this.listSubpartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        storageDesign.getListStorageTemplatePartitionSet().addSetListener(this);
        this.addListSubpartitionsFromDesign(storageDesign.getListStorageTemplatePartitionSet());
        PartitionSetOracle partitionSet = storageDesign.getPartitionSet();
        this.rangeSubpartitions = new StorageObjectCollection(partitionSet);
        this.rangeSubpartitions.setParent(this);
        this.rangeSubpartitions.setName(Messages.getString("PartitionOraclev11g.RangeSubpartitions"));
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.setClassForParent(AbstractStorageObjectOracle.class);
        this.rangeSubpartitions.setSetMethod("setSubPartitionOf");
        this.rangeSubpartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        partitionSet.addSetListener(this);
        this.addRangeSubpartitionsFromDesign(partitionSet);
    }

    protected void addListSubpartitionsFromDesign(ListStorageTemplatePartitionSetOracle listPartitionSet) {
        Iterator it = listPartitionSet.iterator();
        while (it.hasNext()) {
            ListStorageTemplatePartitionOracle lp = (ListStorageTemplatePartitionOracle)it.next();
            if (lp.getSubPartitionOf() == this) {
                lp.addObjectListener(this);
                lp.setParent(this.listSubpartitions);
                this.listSubpartitions.add(lp);
                continue;
            }
            this.listSubpartitions.remove(lp);
        }
    }

    protected void addRangeSubpartitionsFromDesign(PartitionSetOracle rangePartitionSet) {
        Iterator it = rangePartitionSet.iterator();
        while (it.hasNext()) {
            PartitionOraclev11g part = (PartitionOraclev11g)it.next();
            if (part.getSubPartitionOf() == this) {
                part.addObjectListener(this);
                part.setParent(this.rangeSubpartitions);
                this.rangeSubpartitions.add(part);
                continue;
            }
            this.rangeSubpartitions.remove(part);
        }
    }

    public StorageObjectCollection getHashSubpartitions() {
        return this.hashSubpartitions;
    }

    public StorageObjectCollection getListSubpartitions() {
        return this.listSubpartitions;
    }

    public StorageObjectCollection getRangeSubpartitions() {
        return this.rangeSubpartitions;
    }

    public boolean hasSubPartitions() {
        return this.hashSubpartitions.size() > 0 || this.listSubpartitions.size() > 0 || this.rangeSubpartitions.size() > 0;
    }

    public int getSubPartitionsQuantity() {
        return this.subPartitionsQuantity;
    }

    public void setSubPartitionsQuantity(int subPartitionsQuantity) {
        if (this.subPartitionsQuantity != subPartitionsQuantity) {
            this.subPartitionsQuantity = subPartitionsQuantity;
            this.fireDataFieldChange();
        }
    }

    public String getSubPartitionsTableSpaces() {
        return this.subPartitionsTableSpaces;
    }

    public String getAllSubPartitionsTableSpaces() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.subPartitionsTableSpaces, "|");
        while (st.hasMoreTokens()) {
            String tsID = st.nextToken();
            TableSpaceOracle ts = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(tsID.trim());
            if (ts == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(ts.getName());
        }
        return result.toString();
    }

    public void setSubPartitionsTableSpaces(String subPartitionsTableSpaces) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSubPartitionsTSSet(subPartitionsTableSpaces);
        } else {
            this.addSubPartitionsTS(subPartitionsTableSpaces);
        }
        String newValue = this.getSubPartTSSet().toString();
        if (!this.subPartitionsTableSpaces.equals(newValue)) {
            this.subPartitionsTableSpaces = newValue;
            this.fireDataFieldChange();
        }
    }

    private void addSubPartitionsTS(String ts) {
        if (!this.getSubPartTSSet().contains(ts)) {
            this.getSubPartTSSet().add(ts);
        }
    }

    public void recreateSubPartitionsTSSet(String tableSpaces) {
        this.getSubPartTSSet().clear();
        StringTokenizer st = new StringTokenizer(tableSpaces, "|");
        while (st.hasMoreTokens()) {
            this.getSubPartTSSet().add(st.nextToken().trim());
        }
    }

    public InlineList getSubPartTSSet() {
        if (this.subPartitionsTableSpacesSet == null) {
            this.subPartitionsTableSpacesSet = new InlineList();
        }
        return this.subPartitionsTableSpacesSet;
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof HashPartitionOracle) {
            HashPartitionOracle subpart = (HashPartitionOracle)event.getAffected();
            if (subpart.getSubPartitionOf() == this) {
                subpart.setParent(this.hashSubpartitions);
                this.hashSubpartitions.add(subpart);
            } else {
                this.hashSubpartitions.remove(subpart);
            }
        } else if (event.getAffected() instanceof ListStorageTemplatePartitionOracle) {
            ListStorageTemplatePartitionOracle subpart = (ListStorageTemplatePartitionOracle)event.getAffected();
            if (subpart.getSubPartitionOf() == this) {
                subpart.setParent(this.listSubpartitions);
                this.listSubpartitions.add(subpart);
            } else {
                this.listSubpartitions.remove(subpart);
            }
        } else if (event.getAffected() instanceof PartitionOraclev11g) {
            PartitionOraclev11g subpart = (PartitionOraclev11g)event.getAffected();
            if (subpart.getSubPartitionOf() == this) {
                subpart.setParent(this.rangeSubpartitions);
                this.rangeSubpartitions.add(subpart);
            } else {
                this.rangeSubpartitions.remove(subpart);
            }
        } else {
            super.changed(object, event);
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle subpart = (HashPartitionOracle)event.getAffected();
                subpart.addObjectListener(this);
                if (subpart.getSubPartitionOf() == this) {
                    subpart.setParent(this.hashSubpartitions);
                    this.hashSubpartitions.add(subpart);
                } else {
                    this.hashSubpartitions.remove(subpart);
                }
            } else if (event.getAffected() instanceof ListStorageTemplatePartitionOracle) {
                ListStorageTemplatePartitionOracle subpart = (ListStorageTemplatePartitionOracle)event.getAffected();
                subpart.addObjectListener(this);
                if (subpart.getSubPartitionOf() == this) {
                    subpart.setParent(this.listSubpartitions);
                    this.listSubpartitions.add(subpart);
                } else {
                    this.listSubpartitions.remove(subpart);
                }
            } else if (event.getAffected() instanceof PartitionOraclev11g) {
                PartitionOraclev11g subpart = (PartitionOraclev11g)event.getAffected();
                subpart.addObjectListener(this);
                if (subpart.getSubPartitionOf() == this) {
                    subpart.setParent(this.rangeSubpartitions);
                    this.rangeSubpartitions.add(subpart);
                } else {
                    this.rangeSubpartitions.remove(subpart);
                }
            } else {
                super.changed(set, event);
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle subpart = (HashPartitionOracle)event.getAffected();
                this.hashSubpartitions.remove(subpart);
                subpart.removeObjectListener(this);
            } else if (event.getAffected() instanceof ListStorageTemplatePartitionOracle) {
                ListStorageTemplatePartitionOracle subpart = (ListStorageTemplatePartitionOracle)event.getAffected();
                this.listSubpartitions.remove(subpart);
                subpart.removeObjectListener(this);
            } else if (event.getAffected() instanceof PartitionOraclev11g) {
                PartitionOraclev11g part = (PartitionOraclev11g)event.getAffected();
                if (part.getSubPartitionOf() == this) {
                    this.rangeSubpartitions.remove(part);
                    for (int i = 0; i < this.rangeSubpartitions.size(); ++i) {
                        ((PartitionOracle)this.rangeSubpartitions.getElement(i)).setPosition(i + 1);
                    }
                }
                part.removeObjectListener(this);
            } else {
                super.changed(set, event);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 4;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.lobs;
            }
            case 1: {
                return this.hashSubpartitions;
            }
            case 2: {
                return this.listSubpartitions;
            }
            case 3: {
                return this.rangeSubpartitions;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.lobs) {
            return 0;
        }
        if (child == this.hashSubpartitions) {
            return 1;
        }
        if (child == this.listSubpartitions) {
            return 2;
        }
        if (child == this.rangeSubpartitions) {
            return 3;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.lobs) {
            return 0;
        }
        if (child == this.hashSubpartitions) {
            return 1;
        }
        if (child == this.listSubpartitions) {
            return 2;
        }
        if (child == this.rangeSubpartitions) {
            return 3;
        }
        return -1;
    }

    @Override
    public void clearChildren() {
        this.lobs.removeAll();
        this.hashSubpartitions.removeAll();
        this.listSubpartitions.removeAll();
        this.rangeSubpartitions.removeAll();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ListPartitionPropertyDialogOraclev11g dialog = new ListPartitionPropertyDialogOraclev11g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void setPartitionList(PartitionListOracle partitionList) {
        if (this.partitionList != partitionList) {
            if (this.partitionList != null) {
                this.partitionList.removeObjectListener(this);
            }
            this.partitionList = partitionList;
            this.fireDataFieldChange();
            if (partitionList != null) {
                partitionList.addObjectListener(this);
            }
        }
        if (partitionList != null) {
            if ("HASH".equalsIgnoreCase(partitionList.getSubpartitionType())) {
                this.enableSubPartitionsByHash();
            } else if ("LIST".equalsIgnoreCase(partitionList.getSubpartitionType())) {
                this.enableSubPartitionsByList();
            } else if ("RANGE".equalsIgnoreCase(partitionList.getSubpartitionType())) {
                this.enableSubPartitionsByRange();
            } else {
                this.disableSubPartitions();
            }
        }
    }

    public void enableSubPartitionsByHash() {
        if (this.getSubPartitionsQuantity() > 0) {
            this.hashSubpartitions.setForbiddenCreateElement(true);
        } else {
            this.hashSubpartitions.setForbiddenCreateElement(false);
        }
        this.listSubpartitions.setForbiddenCreateElement(true);
        this.listSubpartitions.removeAll();
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.removeAll();
    }

    public void enableSubPartitionsByList() {
        this.hashSubpartitions.setForbiddenCreateElement(true);
        this.hashSubpartitions.removeAll();
        this.listSubpartitions.setForbiddenCreateElement(false);
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.removeAll();
    }

    public void enableSubPartitionsByRange() {
        this.hashSubpartitions.setForbiddenCreateElement(true);
        this.hashSubpartitions.removeAll();
        this.listSubpartitions.setForbiddenCreateElement(true);
        this.listSubpartitions.removeAll();
        this.rangeSubpartitions.setForbiddenCreateElement(false);
    }

    public void disableSubPartitions() {
        this.hashSubpartitions.setForbiddenCreateElement(true);
        this.hashSubpartitions.removeAll();
        this.listSubpartitions.setForbiddenCreateElement(true);
        this.listSubpartitions.removeAll();
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.removeAll();
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        ListPartitionOraclev11g listPart = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev11g)targetDesign).getListPartitionSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                listPart = (ListPartitionOraclev11g)storageObject;
            }
        } else {
            listPart = (ListPartitionOraclev11g)((StorageDesignOraclev11g)targetDesign).getListPartitionSet().createListPartition();
        }
        if (listPart != null) {
            AbstractStorageObjectOracle newSubpart;
            AbstractStorageObjectOracle targetSubpart;
            listPart.setName(this.getName());
            if (this.getPartitionList() != null) {
                PartitionListOraclev11g partList = (PartitionListOraclev11g)((StorageDesignOraclev11g)targetDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (partList == null) {
                    PartitionListOraclev11g newPartList = (PartitionListOraclev11g)((StorageDesignOraclev11g)targetDesign).getPartitionListSet().createPartitionList();
                    newPartList.setName(this.getPartitionList().getName());
                    newPartList.setRawObject(true);
                    listPart.setPartitionList(newPartList);
                } else {
                    listPart.setPartitionList(partList);
                }
            }
            Iterator it = this.lobs.iterator();
            while (it.hasNext()) {
                LobStorageOraclev10g lob = (LobStorageOraclev10g)it.next();
                LobStorageOraclev10g targetLob = (LobStorageOraclev10g)((StorageDesignOraclev11g)targetDesign).getLobStorageSet().getByName(lob.getName());
                if (targetLob == null) {
                    LobStorageOraclev10g newLob = (LobStorageOraclev10g)((StorageDesignOraclev11g)targetDesign).getLobStorageSet().createLobStorage();
                    newLob.setName(lob.getName());
                    newLob.setRawObject(true);
                    newLob.setListPartition(listPart);
                    continue;
                }
                targetLob.setListPartition(listPart);
            }
            it = this.getHashSubpartitions().iterator();
            while (it.hasNext()) {
                HashPartitionOraclev10g hashSubpart = (HashPartitionOraclev10g)it.next();
                targetSubpart = (HashPartitionOraclev10g)((StorageDesignOraclev11g)targetDesign).getHashPartitionSet().getByName(hashSubpart.getName());
                if (targetSubpart == null) {
                    newSubpart = (HashPartitionOraclev10g)((StorageDesignOraclev11g)targetDesign).getHashPartitionSet().createHashPartition();
                    newSubpart.setName(hashSubpart.getName());
                    newSubpart.setRawObject(true);
                    ((HashPartitionOracle)newSubpart).setSubPartitionOf(listPart);
                    listPart.getHashSubpartitions().add(newSubpart);
                    continue;
                }
                ((HashPartitionOracle)targetSubpart).setSubPartitionOf(listPart);
                listPart.getHashSubpartitions().add(targetSubpart);
            }
            it = this.getListSubpartitions().iterator();
            while (it.hasNext()) {
                ListStorageTemplatePartitionOraclev10g listSubpart = (ListStorageTemplatePartitionOraclev10g)it.next();
                targetSubpart = (ListStorageTemplatePartitionOraclev10g)((StorageDesignOraclev11g)targetDesign).getListStorageTemplatePartitionSet().getByName(listSubpart.getName());
                if (targetSubpart == null) {
                    newSubpart = (ListStorageTemplatePartitionOraclev10g)((StorageDesignOraclev11g)targetDesign).getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                    newSubpart.setName(listSubpart.getName());
                    newSubpart.setRawObject(true);
                    ((ListStorageTemplatePartitionOracle)newSubpart).setSubPartitionOf(listPart);
                    listPart.getListSubpartitions().add(newSubpart);
                    continue;
                }
                ((ListStorageTemplatePartitionOracle)targetSubpart).setSubPartitionOf(listPart);
                listPart.getListSubpartitions().add(targetSubpart);
            }
            it = this.getRangeSubpartitions().iterator();
            while (it.hasNext()) {
                PartitionOraclev11g rangeSubpart = (PartitionOraclev11g)it.next();
                targetSubpart = (PartitionOraclev11g)((StorageDesignOraclev11g)targetDesign).getPartitionSet().getByName(rangeSubpart.getName());
                if (targetSubpart == null) {
                    newSubpart = (PartitionOraclev11g)((StorageDesignOraclev11g)targetDesign).getPartitionSet().createPartition();
                    newSubpart.setName(rangeSubpart.getName());
                    newSubpart.setRawObject(true);
                    ((PartitionOraclev11g)newSubpart).setSubPartitionOf(listPart);
                    listPart.getRangeSubpartitions().add(newSubpart);
                    continue;
                }
                ((PartitionOraclev11g)targetSubpart).setSubPartitionOf(listPart);
                listPart.getRangeSubpartitions().add(targetSubpart);
            }
            listPart.setColumns(this.getColumns());
            listPart.setDataSegmentCompression(this.getDataSegmentCompression());
            if (this.getTablespace() != null) {
                TableSpaceOraclev10g tablespace = (TableSpaceOraclev10g)((StorageDesignOraclev11g)targetDesign).getTableSpaceSet().getByName(this.getTablespace().getName());
                if (tablespace == null) {
                    TableSpaceOraclev10g newTablespace = (TableSpaceOraclev10g)((StorageDesignOraclev11g)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getTablespace().getName());
                    newTablespace.setRawObject(true);
                    listPart.setTablespace(newTablespace);
                } else {
                    listPart.setTablespace(tablespace);
                }
            }
            listPart.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                SegmentOraclev10g segment = (SegmentOraclev10g)((StorageDesignOraclev11g)targetDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (segment == null) {
                    SegmentOraclev10g newSegment = (SegmentOraclev10g)((StorageDesignOraclev11g)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getSegment().getName());
                    newSegment.setRawObject(true);
                    listPart.setSegment(newSegment);
                } else {
                    listPart.setSegment(segment);
                }
            }
            listPart.setSubPartitionsQuantity(this.getSubPartitionsQuantity());
            listPart.recreateSubPartitionsTSSet(this.getSubPartTSSet().toString());
            listPart.setComment(this.getComment());
            listPart.setRawObject(false);
        }
    }

    public HashPartitionOracle createHashSubpartition() {
        if (this.hashSubpartitions.getStorageObjectSet() != null) {
            return (HashPartitionOracle)this.hashSubpartitions.createElement(null);
        }
        return null;
    }

    public ListStorageTemplatePartitionOracle createListSubpartition() {
        if (this.listSubpartitions.getStorageObjectSet() != null) {
            return (ListStorageTemplatePartitionOracle)this.listSubpartitions.createElement(null);
        }
        return null;
    }

    public PartitionOracle createRangeSubpartition() {
        if (this.rangeSubpartitions.getStorageObjectSet() != null) {
            return (PartitionOracle)this.rangeSubpartitions.createElement(null);
        }
        return null;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append("| ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

