/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v11g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;

public class PartitionListOraclev11g
extends PartitionListOraclev10g {
    public static final String PARTITION_TYPE_REFERENCE = "REFERENCE";
    public static final String PARTITION_TYPE_SYSTEM = "SYSTEM";
    private static final String[] PARTITION_TYPES = new String[]{"RANGE", "HASH BY QUANTITY", "HASH BY LIST OF PARTITIONS", "LIST", "REFERENCE", "SYSTEM"};
    private static final String[] SUBPARTITION_TYPES = new String[]{"", "RANGE", "HASH", "LIST"};
    private static Set partitionTypeSet = null;
    private static Set subpartitionTypeSet = null;
    private FKProxyOracle refConstraint = null;
    private int systemPartitions = 1;
    private String intervalExpression = "";
    private PartitionListOraclev9i.InlineList intervalTablespaceSet = null;
    private String intervalTablespaces = "";

    public PartitionListOraclev11g(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void setPartitionType(String partitionType) {
        if (partitionType.equalsIgnoreCase("COMPOSITE BY HASH")) {
            partitionType = "RANGE";
            this.setSubpartitionType("HASH");
        } else if (partitionType.equalsIgnoreCase("COMPOSITE BY LIST")) {
            partitionType = "RANGE";
            this.setSubpartitionType("LIST");
        }
        if (!this.partitionType.equals(partitionType) && this.checkPartitionType(partitionType)) {
            this.partitionType = partitionType;
            if (!(partitionType.equalsIgnoreCase("RANGE") || partitionType.equalsIgnoreCase("LIST") || partitionType.startsWith("HASH"))) {
                this.setSubpartitionType("");
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    protected boolean checkPartitionType(String value) {
        if (partitionTypeSet == null) {
            partitionTypeSet = new HashSet();
            partitionTypeSet.addAll(Arrays.asList(PartitionListOraclev11g.getPartitionTypes()));
        }
        return partitionTypeSet.contains(value);
    }

    public static String[] getPartitionTypes() {
        return PARTITION_TYPES;
    }

    @Override
    public void setSubpartitionType(String subpartitionType) {
        if (!this.subpartitionType.equals(subpartitionType) && this.checkSubpartitionType(subpartitionType)) {
            this.subpartitionType = subpartitionType;
            if (subpartitionType.equalsIgnoreCase("HASH")) {
                this.enableSubPartitionsForCompositeByHash();
            } else if (subpartitionType.equalsIgnoreCase("LIST")) {
                this.enableSubPartitionsForCompositeByList();
            } else if (subpartitionType.equalsIgnoreCase("RANGE")) {
                this.enableSubPartitionsForCompositeByRange();
            } else {
                this.disableSubPartitionsForNonComposite();
            }
            this.fireDataFieldChange();
        }
    }

    protected boolean checkSubpartitionType(String value) {
        if (subpartitionTypeSet == null) {
            subpartitionTypeSet = new HashSet();
            subpartitionTypeSet.addAll(Arrays.asList(PartitionListOraclev11g.getSubpartitionTypes()));
        }
        return subpartitionTypeSet.contains(value);
    }

    public static String[] getSubpartitionTypes() {
        return SUBPARTITION_TYPES;
    }

    protected void enableSubPartitionsForCompositeByRange() {
        StorageObjectCollection partitions = null;
        TableProxyOracle tableProxy = this.getTable();
        if (tableProxy != null) {
            partitions = tableProxy.getPartitions();
        } else if (this.getSnapshot() != null) {
            partitions = this.getSnapshot().getPartitionsCollection();
        }
        if (partitions != null) {
            for (AbstractStorageObjectOracle partition : partitions.getElementsList()) {
                if (partition instanceof PartitionOraclev11g) {
                    ((PartitionOraclev11g)partition).enableSubPartitionsByRange();
                    continue;
                }
                if (!(partition instanceof ListPartitionOraclev11g)) continue;
                ((ListPartitionOraclev11g)partition).enableSubPartitionsByRange();
            }
        }
    }

    public void setRefConstraint(FKProxyOracle refConstraint) {
        this.refConstraint = refConstraint;
    }

    public void setRefConstraint(String constraintName) {
        StorageObjectCollection fKeys = null;
        TableProxyOracle tableProxy = this.getTable();
        if (tableProxy != null) {
            fKeys = tableProxy.getFKeys();
        }
        if (fKeys != null) {
            String fkName = constraintName.substring(constraintName.lastIndexOf(46) + 1);
            Iterator it = fKeys.iterator();
            while (it.hasNext()) {
                FKProxyOracle fk = (FKProxyOracle)it.next();
                if (!fk.getName().equals(fkName)) continue;
                this.refConstraint = fk;
                return;
            }
        }
    }

    public FKProxyOracle getRefConstraint() {
        return this.refConstraint;
    }

    public void setSystemPartitions(int systemPartitions) {
        this.systemPartitions = systemPartitions;
    }

    public int getSystemPartitions() {
        return this.systemPartitions;
    }

    public void setIntervalExpression(String intervalExpression) {
        this.intervalExpression = intervalExpression;
    }

    public String getIntervalExpression() {
        return this.intervalExpression;
    }

    public String getIntervalTablespaces() {
        return this.intervalTablespaces;
    }

    public String getAllIntervalTablespaces() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.intervalTablespaces, ",");
        while (st.hasMoreTokens()) {
            String tsID = st.nextToken().trim();
            TableSpaceOracle ts = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(tsID);
            if (ts == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(ts.getName());
        }
        return result.toString();
    }

    public void setIntervalTablespaceSet(String intervalTablespace) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateIntervalTablespaceSet(intervalTablespace);
        } else {
            this.addIntervalTablespace(intervalTablespace);
        }
        String newValue = this.getIntervalTablespaceSet().toString();
        if (!this.intervalTablespaces.equals(newValue)) {
            this.intervalTablespaces = newValue;
            this.fireDataFieldChange();
        }
    }

    private void addIntervalTablespace(String intervalTablespace) {
        if (!this.getIntervalTablespaceSet().contains(intervalTablespace)) {
            this.getIntervalTablespaceSet().add(intervalTablespace);
        }
    }

    private void recreateIntervalTablespaceSet(String intervalTablespace) {
        this.getIntervalTablespaceSet().clear();
        StringTokenizer st = new StringTokenizer(intervalTablespace, ",");
        while (st.hasMoreTokens()) {
            this.getIntervalTablespaceSet().add(st.nextToken().trim());
        }
    }

    public PartitionListOraclev9i.InlineList getIntervalTablespaceSet() {
        if (this.intervalTablespaceSet == null) {
            this.intervalTablespaceSet = new PartitionListOraclev9i.InlineList(this);
        }
        return this.intervalTablespaceSet;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        PartitionListOraclev11g partList = null;
        PartitionListOraclev11g stObject = (PartitionListOraclev11g)((StorageDesignOracle)targetDesign).getPartitionListSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                partList = stObject;
            }
        } else {
            partList = (PartitionListOraclev11g)((StorageDesignOracle)targetDesign).getPartitionListSet().createPartitionList();
        }
        if (partList != null) {
            partList.setName(this.getName());
            partList.setPartitionType(this.getPartitionType());
            partList.setSubpartitionType(this.getSubpartitionType());
            partList.setUseSubpartStorageTemplate(this.getUseSubpartStorageTemplate());
            partList.recreateColumnsSet(this.getColumnSet().toString());
            partList.recreateHashPartitionsTSSet(this.getHashPartitionsTableSpacesSet().toString());
            partList.recreateIOTOverflowHashPTSSet(this.getIOTOverflowHashPTSSet().toString());
            partList.recreateSubPartitionsColumnsSet(this.getSubPartitionsColumnsSet().toString());
            partList.recreateSubPartitionsTSSet(this.getSubPartitionsTableSpacesSet().toString());
            partList.setHashPQuantity(this.getHashPQuantity());
            partList.setSubPartitionsQuantity(this.getSubPartitionsQuantity());
            partList.setRefConstraint(this.getRefConstraint());
            partList.setSystemPartitions(this.getSystemPartitions());
            partList.setIntervalExpression(this.getIntervalExpression());
            partList.recreateIntervalTablespaceSet(this.getIntervalTablespaceSet().toString());
            partList.setRawObject(false);
        }
    }
}

