/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v11g;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxySetOraclev11g;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class PartitionOraclev11g
extends PartitionOraclev10g {
    private int numberOfChildren = 4;
    private TableProxyOracle partOfStorageTable;
    private AbstractStorageObjectOracle subPartitionOf;
    private StorageObjectCollection rangeSubpartitions;

    public PartitionOraclev11g(StorageDesign storageDesign) {
        super(storageDesign);
        PartitionSetOracle partitionSet = ((StorageDesignOracle)storageDesign).getPartitionSet();
        this.rangeSubpartitions = new StorageObjectCollection(partitionSet);
        this.rangeSubpartitions.setParent(this);
        this.rangeSubpartitions.setName(Messages.getString("PartitionOraclev11g.RangeSubpartitions"));
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.setClassForParent(AbstractStorageObjectOracle.class);
        this.rangeSubpartitions.setSetMethod("setSubPartitionOf");
        this.rangeSubpartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        partitionSet.addSetListener(this);
        this.addRangeSubpartitionsFromDesign(partitionSet);
    }

    protected void addRangeSubpartitionsFromDesign(PartitionSetOracle rangePartitionSet) {
        Iterator it = rangePartitionSet.iterator();
        while (it.hasNext()) {
            PartitionOraclev11g part = (PartitionOraclev11g)it.next();
            if (part.getSubPartitionOf() == this) {
                part.addObjectListener(this);
                part.setParent(this.rangeSubpartitions);
                this.rangeSubpartitions.add(part);
                continue;
            }
            this.rangeSubpartitions.remove(part);
        }
    }

    public StorageObjectCollection getRangeSubpartitions() {
        return this.rangeSubpartitions;
    }

    public void setPartOfStorageTable(TableProxyOracle partOfStorageTable) {
        if (this.partOfStorageTable != partOfStorageTable) {
            this.partOfStorageTable = partOfStorageTable;
            if (partOfStorageTable != null) {
                this.numberOfChildren = 1;
                this.useLobItems();
            }
        }
    }

    public TableProxyOracle getPartOfStorageTable() {
        return this.partOfStorageTable;
    }

    public void setSubPartitionOf(AbstractStorageObjectOracle subPartitionOf) {
        if (this.subPartitionOf != subPartitionOf) {
            this.subPartitionOf = subPartitionOf;
            if (subPartitionOf != null) {
                this.numberOfChildren = 1;
                this.useLobItems();
            }
        }
    }

    public AbstractStorageObjectOracle getSubPartitionOf() {
        return this.subPartitionOf;
    }

    private void useLobItems() {
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        storageDesign.getLobStorageSet().removeSetListener(this);
        this.lobs = new StorageObjectCollection(storageDesign.getHashPartitionLobItemSet());
        this.lobs.setParent(this);
        this.lobs.setName(Messages.getString("PartitionOracle.LobStorages"));
        this.lobs.setClassForParent(PartitionOracle.class);
        this.lobs.setSetMethod("setRangePartition");
        storageDesign.getHashPartitionLobItemSet().addSetListener(this);
    }

    @Override
    public boolean hasSubPartitions() {
        return this.partitions.size() > 0 || this.listPartitions.size() > 0 || this.rangeSubpartitions.size() > 0;
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof PartitionOraclev11g) {
            PartitionOraclev11g part = (PartitionOraclev11g)event.getAffected();
            if (part.getSubPartitionOf() == this) {
                part.setParent(this.rangeSubpartitions);
                this.rangeSubpartitions.add(part);
                part.removeObjectListener(this);
                part.setPosition(this.rangeSubpartitions.size());
                part.addObjectListener(this);
            } else {
                this.rangeSubpartitions.remove(part);
            }
        } else {
            super.changed(object, event);
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof PartitionOraclev11g) {
                PartitionOraclev11g subpart = (PartitionOraclev11g)event.getAffected();
                subpart.addObjectListener(this);
                if (subpart.getSubPartitionOf() == this) {
                    subpart.setParent(this.rangeSubpartitions);
                    this.rangeSubpartitions.add(subpart);
                } else {
                    this.rangeSubpartitions.remove(subpart);
                }
            } else {
                super.changed(set, event);
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof PartitionOraclev11g) {
                PartitionOraclev11g subpart = (PartitionOraclev11g)event.getAffected();
                if (subpart.getSubPartitionOf() == this) {
                    this.rangeSubpartitions.remove(subpart);
                    for (int i = 0; i < this.rangeSubpartitions.size(); ++i) {
                        ((PartitionOracle)this.rangeSubpartitions.getElement(i)).setPosition(i + 1);
                    }
                }
                subpart.removeObjectListener(this);
            } else {
                super.changed(set, event);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return this.numberOfChildren;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.lobs;
            }
            case 1: {
                return this.partitions;
            }
            case 2: {
                return this.listPartitions;
            }
            case 3: {
                return this.rangeSubpartitions;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.lobs) {
            return 0;
        }
        if (child == this.partitions) {
            return 1;
        }
        if (child == this.listPartitions) {
            return 2;
        }
        if (child == this.rangeSubpartitions) {
            return 3;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.lobs) {
            return 0;
        }
        if (child == this.partitions) {
            return 1;
        }
        if (child == this.listPartitions) {
            return 2;
        }
        if (child == this.rangeSubpartitions) {
            return 3;
        }
        return -1;
    }

    @Override
    public void clearChildren() {
        this.lobs.removeAll();
        this.partitions.removeAll();
        this.listPartitions.removeAll();
        this.rangeSubpartitions.removeAll();
    }

    @Override
    public void setPartitionList(PartitionListOracle partitionList) {
        if (this.partitionList != partitionList) {
            if (this.partitionList != null) {
                this.partitionList.removeObjectListener(this);
            }
            this.partitionList = partitionList;
            this.fireDataFieldChange();
            if (partitionList != null) {
                partitionList.addObjectListener(this);
            }
        }
        if (partitionList != null) {
            if ("HASH".equalsIgnoreCase(partitionList.getSubpartitionType())) {
                this.enableSubPartitionsByHash();
            } else if ("LIST".equalsIgnoreCase(partitionList.getSubpartitionType())) {
                this.enableSubPartitionsByList();
            } else if ("RANGE".equalsIgnoreCase(partitionList.getSubpartitionType())) {
                this.enableSubPartitionsByRange();
            } else {
                this.disableSubPartitions();
            }
        }
    }

    @Override
    public void enableSubPartitionsByHash() {
        if (this.getSubPartitionsQuantity() > 0) {
            this.partitions.setForbiddenCreateElement(true);
        } else {
            this.partitions.setForbiddenCreateElement(false);
        }
        this.listPartitions.setForbiddenCreateElement(true);
        this.listPartitions.removeAll();
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.removeAll();
    }

    @Override
    public void enableSubPartitionsByList() {
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.removeAll();
        this.listPartitions.setForbiddenCreateElement(false);
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.removeAll();
    }

    public void enableSubPartitionsByRange() {
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.removeAll();
        this.listPartitions.setForbiddenCreateElement(true);
        this.listPartitions.removeAll();
        this.rangeSubpartitions.setForbiddenCreateElement(false);
    }

    @Override
    public void disableSubPartitions() {
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.removeAll();
        this.listPartitions.setForbiddenCreateElement(true);
        this.listPartitions.removeAll();
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.removeAll();
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        PartitionOraclev11g partition = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev11g)targetDesign).getPartitionSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                partition = (PartitionOraclev11g)stObject;
            }
        } else {
            partition = (PartitionOraclev11g)((StorageDesignOraclev11g)targetDesign).getPartitionSet().createPartition();
        }
        if (partition != null) {
            SegmentOraclev10g newSegment;
            SegmentOraclev10g segment;
            partition.setName(this.getName());
            if (this.getPartitionList() != null) {
                PartitionListOraclev11g partList = (PartitionListOraclev11g)((StorageDesignOraclev11g)targetDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (partList == null) {
                    PartitionListOraclev11g newPartList = (PartitionListOraclev11g)((StorageDesignOraclev11g)targetDesign).getPartitionListSet().createPartitionList();
                    newPartList.setName(this.getPartitionList().getName());
                    newPartList.setRawObject(true);
                    partition.setPartitionList(newPartList);
                } else {
                    partition.setPartitionList(partList);
                }
            }
            if (this.getPartOfStorageTable() != null) {
                Table table = (Table)targetDesign.getPhysicalDesign().getTableSet().getByName(this.getPartOfStorageTable().getObject().getName());
                TableProxyOraclev11g tableProxy = (TableProxyOraclev11g)targetDesign.getTableProxySet().getProxy(table.getObjectID());
                if (tableProxy == null) {
                    TableProxyOraclev11g newTableProxy = (TableProxyOraclev11g)((TableProxySetOraclev11g)targetDesign.getTableProxySet()).createProxy(table);
                    newTableProxy.setName(this.getPartOfStorageTable().getName());
                    newTableProxy.setRawObject(true);
                    partition.setPartOfStorageTable(newTableProxy);
                } else {
                    partition.setPartOfStorageTable(tableProxy);
                }
            }
            if (this.getSubPartitionOf() != null) {
                PartitionOraclev11g parentPartition = (PartitionOraclev11g)((StorageDesignOraclev11g)targetDesign).getPartitionSet().getByName(this.getSubPartitionOf().getName());
                if (parentPartition == null) {
                    PartitionOraclev11g newPartition = (PartitionOraclev11g)((StorageDesignOraclev11g)targetDesign).getPartitionSet().createPartition();
                    newPartition.setName(this.getSubPartitionOf().getName());
                    newPartition.setRawObject(true);
                    partition.setSubPartitionOf(newPartition);
                } else {
                    partition.setSubPartitionOf(parentPartition);
                }
            }
            Iterator it = this.getPartitions().iterator();
            while (it.hasNext()) {
                HashPartitionOraclev10g hashPart = (HashPartitionOraclev10g)it.next();
                HashPartitionOraclev10g targetHashPart = (HashPartitionOraclev10g)((StorageDesignOraclev11g)targetDesign).getHashPartitionSet().getByName(hashPart.getName());
                if (targetHashPart == null) {
                    HashPartitionOraclev10g newHashPart = (HashPartitionOraclev10g)((StorageDesignOraclev11g)targetDesign).getHashPartitionSet().createHashPartition();
                    newHashPart.setName(hashPart.getName());
                    newHashPart.setRawObject(true);
                    newHashPart.setSubPartitionOf(partition);
                    partition.getPartitions().add(newHashPart);
                    continue;
                }
                targetHashPart.setSubPartitionOf(partition);
                partition.getPartitions().add(targetHashPart);
            }
            it = this.getLobs().iterator();
            while (it.hasNext()) {
                Object storageObject = it.next();
                if (storageObject instanceof LobStorageOraclev10g) {
                    LobStorageOraclev10g lobStorage = (LobStorageOraclev10g)storageObject;
                    LobStorageOraclev10g targetLobStorage = (LobStorageOraclev10g)((StorageDesignOraclev11g)targetDesign).getLobStorageSet().getByName(lobStorage.getName());
                    if (targetLobStorage == null) {
                        LobStorageOraclev10g newLobStorage = (LobStorageOraclev10g)((StorageDesignOraclev11g)targetDesign).getLobStorageSet().createLobStorage();
                        newLobStorage.setName(lobStorage.getName());
                        newLobStorage.setRawObject(true);
                        newLobStorage.setPartition(partition);
                        partition.getLobs().add(newLobStorage);
                        continue;
                    }
                    targetLobStorage.setPartition(partition);
                    partition.getLobs().add(targetLobStorage);
                    continue;
                }
                if (!(storageObject instanceof HashPartitionLobItemOracle)) continue;
                HashPartitionLobItemOracle lobItem = (HashPartitionLobItemOracle)storageObject;
                HashPartitionLobItemOracle targetLobItem = (HashPartitionLobItemOracle)((StorageDesignOraclev11g)targetDesign).getLobStorageSet().getByName(lobItem.getName());
                if (targetLobItem == null) {
                    HashPartitionLobItemOracle newLobItem = ((StorageDesignOraclev11g)targetDesign).getHashPartitionLobItemSet().createHashPartitionLobItem();
                    newLobItem.setName(lobItem.getName());
                    newLobItem.setRawObject(true);
                    newLobItem.setRangePartition(partition);
                    partition.getLobs().add(newLobItem);
                    continue;
                }
                targetLobItem.setRangePartition(partition);
                partition.getLobs().add(targetLobItem);
            }
            it = this.getListPartitions().iterator();
            while (it.hasNext()) {
                ListStorageTemplatePartitionOraclev10g partList = (ListStorageTemplatePartitionOraclev10g)it.next();
                ListStorageTemplatePartitionOraclev10g targetPartList = (ListStorageTemplatePartitionOraclev10g)((StorageDesignOraclev11g)targetDesign).getListStorageTemplatePartitionSet().getByName(partList.getName());
                if (targetPartList == null) {
                    ListStorageTemplatePartitionOraclev10g newPartList = (ListStorageTemplatePartitionOraclev10g)((StorageDesignOraclev11g)targetDesign).getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                    newPartList.setName(partList.getName());
                    newPartList.setRawObject(true);
                    newPartList.setSubPartitionOf(partition);
                    partition.getListPartitions().add(newPartList);
                    continue;
                }
                targetPartList.setSubPartitionOf(partition);
                partition.getListPartitions().add(targetPartList);
            }
            it = this.getRangeSubpartitions().iterator();
            while (it.hasNext()) {
                PartitionOraclev11g rangeSubpart = (PartitionOraclev11g)it.next();
                PartitionOraclev11g targetSubpart = (PartitionOraclev11g)((StorageDesignOraclev11g)targetDesign).getPartitionSet().getByName(rangeSubpart.getName());
                if (targetSubpart == null) {
                    PartitionOraclev11g newSubpart = (PartitionOraclev11g)((StorageDesignOraclev11g)targetDesign).getPartitionSet().createPartition();
                    newSubpart.setName(rangeSubpart.getName());
                    newSubpart.setRawObject(true);
                    newSubpart.setSubPartitionOf(partition);
                    partition.getRangeSubpartitions().add(newSubpart);
                    continue;
                }
                targetSubpart.setSubPartitionOf(partition);
                partition.getRangeSubpartitions().add(targetSubpart);
            }
            partition.setValueList(this.getValueList());
            partition.setPosition(this.getPosition());
            if (this.getTableSpace() != null) {
                TableSpaceOraclev10g tableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev11g)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tableSpace == null) {
                    TableSpaceOraclev10g newTableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev11g)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    partition.setTableSpace(newTableSpace);
                } else {
                    partition.setTableSpace(tableSpace);
                }
            }
            partition.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                segment = (SegmentOraclev10g)((StorageDesignOraclev11g)targetDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (segment == null) {
                    newSegment = (SegmentOraclev10g)((StorageDesignOraclev11g)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getSegment().getName());
                    newSegment.setRawObject(true);
                    partition.setSegment(newSegment);
                } else {
                    partition.setSegment(segment);
                }
            }
            partition.setDataSegmentCompression(this.getDataSegmentCompression());
            partition.setIOTCompress(this.getIOTCompress());
            if (this.getIOTOverflowSegment() != null) {
                segment = (SegmentOraclev10g)((StorageDesignOraclev11g)targetDesign).getSegmentSet().getByName(this.getIOTOverflowSegment().getName());
                if (segment == null) {
                    newSegment = (SegmentOraclev10g)((StorageDesignOraclev11g)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getIOTOverflowSegment().getName());
                    newSegment.setRawObject(true);
                    partition.setIOTOverflowSegment(newSegment);
                } else {
                    partition.setIOTOverflowSegment(segment);
                }
            }
            partition.setSubPartitionsQuantity(this.getSubPartitionsQuantity());
            partition.recreateSubPartitionsTSSet(this.getSubPartTSSet().toString());
            partition.setComment(this.getComment());
            partition.setRawObject(false);
        }
    }

    public PartitionOracle createRangeSubpartition() {
        if (this.rangeSubpartitions.getStorageObjectSet() != null) {
            return (PartitionOracle)this.rangeSubpartitions.createElement(null);
        }
        return null;
    }
}

