/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v12c;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v12c.ColumnPropertyDialogOraclev12c;
import oracle.dbtools.crest.util.options.Settings;

public class ColumnProxyOraclev12c
extends ColumnProxyOraclev11g {
    private String defaultOnNull = "NO";
    private String invisible = "NO";
    public static final String DEFAULT_CLAUSE = "DEFAULT_CLAUSE";
    public static final String IDENTITY_CLAUSE = "IDENTITY_CLAUSE";
    private static final String[] AUTOINCREMENTDDL = new String[]{"", "NONE", "TRIGGER", "DEFAULT_CLAUSE", "IDENTITY_CLAUSE"};

    public ColumnProxyOraclev12c(Column column, StorageDesign storage) {
        super(column, storage);
    }

    public ColumnProxyOraclev12c(Design design, String id, String longName, StorageDesign storage) {
        super(design, id, longName, storage);
    }

    public String getDefaultOnNull() {
        return this.defaultOnNull;
    }

    public void setDefaultOnNull(String defaultOnNull) {
        if (ConstantsOracle.checkYesNo(defaultOnNull)) {
            this.defaultOnNull = defaultOnNull;
        }
    }

    public String getInvisible() {
        return this.invisible;
    }

    public void setInvisible(String invisible) {
        if (ConstantsOracle.checkYesNo(invisible)) {
            this.invisible = invisible;
        }
    }

    public static String[] getAutoIncrementDDLChoices() {
        return AUTOINCREMENTDDL;
    }

    @Override
    public String getDDLTypeForAutoIncCol() {
        String autoIncrementDDL = this.getAutoIncrementDDL();
        if (autoIncrementDDL.equals("")) {
            Settings settings = this.getAppView().getSettings();
            Column column = (Column)this.getObject();
            if (column.isIdentityColumn()) {
                String dt;
                autoIncrementDDL = settings.getDefaultOracleIdentityDDL();
                if (autoIncrementDDL.equals(IDENTITY_CLAUSE) && (dt = column.getDatatypeString(this.getStorageDesign().getRDBMSType().getName())).toUpperCase().indexOf("CHAR") > -1) {
                    autoIncrementDDL = settings.getDefaultOracleAutoIncDDL();
                }
            } else {
                autoIncrementDDL = settings.getDefaultOracleAutoIncDDL();
            }
        }
        return autoIncrementDDL;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnPropertyDialogOraclev12c dialog = new ColumnPropertyDialogOraclev12c(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.init();
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Column column = (Column)targetDesign.getPhysicalDesign().getColumnSet().getByName(this.getObject().getName());
        ColumnProxyOraclev12c columnProxy = null;
        RelationalObjectProxy storageObject = targetDesign.getColumnProxySet().getProxy(column.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            columnProxy = (ColumnProxyOraclev12c)storageObject;
        }
        if (columnProxy != null) {
            super.copy(targetDesign);
            columnProxy.setDefaultOnNull(this.getDefaultOnNull());
            columnProxy.setInvisible(this.getInvisible());
        }
    }
}

