/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;

public class PartitionListOraclev9i
extends PartitionListOracle {
    private static final String COMMA = ",";
    public static final String PARTITION_TYPE_COMPOSITE_BY_HASH = "COMPOSITE BY HASH";
    public static final String PARTITION_TYPE_COMPOSITE_BY_LIST = "COMPOSITE BY LIST";
    public static final String PARTITION_TYPE_LIST = "LIST";
    private static final String[] PARTITION_TYPE = new String[]{"RANGE", "COMPOSITE BY HASH", "COMPOSITE BY LIST", "HASH BY QUANTITY", "HASH BY LIST OF PARTITIONS", "LIST"};
    public static final String SUBPARTITION_TYPE_RANGE = "RANGE";
    public static final String SUBPARTITION_TYPE_HASH = "HASH";
    public static final String SUBPARTITION_TYPE_LIST = "LIST";
    private static Set partitionTypeSet = null;
    private InlineList IOTOverflowHashPTSSet = null;
    private String IOTOverflowHashPTS = "";
    protected String useSubpartStorageTemplate = "NO";

    public PartitionListOraclev9i(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void showPropertyDialog() {
    }

    public String getIOTOverflowHashPTS() {
        return this.IOTOverflowHashPTS;
    }

    public String getAllIOTOverflowHashPTS() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.IOTOverflowHashPTS, COMMA);
        while (st.hasMoreTokens()) {
            String tsID = st.nextToken().trim();
            TableSpaceOracle ts = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(tsID);
            if (ts == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(ts.getName());
        }
        return result.toString();
    }

    public void setIOTOverflowHashPTSSet(String overflowHashPTS) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateIOTOverflowHashPTSSet(overflowHashPTS);
        } else {
            this.addIOTOverflowHashPTS(overflowHashPTS);
        }
        String newValue = this.getIOTOverflowHashPTSSet().toString();
        if (!this.IOTOverflowHashPTS.equals(newValue)) {
            this.IOTOverflowHashPTS = newValue;
            this.fireDataFieldChange();
        }
    }

    private void addIOTOverflowHashPTS(String IOTOverflowHashPTS) {
        if (!this.getIOTOverflowHashPTSSet().contains(IOTOverflowHashPTS)) {
            this.getIOTOverflowHashPTSSet().add(IOTOverflowHashPTS);
        }
    }

    public void recreateIOTOverflowHashPTSSet(String IOTOverflowHashPTS) {
        this.getIOTOverflowHashPTSSet().clear();
        StringTokenizer st = new StringTokenizer(IOTOverflowHashPTS, COMMA);
        while (st.hasMoreTokens()) {
            this.getIOTOverflowHashPTSSet().add(st.nextToken().trim());
        }
    }

    public InlineList getIOTOverflowHashPTSSet() {
        if (this.IOTOverflowHashPTSSet == null) {
            this.IOTOverflowHashPTSSet = new InlineList();
        }
        return this.IOTOverflowHashPTSSet;
    }

    public String getUseSubpartStorageTemplate() {
        return this.useSubpartStorageTemplate;
    }

    public void setUseSubpartStorageTemplate(String useSubpartStorageTemplate) {
        if (!this.useSubpartStorageTemplate.equalsIgnoreCase(useSubpartStorageTemplate)) {
            if (useSubpartStorageTemplate.equalsIgnoreCase("NO") && this.getTable() != null) {
                this.getTable().disableListStorageTemplates();
            } else if (useSubpartStorageTemplate.equalsIgnoreCase("YES") && this.getTable() != null) {
                this.getTable().enableListStorageTemplates();
            }
            this.useSubpartStorageTemplate = useSubpartStorageTemplate;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.getIOTOverflowHashPTSSet().clear();
        this.IOTOverflowHashPTS = "";
    }

    @Override
    public void setSubpartitionType(String subpartitionType) {
        this.subpartitionType = subpartitionType;
    }

    @Override
    public void setPartitionType(String partitionType) {
        if (!this.partitionType.equals(partitionType) && this.checkPartitionType(partitionType)) {
            this.partitionType = partitionType;
            if (partitionType.equalsIgnoreCase(PARTITION_TYPE_COMPOSITE_BY_HASH)) {
                this.setSubpartitionType(SUBPARTITION_TYPE_HASH);
                this.enableSubPartitionsForCompositeByHash();
            } else if (partitionType.equalsIgnoreCase(PARTITION_TYPE_COMPOSITE_BY_LIST)) {
                this.setSubpartitionType("LIST");
                this.enableSubPartitionsForCompositeByList();
            } else {
                this.setSubpartitionType("");
                this.disableSubPartitionsForNonComposite();
            }
            this.fireDataFieldChange();
        }
    }

    public static String[] getPartitionTypes() {
        return PARTITION_TYPE;
    }

    protected boolean checkPartitionType(String value) {
        if (partitionTypeSet == null) {
            partitionTypeSet = new HashSet();
            partitionTypeSet.addAll(Arrays.asList(PartitionListOraclev9i.getPartitionTypes()));
        }
        return partitionTypeSet.contains(value);
    }

    protected void enableSubPartitionsForCompositeByHash() {
        StorageObjectCollection partitions = null;
        TableProxyOracle tableProxy = this.getTable();
        if (tableProxy != null) {
            partitions = tableProxy.getPartitions();
        } else if (this.getSnapshot() != null) {
            partitions = this.getSnapshot().getPartitionsCollection();
        }
        if (partitions != null) {
            for (AbstractStorageObjectOracle partition : partitions.getElementsList()) {
                if (partition instanceof PartitionOracle) {
                    ((PartitionOracle)partition).enableSubPartitionsByHash();
                    continue;
                }
                if (!(partition instanceof ListPartitionOraclev11g)) continue;
                ((ListPartitionOraclev11g)partition).enableSubPartitionsByHash();
            }
        }
    }

    protected void enableSubPartitionsForCompositeByList() {
        StorageObjectCollection partitions = null;
        TableProxyOracle tableProxy = this.getTable();
        if (tableProxy != null) {
            partitions = tableProxy.getPartitions();
        } else if (this.getSnapshot() != null) {
            partitions = this.getSnapshot().getPartitionsCollection();
        }
        if (partitions != null) {
            for (AbstractStorageObjectOracle partition : partitions.getElementsList()) {
                if (partition instanceof PartitionOracle) {
                    ((PartitionOracle)partition).enableSubPartitionsByList();
                    continue;
                }
                if (!(partition instanceof ListPartitionOraclev11g)) continue;
                ((ListPartitionOraclev11g)partition).enableSubPartitionsByList();
            }
        }
    }

    protected void disableSubPartitionsForNonComposite() {
        StorageObjectCollection partitions = null;
        TableProxyOracle tableProxy = this.getTable();
        if (tableProxy != null) {
            partitions = tableProxy.getPartitions();
        } else if (this.getSnapshot() != null) {
            partitions = this.getSnapshot().getPartitionsCollection();
        }
        if (partitions != null) {
            for (AbstractStorageObjectOracle partition : partitions.getElementsList()) {
                if (partition instanceof PartitionOracle) {
                    ((PartitionOracle)partition).disableSubPartitions();
                    continue;
                }
                if (!(partition instanceof ListPartitionOraclev11g)) continue;
                ((ListPartitionOraclev11g)partition).disableSubPartitions();
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof PartitionOracle) {
                PartitionOracle part = (PartitionOracle)event.getAffected();
                part.addObjectListener(this);
                if (part.getPartitionList() == this) {
                    if (SUBPARTITION_TYPE_HASH.equalsIgnoreCase(this.getSubpartitionType())) {
                        part.enableSubPartitionsByHash();
                    } else if ("LIST".equalsIgnoreCase(this.getSubpartitionType())) {
                        part.enableSubPartitionsByList();
                    } else {
                        part.disableSubPartitions();
                    }
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof PartitionOracle) {
            PartitionOracle part = (PartitionOracle)event.getAffected();
            part.removeObjectListener(this);
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        PartitionListOraclev9i partList = null;
        PartitionListOraclev9i stObject = (PartitionListOraclev9i)((StorageDesignOracle)targetDesign).getPartitionListSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                partList = stObject;
            }
        } else {
            partList = (PartitionListOraclev9i)((StorageDesignOracle)targetDesign).getPartitionListSet().createPartitionList();
        }
        if (partList != null) {
            partList.setName(this.getName());
            partList.setPartitionType(this.getPartitionType());
            partList.setSubpartitionType(this.getSubpartitionType());
            partList.setUseSubpartStorageTemplate(this.getUseSubpartStorageTemplate());
            partList.recreateColumnsSet(this.getColumnSet().toString());
            partList.recreateHashPartitionsTSSet(this.getHashPartitionsTableSpacesSet().toString());
            partList.recreateIOTOverflowHashPTSSet(this.getIOTOverflowHashPTSSet().toString());
            partList.recreateSubPartitionsColumnsSet(this.getSubPartitionsColumnsSet().toString());
            partList.recreateSubPartitionsTSSet(this.getSubPartitionsTableSpacesSet().toString());
            partList.setHashPQuantity(this.getHashPQuantity());
            partList.setSubPartitionsQuantity(this.getSubPartitionsQuantity());
            partList.setRawObject(false);
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

