/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.TableCheckConstraintListener;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraintEvent;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SnapshotOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableCheckConstraintOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableCheckConstraintSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TriggerOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.TablePropertyDialogOraclev9i;

public class TableProxyOraclev9i
extends TableProxyOracle
implements TableCheckConstraintListener {
    protected String suplementalLogGroupName = "";
    protected String suplementalLogConditions = suplementalLogConditionChoices[0];
    protected String IOTMappingTable = "NO";
    public static String[] suplementalLogConditionChoices = new String[]{"ON UPDATE", "ALWAYS"};
    private static Set suplementalLogConditionsSet = null;
    protected String suplementalLogColumns = "";
    protected TableProxyOracle.InlineList suplementalLogColumnSet = null;
    private String partitioned = "NO";
    private String partType = "";
    private String subpartType = "";

    public TableProxyOraclev9i(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
    }

    public TableProxyOraclev9i(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            try {
                TablePropertyDialogOraclev9i dialog = new TablePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
                dialog.show();
            }
            catch (RuntimeException e) {
                this.setDialogVisible(false, null);
            }
        }
    }

    public TableProxyOracle.InlineList getSuplementalLogColumnSet() {
        if (this.suplementalLogColumnSet == null) {
            this.suplementalLogColumnSet = new TableProxyOracle.InlineList();
        }
        return this.suplementalLogColumnSet;
    }

    public void clearSuplementalLogColumns() {
        this.getSuplementalLogColumnSet().removeAllElements();
        this.suplementalLogColumns = "";
    }

    public String getSuplementalLogColumns() {
        return this.suplementalLogColumns;
    }

    public String getAllSuplementalLogColumns() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.suplementalLogColumns, ",");
        while (st.hasMoreTokens()) {
            String colID = st.nextToken().trim();
            ColumnProxy column = this.getColumnProxy(colID);
            if (column == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(column.getLongName());
        }
        return result.toString();
    }

    public void setSuplementalLogColumns(String col) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSuplementalLogColumnSet(col);
        } else {
            this.addSuplementalLogColumn(col);
        }
        this.suplementalLogColumns = this.getSuplementalLogColumnSet().toString();
        this.fireDataFieldChange();
    }

    private void addSuplementalLogColumn(String col) {
        this.getSuplementalLogColumnSet().add(col);
    }

    private void recreateSuplementalLogColumnSet(String col) {
        this.getSuplementalLogColumnSet().clear();
        StringTokenizer st = new StringTokenizer(col, ",");
        this.suplementalLogColumnSet = new TableProxyOracle.InlineList();
        while (st.hasMoreTokens()) {
            this.getSuplementalLogColumnSet().add(st.nextToken().trim());
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof LobStorageOracle) {
            LobStorageOracle lob = (LobStorageOracle)event.getAffected();
            if (lob.getTable() == this) {
                lob.setParent(this.lobs);
                this.lobs.add(lob);
            } else {
                this.lobs.remove(lob);
            }
        } else if (event.getAffected() instanceof PartitionOracle) {
            PartitionOracle part = (PartitionOracle)event.getAffected();
            if (part.getPartitionList() == this.partitionList && this.partitionList != null) {
                part.setParent(this.partitions);
                this.partitions.add(part);
                if (part.getPosition() == 0) {
                    part.removeObjectListener(this);
                    part.setPosition(this.partitions.size());
                    part.addObjectListener(this);
                }
            } else {
                this.partitions.remove(part);
            }
        } else if (event.getAffected() instanceof ListStorageTemplatePartitionOraclev9i) {
            ListStorageTemplatePartitionOraclev9i storage = (ListStorageTemplatePartitionOraclev9i)event.getAffected();
            if (storage.getPartOfStorageTable() == this) {
                storage.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(storage);
            } else {
                this.listStorageTemplates.remove(storage);
            }
        } else if (event.getAffected() instanceof HashPartitionOraclev9i) {
            HashPartitionOraclev9i part = (HashPartitionOraclev9i)event.getAffected();
            if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList() && part.getPartitionList().getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                part.setParent(this.partitions);
                this.partitions.add(part);
            } else {
                this.partitions.remove(part);
            }
            if (part.getPartOfStorageTable() == this) {
                part.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(part);
            } else {
                this.listStorageTemplates.remove(part);
            }
        } else if (event.getAffected() instanceof ListPartitionOraclev9i) {
            ListPartitionOraclev9i part = (ListPartitionOraclev9i)event.getAffected();
            if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                part.setParent(this.partitions);
                this.partitions.add(part);
            } else {
                this.partitions.remove(part);
            }
        } else if (event.getAffected() instanceof BitmapJoinIndexOraclev9i) {
            BitmapJoinIndexOraclev9i ind = (BitmapJoinIndexOraclev9i)event.getAffected();
            if (ind.getTable() == this) {
                ind.setParent(this.bjIndexes);
                this.bjIndexes.add(ind);
            } else {
                this.bjIndexes.remove(ind);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lob = (LobStorageOracle)event.getAffected();
                lob.addObjectListener(this);
                if (lob.getTable() == this) {
                    lob.setParent(this.lobs);
                    this.lobs.add(lob);
                } else {
                    this.lobs.remove(lob);
                }
            } else if (event.getAffected() instanceof PartitionOracle) {
                PartitionOracle part = (PartitionOracle)event.getAffected();
                part.addObjectListener(this);
                if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                    part.setParent(this.partitions);
                    this.partitions.add(part);
                    part.removeObjectListener(this);
                    part.setPosition(this.partitions.size());
                    part.addObjectListener(this);
                } else if (this.partitions.remove(part)) {
                    for (int i = 0; i < this.partitions.size(); ++i) {
                        ModelObject obj = this.partitions.getElement(i);
                        if (!(obj instanceof PartitionOracle)) continue;
                        ((PartitionOracle)obj).setPosition(i + 1);
                    }
                }
            } else if (event.getAffected() instanceof ListStorageTemplatePartitionOraclev9i) {
                ListStorageTemplatePartitionOraclev9i storage = (ListStorageTemplatePartitionOraclev9i)event.getAffected();
                storage.addObjectListener(this);
                if (storage.getPartOfStorageTable() == this) {
                    storage.setParent(this.listStorageTemplates);
                    this.listStorageTemplates.add(storage);
                } else {
                    this.listStorageTemplates.remove(storage);
                }
            } else if (event.getAffected() instanceof HashPartitionOraclev9i) {
                HashPartitionOraclev9i part = (HashPartitionOraclev9i)event.getAffected();
                part.addObjectListener(this);
                if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList() && part.getPartitionList().getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                    part.setParent(this.partitions);
                } else if (part.getPartOfStorageTable() == this) {
                    part.setParent(this.partitions);
                    this.partitions.add(part);
                } else {
                    this.partitions.remove(part);
                }
            } else if (event.getAffected() instanceof ListPartitionOraclev9i) {
                ListPartitionOraclev9i part = (ListPartitionOraclev9i)event.getAffected();
                part.addObjectListener(this);
                if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                    part.setParent(this.partitions);
                    this.partitions.add(part);
                } else {
                    this.partitions.remove(part);
                }
            } else if (event.getAffected() instanceof BitmapJoinIndexOraclev9i) {
                BitmapJoinIndexOraclev9i ind = (BitmapJoinIndexOraclev9i)event.getAffected();
                ind.addObjectListener(this);
                if (ind.getTable() == this) {
                    ind.setParent(this.bjIndexes);
                    this.bjIndexes.add(ind);
                } else {
                    this.bjIndexes.remove(ind);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lob = (LobStorageOracle)event.getAffected();
                this.lobs.remove(lob);
                lob.removeObjectListener(this);
            } else if (event.getAffected() instanceof PartitionOracle) {
                PartitionOracle part = (PartitionOracle)event.getAffected();
                if (this.partitions.remove(part)) {
                    for (int i = 0; i < this.partitions.size(); ++i) {
                        ModelObject obj = this.partitions.getElement(i);
                        if (!(obj instanceof PartitionOracle)) continue;
                        ((PartitionOracle)obj).setPosition(i + 1);
                    }
                }
                part.removeObjectListener(this);
            } else if (event.getAffected() instanceof ListStorageTemplatePartitionOraclev9i) {
                ListStorageTemplatePartitionOraclev9i storage = (ListStorageTemplatePartitionOraclev9i)event.getAffected();
                this.listStorageTemplates.remove(storage);
                storage.removeObjectListener(this);
            } else if (event.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle part = (HashPartitionOracle)event.getAffected();
                this.partitions.remove(part);
                this.listStorageTemplates.remove(part);
                part.removeObjectListener(this);
            } else if (event.getAffected() instanceof ListPartitionOraclev9i) {
                ListPartitionOraclev9i part = (ListPartitionOraclev9i)event.getAffected();
                this.partitions.remove(part);
                part.removeObjectListener(this);
            } else if (event.getAffected() instanceof BitmapJoinIndexOraclev9i) {
                BitmapJoinIndexOraclev9i ind = (BitmapJoinIndexOraclev9i)event.getAffected();
                this.bjIndexes.remove(ind);
                ind.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(TableLevelConstraint object, TableLevelConstraintEvent event) {
        if (event.isType(TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_ADDED)) {
            StorageDesignOraclev9i sd = (StorageDesignOraclev9i)this.getStorageDesign();
            TableCheckConstraintSetOraclev9i set = (TableCheckConstraintSetOraclev9i)sd.getTableCheckConstraintSet();
            set.addTableCheckConstraint(this, object);
            this.setDirty(true);
        } else if (event.isType(TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_REMOVED)) {
            StorageDesignOraclev9i sd = (StorageDesignOraclev9i)this.getStorageDesign();
            TableCheckConstraintSetOraclev9i tcc = (TableCheckConstraintSetOraclev9i)sd.getTableCheckConstraintSet();
            tcc.removeTableCheckConstraint(this, object);
            this.setDirty(true);
        }
    }

    @Override
    protected void addTableCheckConstraintFromDesign(TableCheckConstraintSetOracle set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TableCheckConstraintOracle tcc = (TableCheckConstraintOracle)it.next();
            if (tcc.getTable() == null || tcc.getTable() != this || TableProxyOraclev9i.containsTCCWithID(this.tableCheckConstraints, tcc.getObjectID())) continue;
            tcc.setParent(this.tableCheckConstraints);
            this.tableCheckConstraints.add(tcc);
        }
        Table table = (Table)this.getObject();
        for (TableLevelConstraint constraint : table.getCheckConstraints()) {
            ((TableCheckConstraintSetOraclev9i)set).addTableCheckConstraint(this, constraint);
            this.fireDataFieldChange();
        }
        this.fireDataFieldChange();
    }

    @Override
    public String getIOTMappingTable() {
        return this.IOTMappingTable;
    }

    @Override
    public void setIOTMappingTable(String mappingTable) {
        this.IOTMappingTable = mappingTable;
        this.fireDataFieldChange();
    }

    public String getSuplementalLogConditions() {
        return this.suplementalLogConditions;
    }

    public void setSuplementalLogConditions(String suplementalLogConditions) {
        if (this.checkSuplementalLogConditions(suplementalLogConditions)) {
            this.suplementalLogConditions = suplementalLogConditions;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkSuplementalLogConditions(String value) {
        if (suplementalLogConditionsSet == null) {
            suplementalLogConditionsSet = new HashSet();
            suplementalLogConditionsSet.addAll(Arrays.asList(suplementalLogConditionChoices));
        }
        return suplementalLogConditionsSet.contains(value);
    }

    public String getSuplementalLogGroupName() {
        return this.suplementalLogGroupName;
    }

    public void setSuplementalLogGroupName(String suplementalLogGroupName) {
        this.suplementalLogGroupName = suplementalLogGroupName;
        this.fireDataFieldChange();
    }

    @Override
    public void setPartitionList(PartitionListOracle pList) {
        PartitionListOraclev9i partitionList = (PartitionListOraclev9i)pList;
        String newPartType = "";
        String newSubpartType = "";
        if (partitionList != null) {
            newPartType = partitionList.getPartitionType();
            if (newPartType.equalsIgnoreCase("COMPOSITE BY HASH") || newPartType.equalsIgnoreCase("COMPOSITE BY LIST")) {
                newPartType = "RANGE";
            }
            newSubpartType = partitionList.getSubpartitionType();
        }
        if (this.partitionList != null) {
            if (!this.partType.equalsIgnoreCase(newPartType)) {
                this.partitions.removeAll();
            }
            if (!this.subpartType.equalsIgnoreCase(newSubpartType)) {
                this.listStorageTemplates.removeAll();
            }
        }
        this.partType = newPartType;
        this.subpartType = newSubpartType;
        this.partitionList = partitionList;
        if (this.partitionList == null) {
            this.partitions.setForbiddenCreateElement(true);
            this.listStorageTemplates.setForbiddenCreateElement(true);
        } else {
            this.partitionList.setTable(this);
            this.partitioned = "YES";
            if (this.partType.equalsIgnoreCase("HASH BY QUANTITY")) {
                this.partitions.setForbiddenCreateElement(true);
            } else {
                this.partitions.setForbiddenCreateElement(false);
                this.partitions.setLogicalParent(partitionList);
            }
            if (this.partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev9i)this.getStorageDesign()).getHashPartitionSet());
                this.addHashPartFromDesign(((StorageDesignOraclev9i)this.getStorageDesign()).getHashPartitionSet());
            } else if (this.partType.equalsIgnoreCase("LIST")) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev9i)this.getStorageDesign()).getListPartitionSet());
                this.addListPartFromDesign(((StorageDesignOraclev9i)this.getStorageDesign()).getListPartitionSet());
            } else {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev9i)this.getStorageDesign()).getPartitionSet());
                this.addPartFromDesign(((StorageDesignOraclev9i)this.getStorageDesign()).getPartitionSet());
            }
            if ("NO".equalsIgnoreCase(partitionList.getUseSubpartStorageTemplate())) {
                this.listStorageTemplates.setForbiddenCreateElement(true);
            } else if (this.subpartType.equalsIgnoreCase("HASH")) {
                this.listStorageTemplates.setForbiddenCreateElement(false);
                this.listStorageTemplates.setStorageObjectSet(((StorageDesignOraclev9i)this.getStorageDesign()).getHashPartitionSet());
                this.addHashPartFromDesignToTemplates(((StorageDesignOraclev9i)this.getStorageDesign()).getHashPartitionSet());
            } else if (this.subpartType.equalsIgnoreCase("LIST")) {
                this.listStorageTemplates.setForbiddenCreateElement(false);
                this.listStorageTemplates.setStorageObjectSet(((StorageDesignOraclev9i)this.getStorageDesign()).getListStorageTemplatePartitionSet());
                this.addStorageTemplatePartitionsFromDesign(((StorageDesignOraclev9i)this.getStorageDesign()).getListStorageTemplatePartitionSet());
            } else {
                this.listStorageTemplates.setForbiddenCreateElement(true);
            }
        }
        this.fireDataFieldChange();
    }

    @Override
    public PartitionListOracle getPartitionList() {
        return this.partitionList;
    }

    @Override
    public void setPartitioned(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.partitioned = value;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getPartitioned() {
        return this.partitioned;
    }

    private void addHashPartFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            HashPartitionOraclev9i part = (HashPartitionOraclev9i)it.next();
            if (part.getPartitionList() == this.partitionList && this.partitionList != null) {
                part.addObjectListener(this);
                part.setParent(this.partitions);
                this.partitions.add(part);
                continue;
            }
            this.partitions.remove(part);
        }
    }

    private void addListPartFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ListPartitionOraclev9i part = (ListPartitionOraclev9i)it.next();
            if (part.getPartitionList() == this.partitionList && this.partitionList != null) {
                part.addObjectListener(this);
                part.setParent(this.partitions);
                this.partitions.add(part);
                continue;
            }
            this.partitions.remove(part);
        }
    }

    private void addStorageTemplatePartitionsFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ListStorageTemplatePartitionOraclev9i storage = (ListStorageTemplatePartitionOraclev9i)it.next();
            if (storage.getPartOfStorageTable() == this) {
                storage.addObjectListener(this);
                storage.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(storage);
                continue;
            }
            this.listStorageTemplates.remove(storage);
        }
    }

    private void addHashPartFromDesignToTemplates(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            HashPartitionOraclev9i hash = (HashPartitionOraclev9i)it.next();
            if (hash.getPartOfStorageTable() == this) {
                hash.addObjectListener(this);
                hash.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(hash);
                continue;
            }
            this.listStorageTemplates.remove(hash);
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Table table = (Table)targetDesign.getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxyOraclev9i tableProxy = null;
        RelationalObjectProxy storageObject = targetDesign.getTableProxySet().getProxy(table.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            tableProxy = (TableProxyOraclev9i)storageObject;
        }
        if (tableProxy != null) {
            ColumnProxy columnProxy;
            SegmentOraclev9i segment;
            tableProxy.setName(this.getName());
            Iterator it = this.getTableCheckConstraints().iterator();
            while (it.hasNext()) {
                TableCheckConstraintOraclev9i tblConstr = (TableCheckConstraintOraclev9i)it.next();
                TableCheckConstraintOraclev9i targetConstr = (TableCheckConstraintOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableCheckConstraintSet().getByName(tblConstr.getName());
                if (targetConstr == null) {
                    TableCheckConstraintOraclev9i newConstr = (TableCheckConstraintOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableCheckConstraintSet().createTableCheckConstraint();
                    newConstr.setName(tblConstr.getName());
                    newConstr.setRawObject(true);
                    newConstr.setTable(tableProxy);
                    tableProxy.addTableCheckConstraintFromDesign(((StorageDesignOraclev9i)targetDesign).getTableCheckConstraintSet());
                    continue;
                }
                targetConstr.setTable(tableProxy);
                tableProxy.addTableCheckConstraintFromDesign(((StorageDesignOraclev9i)targetDesign).getTableCheckConstraintSet());
            }
            it = this.getBjIndexes().iterator();
            while (it.hasNext()) {
                BitmapJoinIndexOraclev9i joinIndex = (BitmapJoinIndexOraclev9i)it.next();
                BitmapJoinIndexOraclev9i targetJoinIndex = (BitmapJoinIndexOraclev9i)((StorageDesignOraclev9i)targetDesign).getBitmapJoinIndexSet().getByName(joinIndex.getName());
                if (targetJoinIndex == null) {
                    BitmapJoinIndexOraclev9i newJoinIndex = (BitmapJoinIndexOraclev9i)((StorageDesignOraclev9i)targetDesign).getBitmapJoinIndexSet().createBitmapJoinIndex();
                    newJoinIndex.setName(joinIndex.getName());
                    newJoinIndex.setRawObject(true);
                    newJoinIndex.setTable(tableProxy);
                    tableProxy.addBJIFromDesign(((StorageDesignOraclev9i)targetDesign).getBitmapJoinIndexSet());
                    continue;
                }
                targetJoinIndex.setTable(tableProxy);
                tableProxy.addBJIFromDesign(((StorageDesignOraclev9i)targetDesign).getBitmapJoinIndexSet());
            }
            it = this.getLobStorages().iterator();
            while (it.hasNext()) {
                LobStorageOraclev9i storage = (LobStorageOraclev9i)it.next();
                LobStorageOraclev9i targetStorage = (LobStorageOraclev9i)((StorageDesignOraclev9i)targetDesign).getLobStorageSet().getByName(storage.getName());
                if (targetStorage == null) {
                    LobStorageOraclev9i newStorage = (LobStorageOraclev9i)((StorageDesignOraclev9i)targetDesign).getLobStorageSet().createLobStorage();
                    newStorage.setName(storage.getName());
                    newStorage.setRawObject(true);
                    newStorage.setTable(tableProxy);
                    continue;
                }
                targetStorage.setTable(tableProxy);
            }
            it = this.triggers.iterator();
            while (it.hasNext()) {
                TriggerOraclev9i trigger = (TriggerOraclev9i)it.next();
                TriggerOraclev9i targetTrigger = (TriggerOraclev9i)((StorageDesignOraclev9i)targetDesign).getTriggerSet().getByName(trigger.getName());
                if (targetTrigger == null) {
                    TriggerOraclev9i newTrigger = (TriggerOraclev9i)((StorageDesignOraclev9i)targetDesign).getTriggerSet().createTrigger();
                    newTrigger.setName(trigger.getName());
                    newTrigger.setRawObject(true);
                    newTrigger.setTable(tableProxy);
                    tableProxy.addTriggersFromDesign(((StorageDesignOraclev9i)targetDesign).getTriggerSet());
                    continue;
                }
                targetTrigger.setTable(tableProxy);
                tableProxy.addTriggersFromDesign(((StorageDesignOraclev9i)targetDesign).getTriggerSet());
            }
            it = this.getUniqueKeys().iterator();
            while (it.hasNext()) {
                UniqueOraclev9i unKey = (UniqueOraclev9i)it.next();
                UniqueOraclev9i targetUNKey = (UniqueOraclev9i)((StorageDesignOraclev9i)targetDesign).getUniqueSet().getByName(unKey.getName());
                if (targetUNKey == null) {
                    UniqueOraclev9i newUNKey = (UniqueOraclev9i)((UniqueSetOraclev9i)((StorageDesignOraclev9i)targetDesign).getUniqueSet()).createProxy(unKey.getObject());
                    newUNKey.setName(unKey.getName());
                    newUNKey.setRawObject(true);
                    tableProxy.addIndProxiesFromDesign(((StorageDesignOraclev9i)targetDesign).getUniqueSet());
                    continue;
                }
                tableProxy.addIndProxiesFromDesign(((StorageDesignOraclev9i)targetDesign).getUniqueSet());
            }
            if (this.getPartitionList() != null) {
                PartitionListOraclev9i partList = (PartitionListOraclev9i)((StorageDesignOraclev9i)targetDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (partList == null) {
                    PartitionListOraclev9i newPartList = (PartitionListOraclev9i)((StorageDesignOraclev9i)targetDesign).getPartitionListSet().createPartitionList();
                    newPartList.setName(this.getPartitionList().getName());
                    newPartList.setRawObject(true);
                    tableProxy.setPartitionList(newPartList);
                } else {
                    tableProxy.setPartitionList(partList);
                }
            }
            if (this.getUser() != null) {
                UserOraclev9i user = (UserOraclev9i)((StorageDesignOraclev9i)targetDesign).getUserSet().getByName(this.getUser().getName());
                if (user == null) {
                    UserOraclev9i newUser = (UserOraclev9i)((StorageDesignOraclev9i)targetDesign).getUserSet().createUser();
                    newUser.setName(this.getUser().getName());
                    newUser.setRawObject(true);
                    tableProxy.setUser(newUser);
                } else {
                    tableProxy.setUser(user);
                }
            }
            tableProxy.setTemporary(this.getTemporary());
            tableProxy.setTemporaryChanged(this.isTemporaryChanged());
            tableProxy.setTempPreserveRows(this.getTempPreserveRows());
            if (this.getTableSpace() != null) {
                TableSpaceOraclev9i tablespace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tablespace == null) {
                    TableSpaceOraclev9i newTablespace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getTableSpace().getName());
                    newTablespace.setRawObject(true);
                    tableProxy.setTableSpace(newTablespace);
                } else {
                    tableProxy.setTableSpace(tablespace);
                }
            }
            tableProxy.setOrganization(this.getOrganization());
            if (this.getCluster() != null) {
                ClusterOraclev9i cluster = (ClusterOraclev9i)((StorageDesignOraclev9i)targetDesign).getClusterSet().getByName(this.getCluster().getName());
                if (cluster == null) {
                    ClusterOraclev9i newCluster = (ClusterOraclev9i)((StorageDesignOraclev9i)targetDesign).getClusterSet().createCluster();
                    newCluster.setName(this.getCluster().getName());
                    newCluster.setRawObject(true);
                    tableProxy.setCluster(newCluster);
                } else {
                    tableProxy.setCluster(cluster);
                }
            }
            tableProxy.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                segment = (SegmentOraclev9i)((StorageDesignOraclev9i)targetDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (segment == null) {
                    SegmentOraclev9i newSegment = (SegmentOraclev9i)((StorageDesignOraclev9i)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getSegment().getName());
                    newSegment.setRawObject(true);
                    tableProxy.setSegment(newSegment);
                } else {
                    tableProxy.setSegment(segment);
                }
            }
            tableProxy.setCache(this.getCache());
            tableProxy.setMonitoring(this.getMonitoring());
            tableProxy.setParallel(this.getParallel());
            tableProxy.setDegree(this.getDegree());
            tableProxy.setRowDependency(this.getRowDependency());
            tableProxy.setPartitioned(this.getPartitioned());
            tableProxy.setParttitionedRowMovement(this.getParttitionedRowMovement());
            tableProxy.setDataSegmentCompression(this.getDataSegmentCompression());
            if (this.getSnapshot() != null) {
                SnapshotOraclev9i snapshot = (SnapshotOraclev9i)((StorageDesignOraclev9i)targetDesign).getSnapshotSet().getByName(this.getSnapshot().getName());
                if (snapshot == null) {
                    SnapshotOraclev9i newSnapshot = (SnapshotOraclev9i)((StorageDesignOraclev9i)targetDesign).getSnapshotSet().createSnapshot();
                    newSnapshot.setName(this.getSnapshot().getName());
                    newSnapshot.setRawObject(true);
                    tableProxy.setSnapshot(newSnapshot);
                } else {
                    tableProxy.setSnapshot(snapshot);
                }
            }
            tableProxy.setIotCompress(this.getIotCompress());
            tableProxy.setIotPctThreshold(this.getIotPctThreshold());
            if (this.getIotIncluding() != null && (columnProxy = tableProxy.getColumnProxyByName(this.getIotIncluding().getName())) != null) {
                tableProxy.setIotIncluding(columnProxy);
            }
            tableProxy.setIotOverflowTablespace(this.getIotOverflowTablespace());
            tableProxy.setIotOverflowLogging(this.getIotOverflowLogging());
            if (this.getIotOverflowSegment() != null) {
                segment = (SegmentOraclev9i)((StorageDesignOraclev9i)targetDesign).getSegmentSet().getByName(this.getIotOverflowSegment().getName());
                if (segment == null) {
                    segment = (SegmentOraclev9i)((StorageDesignOraclev9i)targetDesign).getSegmentSet().createSegment();
                    segment.setName(this.getIotOverflowSegment().getName());
                    segment.setRawObject(true);
                }
                tableProxy.setIotOverflowSegment(segment);
            }
            tableProxy.setIOTMappingTable(this.getIOTMappingTable());
            tableProxy.recreateColumnsSet(this.getClusterColumnsSet().toString());
            tableProxy.setSuplementalLogGroupName(this.getSuplementalLogGroupName());
            tableProxy.setSuplementalLogConditions(this.getSuplementalLogConditions());
            tableProxy.recreateSuplementalLogColumnSet(this.getSuplementalLogColumnSet().toString());
            tableProxy.setComment(this.getComment());
            tableProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxy.setRawObject(false);
        }
    }
}

