/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataFileOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxySetOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.TableSpacePropertyDialogOraclev9i;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableSpaceOraclev9i
extends TableSpaceOracle {
    private int blockSize;
    private static Set segManageSet = null;
    private String segmentManagement = SEGMENT_MANAGE_STATES[0];
    private static final String[] SEGMENT_MANAGE_STATES = new String[]{"", "MANUAL", "AUTO"};
    private String forceLogging = "NO";
    protected List propertyWrapperList = null;

    public TableSpaceOraclev9i(StorageDesign storageDesign) {
        super(storageDesign);
        this.extentManagement = EXTEND_MANAGE_STATES[1];
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
        this.fireDataFieldChange();
    }

    public String getSegmentManagement() {
        return this.segmentManagement;
    }

    public void setSegmentManagement(String value) {
        if (this.checkSegManageState(value)) {
            this.segmentManagement = value;
            this.fireDataFieldChange();
        }
    }

    private boolean checkSegManageState(String value) {
        if (segManageSet == null) {
            segManageSet = new HashSet();
            segManageSet.addAll(Arrays.asList(TableSpaceOraclev9i.getSegManageStates()));
        }
        return segManageSet.contains(value);
    }

    public static String[] getSegManageStates() {
        return SEGMENT_MANAGE_STATES;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableSpacePropertyDialogOraclev9i dialog = new TableSpacePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public String getForceLogging() {
        return this.forceLogging;
    }

    public void setForceLogging(String forceLogging) {
        if (ConstantsOracle.checkYesNo(forceLogging)) {
            this.forceLogging = forceLogging;
            this.fireDataFieldChange();
        }
    }

    public String getManagedFiles() {
        if (this.getDfiles().toArray().length == 0) {
            return "NO";
        }
        return "YES";
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.MinExtLen"), this, "getMinExtLen", "setMinExtLen", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.BlockSize"), this, "getBlockSize", "setBlockSize", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.Logging"), this, "getLogging", "setLogging", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.ForceLogging"), this, "getForceLogging", "setForceLogging", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.Status"), this, "getStatus", "setStatus", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.Contents"), this, "getContents", "setContents", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.DSInitialExtent"), this, "getDSInitialExtent", "setDSInitialExtent", Long.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.DSNextExtent"), this, "getDSNextExtent", "setDSNextExtent", Long.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.DSMinExtents"), this, "getDSMinExtents", "setDSMinExtents", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.DSMaxExtents"), this, "getDSMaxExtents", "setDSMaxExtents", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.DSPCTIncrease"), this, "getDSPctIncrease", "setDSPctIncrease", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.ExtManagement"), this, "getExtentManagement", "setExtentManagement", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.EMLocalSubType"), this, "getEMLocalSubtype", "setEMLocalSubtype", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.EMUniformSize"), this, "getEMUniformSize", "setEMUniformSize", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.SegManagement"), this, "getSegmentManagement", "setSegmentManagement", String.class));
        }
        return this.propertyWrapperList;
    }

    protected String getPropertyDialogName(String messageKey) {
        String uiText = Messages.getString(messageKey);
        if (uiText.endsWith(":")) {
            uiText = uiText.substring(0, uiText.length() - 1).trim();
        }
        return uiText;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableSpaceOraclev9i tableSpace = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                tableSpace = (TableSpaceOraclev9i)stObject;
            }
        } else {
            tableSpace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().createTableSpace();
        }
        if (tableSpace != null) {
            tableSpace.setObjectID(this.getObjectID());
            tableSpace.setName(this.getName());
            Iterator it = this.getTabcoll().iterator();
            while (it.hasNext()) {
                StorageObjectPlaceHolder tables = (StorageObjectPlaceHolder)it.next();
                TableProxyOraclev9i targetTables = (TableProxyOraclev9i)((TableProxySetOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableProxySet()).getByName(tables.getName());
                if (targetTables == null) {
                    TableProxyOraclev9i newTable = (TableProxyOraclev9i)((TableProxySetOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableProxySet()).createProxy(tables.getGenerator());
                    newTable.setName(tables.getName());
                    newTable.setTableSpace(tableSpace);
                    newTable.setRawObject(true);
                    tableSpace.registerToTableProxyFromDesign(((StorageDesignOraclev9i)targetDesign).getTableProxySet());
                    continue;
                }
                targetTables.setTableSpace(tableSpace);
                tableSpace.registerToTableProxyFromDesign(((StorageDesignOraclev9i)targetDesign).getTableProxySet());
            }
            it = this.getDfiles().iterator();
            while (it.hasNext()) {
                DataFileOraclev9i dataFile = (DataFileOraclev9i)it.next();
                DataFileOraclev9i targetDataFile = (DataFileOraclev9i)((StorageDesignOraclev9i)targetDesign).getDataFileSet().getByName(dataFile.getName());
                if (targetDataFile == null) {
                    DataFileOraclev9i newDataFile = (DataFileOraclev9i)((StorageDesignOraclev9i)targetDesign).getDataFileSet().createDataFile();
                    newDataFile.setName(dataFile.getName());
                    newDataFile.setTableSpace(tableSpace);
                    newDataFile.setRawObject(true);
                    tableSpace.getDfiles().add(newDataFile);
                    continue;
                }
                targetDataFile.setTableSpace(tableSpace);
                tableSpace.getDfiles().add(targetDataFile);
            }
            tableSpace.setMinExtLen(this.getMinExtLen());
            tableSpace.setBlockSize(this.getBlockSize());
            tableSpace.setLogging(this.getLogging());
            tableSpace.setForceLogging(this.getForceLogging());
            tableSpace.setStatus(this.getStatus());
            tableSpace.setContents(this.getContents());
            tableSpace.setDSInitialExtent(this.getDSInitialExtent());
            tableSpace.setDSNextExtent(this.getDSNextExtent());
            tableSpace.setDSMinExtents(this.getDSMinExtents());
            tableSpace.setDSMaxExtents(this.getDSMaxExtents());
            tableSpace.setDSPctIncrease(this.getDSPctIncrease());
            tableSpace.setExtentManagement(this.getExtentManagement());
            tableSpace.setEMLocalSubtype(this.getEMLocalSubtype());
            tableSpace.setEMUniformSize(this.getEMUniformSize());
            tableSpace.setSegmentManagement(this.getSegmentManagement());
            tableSpace.setComment(this.getComment());
            tableSpace.setRawObject(false);
        }
    }
}

