/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataFileOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.UndoTablespacePropertyDialogOracle;

public class UndoTablespaceOraclev9i
extends UndoTablespaceOracle
implements ModelObjectSetListener,
StorageObjectListener {
    protected StorageObjectCollection dfiles;

    public UndoTablespaceOraclev9i(StorageDesign storageDesign) {
        super(storageDesign);
        this.dfiles = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getDataFileSet());
        this.dfiles.setParent(this);
        this.dfiles.setName(Messages.getString("TableSpaceOracle.DataFiles"));
        this.dfiles.setSetMethod("setUndoTablespace");
        this.dfiles.setClassForParent(UndoTablespaceOracle.class);
        this.dfiles.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        ((StorageDesignOracle)storageDesign).getDataFileSet().addSetListener(this);
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof DataFileOraclev9i) {
            DataFileOraclev9i df = (DataFileOraclev9i)event.getAffected();
            if (df.getUndoTablespace() == this) {
                df.setParent(this.dfiles);
                this.dfiles.add(df);
            } else {
                this.dfiles.remove(df);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.dfiles;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.dfiles) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.dfiles) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof DataFileOraclev9i) {
                DataFileOraclev9i df = (DataFileOraclev9i)event.getAffected();
                df.addObjectListener(this);
                if (df.getUndoTablespace() == this) {
                    df.setParent(this.dfiles);
                    this.dfiles.add(df);
                } else {
                    this.dfiles.remove(df);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof DataFileOraclev9i) {
            DataFileOraclev9i df = (DataFileOraclev9i)event.getAffected();
            this.dfiles.remove(df);
            df.removeObjectListener(this);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            UndoTablespacePropertyDialogOracle dialog = new UndoTablespacePropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void setOracleManagesFiles(String oracleManagesFiles) {
        if (ConstantsOracle.checkYesNo(oracleManagesFiles)) {
            this.oracleManagesFiles = oracleManagesFiles;
            if ("YES".equalsIgnoreCase(oracleManagesFiles) || this.fileType.equalsIgnoreCase(FILE_TYPES[1])) {
                while (this.dfiles.size() > 1) {
                    this.dfiles.remove(this.dfiles.getElement(1));
                }
                this.dfiles.setAllowedNumberOfElements(1);
            } else if (!this.fileType.equalsIgnoreCase(FILE_TYPES[1])) {
                this.dfiles.setAllowedNumberOfElements(99999);
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setFileType(String value) {
        if (this.checkFileType(value)) {
            this.fileType = value;
            if (value.equalsIgnoreCase(FILE_TYPES[1]) || "YES".equalsIgnoreCase(this.oracleManagesFiles)) {
                while (this.dfiles.size() > 1) {
                    this.dfiles.remove(this.dfiles.getElement(1));
                }
                this.dfiles.setAllowedNumberOfElements(1);
            } else if ("YES".equalsIgnoreCase(this.oracleManagesFiles)) {
                this.dfiles.setAllowedNumberOfElements(99999);
            }
            this.fireDataFieldChange();
        }
    }

    public StorageObjectCollection getDfiles() {
        return this.dfiles;
    }

    public DataFileOracle createDataFile() {
        if (this.dfiles.getStorageObjectSet() != null) {
            return (DataFileOracle)this.dfiles.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        UndoTablespaceOraclev9i undoTableSpace = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev9i)targetDesign).getUndoTablespaceSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                undoTableSpace = (UndoTablespaceOraclev9i)stObject;
            }
        } else {
            undoTableSpace = (UndoTablespaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getUndoTablespaceSet().createElement(null);
        }
        if (undoTableSpace != null) {
            undoTableSpace.setName(this.getName());
            Iterator it = this.getDfiles().iterator();
            while (it.hasNext()) {
                DataFileOraclev9i dataFile = (DataFileOraclev9i)it.next();
                DataFileOraclev9i targetFile = (DataFileOraclev9i)((StorageDesignOraclev9i)targetDesign).getDataFileSet().getByName(dataFile.getName());
                if (targetFile == null) {
                    DataFileOraclev9i newFile = (DataFileOraclev9i)((StorageDesignOraclev9i)targetDesign).getDataFileSet().createDataFile();
                    newFile.setName(dataFile.getName());
                    newFile.setRawObject(true);
                    newFile.setUndoTablespace(undoTableSpace);
                    undoTableSpace.getDfiles().add(newFile);
                    continue;
                }
                targetFile.setUndoTablespace(undoTableSpace);
                undoTableSpace.getDfiles().add(targetFile);
            }
            undoTableSpace.setFileType(this.getFileType());
            undoTableSpace.setRetention(this.getRetention());
            undoTableSpace.setOracleManagesFiles(this.getOracleManagesFiles());
            undoTableSpace.setComment(this.getComment());
            undoTableSpace.setRawObject(false);
        }
    }

    @Override
    public void clearNoneMergableStructure() {
        this.dfiles.removeAll();
    }
}

