/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.FKPropertyDialogSqlServer;

public class FKProxySqlServer
extends IndexProxy
implements StorageObjectListener {
    public static final String[] ON_CHOICES = new String[]{"NO ACTION", "CASCADE"};
    private static List onList = Arrays.asList(ON_CHOICES);
    private static Set onSet = null;
    private String onDelete = "NO ACTION";
    private String onUpdate = "NO ACTION";
    private String forReplication = "YES";
    public static final String TYPE_NAME = "FKey";

    public FKProxySqlServer(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public FKProxySqlServer(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        this.fireChange(event);
    }

    public String getColumns() {
        ColumnProxy[] columns = this.getColumnProxies();
        StringBuffer result = new StringBuffer();
        boolean b = false;
        for (int i = 0; i < columns.length; ++i) {
            if (b) {
                result.append(", ");
            } else {
                b = true;
            }
            result.append(columns[i].getName());
        }
        return result.toString();
    }

    public String getReferenceColumns() {
        Index remoteIndex = this.getIndex().getFKAssociation().getRemoteIndex();
        Column[] columns = (Column[])remoteIndex.getElements();
        StringBuffer result = new StringBuffer();
        boolean b = false;
        for (int i = 0; i < columns.length; ++i) {
            if (b) {
                result.append(", ");
            } else {
                b = true;
            }
            result.append(columns[i].getName());
        }
        return result.toString();
    }

    public Column[] getRefColumns() {
        Index remoteIndex = this.getIndex().getFKAssociation().getRemoteIndex();
        return (Column[])remoteIndex.getElements();
    }

    private Table getRemoteTable() {
        return this.getIndex().getFKAssociation().getRemoteTable();
    }

    public String getReferenceTable() {
        TableProxySqlServer tableProxy = (TableProxySqlServer)this.getStorageDesign().getTableProxySet().getProxy(this.getRemoteTable().getObjectID());
        return tableProxy.getLongName();
    }

    public String getReferenceTableDDL() {
        TableProxySqlServer tableProxy = (TableProxySqlServer)this.getStorageDesign().getTableProxySet().getProxy(this.getRemoteTable().getObjectID());
        return tableProxy.getLongNameDDL();
    }

    public String getReferenceOwner() {
        TableProxySqlServer tableProxy = (TableProxySqlServer)this.getStorageDesign().getTableProxySet().getProxy(this.getRemoteTable().getObjectID());
        if (tableProxy.getUser() != null) {
            return tableProxy.getUser().getName();
        }
        return "";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return "ForeignKey";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FKPropertyDialogSqlServer dialog = new FKPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public static List getOnValues() {
        return onList;
    }

    protected boolean checkOn(String value) {
        if (onSet == null) {
            onSet = new HashSet();
            onSet.addAll(Arrays.asList(FKProxySqlServer.getOnChoices()));
        }
        return onSet.contains(value);
    }

    public static String[] getOnChoices() {
        return ON_CHOICES;
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public String getTableUser() {
        if (((TableProxySqlServer)this.getTableProxy()).getUser() != null) {
            return ((TableProxySqlServer)this.getTableProxy()).getUser().getName();
        }
        return "";
    }

    public String getTableSchema() {
        if (((TableProxySqlServer)this.getTableProxy()).getSchema() != null) {
            return ((TableProxySqlServer)this.getTableProxy()).getSchema().getName();
        }
        return "";
    }

    public String getForReplication() {
        return this.forReplication;
    }

    public void setForReplication(String forReplication) {
        if (ConstantsSqlServer.checkYesNo(forReplication)) {
            this.forReplication = forReplication;
            this.fireDataFieldChange();
        }
    }

    public String getOnDelete() {
        return this.onDelete;
    }

    public void setOnDelete(String onDelete) {
        if (this.checkOn(onDelete)) {
            this.onDelete = onDelete;
            this.fireDataFieldChange();
        }
    }

    public String getOnUpdate() {
        return this.onUpdate;
    }

    public void setOnUpdate(String onUpdate) {
        if (this.checkOn(onUpdate)) {
            this.onUpdate = onUpdate;
            this.fireDataFieldChange();
        }
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String name = index.isFK() && index.getFKAssociation() != null ? index.getFKAssociation().getName() : index.getName();
        name = this.applyNameSubstitution(name);
        return name;
    }
}

